@extends('layouts.AdminLayout')
@section('content')

<style>
thead th {
    text-align: center !important;
}
</style>
<div class="content-wrapper">
  <div class="container-xxl flex-grow-1 container-p-y">
    <div class="card mb-4">
      <h5 class="card-header bg-info">Cooling Period List
      <span class="btn btn-primary exportdata" style="color:whitelcursor:pointer">Export To Excel</span></h4>
      </h5>
      <div class="card-body">
          <h5 class="my-4">Search Parameters</h5>
         
          
          <form method="get" id="chatexport" action="{{ url('/ernetdash/coolingexport') }}">	
			       @csrf
              <div class="row mb-4">
                  <div class="col-md-4">
                      <label class="form-label">Domain Name </label>
                      <input type="text" class="form-control" name="user_name" id="user_name" maxlength="35">
                  </div>
                  <!-- <div class="col-md-3">
                      <label class="form-label">Applicant Name </label>
                      <input type="text" class="form-control" name="name" id="name">
                  </div> -->

                  <div class="col-md-4">
                      <label class="form-label">Institute Name </label>
                      <input type="text" class="form-control" name="institute_name" id="institute_name">
                  </div>
                  <div class="col-md-4">
                      <label class="form-label">Language </label>
                      <select class="form-control"  name="domainLangID" id="domainLangID" >
                          <option value="">Choose Language</option>
                          @foreach(\Illuminate\Support\Facades\DB::table('domain_languages')->get() as $lang)
                              <option value="{{$lang->id}}">{{$lang->language_name}}</option>
                          @endforeach
                      </select>
                  </div>
              </div>
              <div class="row mb-4">

                  <div class="col-md-3">
                      <label class="form-label">Application Date From</label>
                      <input type="hidden" class="form-control " name="domainStatus" id="domainStatus" value="{{$domainStatus??''}}">

                      <input type="text" class="form-control from_date_start datepicker" placeholder="dd-mm-yyyy" name="creation_start_date" id="from_date" max="{{ date('Y-m-d') }}" value="{{$creation_start_date??''}}">
                  </div>
                  <div class="col-md-3">
                      <label class="form-label">Application Date To</label>
                      <input type="text" class="form-control to_date_end datepicker" placeholder="dd-mm-yyyy" name="creation_end_date" id="to_date" max="{{ date('Y-m-d') }}" value="{{$creation_end_date??''}}">
                  </div>

			
                  <div class="col-md-3">
                      <label class="form-label">Expiry Date From</label>
                      <input type="text" class="form-control from_date_expiry datepicker"  placeholder="dd-mm-yyyy" name="expiry_start_date" id="expiry_start_date" max="{{ date('Y-m-d') }}" value="{{$expiry_start_date??''}}">
                  </div>
                  <div class="col-md-3">
                      <label class="form-label">Expiry Date To</label>
                      <input type="text" class="form-control to_date_expiry datepicker" placeholder="dd-mm-yyyy" name="expiry_end_date" id="expiry_end_date" max="{{ date('Y-m-d') }}" value="{{$expiry_end_date??''}}">
                  </div>
                 

                  <div class="col-md-3 d-flex">
                      <button class="btn btn-success search" id="search_user_btn" name="action" value="submit" style="height: 40px;margin-top: 27px; margin-right: 20px;">Search</button>
                      <!-- <a href="{{Route('admin.find-users-details-view')}}" >
                          <input type="button" class="btn btn-info" id="Refresh_user_form_btn" name="action" value="Reset" style="height: 40px;margin-top: 27px;" />
                      </a> -->
                  </div>
              </div>
          </form>
          <br>
        <div class="table-responsive mt-3">
          <table class="table table-striped table-bordered dataTable no-footer" id="dataTable">
            <thead class="table-secondary">
              
               <tr>
                <th>S.No.</th>
                <th>Applicant Name</th>
                <th>Domain Name</th>
                <th>Institute Name</th>
                <th>Address</th>
                <th>Contact Details</th>
                <th>Domain Creation Date</th>
                <th>Domain Expiry Date</th>
                <th>Domain Deleted on</th>
                <th>Action</th>
                
              </tr>
            </thead>
            <tbody>
              @php
              $i=0;
              @endphp
              @foreach($users_data as $users)
              @php
              $i++;
              @endphp
                  
                      <tr>
                          <td>{{$i}}</td>
                          <td>{{$users->name}}</td>
                          <td>{{$users->domainName}}</td>
                          <td>{{$users->institute}}</td>
                          <td>{{$users->user_address??''}}</td>
                          <td>0{{$users->user_phone??''}}-{{$users->user_mobile??''}}<br>{{$users->email??''}}</td>

                          @if($users->domainCreationDate == Null)
                          <td>NA</td>
                          @else
                          <td>{{\Carbon\Carbon::parse($users->domainCreationDate)->format('d/m/Y')}}</td>
                          @endif

                          @if($users->domainExpiryDate == Null)
                          <td>NA</td>
                          @else
                          <td>{{\Carbon\Carbon::parse($users->domainExpiryDate)->format('d/m/Y')}}</td>
                          @endif

                           @if($users->created_at == Null)
                          <td>NA</td>
                          @else
                          <td>{{\Carbon\Carbon::parse($users->created_at)->format('d/m/Y')}}</td>
                          @endif

                          <td>


<a class="btn btn-outline-primary mx-2" data-toggle="tooltip" data-placement="top"
title="Edit" href="{{url('ernetdash/admin-users-details-deleted')}}/{{base64_encode($users->user_id)}}"> <i class="fa fa-edit"></i></a>


                         </td>

                          
                      </tr>
                 

              
              @endforeach
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>


@endsection
@section("js")

<link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>

<script>
    $(function() {
      $(".datepicker").datepicker({
		 dateFormat: 'dd-mm-yy',
		 constrainInput: false,
		 changeYear:true,
		 changeMonth:true,
		 yearRange:'1980:+0',
		 maxDate:0
	 });
    });
  </script>
  
<script>
$(document).ready(function() {

$('#dataTable').DataTable();
$('body').on('click', '.search', function() {
	$start=$('#from_date').val();
	$end=$('#to_date').val();    
    if($start!= '' && $end!= '' && $start> $end)
    {
    alert("From Date cannot be greater than To Date");
    return false;
    }else{
		table.ajax.reload();
	}
			});

      $('body').on('click', '.exportdata', function() {
	$('#chatexport').submit();
});

			$('.dataTables_filter input').keyup(function() {
			$('.search_text').val($(this).val());
		    });
		
			$('body').on('click', '.exportdata', function() {
				$('#chatexport').submit();
			});

$('body').on('click', '.update_admin_renewal_status', function() {

var id = $(this).attr('data-id');
if (confirm('Are you sure you want to renew this Domain')) {
  $.ajaxSetup({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
  });

  Swal.fire({
        title: "Please wait...",
    })

    Swal.showLoading();

  $.ajax({
    url: "{{route('admin.update_domain_renewal_status')}}",
    dataType : "json",
    type: "post",
    data : {'id':id},
    success : function(response) {

      if(response.status == 'success') {

       Swal.fire({
            icon: 'success',
            text: 'Domain has been renewed successfully',
            showConfirmButton: true,
        }).then(function () {
            window.location.reload();
        });

      } else if(response.status == 'error') {

        alert(response.message);

      }
      else if(response.status == 'exceptionError')
      {
      }
    },
  });

}
return false;
});




$('body').on('click', '.delete_admin', function() {

var id = $(this).attr('data-id');

$('#delete_id').val(id);
$('#exampleModal').modal('show');

});

$('body').on('submit', '#deleteform', function(e) {
  e.preventDefault();
  var current = $(this);		
	var data = current.serialize();

  $.ajaxSetup({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
  });

  Swal.fire({
    title: "Please wait...",
  })

  Swal.showLoading();

  $.ajax({
    url: "{{route('admin.delete_domain')}}",
    dataType : "json",
    type: "post",
    data : data,
    success : function(response) {

      if(response.status == 'success') {

        Swal.fire({
            icon: 'success',
            text: 'Domain has been deleted successfully',
            showConfirmButton: true,
        }).then(function () {
            window.location.reload();
        });

      } else if(response.status == 'error') {

        alert(response.message);

      }
      else if(response.status == 'exceptionError')
      {
      }
    },
  });

})


});
</script>

@endsection
