@extends('layouts.AdminLayout')
@section('content')
    @php
        $user_id = Auth::guard('admin')->user()->id;
        $view_permission = '';
        $edit_permission = '';
        $delete_permission = '';
        if ($user_id == 1) {
            $view_permission = 1;
            $edit_permission = 1;
            $delete_permission = 1;
        } else {
            $permission = getUserHasRoleProgram($user_id, 29);
            if (isset($permission)) {
                $view_permission = $permission->view_priv ?? null;
                $edit_permission = $permission->modify_priv ?? null;
                $delete_permission = $permission->del_priv ?? null;
            }
        }
    @endphp

    <style>
        thead th {
            text-align: center !important;
        }

        @media screen and (min-width: 1024px) {


            table.dataTable th:nth-child(3) {
                width: 200px;
                max-width: 200px;
                word-break: break-all;
                white-space: pre-line;
            }

            table.dataTable td:nth-child(3) {
                width: 200px;
                max-width: 200px;
                word-break: break-all;
                white-space: pre-line;
            }

            table.dataTable th:nth-child(2) {
                width: 160px;
                max-width: 160px;
                word-break: break-all;
                white-space: pre-line;
            }

            table.dataTable td:nth-child(2) {
                width: 160px;
                max-width: 160px;
                word-break: break-all;
                white-space: pre-line;
            }


        }
    </style>
    <div class="content-wrapper">
        <div class="container-xxl flex-grow-1 container-p-y">
            <div class="card mb-4">
                <h5 class="card-header bg-info">{{ $domaintext }}</h5>
                <div class="card-body">
                    <h5 class="my-4">Search Parameters</h5>
                    <form method="get" id="chatexport1" action="{{ route('admin.rejectedexport1') }}">
                        @csrf
                        <div class="row mb-4">
                            <div class="col-md-4">
                                <label class="form-label">Domain Name </label>
                                <input type="text" class="form-control" name="user_name" id="user_name" maxlength="35">
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">Institute Name </label>
                                <input type="text" class="form-control" name="institute_name" id="institute_name">
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">Language </label>
                                <select class="form-control" name="domainLangID" id="domainLangID">
                                    <option value="">Choose Language</option>
                                    @foreach (\Illuminate\Support\Facades\DB::table('domain_languages')->get() as $lang)
                                        <option value="{{ $lang->id }}">{{ $lang->language_name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="row mb-4">
                            <div class="col-md-4">
                                <label class="form-label">Domain Status</label>
                                <select class="form-control" name="status" id="status">
                                    <option value="" selected disabled>Select Status</option>
                                    <option value="0">Registration Application</option>
                                    <option value="1">Renewal Application</option>
                                </select>
                            </div>
                            <div class="d-flex" style="gap: 10px; margin-top: 27px;">

                                <button type="button" class="btn btn-success search" id="search_user_btn"
                                    style="height: 40px;">
                                    Search
                                </button>


                                <button type="submit" class="btn btn-primary"
                                    style="height: 40px; cursor: pointer; color: white;">
                                    Export To Excel
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>


            <br>



            <div class="table-responsive mt-3">
                <table class="table table-striped table-bordered dataTable no-footer" id="dataTable">
                    <thead class="table-secondary">
                        <tr>
                            <th>S.No.</th>
                            <th>Domain Name</th>
                            <th>Institute Name<br>/ Contact No.</th>
                            <th>Last Updated<br> Date</th>
                            <th>Action</th>
                            <th>Domain Status</th>
                            <th>Documents Status</th>
                        </tr>
                    </thead>
                    <tbody>

                    </tbody>
                </table>
            </div>
        </div>
    </div>
    </div>
    </div>

    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <form method="post" id="deleteform" enctype="multipart/form-data">
                {!! csrf_field() !!}
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Delete Domain</h5>

                    </div>
                    <div class="modal-body">

                        <input type="hidden" id="delete_id" name="id">

                        <div class="form-group">
                            <label for="">Remarks </label>
                            <textarea class="form-control" name="delete_remarks" id="delete_remarks" rows="3" required></textarea>
                        </div>


                        <div class="form-group mt-3">
                            <label for="">Deletion Request </label>
                            <input type="file" name="deleteion_request" class="form-control" accept="application/pdf">
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-danger">Delete</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
@section('js')
    <link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
    <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>

    <script>
        $(function() {
            $(".datepicker").datepicker({
                dateFormat: 'dd-mm-yy',
                constrainInput: false,
                changeYear: true,
                changeMonth: true,
                yearRange: '1980:+0',
                maxDate: 0
            });
        });
    </script>


    <script>
        $(document).ready(function() {

            var domainText = "{{ $domaintext }}";

            var table = $('#dataTable').DataTable({
                processing: true,
                serverSide: true,
                "ajax": {
                    "url": "{{ route('rejected.ajaxcall') }}",
                    "type": "GET",
                    "datatype": "json",
                    "data": function(d) {
                        console.log(d);
                        d.domaintext = domainText;
                        d.user_name = $('#user_name').val();
                        d.institute_name = $('#institute_name').val();
                        d.name = $('#name').val();
                        d.from_date = $('#from_date').val();
                        d.end_date = $('#to_date').val();
                        d.status = $('#status').val();
                    }
                },
                columns: [{
                        data: 'id'
                    },
                    {
                        data: 'domain',
                        orderable: true
                    },
                    {
                        data: 'inst',
                        orderable: false
                    },
                    {
                        data: 'last',
                        orderable: false
                    },
                    {
                        data: 'action',
                        orderable: false
                    },
                    {
                        data: 'status',
                        orderable: true
                    },
                    {
                        data: 'docstatus',
                        orderable: false
                    },
                ]
            });

            $('body').on('click', '.search', function() {
                table.ajax.reload();
            });

            $('body').on('click', '.reset', function() {
                window.location.reload();
            });

            $('body').on('click', '.exportdata', function() {
                $('#chatexport1').submit();
            });

            $('body').on('click', '.delete_admin', function() {

                var id = $(this).attr('data-id');

                $('#delete_id').val(id);
                $('#exampleModal').modal('show');

            });

            $('body').on('submit', '#deleteform', function(e) {
                e.preventDefault();
                var current = $(this);
                var data = new FormData($('#deleteform')[0]);

                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                Swal.fire({
                    title: "Please wait...",
                })

                Swal.showLoading();

                $.ajax({
                    type: 'POST',
                    url: "{{ route('admin.delete_domain') }}",
                    data: data,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function(response) {

                        if (response.status == 'success') {

                            Swal.fire({
                                icon: 'success',
                                text: 'Domain has been deleted successfully',
                                showConfirmButton: true,
                            }).then(function() {
                                window.location.reload();
                            });

                        } else if (response.status == 'error') {

                            alert(response.message);

                        } else if (response.status == 'exceptionError') {}
                    },
                });

            })


        });
    </script>
@endsection
