@extends('layouts.AdminLayout')
@section('content')
@php
$user_id=Auth::guard('admin')->user()->id;
$view_permission = '';
$edit_permission = '';
$delete_permission = '';
if($user_id==1)
        {

          $view_permission = 1;
          $edit_permission = 1;
          $delete_permission = 1;
        }
  else{

        $permission = getUserHasRoleProgram($user_id,29);
        if(isset($permission))
        {

          $view_permission = $permission->view_priv??null;
          $edit_permission = $permission->modify_priv??null;
          $delete_permission = $permission->del_priv??null;
          
        }
      }
@endphp

<style>
thead th {
    text-align: center !important;
}
</style>
<div class="content-wrapper">
  <div class="container-xxl flex-grow-1 container-p-y">
    <div class="card mb-4">
      <h5 class="card-header bg-info">{{$domaintext}}</h5>
      <div class="card-body">
          <h5 class="my-4">Search Parameters</h5>
          <form  role="form" id="find_user_form" method="get">
              @csrf
              <div class="row mb-4">
                  <div class="col-md-3">
                      <label class="form-label">Domain Name </label>
                      <input type="text" class="form-control" name="user_name" id="user_name" maxlength="35">
                  </div>
                  <!-- <div class="col-md-3">
                      <label class="form-label">Applicant Name </label>
                      <input type="text" class="form-control" name="name" id="name">
                  </div> -->

                  <div class="col-md-3">
                      <label class="form-label">Institute Name </label>
                      <input type="text" class="form-control" name="institute_name" id="institute_name">
                  </div>
                  <div class="col-md-3">
                      <label class="form-label">Language </label>
                      <select class="form-control"  name="domainLangID" id="domainLangID" >
                          <option value="">Choose Language</option>
                          @foreach(\Illuminate\Support\Facades\DB::table('domain_languages')->get() as $lang)
                              <option value="{{$lang->id}}">{{$lang->language_name}}</option>
                          @endforeach
                      </select>
                  </div>

                  @if($domainStatus=='')
              <div class="col-md-3">
                      <label class="form-label">Domain Status </label>
                      <select class="form-control"  name="domainStatu" id="domainStatu" >
                          <option value="">Select</option>
                          <option value="2">Incomplete Application</option>
                          <option value="5">Pending Domain Creation</option>
                          <option value="6">Active</option>
                          <option value="7">Hold</option> 
                          <option value="11">Pending Restorable</option>
                        </select>
                  </div>
              @endif

              
              </div>
              <div class="row mb-4">

              <input type="hidden" class="form-control" name="domainStatus" id="domainStatus" value="{{$domainStatus??''}}">

            
                  <div class="col-md-3">
                      <label class="form-label">Application Date From</label>

                      <input type="date" class="form-control from_date_start" name="creation_start_date" id="from_date" max="{{ date('Y-m-d') }}" value="{{$creation_start_date??''}}">
                  </div>
                  <div class="col-md-3">
                      <label class="form-label">Application Date To</label>
                      <input type="date" class="form-control to_date_end" name="creation_end_date" id="to_date" max="{{ date('Y-m-d') }}" value="{{$creation_end_date??''}}">
                  </div>


                  @if($domainStatus !=5 && $domaintext !='Rejected' && $domainStatus !=2 && $domaintext !='Incomplete Application') 
			
                  <div class="col-md-3">
                      <label class="form-label">Expiry Date From</label>
                      <input type="date" class="form-control from_date_expiry" name="expiry_start_date" id="expiry_start_date" max="{{ date('Y-m-d') }}" value="{{$expiry_start_date??''}}">
                  </div>
                  <div class="col-md-3">
                      <label class="form-label">Expiry Date To</label>
                      <input type="date" class="form-control to_date_expiry" name="expiry_end_date" id="expiry_end_date" max="{{ date('Y-m-d') }}" value="{{$expiry_end_date??''}}">
                  </div>
                  @endif

                  <div class="col-md-3 d-flex">
                      <button class="btn btn-success search" id="search_user_btn" name="action" value="submit" style="height: 40px;margin-top: 27px; margin-right: 20px;">Search</button>
                      <!-- <a href="{{Route('admin.find-users-details-view')}}" >
                          <input type="button" class="btn btn-info" id="Refresh_user_form_btn" name="action" value="Reset" style="height: 40px;margin-top: 27px;" />
                      </a> -->
                  </div>
              </div>
          </form>
          <br>
        <div class="table-responsive mt-3">
          <table class="table table-striped table-bordered dataTable no-footer" id="dataTable">
            <thead class="table-secondary">
              <tr>
                <!-- <th>Applicant Name</th> -->
                <th>S.No.</th>
                <th>Domain Name</th>
                <th>Institute Name/ Contact No.</th>
                @if($domainStatus!=2)
                <th>Application Date</th>
                @endif
                
                @if($domainStatus==7)
                <th>Domain Hold Date</th>
                @else
                <th>Last Updated Date</th>
                @endif

               @if($domainStatus>=6) <th>Domain Expiry Date</th> @endif
                <!-- <th>Language</th> -->
                <th>Domain Status</th>
                <th>Action</th>
                @if($domainStatus!=6) 
                <th>Documents Status</th> 
                @endif
                
               
              </tr>
            </thead>
            <tbody>
              @php
              $i=0;
              @endphp
              @foreach($users_data as $users)
              @php
              $i++;
              @endphp
                  @if($domaintext =='Rejected')
                      @if($users->is_doc_approved == 0)
                          <tr>
                            <td>{{$i}}</td>
                              <td>{{$users->domainName}}</td>
                              <td>{{$users->institute}} <br> {{\Illuminate\Support\Facades\DB::table('user_contact_details')->where('user_id',$users->id)->first()->phone??''}}</td>
                              <td>{{\Carbon\Carbon::parse($users->created_at)->format('d/m/Y')}}</td>
                              

                @if($domainStatus==7)
                <td>{{\Carbon\Carbon::parse($users->domainExpiryDate)->format('d/m/Y')}}</td>
                @else
                <td>{{\Carbon\Carbon::parse($users->updated_at)->format('d/m/Y')}}</td>
                @endif
                              @if($domainStatus>=6)   <td>{{\Carbon\Carbon::parse($users->domainExpiryDate)->format('d/m/Y')}}</td>  @endif
                              <!-- <td>{{DB::table('domain_languages')->where('id',$users->domainLangID)->first()->language_name??''}}</td> -->
                              <td>
                                  @if($view_permission == 1)
                                  <a class="btn btn-outline-success" href="{{Route('admin.users-details-view',['id'=>$users->id])}}"> View Details</a>
                                  @endif
                                  @if($delete_permission == 1)
                                  <a class="delete_admin btn btn-danger mt-3 text-white" href="javascript:void(0)" data-id="{{$users->id}}">Delete</a>
                                  @endif
                                  @if($edit_permission == 1)
                                  @if($users->domainStatus == 10 && $users->is_doc_approved == 2 && $domaintext=='Renewal Domain Application')
                                      <a class="update_admin_renewal_status btn btn-primary mt-3 text-white" href="javascript:void(0)" data-id="{{$users->id}}">Renew Domain</a>
                                  @elseif($users->domainStatus == 10 && $domaintext=='Renewal Domain Application')
                                      <a class="btn btn-primary mt-3 text-white" href="javascript:void(0)">Pending for Renewal Domain</a>
                                  @else
                                  @endif
                                  @endif

                                  {{--              <i class="fa fa-trash fs-3 me-md-3 text-danger delete-user-domain" title="Delete"></i>--}}
                              </td>
                              @if($edit_permission == 1)
                              <td>

                                  @if($users->is_doc_approved == 0)
                                      <a class="btn btn-outline-danger" href="{{Route('admin.users-details-view-doc',['id'=>$users->id])}}"> Clarification Required ({{$users->pending_doc}}) </a>
                                  @elseif($users->is_doc_approved == 1)
                                      <a class="btn btn-outline-info" href="{{Route('admin.users-details-view-doc',['id'=>$users->id])}}"> Pending Approval </a>
                                  @elseif($users->is_doc_approved == 2)
                                      <a class="btn btn-outline-success" href="{{Route('admin.users-details-view-doc',['id'=>$users->id])}}"> Document Approved </a>
                                  @else
                                      <a class="btn btn-outline-danger" href="javascript:void(0)"> Not Uploaded </a>
                                  @endif
                              </td>
                              @endif
                          </tr>
                      @endif
                  @else
                      <tr>
                        <td>{{$i}}</td>
                          <!-- <td>{{$users->name}}</td> -->
                          <td>{{$users->domainName}}</td>
                          <td >{{$users->institute}}<br> {{\Illuminate\Support\Facades\DB::table('user_contact_details')->where('user_id',$users->id)->first()->phone??''}}</td>
                          @if($domainStatus!=2)
                          @if($users->applicationDate == Null)
                              <td>NA</td>
                              @else
                              <td>{{\Carbon\Carbon::parse($users->applicationDate)->format('d/m/Y')}}</td>
                              @endif
                          @endif

                              <!-- @if($users->updated_at == Null)
                              <td>NA</td>
                              @else
                              <td>{{\Carbon\Carbon::parse($users->updated_at)->format('d/m/Y')}}</td>
                              @endif -->

                @if($domainStatus==7)
                <td>{{\Carbon\Carbon::parse($users->domainExpiryDate)->format('d/m/Y')}}</td>
                @elseif($users->updated_at == Null)
                <td>NA</td>
                @else
                <td>{{\Carbon\Carbon::parse($users->updated_at)->format('d/m/Y')}}</td>
                @endif
                          
                          @if($domainStatus>=6) <td>{{\Carbon\Carbon::parse($users->domainExpiryDate)->format('d/m/Y')}}</td>  @endif

                          <td>
                            @if($users->domainStatus<=4)
                              Incomplete Application
                            @elseif($users->domainStatus==5)
                             Pending Domain Creation
                            @elseif($users->domainStatus==6)
                             Active Domain
                            @elseif($users->domainStatus==7)
                            Hold Domain
                            @elseif($users->domainStatus==8)
                            Pending Restorable
                            @elseif($users->domainStatus==11)
                            Pending Restorable
                            @elseif($users->domainStatus==10)
                            Renewal Application
                            @else 
                            
                            @endif
                          </td>
                          <td style="width: 150px;">
                          @if($edit_permission == 1)
                          <a class="btn btn-outline-primary" data-toggle="tooltip" data-placement="top"
                          title="Edit" href="{{Route('admin.users-details-view',['id'=>base64_encode($users->id)])}}"> <i class="fa fa-edit"></i></a>

                          <!-- <a class="send_invoice btn btn-warning text-white" data-toggle="tooltip" data-placement="top"
                          title="Send Invoice" href="javascript:void(0)" data-id="{{$users->id}}"><i class="fa fa-envelope"></i> </a> -->

                          @endif
                          @if($delete_permission == 1)
                          <a class="delete_admin btn btn-danger text-white" data-toggle="tooltip" data-placement="top"
                          title="Delete" href="javascript:void(0)" data-id="{{$users->id}}"><i class="fa fa-trash"></i> </a>

                          @if($users->domainExpiryDate>\Carbon\Carbon::now()->format('Y-m-d') && $domainStatus==6 )
                          <a href="javascript:void(0)" style="color:#fff;" class="hold_button btn btn-danger" data-id="{{$users->id}}">Hold</a>
                          @endif
                          
                          @if($users->domainExpiryDate>\Carbon\Carbon::now()->format('Y-m-d') && $domainStatus==7)
                          <a href="javascript:void(0)" style="color:#fff;" class="unhold_button btn btn-danger" data-id="{{$users->id}}">Unhold</a>
                          @endif

                          @endif

                          
        
                              @if($edit_permission == 1)
                              @if($users->domainStatus == 10 && $users->is_doc_approved == 2 && $domaintext=='Renewal Domain Application')
                                  <a class="update_admin_renewal_status btn btn-primary mt-3 text-white" href="javascript:void(0)" data-id="{{$users->id}}">Renew Domain</a>
                              @elseif($users->domainStatus == 10 && $domaintext=='Renewal Domain Application')
                                  <a class="btn btn-primary text-white" href="javascript:void(0)">Pending for Renewal Domain</a>
                              @else
                              @endif
                              @endif
                            </td>
                            @if($edit_permission == 1)
                           @if($domainStatus!=6) 
                          <td>
                            
                              @if($users->is_doc_approved == 0)
                                  <a class="btn btn-outline-danger" href="{{Route('admin.users-details-view-doc',['id'=>base64_encode($users->id)])}}"> Clarification Required ({{$users->pending_doc}}) </a>
                              @elseif($users->is_doc_approved == 1)
                                  @if($users->applicationDate!="")
                                  <a class="btn btn-outline-info" href="{{Route('admin.users-details-view-doc',['id'=>base64_encode($users->id)])}}"> Pending Approval </a>
                                  @else
                                  <a class="btn btn-outline-warning" href="javascript:void(0)">Final Submission Pending </a>
                                  @endif

                              @elseif($users->is_doc_approved == 2)
                                  <a class="btn btn-outline-success" href="{{Route('admin.users-details-view-doc',['id'=>base64_encode($users->id)])}}"> Document Approved </a>
                              @else
                                  <a class="btn btn-outline-danger" href="javascript:void(0)"> Not Uploaded </a>
                              @endif

                          </td>
                          @endif
                          @endif

                      </tr>
                  @endif

              {{-- <tr>
                <td colspan="6"><p class="text-danger text-center py-3"> Data Not Found ! </p></td>
              </tr> --}}
              @endforeach
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>

<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
  <form method="post" id="deleteform">
    {!! csrf_field() !!}
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Delete Domain</h5>
        <!-- <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button> -->
      </div>
      <div class="modal-body">
    
         <input type="hidden" id="delete_id" name="id">

         <div class="form-group">
           <label for="">Remarks </label>
           <textarea class="form-control" name="delete_remarks" id="delete_remarks" rows="3" required></textarea>
         </div>

      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        <button type="submit" class="btn btn-danger">Delete</button>
      </div>
    </div>
    </form>
  </div>
</div>

<div class="modal fade" id="holdModal" tabindex="-1" role="dialog" aria-labelledby="holdModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
  <form method="post" id="holdform">
    {!! csrf_field() !!}
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="holdModalLabel">Hold Domain</h5>
      </div>
      <div class="modal-body">
    
         <input type="hidden" id="hold_id" name="hold_id">

         <div class="form-group">
           <label for="">Remarks </label>
           <textarea class="form-control" name="hold_remarks" id="hold_remarks" rows="3" required></textarea>
         </div>

      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        <button type="submit" class="btn btn-danger">Hold</button>
      </div>
    </div>
    </form>
  </div>
</div>


<div class="modal fade" id="unholdModal" tabindex="-1" role="dialog" aria-labelledby="unholdModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
  <form method="post" id="unholdform">
    {!! csrf_field() !!}
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="unholdModalLabel">Unhold Domain</h5>
      </div>
      <div class="modal-body">
    
         <input type="hidden" id="unhold_id" name="unhold_id">

         <div class="form-group">
           <label for="">Remarks </label>
           <textarea class="form-control" name="unhold_remarks" id="unhold_remarks" rows="3" required></textarea>
         </div>

      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        <button type="submit" class="btn btn-danger">Unhold</button>
      </div>
    </div>
    </form>
  </div>
</div>


@endsection
@section("js")
<script>
$(document).ready(function() {

$('#dataTable').DataTable();
$('body').on('click', '.search', function() {
	$start=$('#from_date').val();
	$end=$('#to_date').val();    
    if($start!= '' && $end!= '' && $start> $end)
    {
    alert("From Date cannot be greater than To Date");
    return false;
    }else{
		table.ajax.reload();
	}
			});

			$('.dataTables_filter input').keyup(function() {
			$('.search_text').val($(this).val());
		    });
		
			$('body').on('click', '.exportdata', function() {
				$('#chatexport').submit();
			});

$('body').on('click', '.update_admin_renewal_status', function() {

var id = $(this).attr('data-id');
if (confirm('Are you sure you want to renew this Domain')) {
  $.ajaxSetup({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
  });

  Swal.fire({
        title: "Please wait...",
    })

    Swal.showLoading();

  $.ajax({
    url: "{{route('admin.update_domain_renewal_status')}}",
    dataType : "json",
    type: "post",
    data : {'id':id},
    success : function(response) {

      if(response.status == 'success') {

       Swal.fire({
            icon: 'success',
            text: 'Domain has been renewed successfully',
            showConfirmButton: true,
        }).then(function () {
            window.location.reload();
        });

      } else if(response.status == 'error') {

        alert(response.message);

      }
      else if(response.status == 'exceptionError')
      {
      }
    },
  });

}
return false;
});



$('body').on('click', '.hold_button', function() {

var id = $(this).attr('data-id');

$('#hold_id').val(id);
$('#holdModal').modal('show');

});

$('body').on('submit', '#holdform', function(e) {
  e.preventDefault();
  var current = $(this);		
  var data = current.serialize();

  $.ajaxSetup({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
  });

  Swal.fire({
    title: "Please wait...",
  })

  Swal.showLoading();

  $.ajax({
    url: "{{route('domain.hold')}}",
    dataType : "json",
    type: "post",
    data : data,
    success : function(response) {

      if(response.status == 'success') {

        Swal.fire({
            icon: 'success',
            text: 'Domain has been hold successfully',
            showConfirmButton: true,
        }).then(function () {
            window.location.reload();
        });

      } else if(response.status == 'error') {

        alert(response.message);

      }
    },
  });

})


$('body').on('click', '.delete_admin', function() {

var id = $(this).attr('data-id');

$('#delete_id').val(id);
$('#exampleModal').modal('show');

});

$('body').on('submit', '#deleteform', function(e) {
  e.preventDefault();
  var current = $(this);		
	var data = current.serialize();

  $.ajaxSetup({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
  });

  Swal.fire({
    title: "Please wait...",
  })

  Swal.showLoading();

  $.ajax({
    url: "{{route('admin.delete_domain')}}",
    dataType : "json",
    type: "post",
    data : data,
    success : function(response) {

      if(response.status == 'success') {

        Swal.fire({
            icon: 'success',
            text: 'Domain has been deleted successfully',
            showConfirmButton: true,
        }).then(function () {
            window.location.reload();
        });

      } else if(response.status == 'error') {

        alert(response.message);

      }
      else if(response.status == 'exceptionError')
      {
      }
    },
  });

})


$('body').on('click', '.unhold_button', function() {

var id = $(this).attr('data-id');

$('#unhold_id').val(id);
$('#unholdModal').modal('show');

});

$('body').on('submit', '#unholdform', function(e) {
  e.preventDefault();
  var current = $(this);		
  var data = current.serialize();

  $.ajaxSetup({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
  });

  Swal.fire({
    title: "Please wait...",
  })

  Swal.showLoading();

  $.ajax({
    url: "{{route('domain.unhold')}}",
    dataType : "json",
    type: "post",
    data : data,
    success : function(response) {

      if(response.status == 'success') {

        Swal.fire({
            icon: 'success',
            text: 'Domain has been Unhold successfully',
            showConfirmButton: true,
        }).then(function () {
            window.location.reload();
        });

      } else if(response.status == 'error') {

        alert(response.message);

      }
    },
  });

})


$('body').on('click', '.send_invoice', function(e) {
        e.preventDefault();
        var id = $(this).attr('data-id');
        if (confirm('Are you sure you want to send the ivoice')) {

        $.ajaxSetup({
                      headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                      }
                    });
        Swal.fire({
            title: "Sending..."
            
        })
        Swal.showLoading();
        $.ajax({
                url: "{{route('admin.send_invoice')}}",
                dataType : "json",
                type: "post",
                data : {'id':id},
                success : function(response) {

                  if(response.status == 'success') {

                   Swal.fire({
                        icon: 'success',
                        text: 'Invoice sent!',
                        showConfirmButton: true,
                    }).then(function () {
                        window.location.reload();
                    });

                  } else if(response.status == 'error') {

                    alert(response.message);

                  }
                  else if(response.status == 'exceptionError')
                  {
                  }
                },
              });
      }
      return false;
    });


});
</script>

@endsection
