@extends('layouts.AdminLayout')
@section('content')

<?php

$action='';

$userid=Auth::guard('admin')->user()->id;

$edit=$del=$add=true;
$priv=getUserHasRoleProgram($userid,12);

if($priv!=null){
    $edit=$priv->modify_priv==1 ?true:false;
    $del=$priv->del_priv==1 ?true:false;
    $add=$priv->add_priv==1 ?true:false;
}
$head_name = get_heading_name(12);
   if($head_name!=null){
       $heading_name= $head_name;
   }else
   {
      $heading_name="Home Page Offer Section Details ";
   }


?>
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <div class="card mb-4">
                <h5 class="card-header">{{$heading_name}}
                @if($add)
<button class="btn btn-info float-end "  data-bs-toggle="modal" data-bs-target="#add_offer_modal"> + Add Offer</button>
@endif</h5>
                <div class="card-body">
                    <div class="table-responsive">

                        <div class="table-responsive">
                            <table class="table table-striped table-bordered cell-border" id="domain_extension_price_table">
                            <thead class="table-secondary">
                            <tr>
                                <th>Id</th>
                                <th>Title</th>
                                <th>Description</th>
                                <th>Discount</th>
                                <th>Expiry Date</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tbody>
                                @php
                                  $i=0;
                                @endphp
                            @foreach($offerItems as $offersItem)
                            @php
                            $i++;
                            @endphp
                                <tr>
                                    <td>{{$i}}</td>
                                    <td>{{ $offersItem->title }}</td>
                                    <td>{{ $offersItem->description }}</td>
                                    <td>{{ $offersItem->discount }}</td>
                                    <td>{{ \Carbon\Carbon::parse($offersItem->exp_date)->format('d-m-Y')  }}</td>
                                    <td>
                                        <button class="btn btn-sm {{ $offersItem->status == 1 ? 'btn-success' : 'btn-danger' }} change-status-btn"data-id="{{ $offersItem->id }}"data-status="{{ $offersItem->status }}">
                                                {{ $offersItem->status == 1 ? 'Active' : 'Inactive' }}
                                        </button>
                                    </td>
                                    <td>
                                    @if($del)
                                        <button class="btn btn-danger delete-offer" data-id="{{ $offersItem->id }}"><i class="fa fa-trash"></i> </button>
                                    @endif
                                    @if($edit)
                                        <button class="btn btn-info edit-offer" data-id="{{ $offersItem->id }}"><i class="fa fa-edit"></i> </button>
                                    @endif
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- / Content -->
        <!-- Modal -->
        <div class="modal fade add_offer_modal" id="add_offer_modal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="staticBackdropLabel">Add Offer</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form role="form" id="add_offer_form" method="POST">
                        @csrf
                        <div class="modal-body">

                            <div class="me-md-3  mb-4">
                                <label class="form-label">Title </label>
                                <input type="text" class="form-control validate" name="title" id="title" required>
                            </div>
                            <div class="me-md-3  mb-4">
                                <label class="form-label">Description </label>
                                <input type="text" class="form-control validate" name="description" id="description" required>
                            </div>
                            <div class="me-md-3  mb-4">
                                <label class="form-label">Discount (in %)</label>
                                <input type="number" class="form-control validate" name="discount" id="discount" required min="0" max="100" oninput="validateDiscount(this)" pattern="[0-9]*">
                            </div>
                            <div class="me-md-3  mb-4">
                                <label class="form-label">Expiry Date</label>
                                <input type="Date" class="form-control" name="exp_date" id="exp_date" required min="<?php echo date('Y-m-d'); ?>">
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                            <button class="btn btn-primary d-grid" id="add_offer_btn" name="action" value="submit">Add</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="modal fade add_offer_modal" id="edit_offer_modal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="staticBackdropLabel">Edit Offer</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form role="form" id="edit_offer_form" method="POST">
                        @csrf
                        <div class="modal-body">
                        <div class="me-md-3  mb-4">
                                <label class="form-label">Title </label>
                                <input type="text" class="form-control validate title" name="title" id="edit_title" required>
                            </div>
                            <div class="me-md-3  mb-4">
                                <label class="form-label">Description </label>
                                <input type="text" class="form-control validate description" name="description" id="edit_description" required>
                            </div>
                            <div class="me-md-3  mb-4">
                                <label class="form-label">Discount (in %)</label>
                                <input type="number" class="form-control validate discount" name="discount" id="edit_discount" required min="0" max="100" oninput="validateDiscount(this)" pattern="[0-9]*">
                            </div>
                            <div class="me-md-3  mb-4">
                                <label class="form-label">Expiry Date</label>
                                <input type="Date" class="form-control exp_date" name="exp_date" id="edit_exp_date" required min="<?php echo date('Y-m-d'); ?>">
                                <input type="hidden" name="offer_id" id="offer_id">
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                            <button class="btn btn-primary d-grid" id="edit_offer_btn" name="action" value="submit">Update</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

    </div>
@endsection
@section("js")
    <script>
        //$('#domain_extension_price_table').DataTable();
        $(document).ready(function() {
            $('#add_offer_form').validate({
                rules: {
                    title: { maxlength:255,},
                    description: { maxlength:255,},
                    discount: { digits: true,},
                    exp_date: { date: true,},
                },
                messages: {
                    title: {required: "Please enter a title."},
                    description: {required: "Please enter a description."},
                    discount: {digits: "Please enter a valid discount."},
                    exp_date: {date: "Please enter a valid date."}
                },
                submitHandler:function(form)
                {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
                    $.ajax({
                        url:"{{Route('admin.add-offer-section')}}",
                        type:'POST',
                        dataType:'json',
                        data:$("#add_offer_form").serialize(),
                        cache: false,
                        beforeSend: function(){
                            $(".loader-area").show();
                            // $("#add_offer_btn").prop('disabled',true);
                        },
                        success:function(res)
                        {
                            if(res.status=='success')
                            {
                                Swal.fire({
                                    position: 'center',
                                    icon: 'success',
                                    text: res.message,
                                    showConfirmButton: true,
                                });
                                setTimeout(function() {
                                    window.location = "{{route('admin.offer-section-view')}}";
                                }, 2000);

                            }
          else if(res.status=='errors')
          {
            
            $.each(res.message, function(i, message) {
	            $('#'+i).after('<span class="Description_error" style="color:red">'+message+'</span>');
			});

          }
                            
                            else
                            {
                                Swal.fire({
                                    position: 'center',
                                    icon: 'error',
                                    text: res.message,
                                    showConfirmButton: true,
                                });
                            }
                        },
                        complete: function(){
                            // $("form").trigger("reset");
                            // $("#add_price_btn").prop('disabled',false);
                        },
                    });
                }
            });


            $('.change-status-btn').click(function() {
                var offerId = $(this).data('id');
                var status = $(this).data('status') === 1 ? 0 : 1;
                Swal.fire({
                    title: 'Are you sure?',
                    text: 'You are about to change the status of this news item. This action cannot be undone.',
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#28a745',
                    cancelButtonColor: '#6c757d',
                    confirmButtonText: 'Confirm',
                    cancelButtonText: 'Cancel'
                }).then((result) => {
                    if (result.isConfirmed) {
                        $.ajax({
                            url: "{{ route('admin.change-offer-status') }}",
                            type: 'POST',
                            dataType: 'json',
                            data: {
                                "_token": "{{ csrf_token() }}",
                                offerId: offerId,
                                status: status
                            },
                            success: function(response) {
                                if (response.status === 'success') {
                                    Swal.fire({
                                        position: 'center',
                                        icon: 'success',
                                        text: response.message,
                                        showConfirmButton: true
                                    });
                                    setTimeout(function() {
                                        window.location = "{{route('admin.offer-section-view')}}";
                                    }, 2000);
                                } else {
                                    // Show an error message
                                    Swal.fire({
                                        position: 'center',
                                        icon: 'error',
                                        text: response.message,
                                        showConfirmButton: true
                                    });
                                }
                            },
                            error: function(xhr, status, error) {
                                // Show an error message
                                Swal.fire({
                                    position: 'center',
                                    icon: 'error',
                                    text: 'An error occurred. Please try again.',
                                    showConfirmButton: true
                                });
                            }
                        });
                    }
                });
            });




        // AJAX request to delete a news item
        $('.delete-offer').click(function() {
            var offerId = $(this).data('id');

            Swal.fire({
                title: 'Are you sure?',
                text: 'You are about to delete this offer item. This action cannot be undone.',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#dc3545',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Delete',
                cancelButtonText: 'Cancel'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: "{{ route('admin.delete-offer') }}",
                        type: 'POST',
                        data: {
                            "_token": "{{ csrf_token() }}",
                            offerId: offerId
                        },
                        dataType: 'json',
                        success: function(res) {
                            if (res.status === 'success') {
                                $('#domain_extension_price_table').find('tr[data-id="' + offerId + '"]').remove();
                                Swal.fire({
                                    position: 'center',
                                    icon: 'success',
                                    text: res.message,
                                    showConfirmButton: true
                                });
                                setTimeout(function() {
                                    window.location = "{{route('admin.offer-section-view')}}";
                                }, 2000);
                            } else {
                                // Show error message
                                Swal.fire({
                                    position: 'center',
                                    icon: 'error',
                                    text: res.message,
                                    showConfirmButton: true
                                });
                            }
                        },
                        error: function(xhr, status, error) {
                            // Show error message
                            Swal.fire({
                                position: 'center',
                                icon: 'error',
                                text: 'An error occurred while deleting the news item. Please try again.',
                                showConfirmButton: true
                            });
                        }
                    });
                }
            });
        });

    $('.edit-offer').click(function() {
        var offerId = $(this).data('id');
        $.ajax({
            url: "{{ route('admin.get-offer') }}",
            type: "POST",
            data: {
                "_token": "{{ csrf_token() }}",
                offerId: offerId
            },
            dataType: "json",
            success: function(response) {
                if (response.status === 'success') {
                    var offer = response.offer;
                    $('#offer_id').val(offer.id);
                    $('#edit_title').val(offer.title);
                    $('#edit_description').val(offer.description);
                    $('#edit_discount').val(offer.discount);
                    // Convert the date string to a Date object
                    var expDate = new Date(offer.exp_date).toLocaleDateString("sv");
                    // Format the date as YYYY-MM-DD
                    var formattedExpDate = expDate;
                    $('#edit_exp_date').val(formattedExpDate);
                    $('#edit_offer_modal').modal('show');
                } else {
                    console.log(response.message);
                }
            },
            error: function(xhr, status, error) {
                console.log(error);
            }
        });
    });

    $('#edit_offer_form').validate({
        rules: {
            title: { maxlength:255,},
            description: { maxlength:255,},
            discount: { digits: true,},
            exp_date: { date: true,},
        },
        messages: {
            title: {required: "Please enter a title."},
            description: {required: "Please enter a description."},
            discount: {digits: "Please enter a valid discount."},
            exp_date: {date: "Please enter a valid date."}
        },
        submitHandler:function(form){
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url:"{{Route('admin.update-offer-section')}}",
                type:'POST',
                dataType:'json',
                data:$("#edit_offer_form").serialize(),
                cache: false,
                beforeSend: function(){
                    $(".loader-area").show();
                    // $("#edit_offer_btn").prop('disabled',true);
                },
                success:function(res)
                {
                    if(res.status=='success'){
                        Swal.fire({
                            position: 'center',
                            icon: 'success',
                            text: res.message,
                            showConfirmButton: true,
                        });
                        setTimeout(function() {
                            window.location = "{{route('admin.offer-section-view')}}";
                        }, 2000);
                    }
                    else if(res.status=='errors')
          {
            
            $.each(res.message, function(i, message) {
				$('.'+i).after('<span class="Description_error" style="color:red">'+message+'</span>');
			});

          }
                    else
                    {
                        Swal.fire({
                            position: 'center',
                            icon: 'error',
                            text: res.message,
                            showConfirmButton: true,
                        });
                    }
                },
                complete: function(){
                    // $("form").trigger("reset");
                    // $("#edit_offer_btn").prop('disabled',false);
                },
            });
        }
    });

    $('.validate').keypress(function(e) {
            var txt = String.fromCharCode(e.which);
            if (!txt.match(/[a-zA-Z0-9% ]/)) {
                return false;
            }
        }); 

});
function validateDiscount(input) {
        input.value = input.value.replace(/\D/g, '');
        if (parseInt(input.value) > 100) {
            input.value = '100';
        }
    }

var currentDate = new Date().toISOString().split('T')[0];
document.getElementById("exp_date").min = currentDate;
document.getElementById("edit_exp_date").min = currentDate;

</script>
@endsection
