<!DOCTYPE html>
<html
  lang="en"
  class="light-style customizer-hide"
  dir="ltr"
  data-theme="theme-default"
  data-assets-path="../assets/"
  data-template="vertical-menu-template-free"
>
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>{{$pageTitle}}</title>
    <meta name="description" content="" />
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="{{asset('assets/img/favicon/favicon.ico')}}" />
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap" rel="stylesheet" />
    <!-- Icons. Uncomment required icon fonts -->
    <link rel="stylesheet" href="{{asset('assets/vendor/fonts/boxicons.css')}}" />
    
    <!-- Core CSS -->
    <link rel="stylesheet" href="{{asset('assets/vendor/css/core.css')}}" class="template-customizer-core-css" />
    <link rel="stylesheet" href="{{asset('assets/vendor/css/theme-default.css')}}" class="template-customizer-theme-css" />
    
    <!-- Vendors CSS -->
    <link rel="stylesheet" href="{{asset('admin/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css')}}" />
    <link rel="stylesheet" href="{{asset('admin/assets/vendor/css/pages/page-auth.css')}}" />
    <!-- Helpers -->
    <script src="{{asset('admin/assets/vendor/js/helpers.js')}}"></script>
      <script src="{{asset('assets/js/config.js')}}"></script>
      <link rel="stylesheet" href="{{asset('/assets/css/sweetalert2.min.css')}}" />
      <script src="{{asset('/assets/js/sweetalert2.min.js')}}"></script>

  </head>

  <body oncontextmenu="return false;">

    <div class="container-xxl">
        <div class="authentication-wrapper authentication-basic container-p-y">
            <div class="authentication-inner">
                <!-- Register -->
                <div class="card">
                    <div class="card-body">
                        <!-- Logo -->
                        <div class="app-brand justify-content-center">
                            <a href="" class="app-brand-link gap-2">
                  <span class="app-brand-logo demo">
                     <img style="    height: 50px;    width: auto;" src="{{asset('user/assets/img/logo.png')}}">
                  </span>
                            </a>
                        </div>
                        <div class="col-md mb-4 mb-md-0">
                            <!-- <div class="card"> -->
                                @if(Session::has('message'))
                                    <p class="alert text-dark {{ Session::get('alert-class', 'alert-danger') }}">{{ Session::get('message') }}</p>
                                @endif
                                @if ($errors->any())
                                    <!-- <div class="card-body"> -->
                                        <ul>
                                            @foreach ($errors->all() as $error)
                                                <div class="alert alert-danger" role="alert">{{ $error }}!</div>
                                            @endforeach
                                        </ul>
                                    <!-- </div> -->
                                @endif
                            <!-- </div> -->
                        </div>
                        <br>

                        <form role="form" id="adminloginForm" method="POST">
                            @csrf

                            <input type="hidden" name="login_type" id="login_type" value="{{$pageTitle}}">

                            <div class="mb-3">
                                <label for="email" class="form-label">Username</label>
                                <input
                                    type="text"
                                    class="form-control specialchars"
                                    id="admin_login_email"
                                    name="admin_login_email"
                                    placeholder="Enter your Username"
                                    autofocus
                                    required
                                />
                            </div>

                            <div class="mb-3 form-password-toggle">
                                <div class="d-flex justify-content-between">
                                    <label class="form-label" for="password">Password</label>
                                    <a href="{{ url('ernetdash/forgot') }}">
                                        <small>Forgot Password?</small>
                                    </a>
                                </div>
                                <div class="input-group input-group-merge">
                                    <input
                                        type="password"
                                        id="admin_login_password"
                                        class="form-control passwordchars"
                                        name="admin_login_password"
                                        placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;"
                                        aria-describedby="password"
                                        required
                                    />
                                    <span class="input-group-text cursor-pointer"><i class="bx bx-hide"></i></span>
                                </div>
                            </div>
                            <div class="mb-3 d-none">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="remember" id="remember-me" />
                                    <label class="form-check-label" for="remember-me"> Remember Me </label>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-8">

                                </div>
                                <!-- /.col -->
                                <div class="col-4">
                                    <button class="btn btn-primary btn-block" id="admin-login-btn" name="action" value="vender-Login">Login</button>
                                </div>
                                <!-- /.col -->
                            </div>
                        </form>

{{--                        <p class="text-center">--}}
{{--                            <span>New on our platform?</span>--}}
{{--                            <a href="{{route('admin.register')}}">--}}
{{--                                <span>Create an account</span>--}}
{{--                            </a>--}}
{{--                        </p>--}}
                    </div>
                </div>
                <!-- /Register -->
            </div>
        </div>
    </div>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.4/jquery.min.js"></script>
    <script src="{{asset('assets/vendor/libs/popper/popper.js')}}"></script>
    <script src="{{asset('assets/vendor/js/bootstrap.js')}}"></script>
    <script src="{{asset('assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js')}}"></script>

    <script src="{{asset('assets/vendor/js/menu.js')}}"></script>
    <!-- endbuild -->

    <!-- Vendors JS -->
    <script src="{{asset('assets/vendor/libs/apex-charts/apexcharts.js')}}"></script>

    <!-- Main JS -->
    <script src="{{asset('assets/js/main.js')}}"></script>

    <!-- Page JS -->
    <script src="{{asset('assets/js/dashboards-analytics.js')}}"></script>
    <!-- jquery-validation -->
    <script src="{{asset('assets/plugins/jquery-validation/jquery.validate.min.js')}}"></script>
    <script src="{{asset('assets/plugins/jquery-validation/additional-methods.min.js')}}"></script>
    <!-- Place this tag in your head or just before your close body tag. -->
    <script async defer src="{{asset('assets/js/buttons.js')}}"></script>
    
    <script type="text/javascript">
      $(document).ready(function()
      {


$('.specialchars').on('keypress',function(e){

var regex=new RegExp("^[a-zA-Z@#!$0-9 ]");
var key=String.fromCharCode(!e.charCode ? e.which :e.charCode);
if(!regex.test(key)){
    e.preventDefault();
    return false;
}

});


$('.passwordchars').on('keypress',function(e){

var regex=new RegExp("^[a-zA-Z@#!$0-9 ]");
var key=String.fromCharCode(!e.charCode ? e.which :e.charCode);
if(!regex.test(key)){
    e.preventDefault();
    return false;
}

});



$(document).keydown(function (event) {
    if (event.keyCode == 123) { 
        return false;
    } else if (event.ctrlKey && event.shiftKey && event.keyCode == 73) {         
        return false;
    }
});


        $("#adminloginForm").validate({
              rules:
              {
                admin_login_email:{
                  required: true,
                  minlength:2
                },
                admin_login_password:{
                  required: true,
                  minlength: 5
                }
              },
              messages:
              {
                 admin_login_email:
                 {
                    required: "Please enter valid Email",
                    minlength:'Please enter valid Email'
                 },
                 admin_login_password:
                 {
                   required: "Please enter valid password",
                   minlength: "Invalid Credentials"
                 }
              },
              submitHandler:function (form)
              {
                if($("#adminloginForm").valid())
                {
                   $.ajax({
                      url:"{{route('admin.login-request')}}",
                      type:'POST',
                      dataType:'json',
                      data:$("#adminloginForm").serialize(),
                      cache: false,
                      beforeSend:function()
                      {
                        //$("#admin-login-btn").prop('disabled',true);
                        $('.cs-process-loader').show();
                      },
                      success:function(data)
                      {
                        if(data.status=='bulkuploaderrole')

                        {
                            Swal.fire({
                            title: "Success!",
                            text: "Successfully logged into the system.",
                            icon: "success",
                            button:false
                          });
                          window.location="{{route('manage.domain')}}";

                        } else{
                        if(data.status=='success')
                        {
                            
                          Swal.fire({
                            title: "Success!",
                            text: "Logged in successfully.",
                            icon: "success",
                            button:false
                          });
                          window.location="{{route('admin.dashboard')}}";
                        }
                        else if(data.status=='figcheck')
                        {
                           

                            Swal.fire({
                            title: 'Success!',
                            icon: 'success',
                            text: 'Logged in successfully.',
                            showConfirmButton: true,
                        }).then(function () {
                            window.location="{{route('admin.dashboard')}}";
                        });

                        }
                        else if(data.status=='samelogin')
                        {
                           
                            Swal.fire({
                            
                            title: 'Confirmation',
                            text: 'This user is already logged in. If you login then current session will expire. Are you sure, you want to proceed?',
                            icon: 'question',
                            showCancelButton: true,
                            confirmButtonText: 'Yes',
                            cancelButtonText: 'No'
                            
                        }).then((result) => {
                            if (result.isConfirmed) {
                                $.ajaxSetup({
                                                headers: {
                                                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                                }
                                            });
                    
                                        $.ajax({
                                            url: "{{route('admin.accesstokenupdate')}}",
                                            dataType : "json",
                                            type: "get",
                                            data : {},
                                            success : function(response) {
                                                
                                                if(response.status == 'success') {
                                                     
                                                     window.location="{{route('admin.dashboard')}}";
                                                                                    
                                                } else if(response.status == 'error') {
                                                    
                                                    window.location="{{route('admin.login')}}";
                                                    
                                                } 
                                          },
                                        });
                             
                         } else
                         {
                            window.location="{{route('admin.login')}}";
                         }
                        });
                        }
                       
                        else if (data.status == 'error') {
                        Swal.fire({
                            title: 'Error!',
                            text: 'Invalid Credentails',
                            icon: 'error'
                        });
                        }
                        
                        else
                        {
                          Swal.fire({
                            title: "Error!",
                            text: data.message,
                            icon: "error"
                          });
                        }
                    }
                },
                        error: function (data, textStatus, errorThrown) {
                        Swal.fire({
                            title: 'Error!',
                            text:"Invalid Credentails",
                            icon: 'error'
                        });
                    },
                      complete:function()
                      {
                        $("#login-btn").prop('disabled',false);
                        $('.cs-process-loader').hide();
                      }
                   });
                }
              }
          });
      });
    </script>

  </body>
</html>
