@extends('layouts.AdminLayout')
@section('content')
<style>
 
</style>
<div class="content-wrapper">
  <div class="container-xxl flex-grow-1 container-p-y">
    <div class="card mb-4">
      <div class="card-body">
        <div class="row">
            <div class="col-md-12">
                <div class="card mb-4">
                    <div class="d-flex">
                        <h5 class="card-header">Uploaded Documents </h5>
                        <h5 class="mt-4">
                            <b>Domain -</b> {{$userdata->domainName}} 
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">

                            <form method="post" id="departmentForm">
                                {!! csrf_field() !!}
                                <input type="hidden" name="user_id" id="user_id" value="{{$user_id}}"/>

                                <table class="table table-striped table-bordered">
                                    <thead>
                                    <tr>
                                        <th>File Name</th>
                                        <th>File Link</th>
                                        <th>Upload Document</th>
                                    </tr>
                                    </thead>
                                    <tbody>

                                    @foreach($userdocuments as $userdoc)
                                        <tr>
                                            <td>{{$userdoc->title?? '' }}</td>

                                           <td><a href="{{url('/user/docs')?? '' }}/{{$userdoc->user_id}}/{{$userdoc->path?? '' }}" target="_blank">View Document</a></td>

                                            <td class="">

                                                    <input type="hidden" name="id[]" id="id" value="{{$userdoc->id?? '' }}"/>
                                                   
                                                    <input type="file" name="document[]" class="form-control document" accept="application/pdf">
                                            
                                            </td>
                                           
                                        </tr>
                                    @endforeach

                                    </tbody>
                                </table>
                                    <button type="submit" class="mt-3 btn btn-primary submit"  style="float:right">Submit</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
      </div>
    </div>
  </div>
</div>
@endsection
@section("js")
<script>
    $(document).ready(function() {
        $('body').on('submit', '#departmentForm', function(e) {
            $(".inputmandatory").css("border","1px solid red");
            e.preventDefault();
            var current = $(this);
            $('.submit', current).attr('disabled', 'disabled');
            $('#loading-image').show();
            
            var data = new FormData($('#departmentForm')[0]);
            $.ajax({
                type:'POST',
                url: "{{route('admin.updateuserdocument')?? '' }}",
                data: data,
                cache:false,
                contentType: false,
                processData: false,
                success : function(response) {
                    $('#loading-image').hide();
                    $('.submit').removeAttr('disabled');

                    if(response.status == 'success') {

                        Swal.fire({
                            icon: 'success',
                            text: 'Documents Submitted successfully.',
                            showConfirmButton: true,
                        }).then(function() {
                            window.location.href = "{{ url('ernetdash/admin-users-details'.'/'.base64_encode($user_id))}}";
                        });

                    }
                    else{
                        Swal.fire({
                            icon: 'error',
                            text: 'Remarks are mandatory',
                            showConfirmButton: true,
                        });
                    }
                },
            });
        });


        $('body').on('change', '.status', function() {
            $data = $(this).attr("data-id");
            if($(this).val() == 0){
                $('#remarks'+$data).removeClass('d-none');
                $('#remarks'+$data).addClass('inputmandatory');
                $('#remarks'+$data).addClass('required_remark');
                $('#remarks'+$data).prop('required',true);
            }else {
                $('#remarks'+$data).addClass('d-none');
                $('#remarks'+$data).removeClass('inputmandatory');
                $('#remarks'+$data).removeClass('required_remark');
                $('#remarks'+$data).prop('required',false);
            }

        });

    });
</script>
@endsection
