@extends('layouts.AdminLayout')
@section('content')
<style>
 
</style>
<div class="content-wrapper">
  <div class="container-xxl flex-grow-1 container-p-y">
    <div class="card mb-4">
      <div class="card-body">
        <div class="row">
            <div class="col-md-12">
                <div class="card mb-4">
                    <div class="d-flex">
                        <h5 class="card-header">Uploaded Documents Verification</h5>
                        <h5 class="mt-4">
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">

                            <form method="post" id="departmentForm">
                                {!! csrf_field() !!}
                                <table class="table table-striped table-bordered">
                                    <thead>
                                    <tr>
                                        <th>File Name</th>
                                        <th>File Link</th>
                                        <th>Documents Verification</th>
                                        <th>Remarks</th>
                                    </tr>
                                    </thead>
                                    <tbody>

                                    @foreach($userdocuments as $userdoc)
                                        <tr>
                                            <td>{{$userdoc->title?? '' }}</td>

                                            @if($userdoc->upload_type==1)
                            <td>Name : {{$userdoc->name}} <br> Affiliation Number : {{$userdoc->path}}</td>
                          @endif
                          @if($userdoc->upload_type==2)
                            <td><a href="{{url('/user/docs')?? '' }}/{{$userdoc->path?? '' }}" target="_blank">View Document</a></td>
                          @endif

                                            <!-- <td><a href="{{url('/user/docs')?? '' }}/{{$userdoc->path?? '' }}" target="_blank">View Document</a></td> -->
                                            <td class="@if($userdoc->status==0) text-danger @else text-success font-weight-bold @endif">
                                                @if($userdoc->status==1)
                                                    <input type="hidden" name="id[]" id="id" value="{{$userdoc->id?? '' }}"/>
                                                    <select class="status form-control " name="status[]" data-id="{{$userdoc->id?? '' }}" id="status{{$userdoc->id?? '' }}" oninvalid="this.setCustomValidity('Kindly select appropriate action')" oninput="setCustomValidity('')" required>
                                                        <option value="">Select</option>
                                                        <option value="2">Approved</option>
                                                        <option value="0">Clarification Required</option>
                                                    </select>
                                                @else
                                                    <?php $stat=$userdoc->status==0 ? "Clarification Required" :"Approved"; ?>
                                                    {{$stat?? '' }}
                                                @endif
                                            </td>
                                            <td>
                                                @if($userdoc->status==1)
                                                    <input type="text" name="remarks[]" id="remarks{{$userdoc->id?? '' }}" class="form-control d-none" placeholder="" value="">
                                                @else
                                                    {{$userdoc->remarks?? '' }}
                                                @endif
                                            </td>

                                        </tr>
                                    @endforeach

                                    </tbody>
                                </table>
                                
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
      </div>
    </div>
  </div>
</div>
@endsection
@section("js")
<script>
    $(document).ready(function() {
        $('body').on('submit', '#departmentForm', function(e) {
            $(".inputmandatory").css("border","1px solid red");
            e.preventDefault();
            var current = $(this);
            $('.submit', current).attr('disabled', 'disabled');
            $('#loading-image').show();
            Swal.fire({
                title: "Loading...",
                html: "Please wait a moment"
            })
            Swal.showLoading();
            var data = current.serialize();
            $.ajax({
                url: "{{route('admin.docupdate')?? '' }}",
                dataType : "json",
                type: "post",
                data : data,
                success : function(response) {
                    $('#loading-image').hide();
                    $('.submit').removeAttr('disabled');

                    if(response.status == 'success') {
                        Swal.fire({
                            icon: 'success',
                            text: 'Documents Verification details submitted successfully.',
                            showConfirmButton: true,
                        }).then(function() {
                            window.location.href = "{{ url('ernetdash/admin-users-details'.'/'.$userdoc->user_id)}}";
                        });

                    } else if(response.status == 'errors') {

                        $.each(response.message, function(i, message) {
                            $('#'+i).after('<span class="Description_error" style="color:red">'+message+'</span>');
                        });

                    } else if(response.status == 'error') {
                        $('#name').after('<span class="Description_error" style="color:red">'+response.error+'</span>');
                    }
                    else if(response.status == false)
                    {
                        Swal.fire({
                            icon: 'error',
                            text: 'Remarks are mandatory',
                            showConfirmButton: true,
                        });
                    }
                },
            });
        });

        $('body').on('change', '.status', function() {
            $data = $(this).attr("data-id");
            if($(this).val() == 0){
                $('#remarks'+$data).removeClass('d-none');
                $('#remarks'+$data).addClass('inputmandatory');
                $('#remarks'+$data).addClass('required_remark');
                $('#remarks'+$data).prop('required',true);
            }else {
                $('#remarks'+$data).addClass('d-none');
                $('#remarks'+$data).removeClass('inputmandatory');
                $('#remarks'+$data).removeClass('required_remark');
                $('#remarks'+$data).prop('required',false);
            }

        });

    });
</script>
@endsection
