@extends('layouts.AdminLayout')
@section('content')

    <style>
        /* .inputmandatory{
                        border:1px solid red;
                      } */
        .card-header {
            font-weight: 600;
        }

        .table:not(.table-dark) th {
            color: #000000 !important;
        }
    </style>
    <div class="content-wrapper">
        <div class="container-xxl flex-grow-1 container-p-y">
            <div class="card mb-4">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="card mb-4">
                                <h5 class="card-header" style="font-size: 25px;">{{ $user->domainName ?? '' }}</h5>
                                <h5 class="card-header">Institution Details
                                    <a href="{{ url('ernetdash/update-contact-details') }}/{{ $user->id }}"
                                        class="btn btn-info btn-sm"><i class="bx bx-edit"></i> Edit</a>
                                </h5>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-striped table-bordered">
                                            <tr>
                                                <th>Name of Institution:</th>
                                                <td>{{ $user->institute ?? '' }}</td>
                                            </tr>

                                            <tr>
                                                <th>Affilation No:</th>
                                                <td>{{ $user->affilation_no ?? '' }}</td>
                                            </tr>

                                            <tr>
                                                <th style="color:black;">Address:</th>
                                                <td>
                                                    <p>{{ $user_contact_details->address ?? '' }},{{ $user_contact_details->state ?? '' }}
                                                    </p>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th style="color:black;">Phone:</th>
                                                <td>
                                                    @if ($user_contact_details != null)
                                                        @if (isset($user_contact_details->prefix_phone))
                                                            0{{ $user_contact_details->prefix_phone ?? '' }}-{{ $user_contact_details->phone ?? '' }}
                                                        @else
                                                            N.A
                                                        @endif
                                                    @endif
                                                </td>
                                            </tr>

                                            <tr>
                                                <th style="color:black;">Email:</th>
                                                <td>{{ $user->email ?? 'N.A' }}</td>
                                            </tr>

                                            <tr>
                                                <th style="color:black;">GST NO.:</th>
                                                <td>{{ $user_contact_details->gst_no ?? 'N.A' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Domain Name:</th>
                                                <td>{{ $user->domainName ?? '' }} &nbsp;
                                                    @if ($user->domainStatus > 5)
                                                        <!-- <a id=""  class="mt-3" href="" disabled="">Edit Domain</a> -->
                                                    @else
                                                        <a id="edit_domain" dit_domain ger mt-3 text-white"
                                                            href="javascript:void(0)" data-id="{{ $user->id }}">Edit
                                                            Domain</a>
                                                    @endif
                                                </td>
                                            </tr>
                                            <tr>
                                                <th style="color:black;">Domain Period:</th>
                                                <td>{{ $user->domainPeriod ?? '' }} Years</td>
                                            </tr>
                                            <tr>
                                                <th>Domain Creation Date:</th>
                                                <td>{{ $user->domainCreationDate ? \Carbon\Carbon::parse($user->domainCreationDate)->format('d-m-Y') : '' }}
                                                </td>
                                            </tr>
                                            <tr>
                                                <th style="color:black;">Last Transaction:</th>
                                                <td>
                                                    @if ($lastpayment != null)
                                                        {{ number_format($lastpayment->total_amount, 2, '.', '') }}
                                                    @endif
                                                </td>
                                            </tr>
                                            <tr>
                                                <th>Last Transaction Date:</th>
                                                @if ($lastpayment != null)
                                                    <td>{{ \Carbon\Carbon::parse($lastpayment->created_at)->format('d-m-Y') }}
                                                    </td>
                                                @endif
                                            </tr>
                                            <tr>
                                                <th style="color:black;">Last Update Date:</th>
                                                <td>{{ \Carbon\Carbon::parse($user->updated_at)->format('d-m-Y') ?? '' }}
                                                </td>
                                            </tr>
                                            <tr>
                                                <th>Domain Expiry Date:</th>
                                                <td>{{ $user->domainExpiryDate ? \Carbon\Carbon::parse($user->domainExpiryDate)->format('d-m-Y') : '' }}
                                                </td>
                                            </tr>

                                            <tr>
                                                <th>Google Authenticator Code:</th>
                                                <td>{{ $user->google2fa_secret != null ? $user->google2fa_secret : 'N.A' }}
                                                    <a href="javascript:void(0)" style="color:#fff;"
                                                        class="mx-2 reset_googleauth btn btn-primary"
                                                        data-id="{{ $user->id }}">Reset Code</a>
                                                </td>
                                            </tr>

                                            <tr>
                                                <th>Hard Copy Status:</th>
                                                <td>
                                                    @if ($user->hard_copy == 2)
                                                        Received
                                                    @else
                                                        <a href="javascript:void(0)" style="color:#fff;"
                                                            class="mx-2 hardcopy_received btn btn-success"
                                                            data-id="{{ $user->id }}">Receive</a>
                                                    @endif

                                                </td>
                                            </tr>

                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @if ($user_contact_details != null)
                            <div class="col-md-6">
                                <div class="card mb-4">
                                    <h5 class="card-header">Details of Head of Institution: </h5>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table table-striped table-bordered">
                                                <tr>
                                                    <th>Name:</th>
                                                    <td>{{ json_decode($user_contact_details->institution_head_detail)->name ?? '' }}
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Desigination:</th>
                                                    <td>{{ json_decode($user_contact_details->institution_head_detail)->designation ?? '' }}
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Email:</th>
                                                    <td>{{ json_decode($user_contact_details->institution_head_detail)->email ?? '' }}
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Phone:</th>
                                                    <td>


                                                        @if ($user_contact_details->institution_head_detail != null)
                                                            @if (isset(json_decode($user_contact_details->institution_head_detail)->prefix_phone))
                                                                0{{ json_decode($user_contact_details->institution_head_detail)->prefix_phone ?? '' }}-{{ json_decode($user_contact_details->institution_head_detail)->phone ?? '' }}
                                                            @else
                                                                N.A
                                                            @endif
                                                        @endif



                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Mobile:</th>
                                                    <td>{{ json_decode($user_contact_details->institution_head_detail)->mobile ?? '' }}
                                                    </td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="card mb-4">
                                    <h5 class="card-header">Administrative Contact Details</h5>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table table-striped table-bordered">
                                                <tr>
                                                    <th>Name:</th>
                                                    <td>{{ json_decode($user_contact_details->administrative_detail)->name ?? '' }}
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Desigination:</th>
                                                    <td>{{ json_decode($user_contact_details->administrative_detail)->designation ?? '' }}
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Email:</th>
                                                    <td>{{ json_decode($user_contact_details->administrative_detail)->email ?? '' }}
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Phone:</th>
                                                    <td>



                                                        @if ($user_contact_details->administrative_detail != null)
                                                            @if (isset(json_decode($user_contact_details->administrative_detail)->prefix_phone))
                                                                0{{ json_decode($user_contact_details->administrative_detail)->prefix_phone ?? '' }}-{{ json_decode($user_contact_details->administrative_detail)->phone ?? '' }}
                                                            @else
                                                                N.A
                                                            @endif
                                                        @endif

                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Mobile:</th>
                                                    <td>{{ json_decode($user_contact_details->administrative_detail)->mobile ?? '' }}
                                                    </td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="card mb-4">
                                    <h5 class="card-header">Billing Contact Details :</h5>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table table-striped table-bordered">
                                                <tr>
                                                    <th>Name:</th>
                                                    <td>{{ json_decode($user_contact_details->billing_contact_detail)->name ?? '' }}
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Desigination:</th>
                                                    <td>{{ json_decode($user_contact_details->billing_contact_detail)->designation ?? '' }}
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Email:</th>
                                                    <td>{{ json_decode($user_contact_details->billing_contact_detail)->email ?? '' }}
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Phone:</th>
                                                    <td>



                                                        @if ($user_contact_details->billing_contact_detail != null)
                                                            @if (isset(json_decode($user_contact_details->billing_contact_detail)->prefix_phone))
                                                                0{{ json_decode($user_contact_details->billing_contact_detail)->prefix_phone ?? '' }}-{{ json_decode($user_contact_details->billing_contact_detail)->phone ?? '' }}
                                                            @else
                                                                N.A
                                                            @endif
                                                        @endif

                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Mobile:</th>
                                                    <td>{{ json_decode($user_contact_details->billing_contact_detail)->mobile ?? '' }}
                                                    </td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="card mb-4">
                                    <h5 class="card-header">Technical Contact Details</h5>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table table-striped table-bordered">
                                                <tr>
                                                    <th>Name:</th>
                                                    <td>{{ json_decode($user_contact_details->technical_detail)->name ?? '' }}
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Desigination:</th>
                                                    <td>{{ json_decode($user_contact_details->technical_detail)->designation ?? '' }}
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Email:</th>
                                                    <td>{{ json_decode($user_contact_details->technical_detail)->email ?? '' }}
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Phone:</th>
                                                    <td>

                                                        @if ($user_contact_details->technical_detail != null)
                                                            @if (isset(json_decode($user_contact_details->technical_detail)->prefix_phone))
                                                                0{{ json_decode($user_contact_details->technical_detail)->prefix_phone ?? '' }}-{{ json_decode($user_contact_details->technical_detail)->phone ?? '' }}
                                                            @else
                                                                N.A
                                                            @endif
                                                        @endif



                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Mobile:</th>
                                                    <td>{{ json_decode($user_contact_details->technical_detail)->mobile ?? '' }}
                                                    </td>
                                                </tr>

                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif
                        @if ($payment != null)
                            <div class="col-md-6">
                                <div class="card mb-4">
                                    <h5 class="card-header">Payment Details</h5>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table table-striped table-bordered">
                                                <tr>
                                                    <th>Transaction ID :</th>
                                                    <td>{{ $payment->transaction_id }}</td>
                                                </tr>
                                                <tr>
                                                    <th style="color:black;">Transaction Date:</th>
                                                    <td>{{ \Carbon\Carbon::parse($payment->created_at)->format('d-m-Y') }}
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <th>Amount : </th>
                                                    <td><span>&#8377;
                                                        </span>{{ number_format(($payment->total_amount * 100) / 118, 2, '.', '') }}
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <th style="color:black;">Tax : </th>
                                                    <td><span>&#8377;
                                                        </span>{{ number_format($payment->total_amount - ($payment->total_amount * 100) / 118, 2, '.', '') }}
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <th>Period: </th>
                                                    <td><span> </span>{{ $payment->period }}</td>
                                                </tr>

                                                <tr>
                                                    <th>Total Amount: </th>
                                                    <td><span>&#8377;
                                                        </span>{{ number_format($payment->total_amount, 2, '.', '') }}</td>
                                                </tr>

                                                <tr>
                                                    <th>Payment Invoice : </th>
                                                    <td><a href="{{ url('ernetdash/userInvoice?id=' . $user->id) }}"
                                                            target="_blank" title="download payment invoice">Click here to
                                                            see invoice</a></td>
                                                </tr>

                                                {{-- <tr>
                                                    <th>Renew Domain : </th>

                                                    @if ($user->domainStatus == 10 && $user->document_status != 1)
                                                    <td><a href="#" class="btn btn-md btn-success update_admin_renewal_status"
                                                            title="Renew Domain" data-id="{{ $user->id }}">Renew
                                                            Domain</a></td>
                                                    @endif


                                                </tr> --}}

                                                <tr>
                                                    <th>Send Invoice : </th>
                                                    <td><a href="javascript:void(0)" target="" class="send_invoice" style=""
                                                            data-id="{{ $user->id }}">Send Invoice</a>
                                                    </td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif
                        @if ($user_name_server != null)
                            <div class="col-md-6">
                                <div class="card mb-4">
                                    <div class="d-flex">
                                        <h5 class="card-header">Name Server Details
                                            @if ($user_name_server->server_type == 1)
                                                <a href="{{ url('ernetdash/view_mx_records' . '/' . base64_encode($user_name_server->user_id)) }}"
                                                    style="font-size:14px;">
                                                    View Resource Records
                                                </a>
                                            @endif
                                        </h5>
                                        <h5 class="card-header">
                                            <a href="{{ $user_name_server != null ? url('ernetdash/user-dns-edit' . '/' . $user_name_server->id) : '' }}"
                                                title="click to update name server">
                                                <i class="fa fa-edit text-info fs-3 me-md-3"></i>
                                            </a>
                                        </h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table table-striped table-bordered">


                                                <tr>
                                                    <th>Primary Name Server :</th>
                                                    <td>{{ $user_name_server->primary_name_server ?? '' }}
                                                        {{ $user_name_server->primary_name_server_ip ?? '' }}
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Secondary Name Server 1 :</th>
                                                    <td>{{ $user_name_server->secondary_name_server1 ?? '' }}
                                                        {{ $user_name_server->secondary_name_server1_ip ?? '' }}
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Secondary Name Server 2 :</th>
                                                    <td>{{ $user_name_server->secondary_name_server2 ?? '' }}
                                                        {{ $user_name_server->secondary_name_server2_ip ?? '' }}
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Secondary Name Server 3 :</th>
                                                    <td>{{ $user_name_server->secondary_name_server3 ?? '' }}
                                                        {{ $user_name_server->secondary_name_server3_ip ?? '' }}
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <th>Secondary Name Server 4 :</th>
                                                    <td>{{ $user_name_server->secondary_name_server4 ?? '' }}
                                                        {{ $user_name_server->secondary_name_server4_ip ?? '' }}
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <th>Secondary Name Server 5 :</th>
                                                    <td>{{ $user_name_server->secondary_name_server5 ?? '' }}
                                                        {{ $user_name_server->secondary_name_server5_ip ?? '' }}
                                                    </td>
                                                </tr>


                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif


                        {{-- neelu july --}}

                        @if ($transaction_type == 'domainRenewal')
                       
                            <div class="col-md-12">
                                <div class="card mb-4">
                                    <h5 class="card-header">Renewal Details for All Services</h5>
                                    <div class="card-body">

                                        <ul class="nav nav-tabs" id="renewalTab" role="tablist">
                                            @if (!empty($renewal_data['checkboxdomain']) && $renewal_data['checkboxdomain'] == 'checkDomain')
                                                <li class="nav-item" role="presentation">
                                                    <a class="nav-link active" id="domain-tab" data-bs-toggle="tab" href="#domain"
                                                        role="tab" aria-controls="domain" aria-selected="true">Domain</a>
                                                </li>
                                            @endif

                                            @if (!empty($renewal_data['checkboxDomainName']) && $renewal_data['checkboxDomainName'] == 'checkDNS')
                                                <li class="nav-item" role="presentation">
                                                    <a class="nav-link" id="dns-tab" data-bs-toggle="tab" href="#dns" role="tab"
                                                        aria-controls="dns" aria-selected="false">DNS</a>
                                                </li>
                                            @endif

                                            @if (!empty($renewal_data['checkboxLmaas']) && $renewal_data['checkboxLmaas'] == 'checkboxLmaas')
                                                <li class="nav-item" role="presentation">
                                                    <a class="nav-link" id="lmaas-tab" data-bs-toggle="tab" href="#lmaas" role="tab"
                                                        aria-controls="lmaas" aria-selected="false">L-MaaS</a>
                                                </li>
                                            @endif

                                            @if (!empty($renewal_data['checkboxEwaas']) && $renewal_data['checkboxEwaas'] == 'checkEwaas')
                                                <li class="nav-item" role="presentation">
                                                    <a class="nav-link" id="ewaas-tab" data-bs-toggle="tab" href="#ewaas" role="tab"
                                                        aria-controls="ewaas" aria-selected="false">WaaS</a>
                                                </li>
                                            @endif
                                        </ul>

                                        <div class="tab-content" id="renewalTabContent">

                                            <!-- Domain Tab Content -->
                                            @if (!empty($renewal_data['checkboxdomain']) && $renewal_data['checkboxdomain'] == 'checkDomain')
                                                <div class="tab-pane fade show active" id="domain" role="tabpanel"
                                                    aria-labelledby="domain-tab">
                                                    <div class="table-responsive">
                                                        <table class="table table-striped table-bordered">
                                                            <tr>
                                                                <th>Domain Period:</th>
                                                                <td>{{ $renewal_data['domain_year'] ?? 'N/A' }} Years</td>
                                                            </tr>
                                                            <tr>
                                                                <th>Old Domain Expiry Date:</th>
                                                                <td>{{ $renewal_data['domainExpiryDateOld'] ?? 'N/A' }}</td>
                                                            </tr>
                                                            <tr>
                                                                <th>New Domain Expiry Date:</th>
                                                                <td>{{ $renewal_data['newDomainExpiryDate'] ?? 'N/A' }}</td>
                                                            </tr>
                                                            <tr>
                                                                <th>Domain Price:</th>
                                                                <td>₹{{ number_format($renewal_data['domain_price'] ?? 0, 2) }}
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <th>Domain Extra Charges:</th>
                                                                <td>₹{{ number_format($renewal_data['domain_extra_charges'] ?? 0, 2) }}
                                                                </td>
                                                            </tr>

                                                        </table>
                                                    </div>
                                                </div>
                                            @endif

                                            <!-- DNS Tab Content -->
                                            @if (!empty($renewal_data['checkboxDomainName']) && $renewal_data['checkboxDomainName'] == 'checkDNS')
                                                <div class="tab-pane fade" id="dns" role="tabpanel" aria-labelledby="dns-tab">
                                                    <div class="table-responsive">
                                                        <table class="table table-striped table-bordered">
                                                            <tr>
                                                                <th>DNS Period:</th>
                                                                <td>{{ $renewal_data['period_dns'] ?? 'N/A' }} Years</td>
                                                            </tr>
                                                            <tr>
                                                                <th>Old DNS Expiry Date:</th>
                                                                <td>{{ $renewal_data['DNS_expiry_date'] ?? 'N/A' }}</td>
                                                            </tr>
                                                            <tr>
                                                                <th>New DNS Expiry Date:</th>
                                                                <td>{{ $renewal_data['New_DNS_Date'] ?? 'N/A' }}</td>
                                                            </tr>
                                                            <tr>
                                                                <th>DNS Price:</th>
                                                                <td>₹{{ number_format($renewal_data['domain_name_server_price'] ?? 0, 2) }}
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <th>DNS Extra Charges:</th>
                                                                <td>₹{{ number_format($renewal_data['domain_name_extra_charges'] ?? 0, 2) }}
                                                                </td>
                                                            </tr>

                                                        </table>
                                                    </div>
                                                </div>
                                            @endif

                                            <!-- Lmaas Tab Content -->
                                            @if (!empty($renewal_data['checkboxLmaas']) && $renewal_data['checkboxLmaas'] == 'checkboxLmaas')
                                                <div class="tab-pane fade" id="lmaas" role="tabpanel" aria-labelledby="lmaas-tab">
                                                    <div class="table-responsive">
                                                        <table class="table table-striped table-bordered">
                                                            <tr>
                                                                <th>Lmaas Period:</th>
                                                                <td>{{ $renewal_data['period_lmaas'] ?? 'N/A' }} Years</td>
                                                            </tr>
                                                            <tr>
                                                                <th>Old Lmaas Expiry Date:</th>
                                                                <td>{{ $renewal_data['lmaas_expiry_date'] ?? 'N/A' }}</td>
                                                            </tr>
                                                            <tr>
                                                                <th>New Lmaas Expiry Date:</th>
                                                                <td>{{ $renewal_data['new_expiry_date_lmaas'] ?? 'N/A' }}</td>
                                                            </tr>
                                                            <tr>
                                                                <th>Lmaas Price:</th>
                                                                <td>₹{{ number_format($renewal_data['lmaas_temp_server_price'] ?? 0, 2) }}
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <th>Lmaas Extra Charges:</th>
                                                                <td>₹{{ number_format($renewal_data['lmaas_temp_extra_charges'] ?? 0, 2) }}
                                                                </td>
                                                            </tr>

                                                        </table>
                                                    </div>
                                                </div>
                                            @endif

                                            <!-- Ewaas Tab Content -->
                                            @if (!empty($renewal_data['checkboxEwaas']) && $renewal_data['checkboxEwaas'] == 'checkEwaas')
                                                <div class="tab-pane fade" id="ewaas" role="tabpanel" aria-labelledby="ewaas-tab">
                                                    <div class="table-responsive">
                                                        <table class="table table-striped table-bordered">
                                                            <tr>
                                                                <th>Ewaas Period:</th>
                                                                <td>{{ $renewal_data['period_ewaas'] ?? 'N/A' }} Years</td>
                                                            </tr>
                                                            <tr>
                                                                <th>Old Ewaas Expiry Date:</th>
                                                                <td>{{ $renewal_data['ewaas_expiry_date'] ?? 'N/A' }}</td>
                                                            </tr>
                                                            <tr>
                                                                <th>New Ewaas Expiry Date:</th>
                                                                <td>{{ $renewal_data['new_expiry_date_ewaas'] ?? 'N/A' }}</td>
                                                            </tr>
                                                            <tr>
                                                                <th>Ewaas Price:</th>
                                                                <td>₹{{ number_format($renewal_data['ewaas_temp_server_price'] ?? 0, 2) }}
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <th>Ewaas Extra Charges:</th>
                                                                <td>₹{{ number_format($renewal_data['ewaas_temp_extra_charges'] ?? 0, 2) }}
                                                                </td>
                                                            </tr>

                                                        </table>
                                                    </div>
                                                </div>
                                            @endif

                                        </div>
                                    </div>
                                </div>
                            </div>

                            
                        @endif

                        @if ($transaction_type == 'domainRenewal' && $user->renewal_status == 1)
                            @php
                                $requestData = is_string($renewal_data)
                                    ? json_decode($renewal_data, true)
                                    : $renewal_data;

                            @endphp

                            @if (
                                    (!empty($requestData['checkboxdomain']) && $requestData['checkboxdomain'] == 'checkDomain') ||
                                    (!empty($requestData['checkboxDomainName']) && $requestData['checkboxDomainName'] == 'checkDNS') ||
                                    !empty($requestData['checkboxEwaas']) ||
                                    !empty($requestData['checkboxLmaas'])
                                )
                                <div id="renewal-section">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th style="color:#fff !important">Type</th>
                                                <th style="color:#fff !important">Domain Name</th>
                                                <th style="color:#fff !important">Years</th>
                                                <th style="color:#fff !important">Old Date</th>
                                                <th style="color:#fff !important">New Expiry</th>
                                                <th style="color:#fff !important">Pricing Details</th>
                                                {{-- <th>Action</th> --}}
                                            </tr>
                                        </thead>

                                        <tbody>

                                            {{-- Domain --}}
                                            @if ($user->domainStatus == 10 && $user->document_status != 1)
                                                @if (!empty($requestData['checkboxdomain']) && $requestData['checkboxdomain'] == 'checkDomain')
                                                    <tr>
                                                        <td>Domain</td>
                                                        <td>{{ $user->domainName ?? '' }}</td>
                                                        <td>{{ $requestData['domain_year'] ?? 'N/A' }}</td>
                                                        <td>{{ $requestData['domainExpiryDateOld'] ?? 'N/A' }}</td>
                                                        <td>{{ $requestData['newDomainExpiryDate'] ?? 'N/A' }}</td>

                                                        <td class="pricing-details">
                                                            <strong>Price:</strong>
                                                            ₹{{ number_format($requestData['domain_price'] ?? 0, 2) }}<br>
                                                            <strong>Extra Charges:</strong>
                                                            ₹{{ number_format($requestData['domain_extra_charges'] ?? 0, 2) }}<br>



                                                            <span style="display: none;">
                                                                <strong>GST:</strong>
                                                                ₹{{ number_format($requestData['domain_price_tax'] ?? 0, 2) }}<br>
                                                                <strong>Total:</strong>
                                                                ₹{{ number_format($requestData['domain_price_total'] ?? 0, 2) }}
                                                            </span>




                                                        </td>



                                                    </tr>
                                                @endif
                                            @endif


                                            {{-- DNS --}}
                                            @if (!empty($requestData['checkboxDomainName']) && $requestData['checkboxDomainName'] == 'checkDNS')
                                                <tr>
                                                    <td>DNS</td>
                                                    <td>{{ $user->domainName ?? '' }}</td>
                                                    <td>{{ $requestData['dns_year'] ?? 'N/A' }}</td>
                                                    <td>{{ $requestData['DNS_expiry_date'] ?? 'N/A' }}</td>
                                                    <td>{{ $requestData['New_DNS_Date'] ?? 'N/A' }}</td>




                                                    <td class="pricing-details">
                                                        <strong>Price:</strong>
                                                        ₹{{ number_format($requestData['domain_name_server_price'] ?? 0, 2) }}<br>
                                                        <strong>Extra Charges:</strong>
                                                        ₹{{ number_format($requestData['domain_name_extra_charges'] ?? 0, 2) }}<br>



                                                        <span style="display: none;">
                                                            <strong>GST:</strong>
                                                            ₹{{ number_format($requestData['domain_name_server_price_tax'] ?? 0, 2) }}<br>
                                                            <strong>Total:</strong>
                                                            ₹{{ number_format($requestData['domain_name_server_price_total'] ?? 0, 2) }}
                                                        </span>




                                                    </td>






                                                </tr>
                                            @endif

                                            {{-- Ewaas --}}
                                            @if (!empty($requestData['checkboxEwaas']))
                                                <tr>
                                                    <td>Ewaas</td>
                                                    <td>{{ $user->domainName ?? '' }}</td>
                                                    <td>{{ $requestData['ewaas_year'] ?? 'N/A' }}</td>
                                                    <td>{{ $requestData['ewaas_expiry_date'] ?? 'N/A' }}</td>
                                                    <td>{{ $requestData['new_expiry_date_ewaas'] ?? 'N/A' }}</td>


                                                    <td class="pricing-details">
                                                        <strong>Price:</strong>
                                                        ₹{{ number_format($requestData['ewaas_temp_server_price'] ?? 0, 2) }}<br>
                                                        <strong>Extra Charges:</strong>

                                                        ₹{{ number_format($requestData['ewaas_temp_extra_charges'] ?? 0, 2) }}<br>
                                                        <span style="display: none;">
                                                            <strong>GST:</strong>
                                                            ₹{{ number_format($requestData['ewaas_temp_server_price_tax'] ?? 0, 2) }}<br>
                                                            <strong>Total:</strong>
                                                            ₹{{ number_format($requestData['ewaas_temp_server_price_total'] ?? 0, 2) }}
                                                        </span>
                                                    </td>



                                                </tr>
                                            @endif

                                            {{-- Lmaas --}}
                                            @if (!empty($requestData['checkboxLmaas']))
                                                <tr>
                                                    <td>Lmaas</td>
                                                    <td>{{ $user->domainName ?? '' }}</td>
                                                    <td>{{ $requestData['lmaas_year'] ?? 'N/A' }}</td>
                                                    <td>{{ $requestData['lmaas_expiry_date'] ?? 'N/A' }}</td>
                                                    <td>{{ $requestData['new_expiry_date_lmaas'] ?? 'N/A' }}</td>



                                                    <td class="pricing-details">
                                                        <strong>Price:</strong>
                                                        ₹{{ number_format($requestData['lmaas_temp_server_price'] ?? 0, 2) }}<br>
                                                        <strong>Extra Charges:</strong>
                                                        ₹{{ number_format($requestData['domain_name_extra_charges'] ?? 0, 2) }}<br>




                                                        <span style="display: none;">
                                                            <strong>GST:</strong>
                                                            ₹{{ number_format($requestData['lmaas_temp_server_price_tax'] ?? 0, 2) }}<br>
                                                            <strong>Total:</strong>
                                                            ₹{{ number_format($requestData['lmaas_temp_server_price_total'] ?? 0, 2) }}
                                                        </span>

                                                    </td>





                                                </tr>
                                            @endif

                                        </tbody>
                                    </table>
                                    {{-- <div class="text-end mt-3">
                                        <button type="button" class="btn btn-primary" id="renew-all-button"
                                            data-id="{{ $user->id }}">
                                            Renew All Services
                                        </button>
                                    </div> --}}


                                    @if ($is_approved == 2)
                                        <div class="text-end mt-3">
                                            <button type="button" class="btn btn-primary" id="renew-all-button"
                                                data-id="{{ $user->id }}">
                                                Renew Services
                                            </button>
                                        </div>
                                    @endif
                                </div>
                            @else
                                <p>No renewal data available.</p>
                            @endif
                        @endif

                        <div class="col-md-12">
                            <div class="card mb-4">
                                <div class="d-flex">
                                    <h5 class="card-header">Uploaded Documents Verification</h5>
                                    <h5 class="mt-4">
                                        @if ($user->domainStatus >= 4)
                                            <a href="{{ url('ernetdash/admin-users-details-doc' . '/' . base64_encode($user->id)) }}"
                                                style="font-size:14px;">
                                                <i class="fa fa-edit text-info fs-3 delete-domain-Category"
                                                    title="Update Uploaded Documents"></i></a>
                                        @endif
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">

                                        <form method="post" id="departmentForm" enctype="multipart/form-data">
                                            {!! csrf_field() !!}
                                            <table class="table table-striped table-bordered">
                                                <thead>
                                                    <tr>
                                                        <th style="color:#fff !important">File Name</th>
                                                        <th style="color:#fff !important">File Link</th>
                                                        <th style="color:#fff !important">Documents Verification</th>
                                                        <th style="color:#fff !important">Remarks</th>
                                                    </tr>
                                                </thead>
                                                <tbody>

                                                    @foreach ($userdocuments as $userdoc)
                                                        <tr>
                                                            <td>{{ $userdoc->title ?? '' }}
                                                            </td>
                                                            @if ($userdoc->upload_type == 1)
                                                                <td>Name : {{ $userdoc->name }} <br> Affiliation Number :
                                                                    {{ $userdoc->path }}
                                                                </td>
                                                            @endif
                                                            @if ($userdoc->upload_type == 2)
                                                                <td>
                                                                    <a href="{{ url('/user/docs') ?? '' }}/{{ $userdoc->user_id }}/{{ $userdoc->path ?? '' }}"
                                                                        target="_blank">View Document</a><br>

                                                                    @if ($user->domainStatus == 6)
                                                                        <input type="hidden" name="id[]" id="id"
                                                                            value="{{ $userdoc->id ?? '' }}" />
                                                                    @endif

                                                                    <!-- @if ($user->domainStatus == 4 || $user->domainStatus == 5 || $user->domainStatus == 10)
                                                                                <input type="file" name="replace_file[]" class="form-control w-100 mt-3" accept="application/pdf">
                                                                            @else
                                                                                -->

                                                                    <!-- @if ($user->domainStatus == 6)
                                                                                <input type="file" name="replace_file[]" class="form-control w-75 mt-3" accept="application/pdf">
                                                                                @endif  -->

                                                                    <!--
                                                                                @endif -->

                                                                    @if ($userdoc->document_category_id == 2 && $user->domainStatus == 10 && $userdoc->old_path != null)
                                                                        <br>

                                                                        <a href="{{ url('/user/docs') ?? '' }}/{{ $userdoc->user_id }}/{{ $userdoc->old_path ?? '' }}"
                                                                            target="_blank">Old Document</a>
                                                                    @endif



                                                                </td>
                                                            @endif


                                                            <td
                                                                class="@if ($userdoc->status == 0) text-danger @else text-success font-weight-bold @endif">

                                                                @if ($userdoc->status == 1)
                                                                    <input type="hidden" name="id[]" id="id"
                                                                        value="{{ $userdoc->id ?? '' }}" />

                                                                    <select class="status form-control " name="status[]"
                                                                        data-id="{{ $userdoc->id ?? '' }}"
                                                                        id="status{{ $userdoc->id ?? '' }}"
                                                                        oninvalid="this.setCustomValidity('Kindly select appropriate action')"
                                                                        oninput="setCustomValidity('')" required>
                                                                        <option value="">Select</option>
                                                                        <option value="2">Approved</option>
                                                                        <option value="0">Clarification Required
                                                                        </option>
                                                                    </select>
                                                                @else
                                                                    @if ($userdoc->upload_type == 1 && $user->domainStatus <= 5)
                                                                        <?php            $stat = $userdoc->status == 0 ? 'Clarification Required' : 'Online Verified'; ?>
                                                                    @endif
                                                                    @if ($userdoc->upload_type == 2)
                                                                        <?php            $stat = $userdoc->status == 0 ? 'Clarification Required' : 'Approved'; ?>
                                                                    @endif
                                                                    {{ $stat ?? '' }}
                                                                @endif
                                                            </td>
                                                            <td>
                                                                @if ($userdoc->status == 1)
                                                                    <input type="text" name="remarks[]"
                                                                        id="remarks{{ $userdoc->id ?? '' }}"
                                                                        class="form-control d-none remark_entering" placeholder=""
                                                                        value="">
                                                                @elseif($userdoc->status == 2)
                                                                @else
                                                                    {{ $userdoc->remarks ?? '' }}
                                                                @endif
                                                            </td>

                                                        </tr>
                                                    @endforeach

                                                </tbody>
                                            </table>

                                            @if ($user->domainStatus == 5 || $user->domainStatus == 10)
                                                @if ($is_approved == 0 && $user->document_status != 1)
                                                    <button type="submit" class="mt-3 btn btn-primary submit" style="float:right"
                                                        data-id="1">Submit</button>
                                                @endif
                                            @endif


                                            <!-- @if ($user->domainStatus == 6)
            <button type="submit" class="mt-3 btn btn-primary submit"  style="float:right" data-id="2">Submit Document</button>
            @endif -->

                                        </form>
                                    </div>
                                </div>
                            </div>

                            @if ($user->domainStatus == 5)
                                @if ($is_approved == 2)
                                    <form id="RegisterDomain" method="post" action="">
                                        @csrf
                                        <input type="hidden" name="user_id" value="{{ $user->id }}">
                                        <button type="submit" class="mt-3 btn btn-success mx-5" style="float:right">Register
                                            Domain</button>
                                    </form>
                                @endif
                            @endif
                        </div>
                    </div>
                </div>


            </div>
        </div>

        <div class="modal fade show" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel"
            style="display:none;" aria-modal="true" role="dialog">
            <div class="modal-dialog" role="document">
                <form method="post" id="editdomainform">
                    @csrf
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel">Update Domain</h5>

                        </div>
                        <div class="modal-body">

                            <input type="hidden" id="edit_id" name="id" value="241">

                            <div class="form-group">
                                <label for="">New Domain</label>

                                <input type="text" class="form-control my-2" name="newdomain" id="newdomain" required="">

                                <label for="">Extension</label>
                                <select id="extensions" class="form-control my-2" name="extension" required>
                                    <option value=""> Extension </option>
                                </select>

                                <label for="">Remarks </label>

                                <textarea class="form-control" name="delete_remarks" id="delete_remarks" rows="3"
                                    required=""></textarea>
                            </div>

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-warning">Update</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

    </div>
@endsection
@section('js')
    <script>
        $(document).ready(function () {

            $('body').on('click', '.send_invoice', function (e) {
                e.preventDefault();
                var id = $(this).attr('data-id');
                if (confirm('Are you sure you want to send the invoice?')) {

                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
                    Swal.fire({
                        title: "Please wait..."

                    })
                    Swal.showLoading();
                    $.ajax({
                        url: "{{ route('admin.send_invoice') }}",
                        dataType: "json",
                        type: "post",
                        data: {
                            'id': id
                        },
                        success: function (response) {

                            if (response.status == 'success') {

                                Swal.fire({
                                    icon: 'success',
                                    text: 'Invoice Sent Successfully!',
                                    showConfirmButton: true,
                                }).then(function () {
                                    window.location.reload();
                                });

                            } else if (response.status == 'error') {

                                alert(response.message);

                            } else if (response.status == 'exceptionError') { }
                        },
                    });
                }
                return false;
            });


            $('body').on('click', '.update_admin_renewal_status', function () {

                var id = $(this).attr('data-id');
                if (confirm('Are you sure you want to renew this Domain?')) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });

                    Swal.fire({
                        title: "Please wait...",
                    })

                    Swal.showLoading();

                    $.ajax({
                        url: "{{ route('admin.update_domain_renewal_status') }}",
                        dataType: "json",
                        type: "post",
                        data: {
                            'id': id
                        },
                        success: function (response) {

                            if (response.status == 'success') {

                                Swal.fire({
                                    icon: 'success',
                                    text: 'Domain has been renewed successfully',
                                    showConfirmButton: true,
                                }).then(function () {
                                    window.location.reload();
                                });

                            } else {

                                alert(response.message);

                            }

                        },
                    });

                }
                return false;
            });

            $('body').on('submit', '#editdomainform', function (e) {
                e.preventDefault();

                var current = $(this);
                var data = current.serialize();
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                Swal.fire({
                    title: "Please wait...",
                })
                Swal.showLoading();
                $.ajax({
                    url: "{{ route('admin.edit_domain') }}",
                    dataType: "json",
                    type: "post",
                    data: data,
                    success: function (response) {
                        if (response.status == 'success') {
                            Swal.fire({
                                icon: 'success',
                                text: 'Domain is successfully modified',
                                showConfirmButton: true,
                            }).then(function () {
                                window.location.reload();
                            });
                        } else if (response.status == 'error') {
                            Swal.fire({
                                icon: 'error',
                                text: 'Domain Not Available',
                                showConfirmButton: true,
                            })
                        } else if (response.status == 'exceptionError') { }
                    },
                });
            });


            $('body').on('keyup', '.remark_entering', function () {
                var enteredText = $(this).val();
                var textLength = enteredText.length;

                var lengthDisplay = $('<span>').text('Characters Left: ' + parseInt(100 - textLength));

                $(this).next('.length-display').remove();

                $(this).after(lengthDisplay.addClass('length-display'));
            });


            $('body').on('click', '#edit_domain', function () {
                var id = $(this).attr('data-id');
                var lang_id = "{{ $user->domainLangID }}";

                $('#edit_id').val(id);
                $('#exampleModal').modal('show');

                $.ajax({
                    url: "{{ url('getExtensionByLang') }}",
                    dataType: "json",
                    type: "GET",
                    data: {
                        lang_id: lang_id
                    },
                    success: function (response) {
                        if (response.status == true) {
                            $('#extensions').empty();
                            $.each(response.data, function (key, value) {
                                $('#extensions').append('<option value="' + value.id +
                                    '">' + value.domain_extension + '</option>');
                            });
                        } else if (response.status == false) {
                            alert(response.message);
                        }
                    },
                });

            });


            // $('body').on('submit', '#departmentForm', function(e) {
            //       $(".inputmandatory").css("border","1px solid red");
            //       e.preventDefault();
            // 			var current = $(this);
            //         $('.submit', current).attr('disabled', 'disabled');

            //         $('.required_remark').each(function(i, obj) {
            //             if ($(this).val().length == 0){
            //                 Swal.fire({
            //                     icon: 'error',
            //                     text: 'Remarks are mandatory',
            //                     showConfirmButton: true,
            //                 }).then(function() {
            //                     return false;
            //                 });
            //             }
            //         });



            //         var data = current.serialize();
            //     Swal.fire({
            //         title: 'Are you sure?',
            //         text: 'You want to submit the action taken on documents?',
            //         icon: 'warning',
            //         showCancelButton: true,
            //         confirmButtonColor: '#28a745',
            //         cancelButtonColor: '#6c757d',
            //         confirmButtonText: 'Confirm',
            //         cancelButtonText: 'Cancel'
            //     }).then((result) => {
            //         if (result.isConfirmed) {
            //             // Perform the AJAX request to change the status
            //             Swal.fire({
            //                 title: "Loading...",
            //                 html: "Please wait a moment"
            //             })
            //             Swal.showLoading();
            //             $.ajax({
            //                 url: "{{ route('admin.docupdate') ?? '' }}",
            //                 dataType : "json",
            //                 type: "post",
            //                 data : data,
            //                 success : function(response) {
            //                     $('#loading-image').hide();
            //                     $('.submit').removeAttr('disabled');

            //                     if(response.status == 'success') {
            //                         Swal.fire({
            //                             icon: 'success',
            //                             text: 'Documents Verification details submitted successfully.',
            //                             showConfirmButton: true,
            //                         }).then(function() {
            //                             window.location.reload();
            //                         });

            //                     } else if(response.status == 'errors') {

            //                         $.each(response.message, function(i, message) {
            //                             $('#'+i).after('<span class="Description_error" style="color:red">'+message+'</span>');
            //                         });

            //                     } else if(response.status == 'error') {
            //                         $('#name').after('<span class="Description_error" style="color:red">'+response.error+'</span>');
            //                     }
            //                     else if(response.status == false)
            //                     {
            //                         Swal.fire({
            //                             icon: 'error',
            //                             text: 'Remarks are mandatory',
            //                             showConfirmButton: true,
            //                         });
            //                     }
            //                 },
            //             });
            //         }
            //     });


            // });

            $('body').on('submit', '#departmentForm', function (e) {
                $(".inputmandatory").css("border", "1px solid red");
                e.preventDefault();
                var current = $(this);
                $('.submit', current).attr('disabled', 'disabled');

                var statusid = $('.submit').attr('data-id');
                console.log(statusid);

                $('.required_remark').each(function (i, obj) {
                    if ($(this).val().length == 0) {
                        Swal.fire({
                            icon: 'error',
                            text: 'Remarks are mandatory',
                            showConfirmButton: true,
                        }).then(function () {
                            return false;
                        });
                    }
                });

                var data = new FormData($('#departmentForm')[0]);
                data.append('statusid', statusid);

                if (statusid == 1) {

                    Swal.fire({
                        title: 'Are you sure?',
                        text: 'You want to submit the action taken on documents?',
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#28a745',
                        cancelButtonColor: '#6c757d',
                        confirmButtonText: 'Confirm',
                        cancelButtonText: 'Cancel'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            Swal.fire({
                                title: "Loading...",
                                html: "Please wait a moment"
                            })
                            Swal.showLoading();
                            $.ajax({
                                type: 'POST',
                                url: "{{ route('admin.docupdate') }}",
                                data: data,
                                cache: false,
                                contentType: false,
                                processData: false,

                                success: function (response) {
                                    $('#loading-image').hide();
                                    $('.submit').removeAttr('disabled');

                                    if (response.status == 'success') {
                                        Swal.fire({
                                            icon: 'success',
                                            text: 'Documents Verification details submitted successfully.',
                                            showConfirmButton: true,
                                        }).then(function () {
                                            window.location.reload();
                                        });

                                    } else if (response.status == 'errors') {

                                        $.each(response.message, function (i, message) {
                                            $('#' + i).after(
                                                '<span class="Description_error" style="color:red">' +
                                                message + '</span>');
                                        });

                                    } else if (response.status == 'error') {
                                        $('#name').after(
                                            '<span class="Description_error" style="color:red">' +
                                            response.error + '</span>');
                                    } else if (response.status == false) {
                                        Swal.fire({
                                            icon: 'error',
                                            text: 'Remarks are mandatory',
                                            showConfirmButton: true,
                                        });
                                    } else {

                                        Swal.fire({
                                            icon: 'error',
                                            text: 'Documents Size must be less than 2 MB',
                                            showConfirmButton: true,
                                        });

                                    }
                                },
                            });
                        }
                    });

                } else {

                    Swal.fire({
                        title: "Loading...",
                        html: "Please wait a moment"
                    })
                    Swal.showLoading();

                    $.ajax({
                        type: 'POST',
                        url: "{{ route('admin.docupdate') }}",
                        data: data,
                        cache: false,
                        contentType: false,
                        processData: false,

                        success: function (response) {
                            $('#loading-image').hide();
                            $('.submit').removeAttr('disabled');

                            if (response.status == 'success') {
                                Swal.fire({
                                    icon: 'success',
                                    text: 'Documents Submitted successfully.',
                                    showConfirmButton: true,
                                }).then(function () {
                                    window.location.reload();
                                });

                            } else if (response.status == 'errors') {

                                $.each(response.message, function (i, message) {
                                    $('#' + i).after(
                                        '<span class="Description_error" style="color:red">' +
                                        message + '</span>');
                                });

                            } else if (response.status == 'error') {
                                $('#name').after(
                                    '<span class="Description_error" style="color:red">' +
                                    response.error + '</span>');
                            } else if (response.status == false) {
                                Swal.fire({
                                    icon: 'error',
                                    text: 'Remarks are mandatory',
                                    showConfirmButton: true,
                                });
                            } else {

                                Swal.fire({
                                    icon: 'error',
                                    text: 'Documents Size must be less than 2 MB',
                                    showConfirmButton: true,
                                });

                            }
                        },
                    });

                }




            });

            $('body').on('change', '.status', function () {
                $data = $(this).attr("data-id");
                if ($(this).val() == 0) {
                    $('#remarks' + $data).removeClass('d-none');
                    // $('#remarks'+$data).addClass('inputmandatory');
                    $('#remarks' + $data).addClass('required_remark');
                    $('#remarks' + $data).prop('required', true);
                } else {
                    $('#remarks' + $data).addClass('d-none');
                    $('.length-display').hide();
                    // $('#remarks'+$data).removeClass('inputmandatory');
                    $('#remarks' + $data).removeClass('required_remark');
                    $('#remarks' + $data).prop('required', false);
                }

            });

            $('#newdomain').on('paste', function (event) {
                event.preventDefault();
            });


            $('body').on('click', '.reset_googleauth', function () {

                var id = $(this).attr('data-id');

                if (confirm('Are you sure you want to reset Google Authenticator?')) {

                    $.ajax({
                        url: "{{ route('domain.reset_googleauth') }}",
                        dataType: "json",
                        type: "get",
                        data: {
                            "id": id
                        },
                        success: function (response) {

                            if (response.status == 'success') {

                                Swal.fire({
                                    icon: 'success',
                                    text: 'Google Authenticator Reset Successfully',
                                    showConfirmButton: true,
                                }).then(function () {
                                    window.location.reload();
                                });

                            } else if (response.status == 'error') {

                                alert(response.message);

                            }
                        },
                    });

                }

            });


            $('body').on('click', '.hardcopy_received', function () {

                var id = $(this).attr('data-id');

                if (confirm(
                    'Are you sure, hard copy of Letter of Undertaking has been received for this domain?'
                )) {

                    $.ajax({
                        url: "{{ route('domain.hardcopy_received') }}",
                        dataType: "json",
                        type: "get",
                        data: {
                            "id": id
                        },
                        success: function (response) {

                            if (response.status == 'success') {

                                Swal.fire({
                                    icon: 'success',
                                    text: 'Hard Copy Received Successfully',
                                    showConfirmButton: true,
                                }).then(function () {
                                    window.location.reload();
                                });

                            } else if (response.status == 'error') {

                                alert(response.message);

                            }
                        },
                    });

                }

            });



            $('body').on('submit', '#RegisterDomain', function (e) {
                e.preventDefault();

                var current = $(this);
                $('.submit', current).attr('disabled', 'disabled');
                Swal.fire({
                    title: "Registering Domain...",
                    html: "Please wait, it will take some time"
                })
                Swal.showLoading();
                var data = current.serialize();
                $.ajax({
                    url: "{{ route('registerUserDomain') }}",
                    dataType: "json",
                    type: "post",
                    data: data,
                    success: function (response) {
                        $('.submit').removeAttr('disabled');

                        if (response.status == true) {
                            Swal.fire({
                                icon: 'success',
                                text: response.msg,
                                showConfirmButton: true,
                            }).then(function () {
                                window.location.reload();
                            });

                        } else if (response.status == false) {
                            Swal.fire({
                                icon: 'error',
                                text: response.msg,
                                showConfirmButton: true,
                            }).then(function () {
                                window.location.reload();
                            });
                        }
                    },
                });
            });
        });
    </script>
    <script>
        document.getElementById('newdomain').addEventListener('keypress', function (event) {
            var charCode = event.which || event.keyCode;
            var charStr = String.fromCharCode(charCode);

        });
    </script>

    {{-- neelu july 10 --}}



    {{--
    <script>
        $('body').on('click', '.update_admin_renewal_status_domain', function () {

            var id = $(this).attr('data-id');
            if (confirm('Are you sure you want to renew this Domain?')) {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                Swal.fire({
                    title: "Please wait...",
                })

                Swal.showLoading();

                $.ajax({
                    url: "{{route('admin.update_domain_renewal_status_domain')}}",
                    dataType: "json",
                    type: "post",
                    data: { 'id': id },
                    success: function (response) {

                        if (response.status == 'success') {

                            Swal.fire({
                                icon: 'success',
                                text: 'Domain has been renewed successfully',
                                showConfirmButton: true,
                            }).then(function () {
                                window.location.reload();
                            });

                        } else {

                            alert(response.message);

                        }

                    },
                });

            }
            return false;
        });

    </script>
    <script>
        $('body').on('click', '.update_admin_renewal_status_lmaas', function () {

            var id = $(this).attr('data-id');
            if (confirm('Are you sure you want to renew this Domain?')) {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                Swal.fire({
                    title: "Please wait...",
                })

                Swal.showLoading();

                $.ajax({
                    url: "{{route('admin.update_domain_renewal_status_lmaas')}}",
                    dataType: "json",
                    type: "post",
                    data: { 'id': id },
                    success: function (response) {

                        if (response.status == 'success') {

                            Swal.fire({
                                icon: 'success',
                                text: 'Domain has been renewed successfully',
                                showConfirmButton: true,
                            }).then(function () {
                                window.location.reload();
                            });

                        } else {

                            alert(response.message);

                        }

                    },
                });

            }
            return false;
        });

    </script>


    <script>
        $('body').on('click', '.update_admin_renewal_status_dns', function () {

            var id = $(this).attr('data-id');
            if (confirm('Are you sure you want to renew this Domain?')) {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                Swal.fire({
                    title: "Please wait...",
                })

                Swal.showLoading();

                $.ajax({
                    url: "{{route('admin.update_domain_renewal_status_dns')}}",
                    dataType: "json",
                    type: "post",
                    data: { 'id': id },
                    success: function (response) {

                        if (response.status == 'success') {

                            Swal.fire({
                                icon: 'success',
                                text: 'Domain has been renewed successfully',
                                showConfirmButton: true,
                            }).then(function () {
                                window.location.reload();
                            });

                        } else {

                            alert(response.message);

                        }

                    },
                });

            }
            return false;
        });

    </script>



    <script>
        $('body').on('click', '.update_admin_renewal_status_ewaas', function () {

            var id = $(this).attr('data-id');
            if (confirm('Are you sure you want to renew this Domain?')) {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                Swal.fire({
                    title: "Please wait...",
                })

                Swal.showLoading();

                $.ajax({
                    url: "{{route('admin.update_domain_renewal_status_ewaas')}}",
                    dataType: "json",
                    type: "post",
                    data: { 'id': id },
                    success: function (response) {

                        if (response.status == 'success') {

                            Swal.fire({
                                icon: 'success',
                                text: 'Domain has been renewed successfully',
                                showConfirmButton: true,
                            }).then(function () {
                                window.location.reload();
                            });

                        } else {

                            alert(response.message);

                        }

                    },
                });

            }
            return false;
        });

    </script> --}}



    <script>
        $(document).on('click', '#renew-all-button', function (e) {
            e.preventDefault();

            var userId = $(this).data('id');

            Swal.fire({
                title: 'Are you sure?',
                text: "This will renew all selected services!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, Renew All'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: '{{ route('renew.all.services') }}',
                        type: 'POST',
                        data: {
                            _token: '{{ csrf_token() }}',
                            id: userId
                        },
                        success: function (response) {
                            if (response.status === 'success') {
                                Swal.fire('Renewed!', response.message, 'success');
                                $('#renewal-section').slideUp();
                            } else {
                                Swal.fire('Error', response.message, 'error');
                            }

                        },
                        error: function () {
                            Swal.fire('Error', 'Something went wrong.', 'error');
                        }
                    });
                }
            });
        });
    </script>
@endsection