@extends('layouts.AdminLayout')

@section('content')

<div class="content-wrapper">

<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-2">Payment List</h4>

		<div class="card">
			<div style="padding:20px">

					<div class="table-responsive text-nowrap">
						@if (Session::has('success'))
						   <div class="alert alert-success">{{ Session::get('success') }}</div>
						@endif

						@if (Session::has('error'))
						   <div class="alert alert-danger">{{ Session::get('error') }}</div>
						@endif
						<table class="table" id="dataTable" width="100%" cellspacing="0">
							<thead>
								<tr>
                                <th>S.No.</th>
								<th>User Name</th>
								<th>Amount</th>
                                <th>Email</th>
                                <th>Date</th>
								</tr>
							</thead>
							<tbody>
							</tbody>
						</table>
					</div>


			</div>
		</div>

            <div class="card mt-3">
                <div class="viewform d-none">
					<div class="card cblack">
						<!-- <h4 class="fw-bold font-weight-bold card-header headingtext font-layout">{{ __('Region Details') }}</h4> -->
						<div class="card-body">
							<form>
								<div class="form-group">
									<label for="" class="inputlabel font-layout">Code</label>
									<input type="text" id="view_code" class="form-control" disabled>
								</div>
								<br>
								<div class="form-group">
									<label for="" class=" font-layout">Description <span class="inputlabelmedetory text-err"></span></label>
									<input type="text" name="description" id="view_updateDescription" class="form-control" placeholder="Enter Description" disabled>
								</div>
							  <br>
							  <button type="button" class="btn btn-danger cancelbutton ">Cancel</button>
							</form>
						</div>
					</div>
	            </div>
            </div>


@endsection
@section("js")
	<script type="text/javascript">
		$(document).ready(function() {
			var _ = $('body');
			var table = $('#dataTable').DataTable({
				processing: true,
				serverSide: true,
				ajax: "{{route('payment.ajaxcall')}}",
				columns: [
					{ data: 'id' },
					{ data: 'additionalInfo1',orderable:false },
                    { data: 'txnAmount',orderable:false },
                    { data: 'additionalInfo2',orderable:false },
					{ data: 'created_at',orderable:false},
				]
			});

			$('body').on('click', '.addbutton', function() {
				$('.viewform').addClass('d-none');
			});
			$('body').on('click', '.cancelbutton', function() {
				$('.viewform').addClass('d-none');
			});
		});
	</script>
@endsection



