@extends('layouts.AdminLayout')

@section('content')
    @php
        $user_id = Auth::guard('admin')->user()->id;
        $view_permission = '';
        $edit_permission = '';
        $delete_permission = '';
        if ($user_id == 1) {
            $view_permission = 1;
            $edit_permission = 1;
            $delete_permission = 1;
        } else {
            $permission = getUserHasRoleProgram($user_id, 29);
            if (isset($permission)) {
                $view_permission = $permission->view_priv ?? null;
                $edit_permission = $permission->modify_priv ?? null;
                $delete_permission = $permission->del_priv ?? null;
            }
        }
    @endphp

    <style>
        thead th {
            text-align: center !important;
        }

        @media screen and (min-width: 1300px) {


            table.dataTable th:nth-child(3) {
                width: 200px;
                max-width: 200px;
                word-break: break-all;
                white-space: pre-line;
            }

            table.dataTable td:nth-child(3) {
                width: 200px;
                max-width: 200px;
                word-break: break-all;
                white-space: pre-line;
            }

            table.dataTable th:nth-child(2) {
                width: 200px;
                max-width: 200px;
                word-break: break-all;
                white-space: pre-line;
            }

            table.dataTable td:nth-child(2) {
                width: 200px;
                max-width: 200px;
                word-break: break-all;
                white-space: pre-line;
            }

        }

        .table.dataTable th {
            vertical-align: top;
            text-align: left;
        }
    </style>


    <div class="content-wrapper">

        <div class="container-xxl flex-grow-1 container-p-y">
            <h4 class="fw-bold py-3 mb-2">{{ $domaintext }}</h4>

            <div class="card">

                <div style="padding:20px">

                    <form method="get" id="chatexport2" action="{{ route('admin.activedomainexport') }}">
                        @csrf
                        <div class="row mb-4">
                            <div class="col-md-3">
                                <label class="form-label">Domain Name </label>
                                <input type="text" class="form-control" name="user_name" id="user_name" maxlength="35">
                            </div>

                            <div class="col-md-3">
                                <label class="form-label">Institute Name </label>
                                <input type="text" class="form-control" name="institute_name" id="institute_name">
                            </div>
                            {{-- <div class="col-md-3">
                                <label class="form-label">Language </label>
                                <select class="form-control" name="domainLangID" id="domainLangID">
                                    <option value="">Choose Language</option>
                                    @foreach (\Illuminate\Support\Facades\DB::table('domain_languages')->get() as $lang)
                                        <option value="{{ $lang->id }}">{{ $lang->language_name }}</option>
                                    @endforeach
                                </select>
                            </div> --}}



                            <div class="col-md-3">
                                <label for="state"> State</label>
                                <select name="state" id="state" class="form-control">
                                    <option value="">-- Select State --</option>
                                    @foreach ($states as $state)
                                        <option value="{{ $state->description }}">{{ $state->description }}</option>
                                    @endforeach
                                </select>
                            </div>





                            @if ($domainStatus == '')
                                <div class="col-md-3">
                                    <label class="form-label">Domain Status </label>
                                    <select class="form-control" name="domainStatu" id="domainStatu">
                                        <option value="">Select</option>
                                        <option value="2">Incomplete Application</option>
                                        <option value="5">Pending Domain Creation</option>
                                        <option value="6">Active</option>
                                        <option value="7">Hold</option>
                                        <option value="11">Pending Restorable</option>
                                    </select>
                                </div>
                            @endif


                        </div>
                        <div class="row mb-4">

                            <input type="hidden" class="form-control" name="domainStatus" id="domainStatus"
                                value="{{ $domainStatus ?? '' }}">

                            {{-- <div class="col-md-3">
                                <label class="form-label">Application Date From</label>

                                <input type="text" class="form-control from_date_start datepicker"
                                    name="creation_start_date" placeholder="dd-mm-yyyy" id="from_date"
                                    max="{{ date('Y-m-d') }}" value="{{ $creation_start_date ?? '' }}" autocomplete="off">
                            </div> --}}
                            {{-- <div class="col-md-3">
                                <label class="form-label">Application Date To</label>
                                <input type="text" class="form-control to_date_end datepicker" name="creation_end_date"
                                    id="to_date" placeholder="dd-mm-yyyy" max="{{ date('Y-m-d') }}"
                                    value="{{ $creation_end_date ?? '' }}" autocomplete="off">
                            </div> --}}


                            @if ($domainStatus != 5 && $domaintext != 'Rejected' && $domainStatus != 2 && $domaintext != 'Incomplete Application')
                                <div class="col-md-3">
                                    <label class="form-label">Expiry Date From</label>
                                    <input type="text" class="form-control from_date_expiry datepicker"
                                        name="expiry_start_date" placeholder="dd-mm-yyyy" id="expiry_start_date"
                                        max="{{ date('Y-m-d') }}" value="{{ $expiry_start_date ?? '' }}" autocomplete="off">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label">Expiry Date To</label>
                                    <input type="text" class="form-control to_date_expiry datepicker"
                                        name="expiry_end_date" placeholder="dd-mm-yyyy" id="expiry_end_date"
                                        max="{{ date('Y-m-d') }}" value="{{ $expiry_end_date ?? '' }}" autocomplete="off">
                                </div>
                            @endif




                            <!-- <div class="col-md-3 d-flex">
                                                                                                                                                                                                                                                                      <button class="btn btn-success reset" id="search_user_btn" name="action" value="reset" style="height: 40px;margin-top: 27px; margin-right: 20px;">Reset</button>
                                                                                                                                                                                                                                                                  </div> -->
                            <div style="text-align: right;"><br>
                                <button type="submit" class="btn btn-primary"
                                    style="height: 40px; cursor: pointer; color: white;">
                                    Export To Excel
                                </button>
                            </div>

                        </div>
                    </form>
                    <div class="col-md-3 d-flex">
                        <button class="btn btn-success search" id="search_user_btn" name="action" value="submit"
                            style="height: 40px;margin-top: 27px; margin-right: 20px;">Search</button>
                    </div>
                    <div class="table-responsive text-nowrap">
                        @if (Session::has('success'))
                            <div class="alert alert-success">{{ Session::get('success') }}</div>
                        @endif

                        @if (Session::has('error'))
                            <div class="alert alert-danger">{{ Session::get('error') }}</div>
                        @endif
                        <table class="table table-striped table-bordered dataTable no-footer" id="dataTable" width="100%"
                            cellspacing="0">
                            <thead class="table-secondary">
                                <tr>

                                    <th>S.No.</th>
                                    <th>Domain <br>Name</th>
                                    <th>Institute Name<br>/ Contact No.</th>
                                    <th>Application Date</th>

                                    @if ($domainStatus == 7)
                                        <th>Domain Hold<br> Date</th>
                                    @elseif($domainStatus == 8)
                                        <th>Domain Temp <br> Deleted Date</th>
                                    @else
                                        <th>Last Updated<br> Date</th>
                                    @endif


                                    <th>Domain Expiry<br> Date</th>
                                    <th>Domain Status</th>
                                    <th>Action</th>


                                </tr>
                            </thead>

                            <tbody>

                            </tbody>
                        </table>
                    </div>

                </div>
            </div>


        </div>
    </div>

    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <form method="post" id="deleteform" enctype="multipart/form-data">
                {!! csrf_field() !!}
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Delete Domain</h5>
                        <!-- <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                                                                                                                                                                                                                                                          <span aria-hidden="true">&times;</span>
                                                                                                                                                                                                                                                        </button> -->
                    </div>
                    <div class="modal-body">

                        <input type="hidden" id="delete_id" name="id">


                        <div class="form-group">
                            <label for="">Remarks </label>
                            <textarea class="form-control" name="delete_remarks" id="delete_remarks" rows="3" required></textarea>
                        </div>

                        <div class="form-group mt-3">
                            <label for="">Deletion Request </label>
                            <input type="file" name="deleteion_request" class="form-control"
                                accept="application/pdf">
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-danger">Delete</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="modal fade" id="holdModal" tabindex="-1" role="dialog" aria-labelledby="holdModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <form method="post" id="holdform">
                {!! csrf_field() !!}
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="holdModalLabel">Hold Domain</h5>
                    </div>
                    <div class="modal-body">

                        <input type="hidden" id="hold_id" name="hold_id">

                        <div class="form-group">
                            <label for="">Remarks </label>
                            <textarea class="form-control" name="hold_remarks" id="hold_remarks" rows="3" required></textarea>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-danger">Hold</button>
                    </div>
                </div>
            </form>
        </div>
    </div>


    <div class="modal fade" id="passwordModal" tabindex="-1" role="dialog" aria-labelledby="passwordModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <form method="post" id="passwordform">
                {!! csrf_field() !!}
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="holdModalLabel">Reset Password</h5>
                    </div>
                    <div class="modal-body">

                        <input type="hidden" id="domchange_id" name="domain_id">

                        <div class="form-group">
                            <label for="">New Password <strong style="color:red !important">*</strong></label>
                            <input type="password" class="form-control" name="newpassword" id="newpassword"
                                placeholder="" required>
                        </div>

                        <div class="form-group mt-3">
                            <label for="">Confirm Password <strong style="color:red !important">*</strong></label>
                            <input type="password" class="form-control" name="conpassword" id="conpassword"
                                placeholder="">
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-success">Change Password</button>
                    </div>
                </div>
            </form>
        </div>
    </div>


    <div class="modal fade" id="unholdModal" tabindex="-1" role="dialog" aria-labelledby="unholdModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <form method="post" id="unholdform">
                {!! csrf_field() !!}
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="unholdModalLabel">Unhold Domain</h5>
                    </div>
                    <div class="modal-body">

                        <input type="hidden" id="unhold_id" name="unhold_id">

                        <div class="form-group">
                            <label for="">Remarks </label>
                            <textarea class="form-control" name="unhold_remarks" id="unhold_remarks" rows="3" required></textarea>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-danger">Unhold</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
@section('js')
    <link href="{{ asset('vendor/datatables/dataTables.bootstrap4.min.css') }}" rel="stylesheet">
    <link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
    <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>


    <script src="{{ asset('vendor/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('vendor/datatables/dataTables.bootstrap4.min.js') }}"></script>


    <script>
        $(function() {
            $(".datepicker").datepicker({
                dateFormat: 'dd-mm-yy',
                constrainInput: false,
                changeYear: true,
                changeMonth: true,
                yearRange: '1980:+0',
                maxDate: 0
            });
        });
    </script>

    <script type="text/javascript">
        $(document).ready(function() {


            $('.specialchars').on('keypress', function(e) {

                var regex = new RegExp("^[a-zA-Z. ]");
                var key = String.fromCharCode(!e.charCode ? e.which : e.charCode);
                if (!regex.test(key)) {
                    e.preventDefault();
                    return false;
                }

            });

            var _ = $('body');
            var createRecord = 'Are you sure you want to save the record?';
            var updateRecord = 'Are you sure you want to modify this record?';
            var deleteRecord = 'Are you sure you want to delete this record?';

            var domainText = "{{ $domaintext }}";
            var domainStatus = "{{ $domainStatus }}";
            var domainLangId = "{{ $langId }}";
            var hardcopy = "{{ $hardcopy }}";

            var table = $('#dataTable').DataTable({
                processing: true,
                serverSide: true,
                "ajax": {
                    "url": "{{ route('finduser.ajaxcall') }}",
                    "type": "GET",
                    "datatype": "json",
                    "data": function(d) {

                        d.domaintext = domainText;
                        d.domainStatus = domainStatus;
                        d.domainLangId = domainLangId;
                        d.hardcopy = hardcopy;

                        d.user_name = $('#user_name').val();
                        d.institute_name = $('#institute_name').val();
                        d.domainStatu = $('#domainStatu').val();
                        d.from_date = $('#from_date').val();
                        d.to_date = $('#to_date').val();
                        d.domainLangIds = $('#domainLangID').val();

                        d.expiry_start_date = $('#expiry_start_date').val();
                        d.expiry_end_date = $('#expiry_end_date').val();
                        d.state = $('#state').val();

                    }
                },
                columns: [{
                        data: 'id'
                    },
                    {
                        data: 'domainName'
                    },
                    {
                        data: 'inst',
                        orderable: false
                    },
                    {
                        data: 'appdate',
                        orderable: false
                    },
                    {
                        data: 'lastdate',
                        orderable: false
                    },
                    {
                        data: 'expdate',
                        orderable: false
                    },
                    {
                        data: 'status',
                        orderable: false
                    },
                    {
                        data: 'Action',
                        orderable: false
                    },
                ],
                order: [
                    [0, 'desc']
                ]
            });

            $('body').on('click', '.search', function() {
                table.ajax.reload();
            });

            $('body').on('click', '.reset', function() {
                window.location.reload();
            });
            $('body').on('click', '.exportdata', function() {
                $('#chatexport2').submit();
            });


            $('body').on('click', '.update_admin_renewal_status', function() {

                var id = $(this).attr('data-id');
                if (confirm('Are you sure you want to renew this Domain')) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });

                    Swal.fire({
                        title: "Please wait...",
                    })

                    Swal.showLoading();

                    $.ajax({
                        url: "{{ route('admin.update_domain_renewal_status') }}",
                        dataType: "json",
                        type: "post",
                        data: {
                            'id': id
                        },
                        success: function(response) {

                            if (response.status == 'success') {

                                Swal.fire({
                                    icon: 'success',
                                    text: 'Domain has been renewed successfully',
                                    showConfirmButton: true,
                                }).then(function() {
                                    window.location.reload();
                                });

                            } else if (response.status == 'error') {

                                alert(response.message);

                            } else if (response.status == 'exceptionError') {}
                        },
                    });

                }
                return false;
            });



            $('body').on('click', '.hold_button', function() {

                var id = $(this).attr('data-id');

                $('#hold_id').val(id);
                $('#holdModal').modal('show');

            });

            $('body').on('submit', '#holdform', function(e) {
                e.preventDefault();
                var current = $(this);
                var data = current.serialize();

                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                Swal.fire({
                    title: "Please wait...",
                })

                Swal.showLoading();

                $.ajax({
                    url: "{{ route('domain.hold') }}",
                    dataType: "json",
                    type: "post",
                    data: data,
                    success: function(response) {

                        if (response.status == 'success') {

                            Swal.fire({
                                icon: 'success',
                                text: 'Domain has been hold successfully',
                                showConfirmButton: true,
                            }).then(function() {
                                window.location.reload();
                            });

                        } else if (response.status == 'error') {

                            alert(response.message);

                        }
                    },
                });

            })


            $('body').on('click', '.delete_admin', function() {

                var id = $(this).attr('data-id');

                $('#delete_id').val(id);
                $('#exampleModal').modal('show');

            });

            $('body').on('submit', '#deleteform', function(e) {
                e.preventDefault();
                var current = $(this);
                // var data = current.serialize();

                var data = new FormData($('#deleteform')[0]);

                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                Swal.fire({
                    title: "Please wait...",
                })

                Swal.showLoading();

                $.ajax({
                    type: 'POST',
                    url: "{{ route('admin.delete_domain') }}",
                    data: data,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function(response) {

                        if (response.status == 'success') {

                            Swal.fire({
                                icon: 'success',
                                text: 'Domain has been deleted successfully',
                                showConfirmButton: true,
                            }).then(function() {
                                window.location.reload();
                            });

                        } else if (response.status == 'error') {

                            alert(response.message);

                        } else if (response.status == 'exceptionError') {}
                    },
                });

            })


            $('body').on('click', '.unhold_button', function() {

                var id = $(this).attr('data-id');

                $('#unhold_id').val(id);
                $('#unholdModal').modal('show');

            });

            $('body').on('submit', '#unholdform', function(e) {
                e.preventDefault();
                var current = $(this);
                var data = current.serialize();

                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                Swal.fire({
                    title: "Please wait...",
                })

                Swal.showLoading();

                $.ajax({
                    url: "{{ route('domain.unhold') }}",
                    dataType: "json",
                    type: "post",
                    data: data,
                    success: function(response) {

                        if (response.status == 'success') {

                            Swal.fire({
                                icon: 'success',
                                text: 'Domain has been Unhold successfully',
                                showConfirmButton: true,
                            }).then(function() {
                                window.location.reload();
                            });

                        } else if (response.status == 'error') {

                            alert(response.message);

                        }
                    },
                });

            })


            $('body').on('click', '.send_invoice', function(e) {
                e.preventDefault();
                var id = $(this).attr('data-id');
                if (confirm('Are you sure you want to send the ivoice')) {

                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
                    Swal.fire({
                        title: "Sending..."

                    })
                    Swal.showLoading();
                    $.ajax({
                        url: "{{ route('admin.send_invoice') }}",
                        dataType: "json",
                        type: "post",
                        data: {
                            'id': id
                        },
                        success: function(response) {

                            if (response.status == 'success') {

                                Swal.fire({
                                    icon: 'success',
                                    text: 'Invoice sent!',
                                    showConfirmButton: true,
                                }).then(function() {
                                    window.location.reload();
                                });

                            } else if (response.status == 'error') {

                                alert(response.message);

                            } else if (response.status == 'exceptionError') {}
                        },
                    });
                }
                return false;
            });


            $('body').on('click', '.change_passwordbutton', function() {

                var id = $(this).attr('data-id');

                $('#domchange_id').val(id);
                $('#passwordModal').modal('show');

            });

            $('body').on('submit', '#passwordform', function(e) {
                e.preventDefault();
                var current = $(this);
                var data = current.serialize();

                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                // Swal.fire({
                //   title: "Please wait...",
                // })

                // Swal.showLoading();

                $.ajax({
                    url: "{{ route('domain.change_password') }}",
                    dataType: "json",
                    type: "post",
                    data: data,
                    success: function(response) {

                        if (response.status == 'success') {

                            Swal.fire({
                                icon: 'success',
                                text: 'Password Changed Successfully',
                                showConfirmButton: true,
                            }).then(function() {
                                window.location.reload();
                            });

                        } else if (response.status == 'error') {

                            alert(response.message);

                        }
                    },
                });

            })



        });
    </script>
@endsection
