<!DOCTYPE html>
<html
  lang="en"
  class="light-style customizer-hide"
  dir="ltr"
  data-theme="theme-default"
  data-assets-path="../assets/"
  data-template="vertical-menu-template-free"
>
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>Admin Login</title>
    <meta name="description" content="" />
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="{{asset('assets/img/favicon/favicon.ico')}}" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap" rel="stylesheet" />
    <!-- Icons. Uncomment required icon fonts -->
    <link rel="stylesheet" href="{{asset('assets/vendor/fonts/boxicons.css')}}" />
    <link rel="stylesheet" href="{{asset('resources/css/app.css')}}" />
    <!-- Core CSS -->
    <link rel="stylesheet" href="{{asset('assets/vendor/css/core.css')}}" class="template-customizer-core-css" />
    <link rel="stylesheet" href="{{asset('assets/vendor/css/theme-default.css')}}" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="{{asset('assets/css/demo.css')}}" />
    <!-- Vendors CSS -->
    <link rel="stylesheet" href="{{asset('admin/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css')}}" />
    <link rel="stylesheet" href="{{asset('admin/assets/vendor/css/pages/page-auth.css')}}" />
    <!-- Helpers -->
    <script src="{{asset('admin/assets/vendor/js/helpers.js')}}"></script>
      <script src="{{asset('assets/js/config.js')}}"></script>
      <link rel="stylesheet" href="{{asset('/assets/css/sweetalert2.min.css')}}" />
      <script src="{{asset('/assets/js/sweetalert2.min.js')}}"></script>
    

      <!--  Mfs 100 JS -->
      <script src="{{asset('assets/js/mfsjquery.js')}}"></script>
      <script src="{{asset('assets/js/mfs100.js')}}"></script>
      <script language="javascript" type="text/javascript">


        var quality = 60; //(1 to 100) (recommanded minimum 55)
        var timeout = 10; // seconds (minimum=10(recommanded), maximum=60, unlimited=0 )
        var nooffinger = '1';
        function GetInfo() {
            document.getElementById('tdSerial').innerHTML = "";
            document.getElementById('tdCertification').innerHTML = "";
            document.getElementById('tdMake').innerHTML = "";
            document.getElementById('tdModel').innerHTML = "";
            document.getElementById('tdWidth').innerHTML = "";
            document.getElementById('tdHeight').innerHTML = "";
            document.getElementById('tdLocalMac').innerHTML = "";
            document.getElementById('tdLocalIP').innerHTML = "";
            document.getElementById('tdSystemID').innerHTML = "";
            document.getElementById('tdPublicIP').innerHTML = "";


            var key = document.getElementById('txtKey').value;
            var res;
            if (key.length == 0) {
                res = GetMFS100Info();
            }
            else {
                //alert("GetMFS100KeyInfo");
                res = GetMFS100KeyInfo(key);
            }

            if (res.httpStaus) {

                document.getElementById('txtStatus').value = "ErrorCode: " + res.data.ErrorCode + " ErrorDescription: " + res.data.ErrorDescription;

                if (res.data.ErrorCode == "0") {
                    document.getElementById('tdSerial').innerHTML = res.data.DeviceInfo.SerialNo;
                    document.getElementById('tdCertification').innerHTML = res.data.DeviceInfo.Certificate;
                    document.getElementById('tdMake').innerHTML = res.data.DeviceInfo.Make;
                    document.getElementById('tdModel').innerHTML = res.data.DeviceInfo.Model;
                    document.getElementById('tdWidth').innerHTML = res.data.DeviceInfo.Width;
                    document.getElementById('tdHeight').innerHTML = res.data.DeviceInfo.Height;
                    document.getElementById('tdLocalMac').innerHTML = res.data.DeviceInfo.LocalMac;
                    document.getElementById('tdLocalIP').innerHTML = res.data.DeviceInfo.LocalIP;
                    document.getElementById('tdSystemID').innerHTML = res.data.DeviceInfo.SystemID;
                    document.getElementById('tdPublicIP').innerHTML = res.data.DeviceInfo.PublicIP;
                }
            }
            else {
                alert(res.err);
            }
            return false;
        }
    
    

        function Capture() {
            try {
                document.getElementById('txtStatus').value = "";
                document.getElementById('imgFinger').src = "data:image/bmp;base64,";
                document.getElementById('txtImageInfo').value = "";
                document.getElementById('txtIsoTemplate').value = "";
                document.getElementById('txtAnsiTemplate').value = "";
                document.getElementById('txtIsoImage').value = "";
                document.getElementById('txtRawData').value = "";
                document.getElementById('txtWsqData').value = "";

                var res = CaptureFinger(quality, timeout);
                if (res.httpStaus) {

                    document.getElementById('txtStatus').value = "ErrorCode: " + res.data.ErrorCode + " ErrorDescription: " + res.data.ErrorDescription;

                    if (res.data.ErrorCode == "0") {
                        document.getElementById('imgFinger').src = "data:image/bmp;base64," + res.data.BitmapData;
                        var imageinfo = "Quality: " + res.data.Quality + " Nfiq: " + res.data.Nfiq + " W(in): " + res.data.InWidth + " H(in): " + res.data.InHeight + " area(in): " + res.data.InArea + " Resolution: " + res.data.Resolution + " GrayScale: " + res.data.GrayScale + " Bpp: " + res.data.Bpp + " WSQCompressRatio: " + res.data.WSQCompressRatio + " WSQInfo: " + res.data.WSQInfo;
                        document.getElementById('txtImageInfo').value = imageinfo;
                        document.getElementById('txtIsoTemplate').value = res.data.IsoTemplate;
                        //document.getElementById('txtIsoTemplate').value = res.data.BitmapData;
                        document.getElementById('txtAnsiTemplate').value = res.data.AnsiTemplate;
                        document.getElementById('txtIsoImage').value = res.data.IsoImage;
                        document.getElementById('txtRawData').value = res.data.RawData;
                        document.getElementById('txtWsqData').value = res.data.WsqImage;
                    }
                }
                else {
                    alert(res.err);
                }
            }
            catch (e) {
                alert(e);
            }
            return false;
        }
      </script>

    <!--  Mfs 100 JS -->

  </head>
  <body oncontextmenu="return false;">

<div class="content-wrapper">

  <!-- Content -->
  <div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light"></span>Fingerprint Registeration</h4>
    
    

    <div class="card mb-4">
       <div class="card-body">
        <a href="{{asset('assets/mfs100driver/Driver.zip')}}" style="float: right;" class="btn btn-primary" download="">Download Driver</a>
          <form role="form" id="addFingerForm" method="POST">
             @csrf
             <div class="row">
                <div class="col-md-4 mb-3">
                   <label class="form-label"></label>
                   <img id="imgFinger"  width="145px" height="188px" alt="Put Your Finger" src="{{asset('/assets/img/finger_scan.gif')}}" />
                </div>
                <div class="form-group" style="display:none;">
                   <textarea id="txtIsoTemplate" name="fingerprint" style="width: 100%; height:50px;" value="" class="form-control"> </textarea>
                </div>
             </div>
             <div class="demo-inline-spacing">
                <br>
                <button type="button" id="btnCapture" value="Capture" onclick="return Capture()" class="btn btn-warning cancelbutton">Capture</button>
                <button type="submit" id="submit" name="action" value="submit" class="btn btn-success submit">Submit</button>
                <br><br>
             </div>
          </form>
       </div>
    </div>
    <div class="panel" style="display:none;">
        <table width="100%">
            <tr style="display:none;">
                <td width="220px">
                    Status:
                </td>
                <td>
                    <input type="text" value="" id="txtStatus" class="form-control" />
                </td>
            </tr>
            <tr style="display:none;">
                <td>
                    Quality:
                </td>
                <td>
                    <input type="text" value="" id="txtImageInfo" class="form-control" />
                </td>
            </tr>
            
            
            <tr style="display:none;">
                <td>
                    Base64Encoded ANSI Template
                </td>
                <td>
                    <textarea id="txtAnsiTemplate" style="width: 100%; height:50px;" class="form-control"> </textarea>
                </td>
            </tr>
            <tr style="display:none;">
                <td>
                    Base64Encoded ISO Image
                </td>
                <td>
                    <textarea id="txtIsoImage" style="width: 100%; height:50px;" class="form-control"> </textarea>
                </td>
            </tr>
            <tr style="display:none;">
                <td>
                    Base64Encoded Raw Data
                </td>
                <td>
                    <textarea id="txtRawData" style="width: 100%; height:50px;" class="form-control"> </textarea>
                </td>
            </tr>
            <tr style="display:none;">
                <td>
                    Base64Encoded Wsq Image Data
                </td>
                <td>
                    <textarea id="txtWsqData" style="width: 100%; height:50px;" class="form-control"> </textarea>
                </td>
            </tr>
            
           
        </table>
    </div>
    
  </div>
  <!-- / Content -->
  
</div>


</body>
</html>


<script type="text/javascript">
  $(document).ready(function()
      {
        var createRecord = 'Are you sure you want to save?';
        $('body').on('submit', '#addFingerForm', function(e) {
                      e.preventDefault();
              var current = $(this);
              if (confirm(createRecord)) {
                $('.submit', current).attr('disabled', 'disabled');
                var data = current.serialize();
                $.ajax({
                  url: "{{route('capturefinger.add')}}",
                  dataType : "json",
                  type: "post",
                  data : data,
                  success : function(response) {
                    
                    $('.btnCapture').removeAttr('disabled');
                    
                    
                    if(response.status == 'success') {
                      Swal.fire({
                            title: "Success!",
                            text: "Your fingerprint has been added successfully",
                            icon: "success",
                            button:false
                          });
                          window.location="{{route('admin.matchfinger')}}";
                     

                    } else if(response.status == 'errors') {
                      
                      $.each(response.message, function(i, message) {
                        $('#'+i).after('<span class="Description_error" style="color:red">'+message+'</span>');
                      });
                      
                    } else if(response.status == 'error') {
                      $('#description').after('<span class="Description_error" style="color:red">'+response.error+'</span>');
                    }
                    else if(response.status == 'exceptionError')
                    {
                    }
                  },
                });
                return false;
              }
              return false;
            });
      });
</script>