@extends('layouts.AdminLayout')

@section('content')

<div class="content-wrapper">

<div class="container-xxl flex-grow-1 container-p-y">

<h4 class="fw-bold py-3 mb-2">Domain Extension</h4>

<div class="card mt-3">
				
<div class="createform">
            
<div class="card cblack">

<div class="card-body">
                    
<form method="post" id="departmentForm">

{!! csrf_field() !!}

<input type="hidden" name="id" id="id">
           
<div class="row">

            <div class="col-md-6 mt-3">
              <label class="form-label text-capitalize fs-6 text-dark">Choose Main extension <span class="text-danger">*</span></label>
              <select class="form-control"  name="main_category" id="main_extension" >
                <option value="">Select Domain extension</option>
                @foreach($get_domain_main_data as $get_domain_main)
                    <option value="{{$get_domain_main->id}}">{{$get_domain_main->domain_category_name}}</option>
                @endforeach
              </select>
            </div>

            <div class="col-md-6 mt-3">
              <label class="form-label text-capitalize fs-6">Choose Languages <span class="text-danger">*</span></label>
              <select class="form-control"  name="regional_languages" id="regional_languages" >
                <option value="">All Languages</option>
                @foreach($get_domain_languages_data as $get_domain_languages)
                <option value="{{$get_domain_languages->id}}">{{$get_domain_languages->language_name}}</option>
                @endforeach
              </select>
            </div>

            <div class="col-md-6 mt-3">
              <label class="form-label text-capitalize fs-6"> Domain Extensions <span class="text-danger">*</span></label>
              <input type="text" class="form-control"  name="domain_extensions" id="domain_extensions" placeholder=" Domain Extensions" value="" />
            </div>

            <div class="col-md-6 mt-3">
              <label class="form-label">Is Active <span class="text-danger">*</span></label>
              <select class="form-control"  name="domain_status" id="domain_status" >
                <option value="Active">Active</option>
                <option value="In-Active">In-Active</option>
              </select>
            </div>

</div>

<h5 class="mt-5">Required Documents</h5>

<?php

print_r($dom_exts->doc_ids);

?>

<table class="table table-bordered mt-3">
  <thead>
    <tr>
      <th scope="col">S.No.</th>
      <th scope="col">Document Name</th>
      <th scope="col">Choosen Documents</th>
      <th scope="col">Mandatory</th>
    </tr>
  </thead>
  <tbody>


  
  
  @foreach($get_domain_doc_data as  $sno => $get_domain_doc)

    <tr>
      <th scope="row">{{$sno+1}}</th>
      <td>{{$get_domain_doc->title}}
      <input type="hidden" name="doc_ids[]" value="{{$get_domain_doc->id}}" />
      </td>
      <td>
      <input type="hidden" name="allow_ids[]" value="0" /><input type="checkbox" class="allow_ids" name="allow_ids[]" value="1"/>       
      </td>
      <td>
      <input type="hidden" name="main[]" value="0" /><input type="checkbox" class="main" name="main[]" value="1"/>       
      </td>
     </tr>
 @endforeach

  </tbody>
</table>

                    <div class="demo-inline-spacing mt-5">
                            <button type="submit" class="btn btn-primary submit ">Submit</button>
                            <button type="button" class="btn btn-danger cancelbutton "><a href="{{url('ernetdash/domain-extension')}}" class="text-white">Cancel</a></button>
                            <br><br>
                    </div>
                </form>
            </div>
        </div>
      </div>
   </div>
</div>

@endsection
@section("js")
	<script type="text/javascript">
		
		$(document).ready(function() {

			var createRecord = 'Are you sure you want to save the record?';
			
			$('body').on('submit', '#departmentForm', function(e) {
                e.preventDefault();
				var current = $(this);
				if (confirm(createRecord)) {
					$('.submit', current).attr('disabled', 'disabled');
					var data = current.serialize();
					$.ajax({
						url: "{{route('domain_ext.save')}}",
						dataType : "json",
						type: "post",
						data : data,
						success : function(response) {
							
							$('.submit').removeAttr('disabled');
							
							if(response.status == 'success') {
 
                             window.location.href="{{url('ernetdash/domain-extension')}}";

							} else if(response.status == 'errors') {
								$.each(response.message, function(i, message) {
									$('#'+i).after('<span class="Description_error" style="color:red">'+message+'</span>');
								});
							} else if(response.status == 'error') {
								$('#description').after('<span class="Description_error" style="color:red">'+response.error+'</span>');
							}
						},
					});
					return false;
				}
				return false;
			});

                var id="{{$id}}";

                $.ajaxSetup({
						headers: {
							'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
						}
				});

                $.ajax({
					url: "{{ route('admin.domain-ext-data') }}",
					dataType : "json",
					data : {'id':id},
					success : function(response) {
						
						if(response.status == 'success') {
						
                            $('#id').val(response.data.id);
                            $('#domain_extensions').val(response.data.domain_extension);
                            $('#main_extension option[value="'+response.data.domain_main_category_id+'"]').prop('selected', true);
                            $('#regional_languages option[value="'+response.data.domain_language_id+'"]').prop('selected', true);
                            $('#domain_status option[value="'+response.data.status+'"]').prop('selected', true);

						} else if(response.status == 'error') {
							
							alert(response.message);
							
						}
						
					},
				});
			
		});
	</script>

@endsection



