@extends('layouts.AdminLayout')
@section('content')

<?php

$action='';

$userid=Auth::guard('admin')->user()->id;

$edit=$del=$add=true;
$priv=getUserHasRoleProgram($userid,6);

if($priv!=null){
    $edit=$priv->modify_priv==1 ?true:false;
    $del=$priv->del_priv==1 ?true:false;
    $add=$priv->add_priv==1 ?true:false;
}
$head_name = get_heading_name(6);
   if($head_name!=null){
       $heading_name= $head_name;
   }else
   {
      $heading_name="Language";
   }


?>

<div class="container-xxl flex-grow-1 container-p-y">
	<h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light"></span>{{$heading_name}}</h4>
  	<div class="card">
  		<div class="card-header">
    		<h5>Add languages</h5>
  		</div>
      	<div class="card-body">
  			<form role="form" id="add_language_form" method="POST">
            @csrf
            	<div class="row">
	                <div class="col-md-5 mb-3">
	                	<label class="form-label text-capitalize fs-6">Language Name<span></span></label>
	                  	<input type="text" id="add_language" name="add_language" class="form-control specialchar" placeholder="Enter Language Name" onKeyPress="if(this.value.length==30) return false;">
	                </div>
	                <div class="col-md-5 mb-3">
		              	<label class="form-label text-capitalize fs-6">Status <span></span></label>
		              	<select class="form-control" name="language_status" id="language_status">
			                <option value="">Choose Status</option>
			                <option value="active">Active</option>
				            <option value="in-active">In-active</option>
		              	</select>
		            </div>
               		<div class="col-md-2 mt-4">
						@if($add)
               			<button class="btn btn-primary btn-block mt-1" id="add_language_smt_btn" name="action" value="add" style="margin-top:5px">Add</button>
						@endif
               		</div>
              	</div>
          	</form>
        </div>
    </div>
    <div class="card mt-4">
  		<div class="card-header">
    		<h5>All languages List</h5>
  		</div>
        <div class="card-body">
          	<div class="table-responsive">
		         <table class="table table-striped table-bordered dataTable no-footer">
		            <thead class="table-secondary">
		              <tr>
		                <th class="text-capitalize fs-6">Languages</th>
		                <th class="text-capitalize fs-6">Status</th>
		                <th class="text-capitalize fs-6">Action</th>
		              </tr>
		            </thead>
		            <tbody>
		            	@foreach($get_lang_data as $get_lang)
		                <tr>
			                <td>{{$get_lang->language_name}}</td>
			                <td>{{$get_lang->status}}</td>
			                <td>
							  @if($edit)
			                  <i class="fa fa-edit text-info fs-3 me-md-3 get-languages-name-data" data-id="{{$get_lang->id}}" data-bs-toggle="modal" data-bs-target="#update_language_modal"></i>
							  @endif
							  @if($del)
			                  <i class="fa fa-trash text-danger fs-3 delete-languages-name" data-id="{{$get_lang->id}}"></i>
							  @endif
			                </td>
		              	</tr>
		              	@endforeach
		            </tbody>
		        </table>
		    </div>
      	</div>
    </div>
    <div class="modal fade update_language_modal" id="update_language_modal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
	  	<div class="modal-dialog">
		    <div class="modal-content">
		      	<div class="modal-header">
		        	<h5 class="modal-title" id="staticBackdropLabel">Update Language</h5>
			        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			    </div>
	        	<form role="form" id="update_language_form" method="POST">
	            @csrf
			      	<div class="modal-body">
		                <div class=" mb-3">
		                	<label class="form-label text-capitalize fs-6">Language Name<span></span></label>
		                  	<input type="text" id="update_language" name="update_language" class="form-control specialchar " placeholder="Enter Language Name" onKeyPress="if(this.value.length==30) return false;">
		                  	<input type="hidden" name="languages_id" id="languages_id">
		                </div>
		                <div class="mb-3">
			              	<label class="form-label text-capitalize fs-6">Status <span></span></label>
			              	<select class="form-control" name="update_language_status" id="update_language_status">
				                <option value="">Choose Status</option>
				                <option value="active">Active</option>
				                <option value="in-active">In-active</option>
			              	</select>
			            </div>
			      	</div>
			      	<div class="modal-footer">
				        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
				        <button type="button" class="btn btn-primary" id="update_language_btn">Update</button>
			      	</div>
		        </form>
		    </div>
	  	</div>
	</div>
</div>
@endsection
@section("js")
<script>
$(document).ready(function(){

	$('.specialcharuser').on('keypress',function(e){

var regex=new RegExp("^[a-zA-Z]");
var key=String.fromCharCode(!e.charCode ? e.which :e.charCode);
if(!regex.test(key)){
    e.preventDefault();
    return false;
}

});
		

	$('#add_language_form').validate({
	    rules: {
	      add_language: {required: true,},
	      language_status: {required: true,},
	    },
	    messages:
	    {
	      add_language:{required: "Please Enter Language name",},
	      language_status:{required: "Please choose language Status",},
	    },
	    submitHandler:function(form)
	    {
	      $.ajaxSetup({
	        headers: {
	          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
	        }
	      });
	      $.ajax({
	        url:"{{Route('admin.add-language')}}",
	        type:'POST',
	        dataType:'json',
	        data:$("#add_language_form").serialize(),
	        cache: false,
	        beforeSend: function(){
	          $(".loader-area").show();
	        },
	        success:function(res)
	        {
	          if(res.status=='success')
	          {
	            Swal.fire({
	              position: 'center',
	              icon: 'success',
	              text: res.message,
	              showConfirmButton: true,
	            });
	            window.location = "{{route('admin.language-view')}}";
	          }
			  else if(res.status=='errors')
          {
            
            $.each(res.message, function(i, message) {
				$('#'+i).after('<span class="Description_error" style="color:red">'+message+'</span>');
		    });

          }
	          else
	          {
	            Swal.fire({
	            position: 'center',
	            icon: 'error',
	            text: res.message,
	            showConfirmButton: true,
	            });
	          }
	        },
	        complete: function(){
	          $("form").trigger("reset");
	          $("#add_domain_category_btn").prop('disabled',false);
	        },
	      });
	    }
  	});
  	$(".get-languages-name-data").click(function(){
	    var languages_id = $(this).attr("data-id");
	    $.ajaxSetup({
	      headers: {
	        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
	      }
	    });
	    $.ajax({
	      url:"{{Route('admin.get-languages-data')}}",
	      type:'POST',
	      dataType:'json',
	      data:{languages_id:languages_id},
	      cache: false,
	      beforeSend: function(){
	        $(".loader-area").show();
	      },
	      success:function(res)
	      {
	        if(res.status=='success')
	        {
	          $('#languages_id').attr('value',res.message.id);
	          $('#update_language').attr('value',res.message.language_name);
	          //alert(res.message.status);
	          var statusValue = res.message.status;
	          if(statusValue == 'active'){
					  	 $('#update_language_status option[value="active"]').attr('selected', 'selected');
					  }else
					  {
					  	$('#update_language_status option[value="in-active"]').attr('selected', 'selected');
					  }
 
	          $("#update_language_modal").modal('show');
	        }
	        else
	        {
	          Swal.fire({
	            position: 'center',
	            icon: 'error',
	            text: res.message,
	            showConfirmButton: false,
	          });
	        }
	      },
	      complete: function(){
	        // $("form").trigger("reset");
	        $("#update_language_btn").prop('disabled',false);
	      },
	    });
  	});
  	$("#update_language_btn").click(function(){
	    $.ajaxSetup({
	      headers: {
	        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
	      }
	    });
	    $.ajax({
	      url:"{{Route('admin.update-languages-data')}}",
	      type:'POST',
	      dataType:'json',
	      data:$("#update_language_form").serialize(),
	      cache: false,
	      beforeSend: function(){
	        $(".loader-area").show();
	      },
	      success:function(res)
	      {
	        if(res.status=='success')
	        {
	        	$("#update_language_modal").modal('hide');
		        Swal.fire({
		            position: 'center',
		            icon: 'success',
		            text: res.message,
		            showConfirmButton: false,
		        });
		        window.location = "{{route('admin.language-view')}}";
	        }else if(res.status=='errors')
          {
            
            $.each(res.message, function(i, message) {
				$('#'+i).after('<span class="Description_error" style="color:red">'+message+'</span>');
		    });

          }
	        else
	        {
	          Swal.fire({
	            position: 'center',
	            icon: 'error',
	            text: res.message,
	            showConfirmButton: false,
	          });
	        }
	      },
	      complete: function(){
	        // $("form").trigger("reset");
	        $("#update_language_btn").prop('disabled',false);
	      },
	    });
  	});
  	$('.delete-languages-name').click(function(){
    Swal.fire({
      title: 'Are you sure?',
      text: "You won't be able to revert this!",
      icon: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      confirmButtonText: 'Yes, delete it!'
    }).then((result) => {
      if (result.isConfirmed)
      {
        var languages_id = $(this).attr('data-id');
        $.ajaxSetup({
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });
        $.ajax({
          url:"{{Route('admin.delete-languages-name')}}",
          type:'POST',
          dataType:'json',
          data:{languages_id:languages_id},
          cache: false,
          beforeSend: function(){
            $(".loader-area").show();
          },
          success:function(res)
          {
            if(res.status=='success')
            {
              Swal.fire(
                'Deleted!',
                'the record has been deleted.',
                'success'
              );
			  window.location = "{{route('admin.language-view')}}";
            }
            else
            {
             Swal.fire({
                position: 'center',
                icon: 'error',
                text: res.message,
                showConfirmButton: false,
              });
            }
          },
          complete: function(){
            $("form").trigger("reset");
            $(".delete-languages-name").prop('disabled',false);
          },
        });
      }
    });
  });
});
</script>
@endsection
