@extends('layouts.AdminLayout')
@section('content')

    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <div class="card mb-4">
                <h5 class="card-header bg-info"> Email Setting <button class="btn float-end {{ $emailItems->status == 1 ? 'btn-success' : 'btn-danger' }} change-status-btn"data-id="{{ $emailItems->id }}"data-status="{{ $emailItems->status }}">{{ $emailItems->status == 1 ? 'Active' : 'Inactive' }}</button></h5>
                <div class="card-body">
                    <div class="table-responsive">
                        <form role="form" id="edit_email_form" method="POST" >
                            @csrf
                            <div class="modal-body">
                                <div class="me-md-3  mb-4">
                                    <label class="form-label">Host Name </label>
                                    <input type="text" class="form-control" name="host_name" value="{{$emailItems->host_name}}" id="edit_title" required>
                                    <input type="hidden" name="tod_id" value="{{$emailItems->id}}" id="tod_id">
                                </div>
                                <div class="me-md-3  mb-4">
                                    <label class="form-label">Port Number </label>
                                    <input type="number" class="form-control" name="port_number" value="{{$emailItems->port_number}}" id="edit_description" required>
                                </div>
                                <div class="me-md-3  mb-4">
                                    <label class="form-label">Username </label>
                                    <input type="text" class="form-control" name="username" value="{{$emailItems->username}}" id="edit_description" required>
                                </div>
                                <div class="me-md-3  mb-4">
                                    <label class="form-label">Password </label>
                                    <input type="text" class="form-control" name="password" value="{{$emailItems->password}}" id="edit_description" required>
                                </div>
                                <div class="me-md-3  mb-4">
                                    <label class="form-label">From Address </label>
                                    <input type="email" class="form-control" name="from_address" value="{{$emailItems->from_address}}" id="edit_description" required>
                                </div>
                                <div class="me-md-3  mb-4">
                                    <label class="form-label">From Name </label>
                                    <input type="text" class="form-control" name="from_name" value="{{$emailItems->from_name}}" id="edit_description" required>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button class="btn btn-primary d-grid" id="edit_email_btn" name="action" value="submit">Update</button>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>
        <!-- / Content -->

    </div>
@endsection
@section("js")
    <script>
        //$('#domain_extension_price_table').DataTable();
        $(document).ready(function() {
            $('.change-status-btn').click(function() {
                var todId = $(this).data('id');
                var status = $(this).data('status') === 1 ? 0 : 1;
                Swal.fire({
                    title: 'Are you sure?',
                    text: 'You are about to change the status of this news item. This action cannot be undone.',
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#28a745',
                    cancelButtonColor: '#6c757d',
                    confirmButtonText: 'Confirm',
                    cancelButtonText: 'Cancel'
                }).then((result) => {
                    if (result.isConfirmed) {
                        // Perform the AJAX request to change the status
                        $.ajax({
                            url: "{{ route('admin.change-email-setting-status') }}",
                            type: 'POST',
                            dataType: 'json',
                            data: {
                                "_token": "{{ csrf_token() }}",
                                todId: todId,
                                status: status
                            },
                            success: function(response) {
                                if (response.status === 'success') {
                                    // Show success message
                                    Swal.fire({
                                        position: 'center',
                                        icon: 'success',
                                        text: response.message,
                                        showConfirmButton: false
                                    });
                                    setTimeout(function() {
                                        window.location = "{{route('admin.email-setting-view')}}";
                                    }, 2000);
                                } else {
                                    // Show an error message
                                    Swal.fire({
                                        position: 'center',
                                        icon: 'error',
                                        text: response.message,
                                        showConfirmButton: false
                                    });
                                }
                            },
                            error: function(xhr, status, error) {
                                // Show an error message
                                Swal.fire({
                                    position: 'center',
                                    icon: 'error',
                                    text: 'An error occurred. Please try again.',
                                    showConfirmButton: false
                                });
                            }
                        });
                    }
                });
            });

    $('#edit_email_form').validate({
        rules: {
          host_name: { maxlength:255,},
          port_number: { maxlength:255,},
          username: { maxlength:255,},
          password: { maxlength:255,},
          from_address: { maxlength:255,},
          from_name: { maxlength:255,},
        },
        messages: {
          host_name: {required: "Please enter a Host name."},
          port_number: {required: "Please enter a Port number."},
          username: {required: "Please enter a Username."},
          password: {required: "Please enter Password."},
          from_address: {required: "Please enter a from email address."},
          from_name: {required: "Please enter a From Name."},
        },
        submitHandler:function(form){
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url:"{{Route('admin.update-email-setting')}}",
                type:'POST',
                dataType:'json',
                data:$("#edit_email_form").serialize(),
                cache: false,
                beforeSend: function(){
                    $(".loader-area").show();
                    $("#edit_email_btn").prop('disabled',true);
                },
                success:function(res)
                {
                    if(res.status=='success'){
                        Swal.fire({
                            position: 'center',
                            icon: 'success',
                            text: res.message,
                            showConfirmButton: false,
                        });
                        setTimeout(function() {
                          window.location = "{{route('admin.email-setting-view')}}";
                        }, 2000);
                        
                    }
                    else
                    {
                        Swal.fire({
                            position: 'center',
                            icon: 'error',
                            text: res.message,
                            showConfirmButton: false,
                        });
                    }
                },
                complete: function(){
                    $("form").trigger("reset");
                    $("#edit_email_btn").prop('disabled',false);
                },
            });
        }
    });

});
    </script>
@endsection
