@extends('layouts.AdminLayout')

@section('content')

<div class="content-wrapper">

<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-2">Emails List</h4>
			
		<div class="card">
			<div style="padding:20px">	
				
					<div class="table-responsive text-nowrap">
						@if (Session::has('success'))
						   <div class="alert alert-success">{{ Session::get('success') }}</div>
						@endif
						
						@if (Session::has('error'))
						   <div class="alert alert-danger">{{ Session::get('error') }}</div>
						@endif

						
						<table class="table table-striped table-bordered cell-border" id="dataTable" width="100%" cellspacing="0">
							  <thead class="table-secondary">
								<tr>
                                <th>S.No.</th>
                                <th>Host Name </th>
								<th>Port Number </th>
								<th>Username </th>
                                <th>Password</th>
                                <th>From Address</th>
                                <th>From Name</th>
								<th>Action</th>
								</tr>
							</thead>
						   
							<tbody>
								
							</tbody>
						</table>
					</div>
					
                    <div class="demo-inline-spacing">
                         <br>
                        <button type="button" class="btn btn-primary addbutton ">Add</button>
						<br><br>
                </div>
			</div>
		</div>

        <div class="card mt-3">
				
        <div class=" createform d-none">
            <div class="card cblack">

                <div class="card-body">
                    
                    <form method="post" id="departmentForm">
                        {!! csrf_field() !!}
                        
                        <div class="form-group">
                            <label for="" class=" font-layout">Host Name  <span class="inputlabelmedetory text-err"></span></label>
                            <input type="text" name="host_name" id="host_name" class="form-control" placeholder="Enter Host Name">
                        </div>

                      <div class="form-group">
                        <label for="" class=" font-layout">Port Number <span class="inputlabelmedetory text-err"></span></label>
                        <input type="text" name="port_number" id="port_number" class="form-control" placeholder="Enter Port Number">
                      </div>
                      <div class="form-group">
                        <label for="" class=" font-layout">Username<span class="inputlabelmedetory text-err"></span></label>
                        <input type="text" name="username" id="username" class="form-control" placeholder="Enter username">
                      </div>
                      <div class="form-group">
                        <label for="" class=" font-layout">Password <span class="inputlabelmedetory text-err"></span></label>
                        <input type="text" name="password" id="password" class="form-control" placeholder="Enter password">
                      </div>
                      <div class="form-group">
                        <label for="" class=" font-layout">From Address <span class="inputlabelmedetory text-err"></span></label>
                        <input type="text" name="from_address" id="from_address" class="form-control" placeholder="Enter From Address">
                      </div>

                      <div class="form-group">
                        <label for="" class=" font-layout">From Name<span class="inputlabelmedetory text-err"></span></label>
                        <input type="text" name="from_name" id="from_name" class="form-control" placeholder="Enter From Name">
                      </div>

                    <div class="demo-inline-spacing">
                            <br>
                            <button type="submit" class="btn btn-primary submit ">Submit</button>
                            <button type="button" class="btn btn-danger cancelbutton ">Cancel</button>
                            <br><br>
                    </div>
                     
                    </form>
                </div>
            </div>
        </div>


        <div class="updateform d-none">
					<div class="card cblack">
						<!-- <h4 class="fw-bold font-weight-bold card-header headingtext font-layout">{{ __('Region Details Data Update') }}</h4> -->

						<div class="card-body">
							
							<form method="post" id="updateDesignationForm" action="#">
								{!! csrf_field() !!}
								<input type="hidden" name="id" id="id" />
								<br>
                                <div class="form-group">
									<label for="" class=" font-layout">Host Name <span class="inputlabelmedetory text-err"></span></label>
									<input type="text" name="host_name" id="updatehost_name" class="form-control" placeholder="Enter Host Name">
								</div>
								<div class="form-group">
									<label for="" class=" font-layout">Port Number <span class="inputlabelmedetory text-err"></span></label>
									<input type="text" name="port_number" id="updateport_number" class="form-control" placeholder="Enter Port Number">
								</div>
                                <div class="form-group">
									<label for="" class=" font-layout">Username <span class="inputlabelmedetory text-err"></span></label>
									<input type="text" name="username" id="updateusername" class="form-control" placeholder="Enter Username">
								</div>
                                <div class="form-group">
									<label for="" class=" font-layout">Password <span class="inputlabelmedetory text-err"></span></label>
									<input type="text" name="password" id="updatepassword" class="form-control" placeholder="Enter Password">
								</div>
                                <div class="form-group">
									<label for="" class=" font-layout">From Address <span class="inputlabelmedetory text-err"></span></label>
									<input type="text" name="from_address" id="updatefrom_address" class="form-control" placeholder="Enter From Address">
								</div>
                                <div class="form-group">
									<label for="" class=" font-layout">From Name <span class="inputlabelmedetory text-err"></span></label>
									<input type="text" name="from_name" id="updatefrom_name" class="form-control" placeholder="Enter From Name">
								</div>
                               
							<div class="demo-inline-spacing">
                                    <br>
									<button type="submit" class="btn btn-primary submit">Update</button>
									<button type="button" class="btn btn-danger cancelbutton">Cancel</button>
									<br><br>
							</div>
							 
							  
							</form>
							
						</div>
					</div>
				
				</div>
        
                <div class="viewform d-none">
					<div class="card cblack">
						<!-- <h4 class="fw-bold font-weight-bold card-header headingtext font-layout">{{ __('Region Details') }}</h4> -->
						<div class="card-body">
							<form>
                            
                                <div class="form-group">
									<label for="" class=" font-layout">Host Name <span class="inputlabelmedetory text-err"></span></label>
									<input type="text" name="host_name" id="view_updatehost_name" class="form-control" placeholder="Enter Host Name" disabled>
								</div>
								<div class="form-group">
									<label for="" class=" font-layout">Port Number<span class="inputlabelmedetory text-err"></span></label>
									<input type="text" name="port_number" id="view_updateport_number" class="form-control" placeholder="Enter Port Number" disabled>
								</div>
                                <div class="form-group">
									<label for="" class=" font-layout">Username<span class="inputlabelmedetory text-err"></span></label>
									<input type="text" name="username" id="view_updateusername" class="form-control" placeholder="Enter Username" disabled>
								</div>
                                <div class="form-group">
									<label for="" class=" font-layout">Password<span class="inputlabelmedetory text-err"></span></label>
									<input type="text" name="password" id="view_updatepassword" class="form-control" placeholder="Enter Password" disabled>
								</div>
                                <div class="form-group">
									<label for="" class=" font-layout">From Address<span class="inputlabelmedetory text-err"></span></label>
									<input type="text" name="from_address" id="view_updatefrom_address" class="form-control" placeholder="Enter checksum key" disabled>
								</div>
                                <div class="form-group">
									<label for="" class=" font-layout">From Name <span class="inputlabelmedetory text-err"></span></label>
									<input type="text" name="from_name" id="view_updatefrom_name" class="form-control" placeholder="Enter From Name" disabled>
								</div>
							  <br>
							  <button type="button" class="btn btn-danger cancelbutton ">Cancel</button>
							</form>
						</div>
					</div>
	</div>
</div>


@endsection
@section("js")
	<script type="text/javascript">
		
		$(document).ready(function() {
			var _ = $('body');
			var createRecord = 'Are you sure you want to save the record?';
			var updateRecord = 'Are you sure you want to modify this record?';
			var deleteRecord = 'Are you sure you want to delete this record?';
			
			var table = $('#dataTable').DataTable({
				processing: true,
				serverSide: true,
				ajax: "{{route('emaiSetting.ajaxcall')}}",
				columns: [
					{ data: 'id' },
                    { data: 'host_name',orderable:false},
                    { data: 'port_number',orderable:false},
                    { data: 'username',orderable:false},
                    { data: 'password',orderable:false},
					{ data: 'from_address',orderable:false},
                    { data: 'from_name',orderable:false},
					{ data: 'Action',orderable:false },
				]
			});
			$('body').on('click', '.delete', function() {
				var id = $(this).attr('data-id');
				if (confirm(deleteRecord)) {
					$('.viewform').addClass('d-none');
					$('.updateform').addClass('d-none');
					$('.createform').addClass('d-none');
					$.ajaxSetup({
						headers: {
							'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
						}
					});
					
					$.ajax({
						url: "{{route('emaiSetting.delete')}}",
						dataType : "json",
						type: "post",
						data : {'id':id},
						success : function(response) {
                            $('#host_name').val('');
                            $('#port_number').val('');
                            $('#username').val('');
                            $('#password').val('');
							$('#from_address').val('');
                            $('#from_name').val('');
							if(response.status == 'success') {
								table.ajax.reload();
							} else if(response.status == 'error') {
								alert(response.message);
							} 
							else if(response.status == 'exceptionError')
							{
								CommonManager.forcelogout();
							}
						},
					});
					
				}
				return false;
			});

			
			
			$('body').on('submit', '#departmentForm', function(e) {
                e.preventDefault();
				var current = $(this);
				if (confirm(createRecord)) {
					$('.submit', current).attr('disabled', 'disabled');
					
                    var host_name = $('#host_name', current).val();
					var port_number = $('#port_number', current).val();
                    var username = $('#username', current).val();
                    var password = $('#password', current).val();
                    var from_address = $('#from_address', current).val();
                    var from_name = $('#from_name', current).val();

                    $('.host_name_error').remove();
					if(host_name == '') {
						$('#host_name').after('<span class="host_name_error" style="color:red">Please Enter Host Name.</span>');
						$('.submit').removeAttr('disabled');
						return false;
					}

					$('.port_number_error').remove();
					if(port_number == '') {
						$('#port_number').after('<span class="port_number_error" style="color:red">Please Enter Port Number.</span>');
						$('.submit').removeAttr('disabled');
						return false;
					}
                    $('.username_error').remove();
                    if(username == '') {
						$('#username').after('<span class="username_error" style="color:red">Please Enter username.</span>');
						$('.submit').removeAttr('disabled');
						return false;
					}
                    $('.password_error').remove();
                    if(password == '') {
						$('#password').after('<span class="password_error" style="color:red">Please Enter password.</span>');
						$('.submit').removeAttr('disabled');
						return false;
					}
                    $('.from_address_error').remove();
                    if(from_address == '') {
						$('#from_address').after('<span class="from_address_error" style="color:red">Please Enter From Address.</span>');
						$('.submit').removeAttr('disabled');
						return false;
					}
                    $('.from_name_error').remove();
                    if(from_name == '') {
						$('#from_name').after('<span class="from_name_error" style="color:red">Please Enter From Name.</span>');
						$('.submit').removeAttr('disabled');
						return false;
					}
					
					var data = current.serialize();
					$.ajax({
						url: "{{route('emaiSetting.save')}}",
						dataType : "json",
						type: "post",
						data : data,
						success : function(response) {
							
							$('.submit').removeAttr('disabled');
							
							if(response.status == 'success') {
                                $('#host_name').val('');
								$('#port_number').val('');
                                $('#username').val('');
                                $('#password').val('');
                                $('#from_address').val('');
                                $('#from_name').val('');
								table.ajax.reload();
								$('.updateform').addClass('d-none');
								$('.createform').addClass('d-none');
								$('.viewform').addClass('d-none');
							} else if(response.status == 'errors') {
								
								$.each(response.message, function(i, message) {
									$('#'+i).after('<span class="Description_error" style="color:red">'+message+'</span>');
								});
								
							} else if(response.status == 'error') {
								$('#description').after('<span class="Description_error" style="color:red">'+response.error+'</span>');
							}
							else if(response.status == 'exceptionError')
							{
								CommonManager.forcelogout();
							}
						},
					});
					return false;
				}
				return false;
			});
			
			$('body').on('submit', '#updateDesignationForm', function(e) {
                e.preventDefault();
			var current = $(this);
			if (confirm(updateRecord)) {
				$('.submit', current).attr('disabled', 'disabled');
				var host_name = $('#updatehost_name', current).val();
				var port_number = $('#updateport_number', current).val();
                var username = $('#updateusername', current).val();
                var password = $('#updatepassword', current).val();
                var from_address = $('#updatefrom_address', current).val();
                var from_name = $('#updatefrom_name', current).val();

				$('.payment_gateway_error').remove();
				if(host_name == '') {
					$('#updatehost_name').after('<span class="host_name_error" style="color:red">Please enter Host Name.</span>');
					$('.submit').removeAttr('disabled');
					return false;
				}
				$('.port_number_error').remove();
				if(port_number == '') {
					$('#updateport_number').after('<span class="port_number_error" style="color:red">Please enter Port Number.</span>');
					$('.submit').removeAttr('disabled');
					return false;
				}
                $('.username_error').remove();
				if(username == '') {
					$('#updateusername').after('<span class="username_error" style="color:red">Please enter username.</span>');
					$('.submit').removeAttr('disabled');
					return false;
				}
                $('.password_error').remove();
				if(password == '') {
					$('#updatepassword').after('<span class="password_error" style="color:red">Please enter password.</span>');
					$('.submit').removeAttr('disabled');
					return false;
				}
                $('.from_address_error').remove();
				if(from_address == '') {
					$('#updatefrom_address').after('<span class="from_address_error" style="color:red">Please enter From Address.</span>');
					$('.submit').removeAttr('disabled');
					return false;
				}
                $('.from_name_error').remove();
				if(from_name == '') {
					$('#updatefrom_name').after('<span class="from_name_error" style="color:red">Please enter From Name.</span>');
					$('.submit').removeAttr('disabled');
					return false;
				}

				$('.err').remove();
				var data = current.serialize();
				$.ajax({
					url:"{{route('emaiSetting.update')}}",
					dataType : "json",
					type: "post",
					data : data,
					success : function(response) {
						
						$('.submit').removeAttr('disabled');
						
						if(response.status == 'success') {
                            $('#host_name').val('');
							$('#port_number').val('');
                            $('#username').val('');
                            $('#password').val('');
                            $('#from_address').val('');
							$('#from_name').val('');
							table.ajax.reload();
							
							$('.updateform').addClass('d-none');
							$('.createform').addClass('d-none');
							$('.viewform').addClass('d-none');
							
						} else if(response.status == 'errors') {
							
							$.each(response.message, function(i, message) {
								$('#updateDescription').after('<span id="Description_error" class="err" style="color:red">'+message+'</span>');
							});
							
						} else if(response.status == 'error') {
							$('#updateDescription').after('<span class="Description_error err" style="color:red">'+response.message+'</span>');
						}
						else if(response.status == 'exceptionError')
						{
							CommonManager.forcelogout();
						}
					},
				});
				return false;
			}
			return false;
		});
			$('body').on('click', '.view', function() {
				var id = $(this).attr('data-id');
				$('.viewform').removeClass('d-none');
				$('.updateform').addClass('d-none');
				$('.createform').addClass('d-none');
				$.ajax({
					url: "{{ route('emaiSetting.regionid') }}",
					dataType : "json",
					type: "get",
					data : {'id':id},
					success : function(response) {
						
						if(response.status == 'success') {
                            $('#view_updatehost_name').val(response.data.host_name);
							$('#view_updateport_number').val(response.data.port_number);
                            $('#view_updateusername').val(response.data.username);
                            $('#view_updatepassword').val(response.data.password);
                            $('#view_updatefrom_address').val(response.data.from_address);
							$('#view_updatefrom_name').val(response.data.from_name);
						} else if(response.status == 'error') {
							
							alert(response.message);
							
						}
						
					},
				});
			});
			
			$('body').on('click', '.update', function() {
				var id = $(this).attr('data-id');
				$('#code').val('');
				$.ajax({
					url: "{{ route('emaiSetting.regionid') }}",
					dataType : "json",
					type: "get",
					data : {'id':id},
					success : function(response) {
						
						if(response.status == 'success') {
							
							$('.createform').addClass('d-none');
							$('.viewform').addClass('d-none');
							$('.updateform').removeClass('d-none');
							$('#id').val(response.data.id);
                            $('#updatehost_name').val(response.data.host_name);
                            $('#updateport_number').val(response.data.port_number);
                            $('#updateusername').val(response.data.username);
                            $('#updatepassword').val(response.data.password);
                            $('#updatefrom_address').val(response.data.from_address);
							$('#updatefrom_name').val(response.data.from_name);

						} else if(response.status == 'error') {
							alert(response.message);						
						}
						
					},
				});
				
			});
			
			$('body').on('click', '.addbutton', function() {
				$('.createform').removeClass('d-none');
				$('.updateform').addClass('d-none');
				$('.viewform').addClass('d-none');
			});
			
			$('body').on('click', '.cancelbutton', function() {
				$('.createform').addClass('d-none');
				$('.updateform').addClass('d-none');
				$('.viewform').addClass('d-none');
			});
			
		});
	</script>

@endsection



