@extends('layouts.AdminLayout')
@section('content')

<div class="content-wrapper">
  <!-- Content -->
  <div class="container-xxl flex-grow-1 container-p-y">
    <div class="card mb-4">
      <h5 class="card-header bg-info">Users Details List</h5>
      <div class="card-body">
          <h5 class="my-4">Search Parameters</h5>
          <form  role="form" id="find_user_form" method="get">
              @csrf
              <div class="row mb-4">
                  <div class="col-md-3">
                      <label class="form-label">Domain Name </label>
                      <input type="text" class="form-control" name="user_name" id="user_name" maxlength="35">
                  </div>
                  <div class="col-md-3">
                      <label class="form-label">Applicant Name </label>
                      <input type="text" class="form-control" name="name" id="name">
                  </div>

                  <div class="col-md-3">
                      <label class="form-label">Institute Name </label>
                      <input type="text" class="form-control" name="institute_name" id="institute_name">
                  </div>
              </div>
              <div class="row mb-4">
                  <div class="col-md-3">
                      <label class="form-label">Status </label>
                      <select class="form-control"  name="domainStatus" id="domainStatus" >
                          <option value="">Choose Status</option>
                          <option value="2">In-active</option>
                          <option value="5">Pending Applications</option>
                          <option value="6">Active</option>

                      </select>
                  </div>
                  <div class="col-md-3">
                      <label class="form-label">Creation Date </label>
                      <input type="date" class="form-control" name="created_date" id="created_date">
                  </div>
                  <div class="col-md-3">
                      <label class="form-label">Expiry Date </label>
                      <input type="date" class="form-control" name="expirey_date" id="expirey_date"  maxlength="35">
                  </div>

                  <div class="col-md-3 d-flex">
                      <button class="btn btn-success" id="search_user_btn" name="action" value="submit" style="height: 40px;margin-top: 27px; margin-right: 20px;">Search</button>
                      <a href="{{Route('admin.find-users-details-view')}}" >
                          <input type="button" class="btn btn-info" id="Refresh_user_form_btn" name="action" value="Reset" style="height: 40px;margin-top: 27px;" />
                      </a>
                  </div>
              </div>
          </form>
          <br>
        <div class="table-responsive mt-3">
          <table class="table table-striped table-bordered">
            <thead>
              <tr>
                <th>Applicant Name</th>
                <th>Domain Name</th>
                <th>Institute Name</th>
                <th>Last Updated Date</th>
                <th>Domain Creation Date</th>
                <th>Domain Expiry Date</th>
                <th>Domain Status</th>
                <th>Documents Status</th>
              </tr>
            </thead>
            <tbody>
              @foreach($users_data as $users)

              <tr>
                <td>{{$users->name}}</td>
                <td>{{$users->domainName}}</td>
                <td>{{$users->institute}}</td>
                <td>{{\Carbon\Carbon::parse($users->updated_at)->format('d/m/Y')}}</td>
                <td></td>
                <td></td>
                <td>
                  <a class="btn btn-outline-success" href="{{Route('admin.users-details-view',['id'=>$users->id])}}"> View Details</a>
{{--                  <i class="fa fa-trash fs-3 me-md-3 text-danger delete-user-domain" title="Delete"></i>--}}
                </td>
                  <td>

                          @if($users->is_doc_approved == 0)
                            <a class="btn btn-outline-danger" href="{{Route('admin.users-details-view-doc',['id'=>$users->id])}}"> Clarification Required ({{$users->pending_doc}}) </a>
                      @elseif($users->is_doc_approved == 1)
                          <a class="btn btn-outline-info" href="{{Route('admin.users-details-view-doc',['id'=>$users->id])}}"> Pending Approval </a>
                      @elseif($users->is_doc_approved == 2)
                          <a class="btn btn-outline-success" href="{{Route('admin.users-details-view-doc',['id'=>$users->id])}}"> Approved </a>
                      @else
                          <a class="btn btn-outline-danger" href="{{Route('admin.users-details-view-doc',['id'=>$users->id])}}"> Not Uploaded </a>
                          @endif

                  </td>

              </tr>
              {{-- <tr>
                <td colspan="6"><p class="text-danger text-center py-3"> Data Not Found ! </p></td>
              </tr> --}}
              @endforeach
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
  <!-- / Content -->
</div>
@endsection
@section("js")
<script>
$(document).ready(function() {

});
</script>
@endsection
