@extends('layouts.AdminLayout')
@section('content')

    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <div class="card mb-4">
                <h5 class="card-header">Home Page News Section Details <button class="btn btn-info float-end "  data-bs-toggle="modal" data-bs-target="#add_news_modal"> + Add News</button></h5>
                <div class="card-body">
                    <div class="table-responsive">
                        
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered cell-border" id="domain_extension_price_table">
                            <thead>
                            <tr>
                                <th>Id</th>
                                <th>Description</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($newsItems as $newsItem)
                                <tr>
                                    <td>{{ $newsItem->id }}</td>
                                    <td><a href="{{ asset('public/front/assets/news_pdf/'.$newsItem->link) }}" target="_blank">{{ $newsItem->description }}</td>
                                    <td>
                                        <button class="btn btn-sm {{ $newsItem->status == 1 ? 'btn-success' : 'btn-danger' }} change-status-btn"data-id="{{ $newsItem->id }}"data-status="{{ $newsItem->status }}">
                                                {{ $newsItem->status == 1 ? 'Active' : 'Inactive' }}
                                        </button>
                                    </td>
                                    <td>
                                        <button class="btn btn-danger delete-news" data-id="{{ $newsItem->id }}"><i class="fa fa-trash"></i> Delete</button>
                                        <button class="btn btn-info edit-news" data-id="{{ $newsItem->id }}"><i class="fa fa-edit"></i> Edit</button>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- / Content -->
        <!-- Modal -->
        <div class="modal fade add_news_modal" id="add_news_modal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="staticBackdropLabel">Add News</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form role="form" id="add_news_form" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="modal-body">
                            
                            <div class="me-md-3  mb-4">
                                <label class="form-label">Description </label>
                                <input type="text" class="form-control" name="description" id="description" required>
                            </div>
                            <div class="me-md-3  mb-4">
                                <label class="form-label">PDF File</label>
                                <input type="file" class="form-control" name="link" id="link" required>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                            <button class="btn btn-primary d-grid" id="add_news_btn" name="action" value="submit">Add</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="modal fade add_news_modal" id="edit_news_modal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="staticBackdropLabel">Edit News</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form role="form" id="edit_news_form" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="modal-body">
                            
                            <div class="me-md-3  mb-4">
                                <label class="form-label">Description </label>
                                <input type="text" class="form-control" name="description" id="edit_description" required>
                                <input type="hidden" name="news_id" id="news_id">
                                
                            </div>
                            <div class="me-md-3  mb-4">
                                <label class="form-label">PDF FIle</label>
                                <input type="file" class="form-control" name="link" id="edit_link">
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                            <button class="btn btn-primary d-grid" id="edit_news_btn" name="action" value="submit">Update</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        
    </div>
@endsection
@section("js")
    <script>
        // $('#domain_extension_price_table').DataTable();
        $(document).ready(function() {
            $('#add_news_form').validate({
                rules: {
                    description: { maxlength:255,},
                    link: {required: true,extension: "pdf"},
                },
                messages:{
                        description:{required: "This field is required"},
                        link:{
                            required: "This field is required",
                            extension: "Please upload a PDF file"
                        },
                    },
                submitHandler:function(form)
                {
                    var formData = new FormData(form);
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
                    $.ajax({
                        url:"{{Route('admin.add-news-section')}}",
                        type:'POST',
                        dataType:'json',
                        data:formData,
                        contentType: false,
                        processData: false,
                        cache: false,
                        beforeSend: function(){
                            $(".loader-area").show();
                            $("#add_news_btn").prop('disabled',true);
                        },
                        success:function(res)
                        {
                            if(res.status=='success')
                            {
                                Swal.fire({
                                    position: 'center',
                                    icon: 'success',
                                    text: res.message,
                                    showConfirmButton: false,
                                });
                                setTimeout(function() {
                                    window.location = "{{route('admin.news-section-view')}}";
                                }, 2000);
                                //window.location = "{{route('admin.news-section-view')}}";
                            }
                            else
                            {
                                Swal.fire({
                                    position: 'center',
                                    icon: 'error',
                                    text: res.message,
                                    showConfirmButton: false,
                                });
                            }
                        },
                        complete: function(){
                            $("form").trigger("reset");
                            $("#add_price_btn").prop('disabled',false);
                        },
                    });
                }
            });

            
            
            $('.change-status-btn').click(function() {
                var newsId = $(this).data('id');
                var status = $(this).data('status') === 1 ? 0 : 1;
                Swal.fire({
                    title: 'Are you sure?',
                    text: 'You are about to change the status of this news item. This action cannot be undone.',
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#28a745',
                    cancelButtonColor: '#6c757d',
                    confirmButtonText: 'Confirm',
                    cancelButtonText: 'Cancel'
                }).then((result) => {
                    if (result.isConfirmed) {
                        // Perform the AJAX request to change the status
                        $.ajax({
                            url: "{{ route('admin.change-news-status') }}",
                            type: 'POST',
                            dataType: 'json',
                            data: {
                                "_token": "{{ csrf_token() }}",
                                newsId: newsId,
                                status: status
                            },
                            success: function(response) {
                                if (response.status === 'success') {
                                    // Show success message
                                    Swal.fire({
                                        position: 'center',
                                        icon: 'success',
                                        text: response.message,
                                        showConfirmButton: false
                                    });
                                    setTimeout(function() {
                                        window.location = "{{route('admin.news-section-view')}}";
                                    }, 2000);
                                } else {
                                    // Show an error message
                                    Swal.fire({
                                        position: 'center',
                                        icon: 'error',
                                        text: response.message,
                                        showConfirmButton: false
                                    });
                                }
                            },
                            error: function(xhr, status, error) {
                                // Show an error message
                                Swal.fire({
                                    position: 'center',
                                    icon: 'error',
                                    text: 'An error occurred. Please try again.',
                                    showConfirmButton: false
                                });
                            }
                        });
                    }
                });
            });





        // AJAX request to delete a news item
        $('.delete-news').click(function() {
            var newsId = $(this).data('id');
            Swal.fire({
                title: 'Are you sure?',
                text: 'You are about to delete this news item. This action cannot be undone.',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#dc3545',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Delete',
                cancelButtonText: 'Cancel'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: "{{ route('admin.delete-news') }}",
                        type: 'POST',
                        data: {
                            "_token": "{{ csrf_token() }}",
                            news_id: newsId 
                        },
                        dataType: 'json',
                        success: function(res) {
                            if (res.status === 'success') {
                                // Remove the deleted news item from the table
                                $('#domain_extension_price_table').find('tr[data-id="' + newsId + '"]').remove();

                                // Show success message
                                Swal.fire({
                                    position: 'center',
                                    icon: 'success',
                                    text: res.message,
                                    showConfirmButton: false
                                });
                                setTimeout(function() {
                                    window.location = "{{route('admin.news-section-view')}}";
                                }, 2000);
                                
                            } else {
                                // Show error message
                                Swal.fire({
                                    position: 'center',
                                    icon: 'error',
                                    text: res.message,
                                    showConfirmButton: false
                                });
                            }
                        },
                        error: function(xhr, status, error) {
                            // Show error message
                            Swal.fire({
                                position: 'center',
                                icon: 'error',
                                text: 'An error occurred while deleting the news item. Please try again.',
                                showConfirmButton: false
                            });
                        }
                    });
                }
            });
        });

    $('.edit-news').click(function() {
        var newsId = $(this).data('id');
    
        $.ajax({
            url: "{{ route('admin.get-news') }}",
            type: "POST",
            data: {
                "_token": "{{ csrf_token() }}",
                news_id: newsId
            },
            dataType: "json",
            success: function(response) {
                if (response.status === 'success') {
                    var news = response.news;
                    $('#news_id').val(news.id);
                    $('#edit_description').val(news.description);
                    $('#edit_news_modal').modal('show');
                } else {
                    console.log(response.message);
                }
            },
            error: function(xhr, status, error) {
                console.log(error);
            }
        });
    });

    $('#edit_news_form').validate({
        rules: {
            description: { maxlength:255,},
        },
        messages:{
            description:{required: "This field is required"},
        },
        submitHandler:function(form){
            var formData = new FormData(form);
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url:"{{Route('admin.update-news-section')}}",
                type:'POST',
                dataType:'json',
                data:formData,
                contentType: false,
                processData: false,
                cache: false,
                beforeSend: function(){
                    $(".loader-area").show();
                    $("#edit_news_btn").prop('disabled',true);
                },
                success:function(res)
                {
                    if(res.status=='success')
                    {
                        Swal.fire({
                            position: 'center',
                            icon: 'success',
                            text: res.message,
                            showConfirmButton: false,
                        });
                        setTimeout(function() {
                            window.location = "{{route('admin.news-section-view')}}";
                        }, 2000);
                    }
                    else
                    {
                        Swal.fire({
                            position: 'center',
                            icon: 'error',
                            text: res.message,
                            showConfirmButton: false,
                        });
                    }
                },
                complete: function(){
                    $("form").trigger("reset");
                    $("#add_price_btn").prop('disabled',false);
                },
            });
        }
    });
            
});
    </script>
@endsection
