@extends('layouts.AdminLayout')
@section('content')

    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <div class="card mb-4">
                <h5 class="card-header bg-info"> Tip Of The Day <button class="btn float-end {{ $todItems->status == 1 ? 'btn-success' : 'btn-danger' }} change-status-btn"data-id="{{ $todItems->id }}"data-status="{{ $todItems->status }}">{{ $todItems->status == 1 ? 'Active' : 'Inactive' }}</button></h5>
                <div class="card-body">
                    <div class="table-responsive">
                        <form role="form" id="edit_tod_form" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="modal-body">
                                <div class="me-md-3  mb-4">
                                    <label class="form-label">Title </label>
                                    <input type="text" class="form-control" name="title" value="{{$todItems->title}}" id="edit_title" required>
                                    <input type="hidden" name="tod_id" value="{{$todItems->id}}" id="tod_id">
                                </div>
                                <div class="me-md-3  mb-4">
                                    <label class="form-label">Description </label>
                                    <input type="text" class="form-control" name="description" value="{{$todItems->description}}" id="edit_description" required>
                                </div>
                                <div class="me-md-3 mb-4">
                                    <label class="form-label">Image</label>
                                    <input type="file" class="form-control" name="image" id="edit_image">
                                    <img src="{{ asset('public/front/assets/img/'.$todItems->image) }}" width="250" height="250" class="img img-responsive mt-5" id="edit_image_preview">
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button class="btn btn-primary d-grid" id="edit_tod_btn" name="action" value="submit">Update</button>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>
        <!-- / Content -->

    </div>
@endsection
@section("js")
    <script>
        //$('#domain_extension_price_table').DataTable();
        $(document).ready(function() {





            $('.change-status-btn').click(function() {
                var todId = $(this).data('id');
                var status = $(this).data('status') === 1 ? 0 : 1;
                Swal.fire({
                    title: 'Are you sure?',
                    text: 'You are about to change the status of this news item. This action cannot be undone.',
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#28a745',
                    cancelButtonColor: '#6c757d',
                    confirmButtonText: 'Confirm',
                    cancelButtonText: 'Cancel'
                }).then((result) => {
                    if (result.isConfirmed) {
                        // Perform the AJAX request to change the status
                        $.ajax({
                            url: "{{ route('admin.change-tod-status') }}",
                            type: 'POST',
                            dataType: 'json',
                            data: {
                                "_token": "{{ csrf_token() }}",
                                todId: todId,
                                status: status
                            },
                            success: function(response) {
                                if (response.status === 'success') {
                                    // Show success message
                                    Swal.fire({
                                        position: 'center',
                                        icon: 'success',
                                        text: response.message,
                                        showConfirmButton: false
                                    });
                                    setTimeout(function() {
                                        window.location = "{{route('admin.tod-section-view')}}";
                                    }, 2000);
                                } else {
                                    // Show an error message
                                    Swal.fire({
                                        position: 'center',
                                        icon: 'error',
                                        text: response.message,
                                        showConfirmButton: false
                                    });
                                }
                            },
                            error: function(xhr, status, error) {
                                // Show an error message
                                Swal.fire({
                                    position: 'center',
                                    icon: 'error',
                                    text: 'An error occurred. Please try again.',
                                    showConfirmButton: false
                                });
                            }
                        });
                    }
                });
            });

    $('.edit-tod').click(function() {
        var todId = $(this).data('id');
        $.ajax({
            url: "{{ route('admin.get-tod') }}",
            type: "POST",
            data: {
                "_token": "{{ csrf_token() }}",
                todId: todId
            },
            dataType: "json",
            success: function(response) {
                if (response.status === 'success') {
                    var tod = response.tod;
                    $('#tod_id').val(tod.id);
                    $('#edit_title').val(tod.title);
                    $('#edit_description').val(tod.description);
                    //$('#edit_image').val(tod.image);
                    $('#edit_image_preview').attr('src', "{{ asset('public/front/assets/img/') }}/" + tod.image);
                    $('#edit_tod_modal').modal('show');
                } else {
                    console.log(response.message);
                }
            },
            error: function(xhr, status, error) {
                console.log(error);
            }
        });
    });

    $('#edit_tod_form').validate({
        rules: {
            title: { maxlength:255,},
            description: { maxlength:255,},

        },
        messages: {
            title: {required: "Please enter a title."},
            description: {required: "Please enter a description."},
        },
        submitHandler:function(form){
            var formData = new FormData(form);
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url:"{{Route('admin.update-tod-section')}}",
                type:'POST',
                dataType:'json',
                data:formData,
                contentType: false,
                processData: false,
                cache: false,
                beforeSend: function(){
                    $(".loader-area").show();
                    $("#edit_tod_btn").prop('disabled',true);
                },
                success:function(res)
                {
                    if(res.status=='success'){
                        Swal.fire({
                            position: 'center',
                            icon: 'success',
                            text: res.message,
                            showConfirmButton: false,
                        });
                        window.location = "{{route('admin.tod-section-view')}}";
                    }
                    else
                    {
                        Swal.fire({
                            position: 'center',
                            icon: 'error',
                            text: res.message,
                            showConfirmButton: false,
                        });
                    }
                },
                complete: function(){
                    $("form").trigger("reset");
                    $("#edit_tod_btn").prop('disabled',false);
                },
            });
        }
    });

});
    </script>
@endsection
