<!DOCTYPE html>
<html
  lang="en"
  class="light-style customizer-hide"
  dir="ltr"
  data-theme="theme-default"
  data-assets-path="../assets/"
  data-template="vertical-menu-template-free"
>
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>Admin Login</title>
    <meta name="description" content="" />
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="{{asset('public/assets/img/favicon/favicon.ico')}}" />
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap" rel="stylesheet" />
    <!-- Icons. Uncomment required icon fonts -->
    <link rel="stylesheet" href="{{asset('public/assets/vendor/fonts/boxicons.css')}}" />
    <link rel="stylesheet" href="{{asset('resources/css/app.css')}}" />
    <!-- Core CSS -->
    <link rel="stylesheet" href="{{asset('public/assets/vendor/css/core.css')}}" class="template-customizer-core-css" />
    <link rel="stylesheet" href="{{asset('public/assets/vendor/css/theme-default.css')}}" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="{{asset('public/assets/css/demo.css')}}" />
    <!-- Vendors CSS -->
    <link rel="stylesheet" href="{{asset('public/admin/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css')}}" />
    <link rel="stylesheet" href="{{asset('public/admin/assets/vendor/css/pages/page-auth.css')}}" />
    <!-- Helpers -->
    <script src="{{asset('public/admin/assets/vendor/js/helpers.js')}}"></script>
      <script src="{{asset('public/assets/js/config.js')}}"></script>
      <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/11.6.15/sweetalert2.min.css" integrity="sha512-NvuRGlPf6cHpxQqBGnPe7fPoACpyrjhlSNeXVUY7BZAj1nNhuNpRBq3osC4yr2vswUEuHq2HtCsY2vfLNCndYA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
      <script src="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/11.6.15/sweetalert2.min.js" integrity="sha512-Z4QYNSc2DFv8LrhMEyarEP3rBkODBZT90RwUC7dYQYF29V4dfkh+8oYZHt0R6T3/KNv32/u0W6icGWUUk9V0jA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>

  </head>

  <body>

    <div class="container-xxl">
        <div class="authentication-wrapper authentication-basic container-p-y">
            <div class="authentication-inner">
                <!-- Register -->
                <div class="card">
                    <div class="card-body">
                        <!-- Logo -->
                        <div class="app-brand justify-content-center">
                            <a href="" class="app-brand-link gap-2">
                  <span class="app-brand-logo demo">
                     <img style="    height: 50px;    width: auto;" src="{{asset('public/user/assets/img/logo.png')}}">
                  </span>
                            </a>
                        </div>
                        <!-- Basic Alerts -->
                        <div class="col-md mb-4 mb-md-0">
                            <div class="card">
                                @if(Session::has('message'))
                                    <p class="alert text-dark {{ Session::get('alert-class', 'alert-danger') }}">{{ Session::get('message') }}</p>
                                @endif
                                @if ($errors->any())
                                    <div class="card-body">
                                        <ul>
                                            @foreach ($errors->all() as $error)
                                                <div class="alert alert-danger" role="alert">{{ $error }}!</div>
                                            @endforeach
                                        </ul>
                                    </div>
                                @endif
                            </div>
                        </div>
                        <br>
                        <!-- /Logo -->


                        <form role="form" id="adminloginForm" method="POST">
                            @csrf

                            <div class="mb-3">
                                <label for="email" class="form-label">Email or Username</label>
                                <input
                                    type="text"
                                    class="form-control"
                                    id="admin_login_email"
                                    name="admin_login_email"
                                    placeholder="Enter your email or username"
                                    autofocus
                                    required
                                />
                            </div>

                            <div class="mb-3 form-password-toggle">
                                <div class="d-flex justify-content-between">
                                    <label class="form-label" for="password">Password</label>
                                    <a href="{{ url('ernetdash/forgot') }}">
                                        <small>Forgot Password e?</small>
                                    </a>
                                </div>
                                <div class="input-group input-group-merge">
                                    <input
                                        type="password"
                                        id="admin_login_password"
                                        class="form-control"
                                        name="admin_login_password"
                                        placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;"
                                        aria-describedby="password"
                                        required
                                    />
                                    <span class="input-group-text cursor-pointer"><i class="bx bx-hide"></i></span>
                                </div>
                            </div>
                            <div class="mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="remember" id="remember-me" />
                                    <label class="form-check-label" for="remember-me"> Remember Me </label>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-8">

                                </div>
                                <!-- /.col -->
                                <div class="col-4">
                                    <button class="btn btn-primary btn-block" id="admin-login-btn" name="action" value="vender-Login">Login</button>
                                </div>
                                <!-- /.col -->
                            </div>
                        </form>

{{--                        <p class="text-center">--}}
{{--                            <span>New on our platform?</span>--}}
{{--                            <a href="{{route('admin.register')}}">--}}
{{--                                <span>Create an account</span>--}}
{{--                            </a>--}}
{{--                        </p>--}}
                    </div>
                </div>
                <!-- /Register -->
            </div>
        </div>
    </div>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.4/jquery.min.js"></script>
    <script src="{{asset('public/assets/vendor/libs/popper/popper.js')}}"></script>
    <script src="{{asset('public/assets/vendor/js/bootstrap.js')}}"></script>
    <script src="{{asset('public/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js')}}"></script>

    <script src="{{asset('public/assets/vendor/js/menu.js')}}"></script>
    <!-- endbuild -->

    <!-- Vendors JS -->
    <script src="{{asset('public/assets/vendor/libs/apex-charts/apexcharts.js')}}"></script>

    <!-- Main JS -->
    <script src="{{asset('public/assets/js/main.js')}}"></script>

    <!-- Page JS -->
    <script src="{{asset('public/assets/js/dashboards-analytics.js')}}"></script>
    <!-- jquery-validation -->
    <script src="{{asset('public/assets/plugins/jquery-validation/jquery.validate.min.js')}}"></script>
    <script src="{{asset('public/assets/plugins/jquery-validation/additional-methods.min.js')}}"></script>
    <!-- Place this tag in your head or just before your close body tag. -->
    <script async defer src="https://buttons.github.io/buttons.js"></script>
    <script type="text/javascript">
      $(document).ready(function()
      {
        $("#adminloginForm").validate({
              rules:
              {
                admin_login_email:{
                  required: true,
                  minlength:2
                },
                admin_login_password:{
                  required: true,
                  minlength: 5
                }
              },
              messages:
              {
                 admin_login_email:
                 {
                    required: "Please enter valid Email",
                    minlength:'Please enter valid Email'
                 },
                 admin_login_password:
                 {
                   required: "Please enter valid password",
                   minlength: "Please enter valid password"
                 }
              },
              submitHandler:function (form)
              {
                if($("#adminloginForm").valid())
                {
                   $.ajax({
                      url:"{{route('admin.login-request')}}",
                      type:'POST',
                      dataType:'json',
                      data:$("#adminloginForm").serialize(),
                      cache: false,
                      beforeSend:function()
                      {
                        //$("#admin-login-btn").prop('disabled',true);
                        $('.cs-process-loader').show();
                      },
                      success:function(data)
                      {
                        if(data.status=='success')
                        {
                          Swal.fire({
                            title: "Success!",
                            text: "You have successfully logged in",
                            icon: "success",
                            button:false
                          });
                          window.location="{{route('admin.dashboard')}}";
                        }
                        else
                        {
                          Swal.fire({
                            title: "Error!",
                            text: data.message,
                            icon: "error"
                          });
                        }
                      },
                      complete:function()
                      {
                        $("#login-btn").prop('disabled',false);
                        $('.cs-process-loader').hide();
                      }
                   });
                }
              }
          });
      });
    </script>

  </body>
</html>
