@extends('layouts.AdminLayout')
@section('content')
@php
@endphp
<!-- Content wrapper -->
<div class="container-xxl flex-grow-1 container-p-y">
  <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Tables /</span> DNS Modificatiopn</h4>
  <div class="row">
    <div class="col-md-12">
      <div class="card mb-4">
        <div class="card-header m-auto">
          <div class="col-12 my-2">
            <div class="form-check form-check-inline">
              <input class="form-check-input" type="radio" name="ernet_name_server" value="ernet_name_server" disabled>
              <label class="form-check-label">ERNET Name Server</label>
            </div>
            <div class="form-check form-check-inline">
              <input class="form-check-input" type="radio" name="ernet_name_server" value="your_name_server" checked="checked">
              <label class="form-check-label">Your Name Server</label>
            </div>
          </div>
        </div>
        <div class="card-body">
          <form role="form" id="modified_server_form" method="post">
          @csrf  
            <div class="row">
              <div class="col-6 my-2">
                <label class="form-label">Primary Name Server * </label>
                <input type="text" class="form-control" id="primary_server" name="primary_server" placeholder="Primary Name Server" value="" />
              </div>
              <div class="col-6 my-2">
                <label class="form-label">Primary Name Server 1</label>
                <input type="text" class="form-control" id="primary_server_one" name="primary_server_one" placeholder="Primary Name Server 1" value="" />
              </div>
              <div class="col-6 my-2">
                <label class="form-label">Primary Name Server 2</label>
                <input type="text" class="form-control" id="primary_server_two" name="primary_server_two" placeholder="Primary Name Server 2" value=""/>
              </div>
              <div class="col-6 my-2">
                <label class="form-label">Primary Name Server 3</label>
                <input type="text" class="form-control" id="primary_server_three" name="primary_server_three" placeholder="Primary Name Server 3" value=""/>
              </div>
              <div class="col-6 my-2">
                <label class="form-label">Primary Name Server 4</label>
                <input type="text" class="form-control" id="primary_server_four" name="primary_server_four" placeholder="Primary Name Server 4" value=""/>
              </div>
              <div class="col-6 my-2">
                <label class="form-label">Primary Name Server 5</label>
                <input type="text" class="form-control" id="primary_server_five" name="primary_server_five" placeholder="Primary Name Server 5" value="" />
              </div>
            </div>
            <h5 class="text-info mt-3">Note : Name Server cannot be same as Domain Name</h5>
            <div class="card-header m-auto p-0 my-2">
              <div class="col-12 my-2">
                <div class="form-check form-check-inline p-0">
                  <label class="form-check-label">Enable DNSSEC</label>
                </div>
                <div class="form-check form-check-inline">
                  <input class="form-check-input" type="radio" id="enable_dnsse_no" name="enable_dnsse" value="no" select>
                  <label class="form-check-label">No</label>
                </div>
                <div class="form-check form-check-inline">
                  <input class="form-check-input" type="radio" id="enable_dnsse_yes" name="enable_dnsse" value="yes">
                  <label class="form-check-label">Yes</label>
                </div>
              </div>
            </div>
            <div class="col-12 my-3" id="kripa">
              <div class="table-responsive text-nowrap">
                <table class="table table-bordered">
                  <thead>
                    <tr>
                      <th>Key Tag</th>
                      <th>Algorithm</th>
                      <th>Digest Type</th>
                      <th>Digest</th>
                    </tr>
                  </thead>
                  <tbody>
                    <div class="mb-4">
                      <button type="button" id="add" value="Add" class="btn btn-sm btn-primary add-row" />Add</td>
                    </div>
                      <tr>
                        <td><input type="text" class="form-control" name="key_tag[]" id="key_tag" value=""></td>
                        <td><input type="text" class="form-control" name="algorithm[]" id="algorithm" value=""></td>
                        <td><input type="text" class="form-control" name="sha[]" id="sha" value="" readonly="readonly"></td>
                        <td><input type="text" class="form-control" name="digest[]" id="digest" value=""></td>
                      </tr>
                  </tbody>
                </table>
              </div>
            </div>
            <div class="col-6 my-5">
                <button class="btn btn-success mr-4" id="add-server-smt-btn" name="action" value="Submit">Submit</button>
                
                <a href="{{route('admin.users-details-view')}}"> <input type="button" class="btn btn-danger ml-3" id="back" name="back" value="Back"/></a>
            </div>
          </form>
        </div>
      </div>
    </div>    
  </div>
</div>
<!-- Content wrapper -->
            
@endsection
@section("js")
<script>
  $(".add-row").click(function(){
    var markup = "<tr>\
        <td><input type='text' class='form-control' name='key_tag[]' value=''></td>\
        <td><input type='text' class='form-control' name='algorithm[]' value=''></td>\
        <td><input type='text' class='form-control' name='sha[]' value='SHA' readonly='readonly'></td>\
        <td><input type='text' class='form-control' name='digest[]' value=''></td>\
    </tr>";
    $("table tbody").append(markup);
  });

  $("#enable_dnsse_yes").attr('checked', true);
  $("#enable_dnsse_no").click(function(){
    $("#kripa").hide();
  });

  $("#enable_dnsse_yes").click(function(){
     $("#kripa").show();
  });

  $('#modified_server_form').validate({
    rules: {
      primary_server: {
        required: true,
      },
    },
    messages: {
      primary_server: {
        required: "Please fill server name",
        primary_server: "Please fill valid server name",
      },
    },

    submitHandler:function(form) 
    {
      $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
      });
      $("#add-server-smt-btn").attr("disabled", true);
      // if($("#enable_dnsse_yes").prop('checked', false)) 
      // { 
      //   $("#key_tag").remove();
      //   $("#algorithm").remove();
      //   $("#sha").remove();
      //   $("#digest").remove();      
      // }
      
      $.ajax({
        url:"{{route('user.modify-dns-server-name_data')}}",
        type:'POST',
        dataType:'json',
        data:$("#modified_server_form").serialize(),
        cache: false,
        beforeSend: function(){
            $(".loader-area").show();
        },
        success:function(res)
        {
          if(res.status=='success')
          {
            Swal.fire({
              position: 'center',
              icon: 'success',
              text: res.message,
              showConfirmButton: true,
            });
          }
          else
          {
           Swal.fire({
              position: 'center',
              icon: 'error',
              text: res.message,
              showConfirmButton: false,
            });
          }          
        },
        complete: function(){
            $("form").trigger("reset"); 
            $("#add-server-smt-btn").prop('disabled',false);
        },
      });
    }
  });

</script>
@endsection
          