@extends('layouts.AdminLayout')
@section('content')

<style>
  /* .inputmandatory{
    border:1px solid red;
  } */
</style>
<div class="content-wrapper">
  <!-- Content -->
  <div class="container-xxl flex-grow-1 container-p-y">
    <div class="card mb-4">
      <div class="card-body">
        <div class="row">
          <div class="col-md-12">
            <div class="card mb-4">
              <h5 class="card-header">Institution Details</h5>
              <div class="card-body">
                <div class="table-responsive">
                  <table class="table table-striped table-bordered">
                    <tr>
                      <th>Name of Institution:</th>
                      <td>{{$user->institute?? '' }}</td>
                    </tr>
                    <tr>
                      <th>Address:</th>
                      <td><p>{{$user_contact_details->address?? '' }},{{$user_contact_details->state?? '' }}</p></td>
                    </tr>
                    <tr>
                      <th>Phone:</th>
                      <td>{{$user_contact_details->phone?? '' }}</td>
                    </tr>
                    <tr>
                      <th>GST NO.:</th>
                      <td>{{$user_contact_details->gst_no ?? '' }}</td>
                    </tr>
                    <tr>
                      <th>Domain Period:</th>
                      <td>{{$user->domainPeriod ?? '' }} Years</td>
                    </tr>
                    <tr>
                      <th>Domain Creation Date:</th>
                      <td>{{($user->domainCreationDate)?\Carbon\Carbon::parse($user->domainCreationDate)->format('d/m/Y'): '' }}</td>
                    </tr>
                    <tr>
                      <th>Last Transaction:</th>
                      <td>{{$user->domainPrice ?? '' }}</td>
                    </tr>
                    <tr>
                      <th>Last Transaction Date:</th>
                      <td>{{\Carbon\Carbon::parse($user->updated_at)->format('d/m/Y') ?? '' }}</td>
                    </tr>
                    <tr>
                      <th>Last Update Date:</th>
                      <td>{{\Carbon\Carbon::parse($user->updated_at)->format('d/m/Y') ?? '' }}</td>
                    </tr>
                    <tr>
                      <th>Domain Expiry Date:</th>
                      <td>{{($user->domainExpiryDate)?\Carbon\Carbon::parse($user->domainExpiryDate)->format('d/m/Y'): '' }}</td>
                    </tr>
                  </table>
                </div>
              </div>
            </div>
          </div>
            @if($user_contact_details !=null)
              <div class="col-md-6">
                <div class="card mb-4">
                  <h5 class="card-header">Details of Head of Institution: </h5>
                  <div class="card-body">
                    <div class="table-responsive">
                      <table class="table table-striped table-bordered">
                        <tr>
                          <th>Name:</th>
                          <td>{{json_decode($user_contact_details->institution_head_detail)->name?? '' }}</td>
                        </tr>
                        <tr>
                          <th>Desigination:</th>
                          <td>{{json_decode($user_contact_details->institution_head_detail)->designation?? '' }}</td>
                        </tr>
                        <tr>
                          <th>Email:</th>
                          <td>{{json_decode($user_contact_details->institution_head_detail)->email?? '' }}</td>
                        </tr>
                        <tr>
                          <th>Phone:</th>
                          <td>{{json_decode($user_contact_details->institution_head_detail)->phone?? '' }}</td>
                        </tr>
                        <tr>
                          <th>Mobile:</th>
                          <td>{{json_decode($user_contact_details->institution_head_detail)->mobile?? '' }}</td>
                        </tr>
                      </table>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-md-6">
                <div class="card mb-4">
                  <h5 class="card-header">Administrative Contact Details</h5>
                  <div class="card-body">
                    <div class="table-responsive">
                      <table class="table table-striped table-bordered">
                          <tr>
                              <th>Name:</th>
                              <td>{{json_decode($user_contact_details->administrative_detail)->name?? '' }}</td>
                          </tr>
                          <tr>
                              <th>Desigination:</th>
                              <td>{{json_decode($user_contact_details->administrative_detail)->designation?? '' }}</td>
                          </tr>
                          <tr>
                              <th>Email:</th>
                              <td>{{json_decode($user_contact_details->administrative_detail)->email?? '' }}</td>
                          </tr>
                          <tr>
                              <th>Phone:</th>
                              <td>{{json_decode($user_contact_details->administrative_detail)->phone?? '' }}</td>
                          </tr>
                          <tr>
                              <th>Mobile:</th>
                              <td>{{json_decode($user_contact_details->administrative_detail)->mobile?? '' }}</td>
                          </tr>
                      </table>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-md-6">
                <div class="card mb-4">
                  <h5 class="card-header">Billing Contact Details :</h5>
                  <div class="card-body">
                    <div class="table-responsive">
                      <table class="table table-striped table-bordered">
                          <tr>
                              <th>Name:</th>
                              <td>{{json_decode($user_contact_details->billing_contact_detail)->name?? '' }}</td>
                          </tr>
                          <tr>
                              <th>Desigination:</th>
                              <td>{{json_decode($user_contact_details->billing_contact_detail)->designation?? '' }}</td>
                          </tr>
                          <tr>
                              <th>Email:</th>
                              <td>{{json_decode($user_contact_details->billing_contact_detail)->email?? '' }}</td>
                          </tr>
                          <tr>
                              <th>Phone:</th>
                              <td>{{json_decode($user_contact_details->billing_contact_detail)->phone?? '' }}</td>
                          </tr>
                          <tr>
                              <th>Mobile:</th>
                              <td>{{json_decode($user_contact_details->billing_contact_detail)->mobile?? '' }}</td>
                          </tr>
                      </table>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-md-6">
                <div class="card mb-4">
                  <h5 class="card-header">Technical Contact Details</h5>
                  <div class="card-body">
                    <div class="table-responsive">
                      <table class="table table-striped table-bordered">
                          <tr>
                              <th>Name:</th>
                              <td>{{json_decode($user_contact_details->technical_detail)->name?? '' }}</td>
                          </tr>
                          <tr>
                              <th>Desigination:</th>
                              <td>{{json_decode($user_contact_details->technical_detail)->designation?? '' }}</td>
                          </tr>
                          <tr>
                              <th>Email:</th>
                              <td>{{json_decode($user_contact_details->technical_detail)->email?? '' }}</td>
                          </tr>
                          <tr>
                              <th>Phone:</th>
                              <td>{{json_decode($user_contact_details->technical_detail)->phone?? '' }}</td>
                          </tr>
                          <tr>
                              <th>Mobile:</th>
                              <td>{{json_decode($user_contact_details->technical_detail)->mobile?? '' }}</td>
                          </tr>
                      </table>
                    </div>
                  </div>
                </div>
              </div>
            @endif
          <div class="col-md-6">
            <div class="card mb-4">
              <h5 class="card-header">Payment Details</h5>
              <div class="card-body">
                <div class="table-responsive">
                  <table class="table table-striped table-bordered">
                    <tr>
                      <th>Transaction ID :</th>
                      <td>YHGFRS45826552</td>
                    </tr>
                    <tr>
                      <th>Added Date:</th>
                      <td>19-04-2023</td>
                    </tr>
                    <tr>
                      <th>Amount : </th>
                      <td><span>&#8377; </span>5684</td>
                    </tr>
                    <tr>
                      <th>Payment Invoice : </th>
                      <td><a href="" download="" title="download payment invoice">Click here to see invoice</a></td>
                    </tr>
                    <tr>
                      <th>Renew Domain : </th>
                      <td><a href="#" title="Renew Domain" data-bs-toggle="modal" data-bs-target="#renew_domain_modal">Renew Domain</a></td>
                    </tr>
                  </table>
                </div>
              </div>
            </div>
          </div>
          <div class="col-md-6">
            <div class="card mb-4">
              <div class="d-flex">
                <h5 class="card-header">Name Server Details</h5>
                <h5 class="card-header">
                  <a href="{{($user_name_server != null)?url('ernetdash/user-dns-edit'.'/'.$user_name_server->id):''}}" title="click to update name server">
                    <i class="fa fa-edit text-info fs-3 me-md-3"></i>
                  </a>
                </h5>
              </div>
              <div class="card-body">
                <div class="table-responsive">
                  <table class="table table-striped table-bordered">
                      <li class="list-group-item ">Primary Server : {{$user_name_server->primary_name_server?? '' }}</li>

                    <tr>
                      <th>Primary Name Server :</th>
                      <td>{{$user_name_server->primary_name_server ?? ''  }}</td>
                    </tr>
                      <tr>
                          <th>Secondary Name Server 1 :</th>
                          <td>{{$user_name_server->secondary_name_server1 ?? ''  }}</td>
                      </tr>
                      <tr>
                          <th>Secondary Name Server 2 :</th>
                          <td>{{$user_name_server->secondary_name_server2 ?? ''  }}</td>
                      </tr>
                      <tr>
                          <th>Secondary Name Server 3 :</th>
                          <td>{{$user_name_server->secondary_name_server3 ?? ''  }}</td>
                      </tr>

                      <tr>
                          <th>Secondary Name Server 4 :</th>
                          <td>{{$user_name_server->secondary_name_server4 ?? ''  }}</td>
                      </tr>

                      <tr>
                          <th>Secondary Name Server 5 :</th>
                          <td>{{$user_name_server->secondary_name_server5 ?? ''  }}</td>
                      </tr>


                  </table>
                </div>
              </div>
            </div>
          </div>
          <div class="col-md-12">
            <div class="card mb-4">
              <div class="d-flex">
                <h5 class="card-header">Uploaded Documents Verification</h5>
                <h5 class="mt-4">
                  <!-- <i class="fa fa-edit text-info fs-3 delete-domain-Category" title="Update Uploaded Documents" data-bs-toggle="modal" data-bs-target="#update_uploades_documents_modal"></i> -->
                </h5>
              </div>
              <div class="card-body">
                <div class="table-responsive">

                <form method="post" id="departmentForm">
                  {!! csrf_field() !!}
                  <table class="table table-striped table-bordered">
                    <thead>
                      <tr>
                        <th>File Name</th>
                        <th>File Link</th>
                        <th>Documents Verification</th>
                        <th>Remarks</th>
                      </tr>
                    </thead>
                    <tbody>

                        @foreach($userdocuments as $userdoc)
                      <tr>
                        <td>{{$userdoc->title?? '' }}</td>
                            <td><a href="{{url('public/user/docs')?? '' }}/{{$userdoc->path?? '' }}" target="_blank">View Document</a></td>
                            <td class="@if($userdoc->status==0) text-danger @else text-success font-weight-bold @endif">
                                @if($userdoc->status==1)
                                        <input type="hidden" name="id[]" id="id" value="{{$userdoc->id?? '' }}"/>

                                          <select class="status form-control " name="status[]" data-id="{{$userdoc->id?? '' }}" id="status{{$userdoc->id?? '' }}" oninvalid="this.setCustomValidity('Kindly select appropriate action')" oninput="setCustomValidity('')" required>
                                            <option value="">Select</option>
                                            <option value="2">Approved</option>
                                            <option value="0">Clarification Required</option>
                                          </select>
                                        @else
                                <?php $stat=$userdoc->status==0 ? "Clarification Required" :"Approved"; ?>
                                    {{$stat?? '' }}
                                    @endif
                            </td>
                        <td>
                        @if($userdoc->status==1)
                        <input type="text" name="remarks[]" id="remarks{{$userdoc->id?? '' }}" class="form-control d-none" placeholder="" value="">
                        @else
                        {{$userdoc->remarks?? '' }}
                        @endif
                        </td>

                      </tr>
                    @endforeach

                    </tbody>
                  </table>
                    @if($is_approved == 0)
                        <button type="submit" class="mt-3 btn btn-primary submit"  style="float:right">Submit</button>
                    @endif


                </form>
                </div>
              </div>
            </div>
              @if($is_approved == 2)
                  <form id="RegisterDomain" method="post" action="">
                      @csrf
                      <input type="hidden" name="user_id" value="{{$user->id}}">
                      <button type="submit" class="mt-3 btn btn-success mx-5"  style="float:right" >Register Domain</button>
                  </form>
              @endif
          </div>
        </div>
      </div>


    </div>
  </div>
  <!-- / Content -->

</div>
@endsection
@section("js")
<script>
$(document).ready(function() {

  $('body').on('submit', '#departmentForm', function(e) {
        $(".inputmandatory").css("border","1px solid red");
        e.preventDefault();
				var current = $(this);
          $('.submit', current).attr('disabled', 'disabled');

          $('.required_remark').each(function(i, obj) {
              if ($(this).val().length == 0){
                  Swal.fire({
                      icon: 'error',
                      text: 'Remarks are mandatory',
                      showConfirmButton: true,
                  }).then(function() {
                      return false;
                  });
              }
          });

      Swal.fire({
          title: "Loading...",
          html: "Please wait a moment"
      })
      Swal.showLoading();

          var data = current.serialize();

          $.ajax({
              url: "{{route('admin.docupdate')?? '' }}",
              dataType : "json",
              type: "post",
              data : data,
              success : function(response) {
                  $('#loading-image').hide();
                  $('.submit').removeAttr('disabled');

                  if(response.status == 'success') {
                      Swal.fire({
                          icon: 'success',
                          text: 'Documents Verification details submitted successfully.',
                          showConfirmButton: true,
                         }).then(function() {
                          window.location.reload();
                      });

                  } else if(response.status == 'errors') {

                      $.each(response.message, function(i, message) {
                          $('#'+i).after('<span class="Description_error" style="color:red">'+message+'</span>');
                      });

                  } else if(response.status == 'error') {
                      $('#name').after('<span class="Description_error" style="color:red">'+response.error+'</span>');
                  }
                  else if(response.status == false)
                  {
                      Swal.fire({
                          icon: 'error',
                          text: 'Remarks are mandatory',
                          showConfirmButton: true,
                      });
                  }
              },
          });
  });

      $('body').on('change', '.status', function() {
          $data = $(this).attr("data-id");
          if($(this).val() == 0){
              $('#remarks'+$data).removeClass('d-none');
              // $('#remarks'+$data).addClass('inputmandatory');
              $('#remarks'+$data).addClass('required_remark');
              $('#remarks'+$data).prop('required',true);
          }else {
              $('#remarks'+$data).addClass('d-none');
              // $('#remarks'+$data).removeClass('inputmandatory');
              $('#remarks'+$data).removeClass('required_remark');
              $('#remarks'+$data).prop('required',false);
          }

      });

    $('body').on('submit', '#RegisterDomain', function(e) {
        e.preventDefault();

        var current = $(this);
        $('.submit', current).attr('disabled', 'disabled');
        Swal.fire({
            title: "Registering Domain...",
            html: "Please wait , it will take some time"
        })
        Swal.showLoading();
        var data = current.serialize();
        $.ajax({
            url: "{{route('registerUserDomain')}}",
            dataType : "json",
            type: "post",
            data : data,
            success : function(response) {
                $('.submit').removeAttr('disabled');

                if(response.status == true) {
                    Swal.fire({
                        icon: 'success',
                        text: response.msg,
                        showConfirmButton: true,
                    }).then(function() {
                        window.location.reload();
                    });

                } else if(response.status == false)
                {
                    Swal.fire({
                        icon: 'error',
                        text: response.msg,
                        showConfirmButton: true,
                    });
                }
            },
        });
    });
});
</script>
@endsection
