@extends('layouts.AdminLayout')
@section('content')

<div class="content-wrapper">
  <!-- Content -->
  <div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light"></span>Admin User</h4>
    <div class="card mb-4">
      <div class="card-body">
        <form role="form" id="add_admin_user_form" method="POST">
        @csrf
          <div class="row">
            <div class="col-md-4 mb-3">
              <label class="form-label">Name <span>*</span></label>
              <input type="text" class="form-control" name="add_name" id="add_name" maxlength="35">
            </div>
            <div class="col-md-4 mb-3">
              <label class="form-label">User Name <span>*</span></label>
              <input type="text" class="form-control" name="add_user_name" id="add_user_name" maxlength="35">
            </div>
            <div class="col-md-4 mb-3">
              <label class="form-label">Password <span>*</span></label>
              <input type="password" class="form-control" name="add_user_password" id="add_user_password">
              <div id="pswd_info" style="display: none;">
               <ul>
               <li id="specialChars" class="invalid">At least <strong>one special characters</strong></li>
               <li id="letter" class="invalid">At least <strong>one letter</strong></li>
               <li id="capital" class="invalid">At least <strong>one capital letter</strong></li>
               <li id="number" class="invalid">At least <strong>one number</strong></li>
               <li id="length" class="invalid">Be at least <strong>8 characters</strong></li>
               <li id="maxlength" class="invalid">Not more than <strong>16 characters</strong></li>
               </ul>
              </div>
            </div>
            <div class="col-md-4 mb-3">
              <label class="form-label">Email <span>*</span></label>
              <input type="email" class="form-control" name="add_user_email" id="add_user_email"  maxlength="35">
            </div>
            <div class="col-md-4 mb-3">
              <label class="form-label">Role <span>*</span></label>
              <select class="form-control"  name="add_user_role" id="add_user_role" >
                <option value="">Choose Role</option>
                <option value="1">Accountant</option>
                <option value="1">Director</option>
                <option value="1">Engineer</option>
                @foreach($get_admin_privilege_data as $get_admin_privilege)
                <option value="{{$get_admin_privilege->roal}}">{{ucfirst(str_replace("_", " ", $get_admin_privilege->roal))}}</option>
                @endforeach
              </select>
            </div>
            <div class="col-md-4 mb-3">
              <label class="form-label">Status <span>*</span></label>
              <select class="form-control"  name="add_user_status" id="add_user_status" >
                <option value="">Choose Status</option>
                <option value="active">Active</option>
                <option value="inactive">In-active</option>
              </select>
            </div>
          </div>
          <div class="my-3">
            <button class="btn btn-success d-grid float-end" id="add_admin_user_btn" name="action" value="submit">Submit</button>
          </div>
        </form>
      </div>
    </div>
    <div class="card mb-4">
      <h5 class="card-header">Admin User Details</h5>
      <div class="card-body">
        <div class="table-responsive">
          <table class="table table-striped table-bordered">
            <thead>
              <tr>
                <th>Name</th>
                <th>User Name</th>
                <th>Email</th>
                <th>Role</th>
                <th>Status</th>
                <th>Action</th>
              </tr>
            </thead>
            <tbody>
              @foreach($admin_user_list_data as $admin_user_list)
              <tr>
                <td>{{$admin_user_list->name}}</td>
                <td>{{$admin_user_list->user_name}}</td>
                <td>{{$admin_user_list->email}}</td>
                <td>{{$admin_user_list->roal}}</td>
                <td>
                  <i class="fa fa-edit text-info fs-3 me-md-3 kp-edit-user" data-id="{{$admin_user_list->id}}" data-bs-toggle="modal" data-bs-target="#update_Category_list_modal"></i>
                  <i class="fa fa-trash text-danger fs-3 delete-domain-Category" data-id="{{$admin_user_list->id}}"></i>
                </td>
              </tr>
              @endforeach
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
  <!-- / Content -->
  <!-- Modal -->
  <div class="modal fade update-Category-list" id="update_Category_list_modal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="staticBackdropLabel">Update Admin User</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <form role="form" id="update_admin_user_form" method="POST">
        @csrf
        <div class="modal-body">
          <div class="me-md-3  mb-4">
            <label class="form-label">Name <span>*</span></label>
            <input type="text" class="form-control" name="update_name" id="update_name">
            <input type="hidden" name="update_user_id" id="update_user_id" value="">
          </div>
          <div class="me-md-3  mb-4">
            <label class="form-label">User Name <span>*</span></label>
            <input type="text" class="form-control" name="update_user_name" id="update_user_name">
          </div>
          <div class="me-md-3 mb-4">
            <label class="form-label">Email <span>*</span></label>
            <input type="email" class="form-control" name="update_user_email" id="update_user_email">
          </div>
          <div class="me-md-3  mb-4">
            <label class="form-label">Role <span>*</span></label>
            <select class="form-control"  name="update_user_role" id="update_user_role" >
              <option value="">Choose Role</option>
              @foreach($get_admin_privilege_data as $get_admin_privilege)
              <option value="{{$get_admin_privilege->roal}}">{{ucfirst(str_replace("_", " ", $get_admin_privilege->roal))}}</option>
              @endforeach
            </select>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
           <button class="btn btn-primary d-grid" id="update_admin_user_btn" name="action" value="submit">Update</button>
        </div>
        </form>
      </div>
    </div>
  </div>
</div>
@endsection
@section("js")
<script>
$(document).ready(function() {
  $('#add_user_password').keyup(function() {
    var pswd = $(this).val();
    if ( pswd.match(/[^!,%,&,@,#,$,^,*,?,_,~,g]/))
    {
      $('#specialChars').removeClass('invalid').addClass('valid');
    }
    else
    {
      $('#specialChars').removeClass('valid').addClass('invalid');
    }
    if ( pswd.match(/[A-z]/) )
    {
      $('#letter').removeClass('invalid').addClass('valid');
    }
    else
    {
      $('#letter').removeClass('valid').addClass('invalid');
    }
    if ( pswd.match(/[A-Z]/) )
    {
      $('#capital').removeClass('invalid').addClass('valid');
    }
    else
    {
      $('#capital').removeClass('valid').addClass('invalid');
    }
    if ( pswd.match(/\d/) )
    {
      $('#number').removeClass('invalid').addClass('valid');
    }
    else
    {
      $('#number').removeClass('valid').addClass('invalid');
    }

    if ( pswd.length < 8 )
    {
      $('#length').removeClass('valid').addClass('invalid');
    }
    else
    {
      $('#length').removeClass('invalid').addClass('valid');
    }
    if ( pswd.length > 16 )
    {
      $('#maxlength').removeClass('valid').addClass('invalid');
    }
    else
    {
      $('#maxlength').removeClass('invalid').addClass('valid');
    }
  }).focus(function() {
     $('#pswd_info').show();
    }).blur(function() {
     $('#pswd_info').hide();
    });

  $('#add_admin_user_form').validate({
    rules: {
      add_name: {required: true, maxlength:35,},
      add_user_name: {required: true,},
      add_user_password: {required: true, maxlength:16,minlength:8,},
      add_user_email: {required: true, maxlength:35,},
      add_user_role: {required: true,},
    },
    messages:
    {
      add_name:{required: "Please enter your name", maxlength:"Not more than 35 character"},
      add_user_name:{required: "Please enter User Name",},
      add_user_password:{required: "Please enter your password", maxlength:"Not more than 16 character", minlength:'At list 8 character'},
      add_user_email:{required: "Please enter your email", maxlength:"Not more than 35 character",},
      add_user_role:{required: "Please choose role"},
    },
    submitHandler:function(form)
    {
      $.ajaxSetup({
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
      });
      $.ajax({
       url:"{{Route('admin.admin-user')}}",
        type:'POST',
        dataType:'json',
        data:$("#add_admin_user_form").serialize(),
        cache: false,
        beforeSend: function(){
          $(".loader-area").show();
        },
        success:function(res)
        {
          if(res.status=='success')
          {
            Swal.fire({
              position: 'center',
              icon: 'success',
              text: res.message,
              showConfirmButton: false,
            });
          }
          else
          {
           Swal.fire({
              position: 'center',
              icon: 'error',
              text: res.message,
              showConfirmButton: false,
            });
          }
        },
        complete: function(){
        $("form").trigger("reset");
        $("#add_admin_user_btn").prop('disabled',false);
        },
      });
    }
  });

  $('.kp-edit-user').click(function(){
    var privilege_id = $(this).attr('data-id');
    $.ajaxSetup({
      headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      }
    });
    $.ajax({
        url:"{{Route('admin.get-user-privilege')}}",
        type:'POST',
        dataType:'json',
        data:{privilege_id:privilege_id},
        cache: false,
        beforeSend: function(){
          $("#update_admin_user_btn").prop('disabled',true);
          $(".loader-area").show();
          $(".update-Category-list").modal('hide');
        },
        success:function(res)
        {
          if(res.status=='success')
          {
            var privilege = res.message.privilege;
            $('#update_user_id').attr('value',privilege.id);
            $('#update_name').attr('value',privilege.name);
            $('#update_user_name').attr('value',privilege.user_name);
            $('#update_user_email').attr('value',privilege.email);
            $('#update_user_role').attr('value',privilege.roal);
            $(".update-Category-list").modal('show');
          }
          else
          {
           Swal.fire({
              position: 'center',
              icon: 'error',
              text: res.message,
              showConfirmButton: false,
            });
          }
        },
        complete: function(){
          $("form").trigger("reset");
          $("#update_admin_user_btn").prop('disabled',false);
        },
      });
  });

  $('#update_admin_user_form').validate({
    rules: {
      update_add_name: { maxlength:35,},
      update_user_name: {maxlength:35,},
      update_user_password: { maxlength:16,minlength:8,},
      update_user_email: { maxlength:35,},
      update_user_role: {required:true,},
    },
    messages:
    {
      update_add_name:{maxlength:"Not more than 35 character"},
      update_user_name:{maxlength:"Not more than 35 character"},
      update_user_password:{maxlength:"Not more than 16 character", minlength:'At list 8 character'},
      update_user_email:{maxlength:"Not more than 35 character",},
      update_user_role:{required: "Please choose role"},
    },
    submitHandler:function(form)
    {
      $.ajaxSetup({
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
      });
      $.ajax({
        url:"{{Route('admin.update-user-privilege')}}",
        type:'POST',
        dataType:'json',
        data:$("#update_admin_user_form").serialize(),
        cache: false,
        beforeSend: function(){
          $(".loader-area").show();
        },
        success:function(res)
        {
          if(res.status=='success')
          {
            $(".update-Category-list").modal('hide');
            Swal.fire({
              position: 'center',
              icon: 'success',
              text: res.message,
              showConfirmButton: false,
            });
          }
          else
          {
           Swal.fire({
              position: 'center',
              icon: 'error',
              text: res.message,
              showConfirmButton: false,
            });
          }
        },
        complete: function(){
          $("form").trigger("reset");
          $("#update_admin_user_btn").prop('disabled',false);
        },
      });
    }
  });

  $('.delete-domain-Category').click(function(){
    Swal.fire({
      title: 'Are you sure?',
      text: "You won't be able to revert this!",
      icon: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      confirmButtonText: 'Yes, delete it!'
    }).then((result) => {
      if (result.isConfirmed)
      {
        var privilege_id = $(this).attr('data-id');
        alert(privilege_id);
        $.ajaxSetup({
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });
        $.ajax({
          url:"{{Route('admin.delete-user-privilege')}}",
          type:'POST',
          dataType:'json',
          data:{privilege_id:privilege_id},
          cache: false,
          beforeSend: function(){
            $(".loader-area").show();
          },
          success:function(res)
          {
            if(res.status=='success')
            {
              Swal.fire(
                'Deleted!',
                'Your file has been deleted.',
                'success'
              )
            }
            else
            {
             Swal.fire({
                position: 'center',
                icon: 'error',
                text: res.message,
                showConfirmButton: false,
              });
            }
          },
          complete: function(){
            $("form").trigger("reset");
            $("#update_price_setting_btn").prop('disabled',false);
          },
        });
        }
    });
  });

});
</script>
@endsection
