@extends('layouts.AdminLayout')
@section('content')

<div class="content-wrapper">
  <!-- Content -->
  {{-- @php
  echo '<pre>';
  @endphp --}}

  <?php

        $domain_extension_add=false;

        $user_id=1;

        if($user_id==1){
          $domain_extension_add=true;
        }else{

    $permission = getUserHasRoleProgram($user_id,2);
                if($permission->add_priv == 1)
                {
                    $domain_extension_add = true;
                }


        }



  ?>
  <div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light"></span>Domain extension</h4>
    <div class="card mb-4">
      <div class="card-body">
        <form role="form" id="add_domain_extension_form" method="POST">
        @csrf
          <div class="row">
            <div class="col-md-3">
              <label class="form-label text-capitalize fs-6 text-dark">Choose Main extension <span class="text-danger">*</span></label>
              <select class="form-control"  name="main_category" id="main_extension" >
                <option value="">Select Domain extension</option>
                @foreach($get_domain_main_data as $get_domain_main)
                    <option value="{{$get_domain_main->id}}">{{$get_domain_main->domain_category_name}}</option>
                @endforeach
              </select>
            </div>
            <div class="col-md-3">
              <label class="form-label text-capitalize fs-6">Choose Languages <span class="text-danger">*</span></label>
              <select class="form-control"  name="regional_languages" id="regional_languages" >
                <option value="">All Languages</option>
                @foreach($get_domain_languages_data as $get_domain_languages)
                <option value="{{$get_domain_languages->id}}">{{$get_domain_languages->language_name}}</option>
                @endforeach
              </select>
            </div>
            <div class="col-md-3">
              <label class="form-label text-capitalize fs-6"> Domain Extensions <span class="text-danger">*</span></label>
              <input type="text" class="form-control"  name="domain_extensions" id="domain_extensions" placeholder=" Domain Extensions" value="" />
            </div>
            <div class="col-md-3">
              <label class="form-label">Is Active <span class="text-danger">*</span></label>
              <select class="form-control"  name="domain_status" id="domain_status" >
                <option value="Active">Active</option>
                <option value="In-Active">In-Active</option>
              </select>
            </div>
          </div>
          <div class="my-3">
            <button class="btn btn-success d-grid float-end" id="add_domain_extension_btn" name="action" value="submit" @if($domain_extension_add==false) disabled @endif>Submit</button>
          </div>
        </form>
      </div>
    </div>

    <div class="card mb-4">
      <h5 class="card-header">extension List</h5>
      <div class="card-body">
        <div class="table-responsive">
          <table class="table cell-borde" id="domain_extension_table">
            <thead>
              <tr>
{{--                <th class="text-capitalize fs-6">Main extension</th>--}}
{{--                <th class="text-capitalize fs-6">Languages</th>--}}
                <th class="text-capitalize fs-6">Domain Extensions </th>
                <th class="text-capitalize fs-6">Is Active</th>
                <th class="text-capitalize fs-6">Action</th>
              </tr>
            </thead>
            <tbody>
              @foreach($domain_extension_data as $domain_extension)
              <tr>
{{--                <td>{{get_domain_main_extension_name($domain_extension->domain_main_extension_id)}}</td>--}}
{{--                <td>{{get_languages_name($domain_extension->language_id)}}</td>--}}
                <td>{{$domain_extension->domain_extension}}</td>
                <td>{{ucfirst($domain_extension->status)}}</td>
                <td>
                  <i class="fa fa-edit text-info fs-3 me-md-3 get-domain-extension-data" data-id={{$domain_extension->id}} data-bs-toggle="modal" data-bs-target="#update_extension_list_modal"></i>
                  <i class="fa fa-trash text-danger fs-3 delete-domain-extension" data-id="{{$domain_extension->id}}"></i>
                </td>
              </tr>
              @endforeach
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
  <!-- / Content -->

  <!-- Modal -->
  <div class="modal fade" id="update_extension_list_modal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="staticBackdropLabel">Update Domain extension</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <form role="form" id="update_domain_extension_form" method="POST">
        @csrf
            <input type="hidden" value="" name="ext_id" id="update_ext_id">
        <div class="modal-body">
          <div class="me-md-3  mb-4">
            <label class="form-label text-capitalize fs-6">Choose Main extension <span class="text-danger">*</span></label>
            <select class="form-control"  name="main_category" id="update_domain_category" required>
                <option value="">Select Domain extension</option>

              </select>
          </div>
          <div class="me-md-3 mb-4">
            <label class="form-label text-capitalize fs-6">Choose Languages <span class="text-danger">*</span></label>
            <select class="form-control"  name="regional_languages" id="update_regional_languages" required>
              <option value="">All Languages</option>

            </select>
          </div>
          <div class="me-md-3  mb-4">
            <label class="form-label text-capitalize fs-6"> Domain Extensions <span class="text-danger">*</span></label>
            <input type="text" class="form-control"  name="domain_extensions" id="update_domain_extensions" placeholder=" Domain Extensions" value="" required/>
          </div>
          <div class="me-md-3  mb-4">
            <label class="form-label text-capitalize fs-6">Domain Status <span class="text-danger">*</span></label>
            <select class="form-control update_domain_status"  name="domain_status" id="update_domain_status" required >
              <option value="Active">Active</option>
              <option value="In-active">In-active</option>
            </select>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
           <button class="btn btn-primary d-grid" id="update_domain_extension_btn" name="action" value="submit">Update</button>
        </div>
        </form>
      </div>
    </div>
  </div>

</div>
@endsection
@section("js")
<script>
  $('#domain_extension_table').DataTable();

  $('#add_domain_extension_form').validate({
    rules: {
      main_extension: {required: true,},
      regional_languages: {required: true,},
      domain_extensions: {required: true,},
      domain_status: {required: true,},
    },
    messages:
    {
      main_extension:{required: "Please choose domain extension",},
      regional_languages:{required: "Please choose regional languages",},
      domain_extensions:{required: "Please enter domain extensions",},
      domain_status:{required: "Please choose domain status",},
    },
    submitHandler:function(form)
    {
      $.ajaxSetup({
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
      });
      $.ajax({
        url:"{{Route('admin.add-domain-extension')}}",
        type:'POST',
        dataType:'json',
        data:$("#add_domain_extension_form").serialize(),
        cache: false,
        beforeSend: function(){
          $(".loader-area").show();
        },
        success:function(res)
        {
          if(res.status=='success')
          {
            Swal.fire({
              position: 'center',
              icon: 'success',
              text: res.message,
              showConfirmButton: false,
            });
            window.location = "{{route('admin.domain-extension-view')}}";
          }
          else
          {
            Swal.fire({
            position: 'center',
            icon: 'error',
            text: res.message,
            showConfirmButton: false,
            });
          }
        },
        complete: function(){
          $("form").trigger("reset");
          $("#add_domain_extension_btn").prop('disabled',false);
        },
      });
    }
  });

  $('#update_domain_extension_form').validate({
      rules: {
          main_extension: {required: true,},
          regional_languages: {required: true,},
          domain_extensions: {required: true,},
          domain_status: {required: true,},
      },
      messages:
          {
              main_extension:{required: "Please choose domain extension",},
              regional_languages:{required: "Please choose regional languages",},
              domain_extensions:{required: "Please enter domain extensions",},
              domain_status:{required: "Please choose domain status",},
          },
      submitHandler:function(form)
      {
          $.ajaxSetup({
              headers: {
                  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
              }
          });
          $.ajax({
              url:"{{Route('admin.add-domain-extension')}}",
              type:'POST',
              dataType:'json',
              data:$("#update_domain_extension_form").serialize(),
              cache: false,
              beforeSend: function(){
                  $(".loader-area").show();
              },
              success:function(res)
              {
                  if(res.status=='success')
                  {
                      Swal.fire({
                          position: 'center',
                          icon: 'success',
                          text: res.message,
                          showConfirmButton: false,
                      });
                      window.location = "{{route('admin.domain-extension-view')}}";
                  }
                  else
                  {
                      Swal.fire({
                          position: 'center',
                          icon: 'error',
                          text: res.message,
                          showConfirmButton: false,
                      });
                  }
              },
              complete: function(){
                  $("form").trigger("reset");
                  $("#add_domain_extension_btn").prop('disabled',false);
              },
          });
      }
  });
  $(".get-domain-extension-data").click(function(){
    var main_extension_id = $(this).attr("data-id");
    $.ajaxSetup({
      headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      }
    });
    $.ajax({
      url:"{{Route('admin.get-domain-extension-data')}}",
      type:'POST',
      dataType:'json',
      data:{id:main_extension_id},
      cache: false,
      beforeSend: function(){
        $(".loader-area").show();
      },
      success:function(res)
      {

        if(res.status=='success')
        {
            $('#update_ext_id').val(res.message.id);
            $('#update_domain_category').empty();
            $('#update_regional_languages').empty();
            $.each(res.message.domain_main_category_list, function( index, value ) {
                if (res.message.domain_main_category_id ==value.id){
                    $('#update_domain_category').append('<option value="'+value.id+'" selected>'+value.domain_category_name+'</option>');
                }else {
                    $('#update_domain_category').append('<option value="'+value.id+'">'+value.domain_category_name+'</option>');
                }
            });
            $.each(res.message.domain_languages_list, function( index1, value1 ) {
                if (res.message.domain_language_id ==value1.id){
                    $('#update_regional_languages').append('<option value="'+value1.id+'" selected>'+value1.language_name+'</option>');
                }else {
                    $('#update_regional_languages').append('<option value="'+value1.id+'">'+value1.language_name+'</option>');

                }
            });
          // $('#update_domain_category option[value='+res.message.domain_main_category_id+']').prop("selected", true);'+if(res.message.domain_language_id) 'selected'+'
          // $('#update_domain_category').val(res.message.domain_main_category_id);
          // $('#update_domain_category').append('<option value="'+res.message.domain_main_category_id+'" selected>'+res.message.domain_main_category_id+'</option>');
          $('#update_domain_extensions').attr('value',res.message.domain_extension);
          $("#update_extension_list_modal").modal('show');
        }
        else
        {
          Swal.fire({
            position: 'center',
            icon: 'error',
            text: res.message,
            showConfirmButton: false,
          });
        }
      },
      complete: function(){
        $("form").trigger("reset");
        $("#update_domain_extension_btn").prop('disabled',false);
      },
    });
  });
  $('.delete-domain-extension').click(function(){
    Swal.fire({
      title: 'Are you sure?',
      text: "You won't be able to revert this!",
      icon: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      confirmButtonText: 'Yes, delete it!'
    }).then((result) => {
      if (result.isConfirmed)
      {
        var domain_cat_id = $(this).attr('data-id');
        $.ajaxSetup({
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });
        $.ajax({
          url:"{{Route('admin.delete-domain-extension-data')}}",
          type:'POST',
          dataType:'json',
          data:{domain_cat_id:domain_cat_id},
          cache: false,
          beforeSend: function(){
            $(".loader-area").show();
          },
          success:function(res)
          {
            if(res.status=='success')
            {
              Swal.fire(
                'Deleted!',
                'Your file has been deleted.',
                'success'
              )
                window.location = "{{route('admin.domain-extension-view')}}";
            }
            else
            {
             Swal.fire({
                position: 'center',
                icon: 'error',
                text: res.message,
                showConfirmButton: false,
              });
            }
          },
          complete: function(){
            $("form").trigger("reset");
            $("#update_price_setting_btn").prop('disabled',false);
          },
        });
      }
    });
  });
</script>
@endsection
