@extends('layouts.AdminLayout')
@section('content')

    <style>
        /* .inputmandatory{
                                                                                                                border:1px solid red;
                                                                                                              } */
        .card-header {
            font-weight: 600;
        }

        .table:not(.table-dark) th {
            color: #000000 !important;
        }
    </style>
    <div class="content-wrapper">
        <div class="container-xxl flex-grow-1 container-p-y">
            <div class="card mb-4">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="card mb-4">
                                <h5 class="card-header" style="font-size: 25px;">{{ $user_data->domainName ?? '' }}</h5>
                                <h5 class="card-header">Institution Details
                                </h5>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-striped table-bordered">
                                            <tr>
                                                <th>Name of Institution:</th>
                                                <td>{{ $user_data->institute ?? '' }}</td>
                                            </tr>
                                            <tr>
                                                <th style="color:black;">Address:</th>
                                                <td>
                                                    <p>{{ $user_contact_details->address ?? '' }},{{ $user_contact_details->state ?? '' }}
                                                    </p>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th style="color:black;">Phone:</th>
                                                <td>
                                                    @if ($user_contact_details != null)
                                                        @if (isset($user_contact_details->prefix_phone))
                                                            0{{ $user_contact_details->prefix_phone ?? '' }}-{{ $user_contact_details->phone ?? '' }}
                                                        @else
                                                            N.A
                                                        @endif
                                                    @endif
                                                </td>
                                            </tr>

                                            <tr>
                                                <th style="color:black;">Email:</th>
                                                <td>{{ $user_data->email ?? 'N.A' }}</td>
                                            </tr>

                                            <tr>
                                                <th style="color:black;">GST NO.:</th>
                                                <td>{{ $user_contact_details->gst_no ?? 'N.A' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Domain Name:</th>
                                                <td>{{ $user_data->domainName ?? '' }} &nbsp;
                                                    {{-- @if ($user_data->domainStatus > 5)
                                                    @else
                                                        <a id="edit_domain" dit_domain ger mt-3 text-white"
                                                            href="javascript:void(0)" data-id="{{ $user_data->id }}">Edit
                                                            Domain</a>
                                                    @endif --}}
                                                </td>
                                            </tr>
                                            <tr>
                                                <th style="color:black;">Domain Period:</th>
                                                <td>{{ $user_data->domainPeriod ?? '' }} Years</td>
                                            </tr>
                                            <tr>
                                                <th>Domain Creation Date:</th>
                                                <td>{{ $user_data->domainCreationDate ? \Carbon\Carbon::parse($user_data->domainCreationDate)->format('d-m-Y') : '' }}
                                                </td>
                                            </tr>
                                            <tr>
                                                <th style="color:black;">Last Transaction:</th>
                                                <td>
                                                    @if ($lastpayment != null)
                                                        {{ number_format($lastpayment->total_amount, 2, '.', '') }}
                                                    @endif
                                                </td>
                                            </tr>
                                            <tr>
                                                <th>Last Transaction Date:</th>
                                                @if ($lastpayment != null)
                                                    <td>{{ \Carbon\Carbon::parse($lastpayment->created_at)->format('d-m-Y') }}
                                                    </td>
                                                @endif
                                            </tr>
                                            <tr>
                                                <th style="color:black;">Last Update Date:</th>
                                                <td>{{ \Carbon\Carbon::parse($user_data->updated_at)->format('d-m-Y') ?? '' }}
                                                </td>
                                            </tr>
                                            <tr>
                                                <th>Domain Expiry Date:</th>
                                                <td>{{ $user_data->domainExpiryDate ? \Carbon\Carbon::parse($user_data->domainExpiryDate)->format('d-m-Y') : '' }}
                                                </td>
                                            </tr>

                                            <tr>
                                                <th>Google Authenticator Code:</th>
                                                <td>{{ $user_data->google2fa_secret != null ? $user_data->google2fa_secret : 'N.A' }}
                                                </td>
                                            </tr>

                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @if ($user_contact_details != null)
                            <div class="col-md-6">
                                <div class="card mb-4">
                                    <h5 class="card-header">Details of Head of Institution: </h5>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table table-striped table-bordered">
                                                <tr>
                                                    <th>Name:</th>
                                                    <td>{{ json_decode($user_contact_details->institution_head_detail)->name ?? '' }}
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Desigination:</th>
                                                    <td>{{ json_decode($user_contact_details->institution_head_detail)->designation ?? '' }}
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Email:</th>
                                                    <td>{{ json_decode($user_contact_details->institution_head_detail)->email ?? '' }}
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Phone:</th>
                                                    <td>


                                                        @if ($user_contact_details->institution_head_detail != null)
                                                            @if (isset(json_decode($user_contact_details->institution_head_detail)->prefix_phone))
                                                                0{{ json_decode($user_contact_details->institution_head_detail)->prefix_phone ?? '' }}-{{ json_decode($user_contact_details->institution_head_detail)->phone ?? '' }}
                                                            @else
                                                                N.A
                                                            @endif
                                                        @endif



                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Mobile:</th>
                                                    <td>{{ json_decode($user_contact_details->institution_head_detail)->mobile ?? '' }}
                                                    </td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="card mb-4">
                                    <h5 class="card-header">Administrative Contact Details</h5>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table table-striped table-bordered">
                                                <tr>
                                                    <th>Name:</th>
                                                    <td>{{ json_decode($user_contact_details->administrative_detail)->name ?? '' }}
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Desigination:</th>
                                                    <td>{{ json_decode($user_contact_details->administrative_detail)->designation ?? '' }}
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Email:</th>
                                                    <td>{{ json_decode($user_contact_details->administrative_detail)->email ?? '' }}
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Phone:</th>
                                                    <td>



                                                        @if ($user_contact_details->administrative_detail != null)
                                                            @if (isset(json_decode($user_contact_details->administrative_detail)->prefix_phone))
                                                                0{{ json_decode($user_contact_details->administrative_detail)->prefix_phone ?? '' }}-{{ json_decode($user_contact_details->administrative_detail)->phone ?? '' }}
                                                            @else
                                                                N.A
                                                            @endif
                                                        @endif

                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Mobile:</th>
                                                    <td>{{ json_decode($user_contact_details->administrative_detail)->mobile ?? '' }}
                                                    </td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="card mb-4">
                                    <h5 class="card-header">Billing Contact Details :</h5>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table table-striped table-bordered">
                                                <tr>
                                                    <th>Name:</th>
                                                    <td>{{ json_decode($user_contact_details->billing_contact_detail)->name ?? '' }}
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Desigination:</th>
                                                    <td>{{ json_decode($user_contact_details->billing_contact_detail)->designation ?? '' }}
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Email:</th>
                                                    <td>{{ json_decode($user_contact_details->billing_contact_detail)->email ?? '' }}
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Phone:</th>
                                                    <td>



                                                        @if ($user_contact_details->billing_contact_detail != null)
                                                            @if (isset(json_decode($user_contact_details->billing_contact_detail)->prefix_phone))
                                                                0{{ json_decode($user_contact_details->billing_contact_detail)->prefix_phone ?? '' }}-{{ json_decode($user_contact_details->billing_contact_detail)->phone ?? '' }}
                                                            @else
                                                                N.A
                                                            @endif
                                                        @endif

                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Mobile:</th>
                                                    <td>{{ json_decode($user_contact_details->billing_contact_detail)->mobile ?? '' }}
                                                    </td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="card mb-4">
                                    <h5 class="card-header">Technical Contact Details</h5>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table table-striped table-bordered">
                                                <tr>
                                                    <th>Name:</th>
                                                    <td>{{ json_decode($user_contact_details->technical_detail)->name ?? '' }}
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Desigination:</th>
                                                    <td>{{ json_decode($user_contact_details->technical_detail)->designation ?? '' }}
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Email:</th>
                                                    <td>{{ json_decode($user_contact_details->technical_detail)->email ?? '' }}
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Phone:</th>
                                                    <td>

                                                        @if ($user_contact_details->technical_detail != null)
                                                            @if (isset(json_decode($user_contact_details->technical_detail)->prefix_phone))
                                                                0{{ json_decode($user_contact_details->technical_detail)->prefix_phone ?? '' }}-{{ json_decode($user_contact_details->technical_detail)->phone ?? '' }}
                                                            @else
                                                                N.A
                                                            @endif
                                                        @endif



                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Mobile:</th>
                                                    <td>{{ json_decode($user_contact_details->technical_detail)->mobile ?? '' }}
                                                    </td>
                                                </tr>

                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif
                        @if ($payment != null)
                            <div class="col-md-6">
                                <div class="card mb-4">
                                    <h5 class="card-header">Payment Details</h5>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table table-striped table-bordered">
                                                <tr>
                                                    <th>Transaction ID :</th>
                                                    <td>{{ $payment->transaction_id }}</td>
                                                </tr>
                                                <tr>
                                                    <th style="color:black;">Transaction Date:</th>
                                                    <td>{{ \Carbon\Carbon::parse($payment->created_at)->format('d-m-Y') }}
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <th>Amount : </th>
                                                    <td><span>&#8377;
                                                        </span>{{ number_format(($payment->total_amount * 100) / 118, 2, '.', '') }}
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <th style="color:black;">Tax : </th>
                                                    <td><span>&#8377;
                                                        </span>{{ number_format($payment->total_amount - ($payment->total_amount * 100) / 118, 2, '.', '') }}
                                                    </td>
                                                </tr>

                                                <tr>
                                                    <th>Period: </th>
                                                    <td><span> </span>{{ $payment->period }}</td>
                                                </tr>

                                                <tr>
                                                    <th>Total Amount: </th>
                                                    <td><span>&#8377;
                                                        </span>{{ number_format($payment->total_amount, 2, '.', '') }}</td>
                                                </tr>

                                                <tr>
                                                    <th>Payment Invoice : </th>
                                                    <td>-</td>
                                                </tr>

                                                <!-- @if ($user_data->domainStatus == 6)
    -->

                                                <!--
    @endif -->

                                                <tr>
                                                    <th> Renew Domain:</th>
                                                    <td>-</td>

                                                    <!-- $user->domainExpiryDate -->

                                                    <!-- && $user->document_status!=1 -->



                                                </tr>

                                                <tr>

                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif
                        @if ($user_name_server != null)
                            <div class="col-md-6">
                                <div class="card mb-4">
                                    <div class="d-flex">
                                        <h5 class="card-header">Name Server Details

                                        </h5>
                                        <h5 class="card-header">

                                        </h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table table-striped table-bordered">
                                                <!-- <li class="list-group-item ">Primary Server : {{ $user_name_server->primary_name_server ?? '' }} {{ $user_name_server->primary_name_server_ip ?? '' }}</li> -->
                                                <!-- <tr>
                                                                                                                                  <th>Primary Server :</th>
                                                                                                                                  <td>{{ $user_name_server->primary_name_server ?? '' }} {{ $user_name_server->primary_name_server_ip ?? '' }}</td>
                                                                                                                                </tr> -->

                                                <tr>
                                                    <th>Primary Name Server :</th>
                                                    <td>{{ $user_name_server->primary_name_server ?? '' }}
                                                        {{ $user_name_server->primary_name_server_ip ?? '' }}</td>
                                                </tr>
                                                <tr>
                                                    <th>Secondary Name Server 1 :</th>
                                                    <td>{{ $user_name_server->secondary_name_server1 ?? '' }}
                                                        {{ $user_name_server->secondary_name_server1_ip ?? '' }}</td>
                                                </tr>
                                                <tr>
                                                    <th>Secondary Name Server 2 :</th>
                                                    <td>{{ $user_name_server->secondary_name_server2 ?? '' }}
                                                        {{ $user_name_server->secondary_name_server2_ip ?? '' }}</td>
                                                </tr>
                                                <tr>
                                                    <th>Secondary Name Server 3 :</th>
                                                    <td>{{ $user_name_server->secondary_name_server3 ?? '' }}
                                                        {{ $user_name_server->secondary_name_server3_ip ?? '' }}</td>
                                                </tr>

                                                <tr>
                                                    <th>Secondary Name Server 4 :</th>
                                                    <td>{{ $user_name_server->secondary_name_server4 ?? '' }}
                                                        {{ $user_name_server->secondary_name_server4_ip ?? '' }}</td>
                                                </tr>

                                                <tr>
                                                    <th>Secondary Name Server 5 :</th>
                                                    <td>{{ $user_name_server->secondary_name_server5 ?? '' }}
                                                        {{ $user_name_server->secondary_name_server5_ip ?? '' }}</td>
                                                </tr>


                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif
                        <div class="col-md-12">
                            <div class="card mb-4">
                                <div class="d-flex">
                                    <h5 class="card-header">Uploaded Documents Verification</h5>
                                    <h5 class="mt-4">
                                        <!-- <i class="fa fa-edit text-info fs-3 delete-domain-Category" title="Update Uploaded Documents" data-bs-toggle="modal" data-bs-target="#update_uploades_documents_modal"></i> -->
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">

                                        <form method="post" id="departmentForm" enctype="multipart/form-data">
                                            {!! csrf_field() !!}
                                            <table class="table table-striped table-bordered">
                                                <thead>
                                                    <tr>
                                                        <th style="color:#fff !important">File Name</th>
                                                        <th style="color:#fff !important">File Link</th>
                                                        <th style="color:#fff !important">Documents Verification</th>
                                                        <th style="color:#fff !important">Remarks</th>
                                                    </tr>
                                                </thead>
                                                <tbody>

                                                    @foreach ($userdocuments as $userdoc)
                                                        <tr>
                                                            <td>{{ $userdoc->title ?? '' }}</td>
                                                            @if ($userdoc->upload_type == 1)
                                                                <td>Name : {{ $userdoc->name }} <br> Affiliation Number :
                                                                    {{ $userdoc->path }}</td>
                                                            @endif
                                                            @if ($userdoc->upload_type == 2)
                                                                <td>
                                                                    <a href="{{ url('/user/docs') ?? '' }}/{{ $userdoc->user_id }}/{{ $userdoc->path ?? '' }}"
                                                                        target="_blank">View Document</a>

                                                                    @if ($userdoc->document_category_id == 2 && $user_data->domainStatus == 10 && $userdoc->old_path != null)
                                                                        <br>

                                                                        <a href="{{ url('/user/docs') ?? '' }}/{{ $userdoc->user_id }}/{{ $userdoc->old_path ?? '' }}"
                                                                            target="_blank">Old Document</a>
                                                                    @endif


                                                                    @if ($user_data->domainStatus <= 5 && $userdoc->upload_type != 2)
                                                                        <input type="file" name="replace_file[]"
                                                                            class="form-control">
                                                                    @endif

                                                                </td>
                                                            @endif


                                                            <td
                                                                class="@if ($userdoc->status == 0) text-danger @else text-success font-weight-bold @endif">
                                                                @if ($userdoc->status == 1)
                                                                    Action Not Taken
                                                                @else
                                                                    @if ($userdoc->upload_type == 1 && $user->domainStatus <= 5)
                                                                        <?php $stat = $userdoc->status == 0 ? 'Clarification Required' : 'Online Verified'; ?>
                                                                    @endif
                                                                    @if ($userdoc->upload_type == 2)
                                                                        <?php $stat = $userdoc->status == 0 ? 'Clarification Required' : 'Approved'; ?>
                                                                    @endif
                                                                    {{ $stat ?? '' }}
                                                                @endif
                                                            </td>
                                                            <td>
                                                                @if ($userdoc->status == 1)
                                                                    <input type="text" name="remarks[]"
                                                                        id="remarks{{ $userdoc->id ?? '' }}"
                                                                        class="form-control d-none remark_entering"
                                                                        placeholder="" value="">
                                                                @elseif($userdoc->status == 2)
                                                                @else
                                                                    {{ $userdoc->remarks ?? '' }}
                                                                @endif
                                                            </td>

                                                        </tr>
                                                    @endforeach


                                                    @if ($user_data->deleteion_request != null)
                                                        <tr>
                                                            <td>Deletion Request Attachment</td>

                                                            <td>
                                                                <a href="{{ url('/user/docs') ?? '' }}/{{ $userdoc->user_id }}/{{ $user->deleteion_request ?? '' }}"
                                                                    target="_blank">View Document</a>




                                                            </td>


                                                            <td
                                                                class="@if ($userdoc->status == 0) text-danger @else text-success font-weight-bold @endif">

                                                            </td>
                                                            <td>


                                                            </td>

                                                        </tr>
                                                    @endif
                                                </tbody>
                                            </table>




                                        </form>
                                    </div>
                                </div>
                            </div>

                            <!-- <a href="{{ url()->previous() }}"> <input type="button" class="btn btn-danger mr-4" id="back" name="back" value="Back"/></a> -->

                        </div>
                    </div>
                </div>


            </div>
        </div>
        <!-- / Content -->



    </div>
@endsection
@section('js')
    <script>
        $(document).ready(function() {



        });
    </script>
@endsection