@extends('layouts.AdminLayout')
@section('content')
<!-- Content wrapper -->
<div class="content-wrapper mt-5">
  <!-- Content -->
  <div class="container-xxl flex-grow-1 container-p-y">
    <div class="row">
        <div class="col-12 col-md-6 col-lg-3 mb-4">
            <div class="card border border-warning border-2">
                <a href="{{url('/ernetdash/admin-find-users-details?domainStatus=2')}}">
                    <div class="card-body">
                        <div class="gap-3">
                            <div class="card-title">
                                <h5 class="text-nowrap mb-2 text-center">Incomplete Application</h5>
                            </div>
                            <div class="mt-sm-auto">
                                <h3 class="mb-0 text-center">{{$incompleteApplicationCount?? 0}}</h3>
                            </div>
                        </div>
                    </div>
                </a>
            </div>
        </div>
      <div class="col-12 col-md-6 col-lg-3 mb-4">
        <div class="card border border-warning border-2">
          <a href="{{url('/ernetdash/admin-find-users-details?domainStatus=5')}}">
            <div class="card-body">
              <div class="gap-3">
                <div class="card-title">
                  <h5 class="text-nowrap mb-2 text-center">Pending Creations</h5>
                </div>
                <div class="mt-sm-auto">
                  <h3 class="mb-0 text-center">{{$pendingApplicationCount?? 0}}</h3>
                </div>
              </div>
            </div>
          </a>
        </div>
      </div>

      <div class="col-12 col-md-6 col-lg-3 mb-4">
        <a href="{{url('ernetdash/admin-find-users-details?domainStatus=8')}}">
          <div class="card border border-dark border-2">
            <div class="card-body">
              <div class="gap-3">
                <div class="card-title">
                  <h5 class="text-nowrap mb-2 text-center">Pending Restorable Domains</h5>
                </div>
                <div class="mt-sm-auto">
                  <h3 class="mb-0 text-center">{{$deletedApplicationCount?? 0}}</h3>
                </div>
              </div>
            </div>
          </div>
        </a>
      </div>
      <div class="col-12 col-md-6 col-lg-3 mb-4">
        <a href="{{url('ernetdash/admin-find-users-details?domainStatus=6')}}">
          <div class="card border border-success border-2">
            <div class="card-body">
              <div class="gap-3">
                <div class="card-title">
                  <h5 class="text-nowrap mb-2 text-center">Active Domain</h5>
                </div>
                <div class="mt-sm-auto">
                  <h3 class="mb-0 text-center">{{$activeApplicationCount??0}}</h3>
                </div>
              </div>
            </div>
          </div>
        </a>
      </div>
      <div class="col-12 col-md-6 col-lg-3 mb-4">
          <a href="{{url('ernetdash/admin-find-users-details?domainStatus=7')}}">
          <div class="card border border-primary border-2">
            <div class="card-body">
              <div class="gap-3">
                <div class="card-title">
                  <h5 class="text-nowrap mb-2 text-center">Hold Domains</h5>
                </div>
                <div class="mt-sm-auto">
                  <h3 class="mb-0 text-center">{{$holdApplicationCount?? 0}}</h3>
                </div>
              </div>
            </div>
          </div>
        </a>
      </div>

      <div class="col-12 col-md-6 col-lg-3 mb-4">
        <a href="{{url('ernetdash/admin-find-users-details?domainStatus=4')}}">
          <div class="card border border-secondary border-2">
            <div class="card-body">
              <div class="gap-3">
                <div class="card-title">
                  <h5 class="text-nowrap mb-2 text-center">Rejected Documents List</h5>
                </div>
                <div class="mt-sm-auto">
                  <h3 class="mb-0 text-center">{{$rejectedDocsCount?? 0}}</h3>
                </div>
              </div>
            </div>
          </div>
        </a>
      </div>
      <div class="col-12 col-md-6 col-lg-3 mb-4">
        <a href="#">
          <div class="card border border-secondary border-2">
            <div class="card-body">
              <div class="gap-3">
                <div class="card-title">
                  <h5 class="text-nowrap mb-2 text-center">Cooling Period</h5>
                </div>
                <div class="mt-sm-auto">
                  <h3 class="mb-0 text-center">0</h3>
                </div>
              </div>
            </div>
          </div>
        </a>
      </div>
      <div class="col-12 col-md-6 col-lg-3 mb-4">
          <a href="{{url('ernetdash/admin-find-users-details?lang=hi')}}">
          <div class="card border border-secondary border-2">
            <div class="card-body">
              <div class="gap-3">
                <div class="card-title">
                  <h5 class="text-nowrap mb-2 text-center">Hindi Domain</h5>
                </div>
                <div class="mt-sm-auto">
                  <h3 class="mb-0 text-center">{{$hindiDomainCount ?? 0}}</h3>
                </div>
              </div>
            </div>
          </div>
        </a>
      </div>

    </div>
  </div>
  <!-- / Content -->
</div>
<!-- Content wrapper -->
@endsection
@section("js")
<script src="/javascripts/application.js" type="text/javascript" charset="utf-8" async defer>

</script>
@endsection
