@extends('layouts.AdminLayout')
@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
	<h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light"></span>Extensions</h4>
  	<div class="card">
  		<div class="card-header">
    		<h5>Add Extensions</h5>
  		</div>
      	<div class="card-body">
  			<form role="form" id="add_domain_extension_form" method="POST" novalidate="novalidate">
		        <div class="row">
		            <div class="col-md-3">
		              	<label class="form-label text-capitalize fs-6 text-dark">Choose Main Category <span>*</span></label>
		              	<select class="form-control" name="main_Category" id="main_Category">
			                <option value="">Select Domain Category</option>
			                @foreach($domain_main_category as $main_category)
	                        <option value="{{$main_category->id}}">{{$main_category->domain_category_name}}</option>
	                        @endforeach
                     	</select>
		            </div>
		            <div class="col-md-3">
		              	<label class="form-label text-capitalize fs-6">Choose Languages <span>*</span></label>
		              	<select class="form-control" name="languages" id="languages">
		                	<option value="">All Languages</option>
		                	@foreach($domain_languages as $languages)
		                    <option value="{{$languages->id}}">{{$languages->language_name}}</option>
		                    @endforeach
		                </select>
		            </div>
		            <div class="col-md-3">
		              <label class="form-label text-capitalize fs-6"> Domain Extensions <span>*</span></label>
		              <input type="text" class="form-control" name="domain_extensions" id="domain_extensions" placeholder=" Domain Extensions" value="">
		            </div>
		            <div class="col-md-3">
		              <label class="form-label">Status <span>*</span></label>
		              <select class="form-control" name="domain_status" id="domain_status">
		                <option value="">Choose Status</option>
		                <option value="active">Active</option>
		                <option value="in-active">In-active</option>
		              </select>
		            </div>
		        </div>
		        <div class="my-3">
		            <button class="btn btn-success d-grid float-end" id="add_Extensions_btn" name="action" value="submit">Submit</button>
		        </div>
		    </form>
        </div>
    </div>
    <div class="card mt-4">
  		<div class="card-header">
    		<h5>All Extension List</h5>
  		</div>
        <div class="card-body">
          	<div class="table-responsive">
		         <table class="table table-striped table-bordered">
		            <thead>
		              <tr>
		                <th class="text-capitalize fs-6">Main Category</th>
		                <th class="text-capitalize fs-6">Languages</th>
		                <th class="text-capitalize fs-6">Domain Extensions</th>
		                <th class="text-capitalize fs-6">Status</th>
		                <th class="text-capitalize fs-6">Action</th>
		              </tr>
		            </thead>
		            <tbody>
		            	@foreach($domain_extensions as $extension)
		            	 <tr>
		            	 	<td>{{get_domain_main_category_name($extension->main_category_id)}}</td>
		            	 	<td>{{get_languages_name($extension->domain_languages_id)}}</td>
		            	 	<td>{{$extension->domain_extensions}}</td>
		            	 	<td>{{$extension->status}}</td>
		            	 	<td>
			                  <i class="fa fa-edit text-info fs-3 me-md-3 get-domain-extension-data" data-id={{$extension->id}} data-bs-toggle="modal" data-bs-target="#update_extension_modal"></i>
			                  <i class="fa fa-trash text-danger fs-3 delete-domain-extension-name" data-id="{{$extension->id}}"></i>
			                </td>
		            	 </tr>
		            	 @endforeach
		            </tbody>
		        </table>
		    </div>
      	</div>
    </div>
    <div class="modal fade update_extension_modal" id="update_extension_modal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
	  	<div class="modal-dialog">
		    <div class="modal-content">
		      	<div class="modal-header">
		        	<h5 class="modal-title" id="staticBackdropLabel">Update Extension</h5>
			        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			    </div>
	        	<form role="form" id="update_extension_form" method="POST">
	            @csrf
			      	<div class="modal-body">
		                <div class=" mb-3">
		                	<label class="form-label text-capitalize fs-6 text-dark">Choose Main Category <span>*</span></label>
			              	<select class="form-control" name="update_main_Category" id="update_main_Category">
				                <option value="">Select Domain Category</option>
				                @foreach($domain_main_category as $main_category)
		                        <option value="{{$main_category->id}}">{{$main_category->domain_category_name}}</option>
		                        @endforeach
	                     	</select>
		                  	<input type="hidden" name="extension_id" id="extension_id">
		                </div>
		                <div class="mb-3">
			              	<label class="form-label text-capitalize fs-6">Choose Languages <span>*</span></label>
		              		<select class="form-control" name="update_languages" id="update_languages">
			                	<option value="">All Languages</option>
			                	@foreach($domain_languages as $languages)
			                    <option value="{{$languages->id}}">{{$languages->language_name}}</option>
			                    @endforeach
		                	</select>
			            </div>
			            <div class="mb-3">
			              <label class="form-label text-capitalize fs-6"> Domain Extensions <span>*</span></label>
			              <input type="text" class="form-control" name="update_domain_extensions" id="update_domain_extensions" placeholder=" Domain Extensions" value="">
			            </div>
			            <div>
			            	<label class="form-label">Status <span>*</span></label>
				            <select class="form-control" name="update_domain_status" id="update_domain_status">
				                <option value="">Choose Status</option>
				                <option value="active">Active</option>
				                <option value="in-active">In-active</option>
				            </select>
			            </div>
			      	</div>
			      	<div class="modal-footer">
				        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
				        <button type="button" class="btn btn-primary" id="update_extension_btn">Update</button>
			      	</div>
		        </form>
		    </div>
	  	</div>
	</div>
</div>
@endsection
@section("js")
<script>
$(document).ready(function(){
	$('#add_domain_extension_form').validate({
	    rules: {
	      main_Category: {required: true,},
	      languages: {required: true,},
	      domain_extensions: {required: true,},
	      domain_status: {required: true,},
	    },
	    messages:
	    {
	      main_Category:{required: "Please Enter Language name",},
	      languages:{required: "Please choose language",},
	      domain_extensions:{required: "Please Enter Domain Extensions",},
	      domain_status:{required: "Please choose Status",},
	    },
	    submitHandler:function(form)
	    {
	      $.ajaxSetup({
	        headers: {
	          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
	        }
	      });
	      $.ajax({
	        url:"{{Route('admin.add-extensions')}}",
	        type:'POST',
	        dataType:'json',
	        data:$("#add_domain_extension_form").serialize(),
	        cache: false,
	        beforeSend: function(){
	          $(".loader-area").show();
	        },
	        success:function(res)
	        {
	          if(res.status=='success')
	          {
	            Swal.fire({
	              position: 'center',
	              icon: 'success',
	              text: res.message,
	              showConfirmButton: false,
	            });
	            //window.location = "{{route('admin.extensions-view')}}";
	          }
	          else
	          {
	            Swal.fire({
	            position: 'center',
	            icon: 'error',
	            text: res.message,
	            showConfirmButton: false,
	            });
	          }
	        },
	        complete: function(){
	          $("form").trigger("reset");
	          $("#add_domain_category_btn").prop('disabled',false);
	        },
	      });
	    }
  	});
  	$(".get-domain-extension-data").click(function(){
	    var extension_id = $(this).attr("data-id");
	    $.ajaxSetup({
	      headers: {
	        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
	      }
	    });
	    $.ajax({
	      url:"{{Route('admin.get-extension-data')}}",
	      type:'POST',
	      dataType:'json',
	      data:{extension_id:extension_id},
	      cache: false,
	      beforeSend: function(){
	        $(".loader-area").show();
	      },
	      success:function(res)
	      {
	        if(res.status=='success')
	        {
	          $('#extension_id').attr('value',res.message.id);
	          $('#update_main_Category').attr('value',res.message.main_category_id);
	          $('#update_languages option[value='+res.message.domain_languages_id+']').text("selected", true);
	          $('#update_domain_extensions').attr('value',res.message.domain_extensions);
	          $('#update_domain_status option[value='+res.message.status+']').text("selected", true);
	          $("#update_language_modal").modal('show');
	        }
	        else
	        {
	          Swal.fire({
	            position: 'center',
	            icon: 'error',
	            text: res.message,
	            showConfirmButton: false,
	          });
	        }
	      },
	      complete: function(){
	        $("form").trigger("reset");
	        $("#update_language_btn").prop('disabled',false);
	      },
	    });
  	});
  	$("#update_extension_btn").click(function(){
	    $.ajaxSetup({
	      headers: {
	        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
	      }
	    });
	    $.ajax({
	      url:"{{Route('admin.update-extension-data')}}",
	      type:'POST',
	      dataType:'json',
	      data:$("#update_extension_form").serialize(),
	      cache: false,
	      beforeSend: function(){
	        $(".loader-area").show();
	      },
	      success:function(res)
	      {
	        if(res.status=='success')
	        {
	        	$("#update_extension_modal").modal('hide');
		        Swal.fire({
		            position: 'center',
		            icon: 'success',
		            text: res.message,
		            showConfirmButton: false,
		        });
		        window.location = "{{route('admin.extensions-view')}}";
	        }
	        else
	        {
	          Swal.fire({
	            position: 'center',
	            icon: 'error',
	            text: res.message,
	            showConfirmButton: false,
	          });
	        }
	      },
	      complete: function(){
	        $("form").trigger("reset");
	        $("#update_extension_btn").prop('disabled',false);
	      },
	    });
  	});
  	$('.delete-domain-extension-name').click(function(){
    Swal.fire({
      title: 'Are you sure?',
      text: "You won't be able to revert this!",
      icon: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      confirmButtonText: 'Yes, delete it!'
    }).then((result) => {
      if (result.isConfirmed)
      {
       var extension_id = $(this).attr("data-id");
        $.ajaxSetup({
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });
        $.ajax({
          url:"{{Route('admin.delete-domain-extension')}}",
          type:'POST',
          dataType:'json',
          data:{extension_id:extension_id},
          cache: false,
          beforeSend: function(){
            $(".loader-area").show();
          },
          success:function(res)
          {
            if(res.status=='success')
            {
              Swal.fire(
                'Deleted!',
                'Your file has been deleted.',
                'success'
              )
            }
            else
            {
             Swal.fire({
                position: 'center',
                icon: 'error',
                text: res.message,
                showConfirmButton: false,
              });
            }
          },
          complete: function(){
            $("form").trigger("reset");
            $(".delete-languages-name").prop('disabled',false);
          },
        });
      }
    });
  });
});
</script>
@endsection
