@extends('layouts.AdminLayout')
@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
	<h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light"></span>Documents</h4>
  	<div class="card">
  		<div class="card-header">
    		<h5>Add Documents Name</h5>
  		</div>
      	<div class="card-body">
  			<form role="form" id="add_document_form" method="POST" enctype="multipart/form-data">
            @csrf
            	<div class="row">
	                <div class="col-md-3 mb-3">
	                	<label class="form-label text-capitalize fs-6">Document Name<span>*</span></label>
	                  	<input type="text" id="add_document" name="add_document" class="form-control" placeholder="Enter Document Name">
	                </div>
	                <div class="col-md-3 mb-3">
	                	<label class="form-label text-capitalize fs-6">Document Description<span>*</span></label>
	                  	<input type="text" id="add_description" name="add_description" class="form-control" placeholder="Enter Document Description">
	                </div>
	                <div class="col-md-3 mb-3">
	                	<label class="form-label text-capitalize fs-6">Document Sample<span>*</span></label>
	                  	<input type="file" id="document_sample" name="document_sample" class="form-control" placeholder="Enter Document Sample"  accept="pdf" />
	                </div>
	                <div class="col-md-3 mb-3">
		              	<label class="form-label text-capitalize fs-6">Status <span>*</span></label>
		              	<select class="form-control" name="document_status" id="document_status">
			                <option value="">Choose Status</option>
			                <option value="active">Active</option>
				            <option value="in-active">In-active</option>
		              	</select>
		            </div>
               		<div class="col-md-2 mt-4">
               			<button class="btn btn-primary btn-block mt-1" id="add_document_smt_btn" name="action" value="add">Add</button>
               		</div>
              	</div>
          	</form>
        </div>
    </div>
    <div class="card mt-4">
  		<div class="card-header">
    		<h5>All Documents List</h5>
  		</div>
        <div class="card-body">
          	<div class="table-responsive">
		         <table class="table table-striped table-bordered">
		            <thead>
		              <tr>
		                <th class="text-capitalize fs-6">Documents Name</th>
		                <th class="text-capitalize fs-6">Document Description</th>
		                <th class="text-capitalize fs-6">Document Sample</th>
		                <th class="text-capitalize fs-6">Status</th>
		                <th class="text-capitalize fs-6">Action</th>
		              </tr>
		            </thead>
		            <tbody>
		            	@foreach($get_documents as $documents)
		                <tr>
			                <td>{{$documents->title}}</td>
			                <td>{{$documents->description}}</td>
			                <td><a href="{{asset('public/document_sample/'.$documents->required_document_sample)}}">View Document</a></td>
			                <td>{{$documents->status}}</td>
			                <td>
			                  <i class="fa fa-edit text-info fs-3 me-md-3 get-document-name-data" data-id="{{$documents->id}}" data-bs-toggle="modal" data-bs-target="#update_document_modal"></i>
			                  <i class="fa fa-trash text-danger fs-3 delete-document-name" data-id="{{$documents->id}}"></i>
			                </td>
		              	</tr>
		              	@endforeach
		            </tbody>
		        </table>
		    </div>
      	</div>
    </div>
    <div class="modal fade update_document_modal" id="update_document_modal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
	  	<div class="modal-dialog">
		    <div class="modal-content">
		      	<div class="modal-header">
		        	<h5 class="modal-title" id="staticBackdropLabel">Update Language</h5>
			        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			    </div>
	        	<form role="form" id="update_document_form" method="POST" enctype='multipart/form-data'>
	            @csrf
			      	<div class="modal-body">
		                <div class="mb-3">
		                	<label class="form-label text-capitalize fs-6">Document Name<span>*</span></label>
		                  	<input type="hidden" id="document_id" name="document_id" >
		                  	<input type="text" id="update_document" name="update_document" class="form-control" placeholder="Enter Document Name">
		                </div>
		                <div class="mb-3">
		                	<label class="form-label text-capitalize fs-6">Document Description<span>*</span></label>
		                  	<input type="text" id="update_description" name="update_description" class="form-control" placeholder="Enter Document Description">
		                </div>
		                <div class="mb-3">
		                	<label class="form-label text-capitalize fs-6">Document Sample<span>*</span></label>
		                  	<input type="file" id="update_document_sample" name="update_document_sample" class="form-control" placeholder="Enter Document Sample">
		                  	<a href="" id="view_document" name="view_document">view Documents</a>
		                </div>
		                <div class="mb-3">
			              	<label class="form-label text-capitalize fs-6">Status <span>*</span></label>
			              	<select class="form-control" name="update_document_status" id="update_document_status">
				                <option value="">Choose Status</option>
				                <option value="active">Active</option>
					            <option value="in-active">In-active</option>
			              	</select>
			            </div>
			      	</div>
			      	<div class="modal-footer">
				        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
				        <button type="button" class="btn btn-primary" id="update_document_btn">Update</button>
			      	</div>
		        </form>
		    </div>
	  	</div>
	</div>
</div>
@endsection
@section("js")
<script>
$(document).ready(function(){
	$('#add_document_form').validate({
	    rules: {
	      add_document: {required: true,},
	      add_description: {required: true,},
	      document_sample: {extension: "pdf",required: true, maxsize : 200000,},
	      document_status: {required: true,},
	    },
	    messages: 
	    { 
	      add_document:{required: "Please enter document name",},
	      add_description:{required: "Please enter document description",},
	      document_sample:{required: "Please enter document sample", extension: "Please upload file in these format only pdf.", maxsize:"file size must be less than 200 KB", },
	      document_status:{required: "Please choose document status",},
	    },
	    submitHandler:function(form) 
	    {
	      $.ajaxSetup({
	        headers: {
	          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
	        }
	      });
	      var formData = new FormData($('#add_document_form')[0]);
	      $.ajax({
	        url:"{{Route('admin.add-document')}}",
	        type: "POST",
            data: formData,
            dataType:'json',
            contentType: false,
            cache: false,
            processData: false,
	        beforeSend: function(){
	          $(".loader-area").show();
	        },
	        success:function(res)
	        {
	          if(res.status=='success')
	          {
	            Swal.fire({
	              position: 'center',
	              icon: 'success',
	              text: res.message,
	              showConfirmButton: false,
	            });
	            window.location = "{{route('admin.document-view')}}";
	          }
	          else
	          {
	            Swal.fire({
	            position: 'center',
	            icon: 'error',
	            text: res.message,
	            showConfirmButton: false,
	            });
	          }          
	        },
	        complete: function(){
	          $("form").trigger("reset"); 
	          $("#add_document_smt_btn").prop('disabled',false);
	        },
	      });
	    }
  	});
  	$(".get-document-name-data").click(function(){
	    var document_id = $(this).attr("data-id");
	    $.ajaxSetup({
	      headers: {
	        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
	      }
	    });
	    $.ajax({
	      url:"{{Route('admin.get-document-data')}}",
	      type:'POST',
	      dataType:'json',
	      data:{document_id:document_id},
	      cache: false,
	      beforeSend: function(){
	        $(".loader-area").show();
	      },
	      success:function(res)
	      {
	        if(res.status=='success')
	        {
	          var url = res.message.required_document_sample;
	          $('#document_id').attr('value',res.message.id);
	          $('#update_document').attr('value',res.message.title);
	          $('#update_description').attr('value',res.message.description);
	          $('#view_document').attr('href',"{{asset('public/document_sample/')}}"+'/'+url);
	          $('#update_document_status option[value='+res.message.status+']').text(res.message.status, true);
	          $("#update_document_modal").modal('show');
	        }
	        else
	        {
	          Swal.fire({
	            position: 'center',
	            icon: 'error',
	            text: res.message,
	            showConfirmButton: false,
	          });
	        }          
	      },
	      complete: function(){
	        $("form").trigger("reset"); 
	        $("#update_document_btn").prop('disabled',false);
	      },
	    });
  	});
  	$("#update_document_btn").click(function(){
	    $.ajaxSetup({
	      headers: {
	        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
	      }
	    });
	    var formData = new FormData($('#update_document_form')[0]);
	    $.ajax({
	      url:"{{Route('admin.update-document-data')}}",
	      type: "POST",
	      data: formData,
	      dataType:'json',
	      contentType: false,
	      cache: false,
	      processData: false,
	      beforeSend: function(){
	        $(".loader-area").show();
	      },
	      success:function(res)
	      {
	        if(res.status=='success')
	        {
	        	$("#update_document_modal").modal('hide');
		        Swal.fire({
		            position: 'center',
		            icon: 'success',
		            text: res.message,
		            showConfirmButton: false,
		        });
		        window.location = "{{route('admin.document-view')}}";
	        }
	        else
	        {
	          Swal.fire({
	            position: 'center',
	            icon: 'error',
	            text: res.message,
	            showConfirmButton: false,
	          });
	        }          
	      },
	      complete: function(){
	        $("form").trigger("reset"); 
	        $("#update_document_btn").prop('disabled',false);
	      },
	    });
  	});
  	$('.delete-document-name').click(function(){
    Swal.fire({
      title: 'Are you sure?',
      text: "You won't be able to revert this!",
      icon: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      confirmButtonText: 'Yes, delete it!'
    }).then((result) => {
      if (result.isConfirmed) 
      {
        var document_id = $(this).attr('data-id');
        $.ajaxSetup({
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });
        $.ajax({
          url:"{{Route('admin.delete-document-name')}}",
          type:'POST',
          dataType:'json',
          data:{document_id:document_id},
          cache: false,
          beforeSend: function(){
            $(".loader-area").show();
          },
          success:function(res)
          {
            if(res.status=='success')
            {
              Swal.fire(
                'Deleted!',
                'Your file has been deleted.',
                'success'
              )
            }
            else
            {
             Swal.fire({
                position: 'center',
                icon: 'error',
                text: res.message,
                showConfirmButton: false,
              });
            }          
          },
          complete: function(){
            $("form").trigger("reset"); 
            $(".delete-document-name").prop('disabled',false);
          },
        });
      }
    });
  });
});
</script>
@endsection
