@extends('layouts.AdminLayout')
@section('content')
<div class="content-wrapper">
  <!-- Content -->
  <div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light"></span>Misc. Settings Details</h4>
    <form role="form" id="web_setting_form" method="post">
      @csrf
      <div class="row">
        <div class="col-md-4">
          <div class="card mb-4">
            <h5 class="card-header">Unhold Price <span class="text-danger">*</span></h5>
            <div class="card-body">
              <div class="mb-4">
                <input type="number" class="form-control valid-num" id="reactivation_price" name="reactivation_price" placeholder="Enter Reactivation Price" min="0
                " value="{{$getSettingData->reactivation_price}}" />
              </div>
            </div>
          </div>
        </div>
        <div class="col-md-4">
          <div class="card mb-4">
            <h5 class="card-header">Restoration Price <span class="text-danger">*</span></h5>
            <div class="card-body">
              <div class="mb-4">
                <input type="number" class="form-control valid-num" id="hold_deduction_price" name="hold_deduction_price" placeholder="Enter Hold Deduction Price" min="0" value="{{$getSettingData->hold_deduction_price}}" />
              </div>
            </div>
          </div>
        </div>
        <div class="col-md-4">
          <div class="card mb-4">
            <h5 class="card-header">Tax (in %)<span class="text-danger">*</span></h5>
            <div class="card-body">
              <div class="mb-4">
                <input type="number" class="form-control valid-num" id="service_tax" name="service_tax" placeholder="Enter Service Tax" min="0" value="{{$getSettingData->service_tax}}" />
              </div>
            </div>
          </div>
        </div>
          <div class="col-md-12">
              <div class="card mb-4">
                  <div class="card-body">
                      <div class="row">
                          <div class="mb-4 col-md-6">
                              <label class="form-label text-capitalize fs-6">Hold Domain Period (in days) <span class="text-danger">*</span> </label>
                              <input type="number" class="form-control days" id="hold_domain_period" name="hold_domain_period" placeholder="" max="100" value="{{$getSettingData->hold_domain_period ?? 0}}" />
                          </div>

                          <div class="mb-4 col-md-6">
                              <label class="form-label text-capitalize fs-6">Restorable Domain Period (in days)<span class="text-danger">*</span> </label>
                              <input type="number" class="form-control days" id="restorable_domain_period" name="restorable_domain_period" placeholder="" max="100" value="{{$getSettingData->restorable_domain_period ?? 0 }}" />
                          </div>
                          <h5 class="card-header">Frequency Setting</h5>
                          <div class="mb-4 col-md-6">
                              <label class="form-label text-capitalize fs-6">Hold Domain Reminder Frequency (in days) <span class="text-danger">*</span> </label>
                              <input type="number" class="form-control days" id="hold_domain_reminder_period" name="hold_domain_reminder_period" placeholder="" max="100" value="{{$getSettingData->hold_domain_reminder_period ?? 0}}" />
                          </div>
                          <div class="mb-4 col-md-6">
                              <label class="form-label text-capitalize fs-6">Restorable Reminder Frequency (in days)<span class="text-danger">*</span> </label>
                              <input type="number" class="form-control days" id="restorable_domain_reminder_period" name="restorable_domain_reminder_period" placeholder="" max="100" value="{{$getSettingData->restorable_domain_reminder_period ?? 0}}" />
                          </div>
                      </div>
                  </div>
              </div>
          </div>
          <div class="col-md-12">
            <div class="card mb-4">
              <h5 class="card-header">Feedback Mail</h5>
              <div class="card-body">
                <div class="row">
                  <div class="col-md-4 mb-4">
                    <label class="form-label text-capitalize fs-6">Email Address 1 <span class="text-danger">*</span></label>
                    <input type="email" class="form-control" id="email_address_one" name="email_address_one" placeholder="Email Address 1" maxlength="35" value="{{$getSettingData->email_address_one}}" />
                  </div>
                  <div class="col-md-4 mb-4">
                    <label class="form-label text-capitalize fs-6">Email Address 2 <span class="text-danger">*</span></label>
                    <input type="email" class="form-control" id="email_address_two" name="email_address_two" placeholder="Email Address 2" maxlength="35" value="{{$getSettingData->email_address_two}}" />
                  </div>
                  <div class="col-md-4 mb-4">
                    <label class="form-label text-capitalize fs-6">Email Address (Optional)</label>
                    <input type="email" class="form-control" id="email_address_optional" name="email_address_optional" placeholder="Email Address Optional" maxlength="35" value="{{$getSettingData->email_address_optional}}" />
                  </div>
                </div>
              </div>
            </div>
          </div>


          <div class="col-md-12">
            <div class="card mb-4">
              <h5 class="card-header">EPP Portal</h5>
              <div class="card-body">
                <div class="row">
                  <div class="col-md-4 mb-4">
                    <label class="form-label text-capitalize fs-6">interface <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="interface" name="interface" placeholder="Email Address 1" maxlength="35" value="{{$getSettingData->interface}}" />
                  </div>
                  <div class="col-md-4 mb-4">
                    <label class="form-label text-capitalize fs-6">hostname <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="hostname" name="hostname" placeholder="Email Address 2" maxlength="35" value="{{$getSettingData->hostname}}" />
                  </div>
                  <div class="col-md-4 mb-4">
                    <label class="form-label text-capitalize fs-6">port</label>
                    <input type="text" class="form-control" id="port" name="port" placeholder="Email Address Optional" maxlength="35" value="{{$getSettingData->port}}" />
                  </div>
                  <div class="col-md-4 mb-4">
                    <label class="form-label text-capitalize fs-6">userid</label>
                    <input type="text" class="form-control" id="userid" name="userid" placeholder="Email Address Optional" maxlength="35" value="{{$getSettingData->userid}}" />
                  </div>
                  <div class="col-md-4 mb-4">
                    <label class="form-label text-capitalize fs-6">password</label>
                    <input type="text" class="form-control" id="password" name="password" placeholder="Email Address Optional" maxlength="35" value="{{$getSettingData->password}}" />
                  </div>

                  <div class="col-md-4 mb-4">
                    <label class="form-label text-capitalize fs-6">logging</label>
                    <select class="form-control" id="logging" name="logging">
                      <option {{ $getSettingData->logging ? 'selected' : '' }} value="1">True</option>
                      <option {{ $getSettingData->logging ? '' : 'selected' }} value="0">False</option>
                    </select>
                  </div>

                  
                  <div class="col-md-4 mb-4">
                    <label class="form-label text-capitalize fs-6">certificate file</label>
                    <input type="text" class="form-control" id="certificatefile" name="certificatefile" placeholder="Email Address Optional" maxlength="35" value="{{$getSettingData->certificatefile}}" />
                  </div>
                  <div class="col-md-4 mb-4">
                    <label class="form-label text-capitalize fs-6">certificate password</label>
                    <input type="text" class="form-control" id="certificatepassword" name="certificatepassword" placeholder="Email Address Optional" maxlength="35" value="{{$getSettingData->certificatepassword}}" />
                  </div>



                  <div class="col-md-4 mb-4">
                    <label class="form-label text-capitalize fs-6">verify peer</label>
                    <select class="form-control" id="verifypeer" name="verifypeer">
                      <option {{ $getSettingData->verifypeer ? 'selected' : '' }} value="1">True</option>
                      <option {{ $getSettingData->verifypeer ? '' : 'selected' }} value="0">False</option>
                    </select>
                  </div>
                  <div class="col-md-4 mb-4">
                    <label class="form-label text-capitalize fs-6">verify peername</label>
                    <select class="form-control" id="verifypeername" name="verifypeername">
                      <option {{ $getSettingData->verifypeername ? 'selected' : '' }} value="1">True</option>
                      <option {{ $getSettingData->verifypeername ? '' : 'selected' }} value="0">False</option>
                    </select>
                  </div>
                  <div class="col-md-4 mb-4">
                    <label class="form-label text-capitalize fs-6">allow self signed</label>
                    <select class="form-control" id="allowselfsigned" name="allowselfsigned">
                      <option {{ $getSettingData->allowselfsigned ? 'selected' : '' }} value="1">True</option>
                      <option {{ $getSettingData->allowselfsigned ? '' : 'selected' }} value="0">False</option>
                    </select>
                  </div>

                  




                </div>
              </div>
            </div>
          </div>

          

        <div class="mb-3">
           <button class="btn btn-success mr-4 float-end" id="web_setting_btn" name="action" value="Submit">Submit</button>
        </div>
      </div>
    </form>
  </div>
  <!-- / Content -->
</div>
@endsection
@section("js")
<script>
   $('.valid-num').keypress(function(event) {
    var charCode = (event.which) ? event.which : event.keyCode;
    var inputValue = $(this).val();
    var decimalIndex = inputValue.indexOf('.');
      if (charCode == 46) {
      if (decimalIndex != -1 || inputValue.length === 0 || inputValue.length > 14) {
        event.preventDefault();
      }
    } else if ((charCode < 48 || charCode > 57) || (decimalIndex != -1 && inputValue.length - decimalIndex > 2)) {
      event.preventDefault();
    } else if (inputValue.length >= 11 && decimalIndex === -1) {
      event.preventDefault();
    }
  });

  $('#web_setting_form').validate({
    rules: {
      reactivation_price: {required: true,},
      hold_deduction_price: {required: true,},
      service_tax: {required: true, maxlength:3,},
      account_number: {required: true, maxlength:16},
      branch_name: {required: true,},
      email: {required: true,},
      email_address_one: {required: true,},
      email_address_two: {required: true,},
      hold_domain_period: {required: true,},
      restorable_domain_period: {required: true,},
      hold_domain_reminder_period: {required: true,},
      restorable_domain_reminder_period: {required: true,},
    },
    messages:
    {
      reactivation_price:{required: "Please enter reactivation Price",number:"Please enter valid reactivation Price"},
      hold_deduction_price:{required: "Please enter hold deduction price",number:"Please enter valid hold deduction price", maxlength:"Please enter valid hold deduction price"},
      service_tax:{required: "Please enter service tax in %",number:"Please enter valid service tax in %", maxlength:"Please enter valid tax percentage"},
      account_number:{required: "Please enter account number", number:"Please enter valid account number", maxlength:"Please enter valid account number"},
      branch_name:{required: "Please enter branch name",},
      email:{required: "Please enter email id",},
      email_address_one:{required: "Please enter email address 1",},
      email_address_two:{required: "Please enter email address 2",},
      hold_domain_period:{required: "This field is required",},
      restorable_domain_period:{required: "This field is required"},
      hold_domain_reminder_period:{required: "This field is required"},
      restorable_domain_reminder_period:{required: "This field is required"},
    },
    submitHandler:function(form)
    {
      $.ajaxSetup({
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
      });
      $.ajax({
        url:"{{route('admin.add-setting')}}",
        type:'POST',
        dataType:'json',
        data:$("#web_setting_form").serialize(),
        cache: false,
        beforeSend: function(){
          $(".loader-area").show();
        },
        success:function(res)
        {
          if(res.status=='success')
          {
            Swal.fire({
              position: 'center',
              icon: 'success',
              text: res.message,
              showConfirmButton: true,
            }).then(function () {
                window.location = "{{route('admin.setting-view')}}";
            });
          }
          else
          {
           Swal.fire({
              position: 'center',
              icon: 'success',
              text: res.message,
              showConfirmButton: false,
            });
          }
        },
        complete: function(){
        $("form").trigger("reset");
        $("#web_setting_btn").prop('disabled',false);
        },
      });
    }
  });
</script>
@endsection
