@extends('layouts.AdminLayout')

@section('content')

<div class="content-wrapper">
<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-2">DNS Records</h4>

	<h5 class="fw-bold py-3 mb-2"> Domain ({{$domain->domainName}}) 
		@if($domain->domainLangID==3)
		-
		({{$domain->domainPunycode}})
	@endif</h5>

		<div class="card">
			<div style="padding:20px">
					<div class="table-responsive text-nowrap">
						@if (Session::has('success'))
						   <div class="alert alert-success">{{ Session::get('success') }}</div>
						@endif

						@if (Session::has('error'))
						   <div class="alert alert-danger">{{ Session::get('error') }}</div>
						@endif
						<table class="table" id="dataTable" width="100%" cellspacing="0">
						   <thead>
						  <tr>
                          <th>Type</th>
                          <th>Name</th>
                          <th>Content</th>
                          <th>TTL (seconds)</th>
						  </tr>
						  </thead>
						  <tbody>
                            @foreach($records as $record)
                                 <tr>
                                     <td>{{$record->type}}</td>
                                     <td>{{$record->name}}</td>
                                     <td>{{$record->data}}</td>
                                     <td>{{$record->ttl}}</td>
                                 </tr>
                            @endforeach
						  </tbody>
						</table>
					</div>
			</div>
		</div>
    </div>
</div>
@endsection
@section("js")
	<script type="text/javascript">
		$(document).ready(function() {

			$('#dataTable').DataTable();

		});
	</script>
@endsection
