@extends('layouts.AdminLayout')
@section('content')

<style>
     .check {
        -webkit-appearance: none; /*hides the default checkbox*/
        height: 20px;
         width: 20px;
        position: relative;
        transition: 0.10s;
         background-color: #FE0006;
        text-align: center;
        font-weight: 600;
         color: white;
        border-radius: 3px;
        outline: none;
     }

    .check:checked {
         background-color: #0E9700;
    }

     .check:before {
        content: "✖";
    }
     .check:checked:before {
        content: "✔";
    }
 
    .check:hover {
        cursor: pointer;
         opacity: 0.8;
    }
</style>

<?php

$action='';

$userid=Auth::guard('admin')->user()->id;

$edit=$del=$add=true;
$priv=getUserHasRoleProgram($userid,20);

if($priv!=null){
    $edit=$priv->modify_priv==1 ?true:false;
    $del=$priv->del_priv==1 ?true:false;
    $add=$priv->add_priv==1 ?true:false;
}
$head_name = get_heading_name(20);
   if($head_name!=null){
       $heading_name= $head_name;
   }else
   {
      $heading_name="Misc. Settings Details";
   }


?>

<!--  Content wrapper -->
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="row">
        <!-- Domain Status Table Start-->
        <div class="col-12 my-2">
        <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light"></span>{{$heading_name}}</h4>
            <div class="card">
                <div class="card-body">
                     <div class="row">
                        <div class="col-xl-12">
                            <div class="nav-align-top mb-4">
                                 <ul class="nav nav-tabs nav-fill" role="tablist">
    <li class="nav-item">
        <button
            type="button"
            class="nav-link prices active"
            role="tab"
            data-bs-toggle="tab"
            data-bs-target="#navs-justified-prices"
            aria-controls="navs-justified-prices"
            aria-selected="true"
        >
            Prices
        </button>
    </li>
    <li class="nav-item">
        <button
            type="button"
            class="nav-link period"
            role="tab"
            data-bs-toggle="tab"
            data-bs-target="#navs-justified-period"
            aria-controls="navs-justified-period"
            aria-selected="false"
        >
            Period
        </button>
    </li>
    <li class="nav-item">
        <button
            type="button"
            class="nav-link frequency"
            role="tab"
            data-bs-toggle="tab"
            data-bs-target="#navs-justified-frequency"
            aria-controls="navs-justified-frequency"
            aria-selected="false"
        >
            Reminder Frequency
        </button>
    </li>
    <li class="nav-item">
        <button
            type="button"
            class="nav-link feed"
            role="tab"
            data-bs-toggle="tab"
            data-bs-target="#navs-justified-feed"
            aria-controls="navs-justified-feed"
            aria-selected="false"
        >
            Feedback
        </button>
    </li>

    <li class="nav-item">
        <button
            type="button"
            class="nav-link vas"
            role="tab"
            data-bs-toggle="tab"
            data-bs-target="#navs-justified-vas"
            aria-controls="navs-justified-vas"
            aria-selected="false"
        >
            Value Added Services
        </button>
    </li>

    
</ul>

                                <form role="form" id="web_setting_form" method="post">
                                @csrf
                                <div class="tab-content" style="box-shadow: none">
                                    
                                    <div class="tab-pane fade show active" id="navs-justified-prices" role="tabpanel"  >
                                        <div class="col-xxl">
                                            <div class="card mb-4" style="box-shadow: none">
                                                <div class="card-header d-flex align-items-center justify-content-between">
                                                </div>
                                                <div class="card-body">
                                                    
                                                        <div class="row">
                                                          
                                                        <div class="col-md-12">

                                                        <div class="row">

                                                        <div class="col-sm-3 ">
                                                        <label>Unhold Price<span style="color: red">*</span></label>
                                                         </div>

                                                            <div class="col-sm-9">
                                                            <input type="number" class="form-control valid-num" id="reactivation_price" name="reactivation_price" placeholder="Enter Reactivation Price" min="0" value="{{$getSettingData->reactivation_price}}" onKeyPress="if(this.value.length==5) return false;"/>
                                                            </div>

                                                        </div>


                                                        <div class="row mt-3">

                                                            <div class="col-sm-3">
                                                        <label>Restoration Price <span style="color: red">*</span></label>
                                                         </div>

                                                            <div class="col-sm-9">
                                                            <input type="number" class="form-control valid-num" id="hold_deduction_price" name="hold_deduction_price" placeholder="Enter Hold Deduction Price" min="0" value="{{$getSettingData->hold_deduction_price}}" onKeyPress="if(this.value.length==5) return false;" />
                                                            </div>

                                                       </div>

                                                            <div class="row mt-3">

                                                            <div class="col-sm-3">
                                                           <label>Tax (in %)<span style="color: red">*</span></label>
                                                            </div>

                                                            <div class="col-sm-9">
                                                            <input type="number" class="form-control valid-per" id="service_tax" name="service_tax" placeholder="Enter Service Tax" min="0" value="{{$getSettingData->service_tax}}" />
                                                            </div>


                                                        </div>


                                                        <div class="row mt-3">

<div class="col-sm-3">
<label>Bulk Domain Discount (in %)<span style="color: red">*</span></label>
</div>

<div class="col-sm-9">
<input type="number" class="form-control valid-per" id="bulk_domain_discount" name="bulk_domain_discount" placeholder="Enter Service Tax" min="0" value="{{$getSettingData->bulk_domain_discount}}" />
</div>


</div>



<div class="row mt-3">

<div class="col-sm-3">
<label>Bulk DNS Discount (in %)<span style="color: red">*</span></label>
</div>

<div class="col-sm-9">
<input type="number" class="form-control valid-per" id="bulk_dns_discount" name="bulk_dns_discount" placeholder="Enter Service Tax" min="0" value="{{$getSettingData->bulk_dns_discount}}" />
</div>


</div>
                            
                                                        
                                                        </div>
                                                           
                                                        </div>
                                                    

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                  

                                    <div class="tab-pane fade " id="navs-justified-period" role="tabpanel"  >
                                        <div class="col-xxl">
                                            <div class="card mb-4" style="box-shadow: none">
                                                <div class="card-header d-flex align-items-center justify-content-between">
                                                </div>
                                                <div class="card-body">
                                                    
                                                        <div class="row">
                                                          
                                                        <div class="col-md-12">

                                                        <div class="row">

                                                        <div class="col-sm-3 ">
                                                        <label>Hold Domain Period (in days)<span style="color: red">*</span></label>
                                                         </div>

                                                            <div class="col-sm-9">
                                                            <input type="number" class="form-control days special" id="hold_domain_period" name="hold_domain_period" placeholder="" max="100" value="{{$getSettingData->hold_domain_period ?? 0}}" onKeyPress="if(this.value.length==3) return false;" />
                                                            </div>

                                                        </div>


                                                        <div class="row mt-3">

                                                            <div class="col-sm-3">
                                                        <label>Restorable Domain Period (in days)<span style="color: red">*</span></label>
                                                         </div>

                                                            <div class="col-sm-9">
                                                            <input type="number" class="form-control days special" id="restorable_domain_period" name="restorable_domain_period" placeholder="" max="100" value="{{$getSettingData->restorable_domain_period ?? 0 }}" onKeyPress="if(this.value.length==3) return false;"  />
                                                            </div>

                                                       </div>

                                                          
                                                        
                                                        </div>
                                                           
                                                        </div>
                                                    

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                  


                                    <div class="tab-pane fade " id="navs-justified-frequency" role="tabpanel"  >
                                        <div class="col-xxl">
                                            <div class="card mb-4" style="box-shadow: none">
                                                <div class="card-header d-flex align-items-center justify-content-between">
                                                </div>
                                                <div class="card-body">
                                                    
                                                        <div class="row">
                                                          
                                                        <div class="col-md-12">

                                                        <div class="row">

                                                        <div class="col-sm-3 ">
                                                        <label>Hold Domain Reminder Frequency (in days)<span style="color: red">*</span></label>
                                                         </div>

                                                            <div class="col-sm-9">
                                                            <input type="number" class="form-control days special" id="hold_domain_reminder_period" name="hold_domain_reminder_period" placeholder="" max="100" value="{{$getSettingData->hold_domain_reminder_period ?? 0}}"  onKeyPress="if(this.value.length==3) return false;" />
                                                            </div>

                                                        </div>


                                                        <div class="row mt-3">

                                                            <div class="col-sm-3">
                                                        <label>Restorable Reminder Frequency (in days)<span style="color: red">*</span></label>
                                                         </div>

                                                            <div class="col-sm-9">
                                                            <input type="number" class="form-control days special" id="restorable_domain_reminder_period" name="restorable_domain_reminder_period" placeholder="" max="100" value="{{$getSettingData->restorable_domain_reminder_period ?? 0}}" onKeyPress="if(this.value.length==3) return false;" />
                                                            </div>

                                                       </div>

                                                          
                                                        
                                                        </div>
                                                           
                                                        </div>
                                                    

                                                </div>
                                            </div>
                                        </div>
                                    </div>


                                    <div class="tab-pane fade " id="navs-justified-vas" role="tabpanel"  >
                                        <div class="col-xxl">
                                            <div class="card mb-4" style="box-shadow: none">
                                                <div class="card-header d-flex align-items-center justify-content-between">
                                                </div>
                                                <div class="card-body">
                                                    
                                                        <div class="row">
                                                          
                                                        <div class="col-md-12">

                                                        <div class="row">

                                                        <div class="col-sm-3 ">
                                                        <label>WaaS Free Storage (in GB)<span style="color: red">*</span></label>
                                                         </div>

                                                            <div class="col-sm-9">
                                                            <input type="number" step="any" class="form-control " id="ewaas_free" name="ewaas_free" placeholder="" max="100" min="0.1" value="{{$getSettingData->ewaas_free ?? 0}}"  onKeyPress="if(this.value.length==3) return false;" />
                                                            </div>

                                                        </div>


                                                        <div class="row mt-3">

                                                            <div class="col-sm-3">
                                                        <label>WaaS Price (Per 1GB)<span style="color: red">*</span></label>
                                                         </div>

                                                            <div class="col-sm-9">
                                                            <input type="number" class="form-control " min="1" id="ewaas_pergb" name="ewaas_pergb" placeholder=""  value="{{$getSettingData->ewaas_pergb ?? 0}}" onKeyPress="if(this.value.length==5) return false;" />
                                                            </div>

                                                       </div>

<div class="row mt-3">

<div class="col-sm-3">
<label>L-MaaS Free Storage (in GB)<span style="color: red">*</span></label>
</div>

<div class="col-sm-9">
<input type="number" step="any" class="form-control " id="elmaas_free" name="elmaas_free" placeholder="" min="0.1"  value="{{$getSettingData->elmaas_free ?? 0}}" onKeyPress="if(this.value.length==3) return false;" />
</div>

</div>

<div class="row mt-3">

<div class="col-sm-3">
<label>L-MaaS Price (Per 1GB)<span style="color: red">*</span></label>
</div>

<div class="col-sm-9">
<input type="number" class="form-control " id="elmaas_pergb" name="elmaas_pergb" placeholder=""  min="1" value="{{$getSettingData->elmaas_pergb ?? 0}}" onKeyPress="if(this.value.length==5) return false;" />
</div>

</div>

                                                          
                                                        
                                                        </div>
                                                           
                                                        </div>
                                                    

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                  

                                    <div class="tab-pane fade " id="navs-justified-epp" role="tabpanel"  >
                                        <div class="col-xxl">
                                            <div class="card mb-4" style="box-shadow: none">
                                                <div class="card-header d-flex align-items-center justify-content-between">
                                                </div>
                                                <div class="card-body">
                                                    
                                                        <div class="row">
                                                          
                                                        <div class="col-md-12">

                                                        <div class="row">

                                                        <div class="col-sm-2">
                                                        <label>Interface <span style="color: red">*</span></label>
                                                         </div>

                                                            <div class="col-sm-4">
                                                            <input type="text" class="form-control" id="interface" name="interface" placeholder="Email Address 1" maxlength="35" value="{{$getSettingData->interface}}" />
                                                            </div>


                                                            <div class="col-sm-2">
                                                        <label>Hostname<span style="color: red">*</span></label>
                                                         </div>

                                                            <div class="col-sm-4">
                                                            <input type="text" class="form-control" id="hostname" name="hostname" placeholder="Email Address 2" maxlength="35" value="{{$getSettingData->hostname}}" />
                                                            </div>


                                                            

                                                        </div>


                                


<div class="row mt-3">

<div class="col-sm-2">
<label>Port<span style="color: red">*</span></label>
</div>

<div class="col-sm-4">
<input type="text" class="form-control" id="port" name="port" placeholder="Email Address Optional" maxlength="35" value="{{$getSettingData->port}}" />
</div>

<div class="col-sm-2">
<label>Userid<span style="color: red">*</span></label>
</div>

<div class="col-sm-4">
<input type="text" class="form-control" id="userid" name="userid" placeholder="Email Address Optional" maxlength="35" value="{{$getSettingData->userid}}" />
</div>

</div>



<div class="row mt-3">

<div class="col-sm-2">
<label>Password<span style="color: red">*</span></label>
</div>

<div class="col-sm-4">
<input type="text" class="form-control" id="password" name="password" placeholder="Email Address Optional" maxlength="35" value="{{$getSettingData->password}}" />
</div>


<div class="col-sm-2">
<label>Logging<span style="color: red">*</span></label>
</div>

<div class="col-sm-4">
<select class="form-control" id="logging" name="logging">
<option {{ $getSettingData->logging ? 'selected' : '' }} value="1">True</option>
<option {{ $getSettingData->logging ? '' : 'selected' }} value="0">False</option>
</select>
</div>


</div>

<div class="row mt-3">

<div class="col-sm-2">
<label>Certificate File<span style="color: red">*</span></label>
</div>

<div class="col-sm-4">
<input type="text" class="form-control" id="certificatefile" name="certificatefile" placeholder="Email Address Optional" maxlength="35" value="{{$getSettingData->certificatefile}}" />
</div>

<div class="col-sm-2">
<label>Certificate Password<span style="color: red">*</span></label>
</div>

<div class="col-sm-4">
<input type="text" class="form-control" id="certificatepassword" name="certificatepassword" placeholder="Email Address Optional" maxlength="35" value="{{$getSettingData->certificatepassword}}" />
</div>

</div>


<div class="row mt-3">

<div class="col-sm-2">
<label>Verify peer<span style="color: red">*</span></label>
</div>

<div class="col-sm-4">
<select class="form-control" id="verifypeer" name="verifypeer">
                      <option {{ $getSettingData->verifypeer ? 'selected' : '' }} value="1">True</option>
                      <option {{ $getSettingData->verifypeer ? '' : 'selected' }} value="0">False</option>
                    </select>
</div>


<div class="col-sm-2">
<label>Verify Peername<span style="color: red">*</span></label>
</div>

<div class="col-sm-4">
<select class="form-control" id="verifypeername" name="verifypeername">
<option {{ $getSettingData->verifypeername ? 'selected' : '' }} value="1">True</option>
<option {{ $getSettingData->verifypeername ? '' : 'selected' }} value="0">False</option>
</select>
</div>


</div>


<div class="row mt-3">

<div class="col-sm-2">
<label>Allow Self signed<span style="color: red">*</span></label>
</div>

<div class="col-sm-4">
<select class="form-control" id="allowselfsigned" name="allowselfsigned">
                      <option {{ $getSettingData->allowselfsigned ? 'selected' : '' }} value="1">True</option>
                      <option {{ $getSettingData->allowselfsigned ? '' : 'selected' }} value="0">False</option>
</select>
</div>

</div>



                                                          
                                                        
                                                        </div>
                                                           
                                                        </div>
                                                    

                                                </div>
                                            </div>
                                        </div>
                                    </div>



                                    <!-- <div class="tab-pane fade " id="navs-justified-vas" role="tabpanel"  >
                                        <div class="col-xxl">
                                            <div class="card mb-4" style="box-shadow: none">
                                                <div class="card-header d-flex align-items-center justify-content-between">
                                                </div>
                                                <div class="card-body">
                                                    
                                                        <div class="row">
                                                          
                                                        <div class="col-md-12">

                                                        <div class="row">

                                                        <div class="col-sm-3 ">
                                                        <label>WaaS Free Storage (in GB)<span style="color: red">*</span></label>
                                                         </div>

                                                            <div class="col-sm-9">
                                                            <input type="number" step="any" class="form-control " id="ewaas_free" name="ewaas_free" placeholder="" max="100" value="{{$getSettingData->ewaas_free ?? 0}}"  onKeyPress="if(this.value.length==3) return false;" />
                                                            </div>

                                                        </div>


                                                        <div class="row mt-3">

                                                            <div class="col-sm-3">
                                                        <label>WaaS Price (Per 1GB)<span style="color: red">*</span></label>
                                                         </div>

                                                            <div class="col-sm-9">
                                                            <input type="number" class="form-control " id="ewaas_pergb" name="ewaas_pergb" placeholder=""  value="{{$getSettingData->ewaas_pergb ?? 0}}" onKeyPress="if(this.value.length==5) return false;" />
                                                            </div>

                                                       </div>

<div class="row mt-3">

<div class="col-sm-3">
<label>L-MaaS Free Storage (in GB)<span style="color: red">*</span></label>
</div>

<div class="col-sm-9">
<input type="number" step="any" class="form-control " id="elmaas_free" name="elmaas_free" placeholder=""  value="{{$getSettingData->elmaas_free ?? 0}}" onKeyPress="if(this.value.length==3) return false;" />
</div>

</div>

<div class="row mt-3">

<div class="col-sm-3">
<label>L-MaaS Price (Per 1GB)<span style="color: red">*</span></label>
</div>

<div class="col-sm-9">
<input type="number" class="form-control " id="elmaas_pergb" name="elmaas_pergb" placeholder=""  value="{{$getSettingData->elmaas_pergb ?? 0}}" onKeyPress="if(this.value.length==5) return false;" />
</div>

</div>

                                                          
                                                        
                                                        </div>
                                                           
                                                        </div>
                                                    

                                                </div>
                                            </div>
                                        </div>
                                    </div> -->

                                    <div class="tab-pane fade " id="navs-justified-feed" role="tabpanel"  >
                                        <div class="col-xxl">
                                            <div class="card mb-4" style="box-shadow: none">
                                                <div class="card-header d-flex align-items-center justify-content-between">
                                                </div>
                                                <div class="card-body">
                                                    
                                                        <div class="row">
                                                          
                                                        <div class="col-md-12">

                                                        <div class="row">

                                                        <div class="col-sm-3 ">
                                                        <label>Email Address 1<span style="color: red">*</span></label>
                                                         </div>

                                                            <div class="col-sm-9">
                                                            <input type="email" class="form-control" id="email_address_one" name="email_address_one" placeholder="Email Address 1" maxlength="35" value="{{$getSettingData->email_address_one}}" />
                                                            </div>

                                                        </div>


                                                        <div class="row mt-3">

                                                            <div class="col-sm-3">
                                                        <label>Email Address 2<span style="color: red">*</span></label>
                                                         </div>

                                                            <div class="col-sm-9">
                                                            <input type="email" class="form-control" id="email_address_two" name="email_address_two" placeholder="Email Address 2" maxlength="35" value="{{$getSettingData->email_address_two}}" />
                                                            </div>

                                                       </div>


<div class="row mt-3">

<div class="col-sm-3">
<label>Email Address (Optional)</label>
</div>

<div class="col-sm-9">
<input type="email" class="form-control" id="email_address_optional" name="email_address_optional" placeholder="Email Address Optional" maxlength="35" value="{{$getSettingData->email_address_optional}}" />
</div>

</div>

                                                          
                                                        
                                                        </div>

                                                        </div>
                                                    

                                                </div>
                                            </div>
                                        </div>
                                    </div>


<!-- 
                                    <div class="tab-pane email" id="navs-justified-email" role="tabpanel">
                                        <div class="col-xxl">
                                            <div class="card mb-4" style="box-shadow: none">
                                              
                                                <div class="card-body">
                                                    
                                                        <div class="row">

                                                        <div class="col-sm-2 mt-3">
                                                        <label>Domain 90 Days Reminder<span style="color: red">*</span></label>
                                                         </div>
                                                         

                                                            <div class="col-sm-4  mt-3">
                                                              
                                                            <textarea class="form-control" name="email_90days" id="email_90days rows="2">{{$getSettingData->email_90days}} </textarea>

                                                            </div>

                                                            <div class="col-sm-2  mt-3">
                                                            <label>Domain 60 Days Reminder<span style="color: red">*</span></label>
                                                            </div>

                                                            <div class="col-sm-4  mt-3">
                                                            <textarea class="form-control" name="email_60days" id="email_60days"  rows="2">{{$getSettingData->email_60days}}</textarea>
                                                            </div>

                                                            <div class="col-sm-2  mt-3">
                                                            <label>Domain 45 Days Reminder<span style="color: red">*</span></label>
                                                            </div>

                                                            <div class="col-sm-4  mt-3">
                                                            <textarea class="form-control" name="email_45days" id="email_45days"  rows="2">{{$getSettingData->email_45days}}</textarea>
                                                            </div>

                                                            <div class="col-sm-2  mt-3">
                                                            <label>Domain 30 Days Reminder<span style="color: red">*</span></label>
                                                            </div>

                                                            <div class="col-sm-4  mt-3">
                                                            <textarea class="form-control" name="email_30days" id="email_30days" rows="2">{{$getSettingData->email_30days}}</textarea>
                                                            </div>

                                                            <div class="col-sm-2  mt-3">
                                                            <label>Domain 15 Days Reminder<span style="color: red">*</span></label>
                                                            </div>

                                                            <div class="col-sm-4  mt-3">
                                                            <textarea class="form-control" name="email_15days" id="email_15days" rows="2">{{$getSettingData->email_15days}}</textarea>
                                                            </div>

                                                            <div class="col-sm-2  mt-3">
                                                            <label>Domain 7 Days Reminder<span style="color: red">*</span></label>
                                                            </div>

                                                            <div class="col-sm-4  mt-3">
                                                            <textarea class="form-control" name="email_7days" id="email_7days"  rows="2">{{$getSettingData->email_7days}}</textarea>
                                                            </div>

                                                            <div class="col-sm-2  mt-3">
                                                            <label>Domain Hold<span style="color: red">*</span></label>
                                                            </div>

                                                            <div class="col-sm-4  mt-3">
                                                            <textarea class="form-control" name="email_hold" id="email_hold" rows="2">{{$getSettingData->email_hold}}</textarea>
                                                            </div>

                                                            <div class="col-sm-2  mt-3">
                                                            <label>Domain Restorable<span style="color: red">*</span></label>
                                                            </div>

                                                            <div class="col-sm-4  mt-3">
                                                            <textarea class="form-control" name="email_restorable" id="email_restorable" rows="2">{{$getSettingData->email_restorable}}</textarea>
                                                            </div>

                                                            <div class="col-sm-2  mt-3">
                                                            <label>Domain Delete<span style="color: red">*</span></label>
                                                            </div>

                                                            <div class="col-sm-4  mt-3">
                                                            <textarea class="form-control" name="email_delete" id="email_delete" rows="2">{{$getSettingData->email_delete}}</textarea>
                                                            </div>

                                                            <div class="col-sm-2  mt-3">
                                                            <label>Domain Registered<span style="color: red">*</span></label>
                                                            </div>

                                                            <div class="col-sm-4  mt-3">
                                                            <textarea class="form-control" name="email_registered" id="email_registered" rows="2">{{$getSettingData->email_registered}}</textarea>
                                                            </div>

                                                            <div class="col-sm-2  mt-3">
                                                            <label>Domain Renewed<span style="color: red">*</span></label>
                                                            </div>

                                                            <div class="col-sm-4  mt-3">
                                                            <textarea class="form-control" name="email_renewed" id="email_renewed" rows="2">{{$getSettingData->email_renewed}}</textarea>
                                                            </div>

                                                            <div class="col-sm-2  mt-3">
                                                            <label>Document Clarification<span style="color: red">*</span></label>
                                                            </div>

                                                            <div class="col-sm-4  mt-3">
                                                            <textarea class="form-control" name="email_clarification" id="email_clarification" rows="2">{{$getSettingData->email_clarification}}</textarea>
                                                            </div>

                                                            <div class="col-sm-2  mt-3">
                                                            <label>Document Approved<span style="color: red">*</span></label>
                                                            </div>

                                                            <div class="col-sm-4  mt-3">
                                                            <textarea class="form-control" name="email_approved" id="email_approved" rows="2">{{$getSettingData->email_approved}}</textarea>
                                                            </div>

                                                            <div class="col-sm-2  mt-3">
                                                            <label>Name Server Updation<span style="color: red">*</span></label>
                                                            </div>

                                                            <div class="col-sm-4  mt-3">
                                                            <textarea class="form-control" name="email_nameserver" id="email_nameserver" rows="2">{{$getSettingData->email_nameserver}}</textarea>
                                                            </div>

                                                        </div>
                                                    
                                                </div>
                                            </div>
                                        </div>
                                    </div> -->

        <div class="mb-3">
          @if($add)
          <button class="btn btn-success mr-4 float-end" id="web_setting_btn" name="action" value="Submit">Submit</button>
          @endif
        </div>

        </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>


@endsection
@section("js")
<script>
   $('.valid-num').keypress(function(event) {
    var charCode = (event.which) ? event.which : event.keyCode;
    var inputValue = $(this).val();
    var decimalIndex = inputValue.indexOf('.');
      if (charCode == 46) {
      if (decimalIndex != -1 || inputValue.length === 0 || inputValue.length > 14) {
        event.preventDefault();
      }
    } else if ((charCode < 48 || charCode > 57) || (decimalIndex != -1 && inputValue.length - decimalIndex > 2)) {
      event.preventDefault();
    } else if (inputValue.length >= 11 && decimalIndex === -1) {
      event.preventDefault();
    }
  });

  $('.special').on('keypress',function(e){

var regex=new RegExp("^[0-9]");
var key=String.fromCharCode(!e.charCode ? e.which :e.charCode);
if(!regex.test(key)){
    e.preventDefault();
    return false;
}

});


  $('.valid-per').keypress(function(event) {
    var charCode = (event.which) ? event.which : event.keyCode;
    var inputValue = $(this).val();
    var decimalIndex = inputValue.indexOf('.');
      if (charCode == 46) {
      if (decimalIndex != -1 || inputValue.length === 0 || inputValue.length > 2) {
        event.preventDefault();
      }
    } else if ((charCode < 48 || charCode > 57) || (decimalIndex != -1 && inputValue.length - decimalIndex > 2)) {
      event.preventDefault();
    } else if (inputValue.length >= 4 && decimalIndex === -1) {
      event.preventDefault();
    }
  });

  // $('.valid-per').keypress(function(event) {
  //   var charCode = (event.which) ? event.which : event.keyCode;
  //   var inputValue = $(this).val();
  //   var decimalIndex = inputValue.indexOf('.');
  //     if (charCode == 46) {
  //     if (decimalIndex != -1 || inputValue.length === 0 || inputValue.length > 2) {
  //       event.preventDefault();
  //     }
  //   } else if ((charCode < 48 || charCode > 57) || (decimalIndex != -1 && inputValue.length - decimalIndex > 2)) {
  //     event.preventDefault();
  //   } else if (inputValue.length >= 4 && decimalIndex === -1) {
  //     event.preventDefault();
  //   }
  // });

  $('#web_setting_form').validate({
    rules: {
      reactivation_price: {required: true,},
      hold_deduction_price: {required: true,},
      service_tax: {required: true},
      account_number: {required: true, maxlength:16},
      branch_name: {required: true,},
      email: {required: true,},
      email_address_one: {required: true,},
      email_address_two: {required: true,},
      hold_domain_period: {required: true,},
      restorable_domain_period: {required: true,},
      hold_domain_reminder_period: {required: true,},
      restorable_domain_reminder_period: {required: true,},
    },
    messages:
    {
      reactivation_price:{required: "Please enter reactivation Price",number:"Please enter valid reactivation Price"},
      hold_deduction_price:{required: "Please enter hold deduction price",number:"Please enter valid hold deduction price", maxlength:"Please enter valid hold deduction price"},
      service_tax:{required: "Please enter service tax in %",number:"Please enter valid service tax in %"},
      account_number:{required: "Please enter account number", number:"Please enter valid account number", maxlength:"Please enter valid account number"},
      branch_name:{required: "Please enter branch name",},
      email:{required: "Please enter email id",},
      email_address_one:{required: "Please enter email address 1",},
      email_address_two:{required: "Please enter email address 2",},
      hold_domain_period:{required: "This field is required",},
      restorable_domain_period:{required: "This field is required"},
      ewaas_free:{minlength: "please enter free space greater than 0.1"},
      elmaas_free:{minlength: "please enter free space greater than 0.1"},
      hold_domain_reminder_period:{required: "This field is required"},
      restorable_domain_reminder_period:{required: "This field is required"},
    },
    submitHandler:function(form)
    {
      $.ajaxSetup({
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
      });
      $.ajax({
        url:"{{route('admin.add-setting')}}",
        type:'POST',
        dataType:'json',
        data:$("#web_setting_form").serialize(),
        cache: false,
        beforeSend: function(){
          $(".loader-area").show();
        },
        success:function(res)
        {
          if(res.status=='success')
          {
            Swal.fire({
              position: 'center',
              icon: 'success',
              text: res.message,
              showConfirmButton: true,
            }).then(function () {
                window.location = "{{route('admin.setting-view')}}";
            });
          }
          else
          {
           Swal.fire({
              position: 'center',
              icon: 'success',
              text: res.message,
              showConfirmButton: false,
            });
          }
        },
        complete: function(){
        $("form").trigger("reset");
        $("#web_setting_btn").prop('disabled',false);
        },
      });
    }
  });
</script>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const tabButtons = document.querySelectorAll('[data-bs-toggle="tab"]');
        const tabContents = document.querySelectorAll('.tab-pane');

        tabButtons.forEach(button => {
            button.addEventListener('click', function () {
                // Remove 'active' class from all tab buttons and contents
                tabButtons.forEach(btn => btn.classList.remove('active'));
                tabContents.forEach(content => content.classList.remove('show', 'active'));

                // Add 'active' class to the clicked tab button and corresponding content
                const targetTab = document.querySelector(button.getAttribute('data-bs-target'));
                button.classList.add('active');
                targetTab.classList.add('show', 'active');
            });
        });
    });
</script>

@endsection
