@extends('layouts.AdminLayout')

@section('content')

<?php

$action='';

$userid=Auth::guard('admin')->user()->id;

$edit=$del=$add=true;
$priv=getUserHasRoleProgram($userid,4);

if($priv!=null){
    $add=$priv->add_priv==1 ?true:false;
}
$head_name = get_heading_name(4);
if($head_name!=null){
    $heading_name= $head_name;
}else
{
	$heading_name="Program Master";
}

?>

<div class="content-wrapper">

	<div class="container-xxl flex-grow-1 container-p-y">
		<h4 class="fw-bold py-3 mb-2">{{$heading_name}}</h4>

		<div class="card">
			<div style="padding:20px">

				<div class="col-sm-3">

					<div class="form-group mt-1 mb-4">
						<label for="">Module</label>
						<select class="mod_id form-control" name="" id="">
							<option value="">All Module</option>
							@foreach($modules as $module)
							<option value="{{$module->id}}">{{$module->menu}}</option>
							@endforeach
						</select>
					</div>

				</div>

				<div class="table-responsive text-nowrap">
					@if (Session::has('success'))
					<div class="alert alert-success">{{ Session::get('success') }}</div>
					@endif

					@if (Session::has('error'))
					<div class="alert alert-danger">{{ Session::get('error') }}</div>
					@endif
					<table class="table table-striped table-bordered dataTable no-footer" id="dataTable" width="100%" cellspacing="0">
						<thead class="table-secondary">
							<tr>
								<th>S.No.</th>
								<th>Description</th>
								<th>Module</th>
								<th>Action</th>
							</tr>
						</thead>

						<tbody>

						</tbody>
					</table>
				</div>

				<div class="demo-inline-spacing">
					<br>
					@if($add)
					<button type="button" class="btn btn-primary addbuttons" disabled>Add</button>
					@endif
					<br><br>
				</div>
			</div>
		</div>

		<div class="card mt-3">

			<div class=" createform d-none">

				<div class="card cblack">

					<div class="card-body">

						<form method="post" id="departmentForm">
							{!! csrf_field() !!}

							<div class="form-group mt-3">
								<label for="">Module</label>
								<select class=" form-control" name="module_id" id="module_id">
									<option value="">Select Module</option>
									@foreach($modules as $module)
									<option value="{{$module->id}}">{{$module->menu}}</option>
									@endforeach
								</select>
							</div>

							<div class="form-group mt-3">
								<label for="" class=" font-layout">Name <span class="inputlabelmedetory text-err"></span></label>
								<input type="text" name="description" id="description" class="form-control specialchar" placeholder="" onKeyPress="if(this.value.length==30) return false;">
							</div>




							<div class="form-group">
								<!-- <label for="" class=" font-layout">Status <span class="inputlabelmedetory text-err"></span></label> -->
								<select name="status" class="form-control" id="status" hidden>
									<option value="active" selected>Active</option>
									<option value="in-active">In-active</option>
								</select>
							</div>

							<div class="demo-inline-spacing">
								<br>
								<button type="submit" class="btn btn-primary submit ">Submit</button>
								<button type="button" class="btn btn-danger cancelbutton ">Cancel</button>
								<br><br>
							</div>

						</form>
					</div>
				</div>
			</div>

			<div class="updateform d-none">
				<div class="card cblack">

					<div class="card-body">

						<form method="post" id="updateDesignationForm" action="#">
							{!! csrf_field() !!}
							<input type="hidden" name="id" id="id" />

							<div class="form-group mt-3">
								<label for="">Module</label>
								<select class="module_id form-control" name="module_id" id="">
									<option value="">Select Module</option>
									@foreach($modules as $module)
									<option value="{{$module->id}}">{{$module->menu}}</option>
									@endforeach
								</select>
							</div>

							<div class="form-group mt-3">
								<label for="" class=" font-layout">Name <span class="inputlabelmedetory text-err"></span></label>
								<input type="text" name="description" id="" class="description form-control specialchar" placeholder="" onKeyPress="if(this.value.length==30) return false;">
							</div>



							<div class="form-group ">
								<!-- <label for="" class=" font-layout">Status <span class="inputlabelmedetory text-err"></span></label> -->
								<select name="status" class="status form-control" hidden>
									<option value="active" selected>Active</option>
									<option value="in-active">In-active</option>
								</select>

							</div>


							<div class="demo-inline-spacing">
								<br>
								<button type="submit" class="btn btn-primary submit ">Update</button>
								<button type="button" class="btn btn-danger cancelbutton ">Cancel</button>
								<br><br>
							</div>


						</form>

					</div>
				</div>

			</div>

			<div class="viewform d-none">
				<div class="card cblack">
					<!-- <h4 class="fw-bold font-weight-bold card-header headingtext font-layout">{{ __('Program Details') }}</h4> -->
					<div class="card-body">

						<form>

							<div class="form-group mt-3">
								<label for="">Module</label>
								<select class="module_id1 form-control" name="module_id" id="" disabled>
									<option value="">Select Module</option>
									@foreach($modules as $module)
									<option value="{{$module->id}}">{{$module->menu}}</option>
									@endforeach
								</select>
							</div>

							<div class="form-group mt-3">
								<label for="" class=" font-layout">Name <span class="inputlabelmedetory text-err"></span></label>
								<input type="text" name="description" id="" class="description1 form-control" placeholder="" disabled>
							</div>

							<div class="form-group  d-none">
								<label for="" class=" font-layout">Status <span class="inputlabelmedetory text-err"></span></label>
								<select name="status" class="status1 form-control" id="" disabled>
									<option value=" ">Select Status</option>
									<option value="active">Active</option>
									<option value="in-active">In-active</option>
								</select>
							</div>

							<br>
							<button type="button" class="btn btn-danger cancelbutton">Cancel</button>
						</form>
					</div>
				</div>
			</div>
		</div>

		@endsection
		@section("js")
		<script type="text/javascript">
			$(document).ready(function() {
				var _ = $('body');
				var createRecord = 'Are you sure you want to save the record?';
				var updateRecord = 'Are you sure you want to modify this record?';
				var deleteRecord = 'Are you sure you want to delete this record?';

				var table = $('#dataTable').DataTable({
				processing: true,
				serverSide: true,
				"ajax": {
                    "url": "{{route('program.ajaxcall')}}",
                    "type": "GET",
                    "datatype": "json",
					"data": function(d){
						d.module_id = $('.mod_id').val();
					  }
                },
				
				columns: [{
							data: 'id'
						},
						{
							data: 'description',
							orderable: false
						},
						{
							data: 'module',
							orderable: false
						},
						{
							data: 'Action',
							orderable: false
						},
					]
				});

				$('body').on('change', '.mod_id', function() {
				
				table.ajax.reload();
			
		        });

$('.specialchar').on('keypress',function(e){

var regex=new RegExp("^[a-zA-Z&. ]");
var key=String.fromCharCode(!e.charCode ? e.which :e.charCode);
if(!regex.test(key)){
    e.preventDefault();
    return false;
}

});


				$('body').on('click', '.delete', function() {

					var id = $(this).attr('data-id');
					if (confirm(deleteRecord)) {
						$('.viewform').addClass('d-none');
						$('.updateform').addClass('d-none');
						$('.createform').addClass('d-none');
						$.ajaxSetup({
							headers: {
								'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
							}
						});

						$.ajax({
							url: "{{route('program.delete')}}",
							dataType: "json",
							type: "post",
							data: {
								'id': id
							},
							success: function(response) {
								$('#name').val('');
								$('.name').val('');
								if (response.status == 'success') {

									table.ajax.reload();

								} else if (response.status == 'error') {

									alert(response.message);

								} else if (response.status == 'exceptionError') {
									CommonManager.forcelogout();
								}
							},
						});

					}
					return false;
				});

				$('body').on('submit', '#departmentForm', function(e) {
					e.preventDefault();
					var current = $(this);
					if (confirm(createRecord)) {
						$('.submit', current).attr('disabled', 'disabled');

						var Description = $('#description', current).val();

						$('.Description_error').remove();
						if (Description == '') {
							$('#description').after('<span class="Description_error" style="color:red">Please Enter Description.</span>');
							$('.submit').removeAttr('disabled');
							return false;
						}

						var data = current.serialize();
						$.ajax({
							url: "{{route('program.save')}}",
							dataType: "json",
							type: "post",
							data: data,
							success: function(response) {

								$('.submit').removeAttr('disabled');

								if (response.status == 'success') {
									$('#name').val('');
									$('.name').val('');
									table.ajax.reload();
									$('.updateform').addClass('d-none');
									$('.createform').addClass('d-none');
									$('.viewform').addClass('d-none');
								} else if (response.status == 'errors') {

									$.each(response.message, function(i, message) {
										$('#' + i).after('<span class="Description_error" style="color:red">' + message + '</span>');
									});

								} else if (response.status == 'error') {
									$('#name').after('<span class="Description_error" style="color:red">' + response.error + '</span>');
								} else if (response.status == 'exceptionError') {
									CommonManager.forcelogout();
								}
							},
						});
						return false;
					}
					return false;
				});

				$('body').on('submit', '#updateDesignationForm', function(e) {
					e.preventDefault();
					var current = $(this);
					if (confirm(updateRecord)) {
						$('.submit', current).attr('disabled', 'disabled');

						var Description = $('#updateDescription', current).val();

						$('.Description_error').remove();
						if (Description == '') {
							$('#updateDescription').after('<span class="Description_error" style="color:red">Please enter Description.</span>');
							$('.submit').removeAttr('disabled');
							return false;
						}
						$('.err').remove();
						var data = current.serialize();
						$.ajax({
							url: "{{route('program.update')}}",
							dataType: "json",
							type: "post",
							data: data,
							success: function(response) {

								$('.submit').removeAttr('disabled');

								if (response.status == 'success') {
									$('#name').val('');
									$('.name').val('');
									table.ajax.reload();
									$('.updateform').addClass('d-none');
									$('.createform').addClass('d-none');
									$('.viewform').addClass('d-none');
								} else if (response.status == 'errors') {

									$.each(response.message, function(i, message) {
										$('#updateDescription').after('<span id="Description_error" class="err" style="color:red">' + message + '</span>');
									});

								} else if (response.status == 'error') {
									$('#updateDescription').after('<span class="Description_error err" style="color:red">' + response.message + '</span>');
								} else if (response.status == 'exceptionError') {
									CommonManager.forcelogout();
								}
							},
						});
						return false;
					}
					return false;
				});
				$('body').on('click', '.view', function() {
					var id = $(this).attr('data-id');
					$('.viewform').removeClass('d-none');
					$('.updateform').addClass('d-none');
					$('.createform').addClass('d-none');
					$.ajax({
						url: "{{ route('program.get') }}",
						dataType: "json",
						type: "get",
						data: {
							'id': id
						},
						success: function(response) {

							if (response.status == 'success') {

								$('.description1').val(response.data.description);
								$('.module_id1 option[value="' + response.data.module_id + '"]').prop('selected', true);
								$('.status1 option[value="' + response.data.status + '"]').prop('selected', true);

							} else if (response.status == 'error') {

								alert(response.message);

							}

						},
					});
				});

				$('body').on('click', '.update', function() {
					var id = $(this).attr('data-id');
					$('#code').val('');
					$.ajax({
						url: "{{ route('program.get') }}",
						dataType: "json",
						type: "get",
						data: {
							'id': id
						},
						success: function(response) {

							if (response.status == 'success') {

								$('.createform').addClass('d-none');
								$('.viewform').addClass('d-none');
								$('.updateform').removeClass('d-none');
								$('#id').val(response.data.id);
								$('.description').val(response.data.description);
								$('.module_id option[value="' + response.data.module_id + '"]').prop('selected', true);
								$('.status option[value="' + response.data.status + '"]').prop('selected', true);

							} else if (response.status == 'error') {
								alert(response.message);
							}

						},
					});

				});

				$('body').on('click', '.addbutton', function() {
					$('.createform').removeClass('d-none');
					$('.updateform').addClass('d-none');
					$('.viewform').addClass('d-none');
				});

				$('body').on('click', '.cancelbutton', function() {
					$('.createform').addClass('d-none');
					$('.updateform').addClass('d-none');
					$('.viewform').addClass('d-none');
				});

			});
		</script>

		@endsection