@extends('layouts.AdminLayout')
@section('content')

<?php

$action='';

$userid=Auth::guard('admin')->user()->id;

$edit=$del=$add=true;
$priv=getUserHasRoleProgram($userid,5);

if($priv!=null){
    $add=$priv->add_priv==1 ?true:false;
}
$head_name = get_heading_name(5);
if($head_name!=null){
    $heading_name= $head_name;
}else
{
	$heading_name="User Privilege Master";
}

?>

<div class="content-wrapper">
<!-- Content -->

<div class="container-xxl flex-grow-1 container-p-y">
  	<h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light"></span>{{$heading_name}}</h4>
  	<div class="card">
        <!-- DataTales Example -->
        <div class="mb-4">
            <div class="card-body cblack">
				<form action="#" method="post" id="userprivilege">
					<div class="row mb-3">
						<div class="col-md-3">
							<div class="form-group">
								<label class="form-label text-capitalize fs-6">User</label>
								<select class="form-control" id="user_id" name="user_id">
									<option value="">Select User Name</option>
									<?php foreach($user as $userobj) {
										?>
										<option class="text-capitalize" value="{{ $userobj->id }}">{{ $userobj->username }}</option>
									<?php  } ?>
								</select>
							</div>
						</div>
						<div class="col-md-3">
							<div class="form-group">
								<label class="form-label text-capitalize fs-6">Module</label>
								<select class="form-control" id="module" name="module_id">
									<option value="">Select Module</option>
									<?php foreach($modules as $moduleobj) { ?>
										<option class="text-capitalize" value="{{ $moduleobj->id }}">{{ $moduleobj->menu }}</option>
									<?php } ?>
								</select> 
							</div>
						</div>
					</div>
					
					<input type="checkbox" class="selectall">Check All<br>
                    <div class="table-responsive tabletr tabletext mt-3">
                        <table class="table table-striped table-bordered dataTable no-footer" id="dataTable" width="100%" cellspacing="0">
                            <thead class="table-secondary">
                                <tr>
                                    <th class="fs-6 text-capitalize">S.No.</th>
									<th class="fs-6 text-capitalize">Program Description</th>
									<th class="fs-6 text-capitalize">View</th>
									<th class="fs-6 text-capitalize">Add</th>
									<th class="fs-6 text-capitalize">Edit</th>
									<th class="fs-6 text-capitalize">Delete</th>
                                </tr>
                            </thead>
                           
                            <tbody>
                                
                            </tbody>
                        </table>
                    </div>
					
					<button type="button" class="btn btn-primary addbutton d-none">Submit</button><br><br>
				</form>
			</div>
    	</div>
	</div>
</div>
@endsection
@section("js")
	<script type="text/javascript">
		$(document).ready(function() {
			
			
			var table = $('#dataTable').DataTable({
				processing: true,
				serverSide: true,
				bFilter: false,
				"ajax": {
                    "url": "{{route('privilege.ajaxcall')}}",
                    "type": "GET",
                    "datatype": "json",
					"data": function(d){
						 d.user_id = $('#user_id').val();
						 d.module_id = $('#module').val();
					  }
                },
				
				columns: [
					{ data: 'id' , orderable: false},
					{data: 'description', orderable: false},
					{ data: 'view', orderable: false },
					{ data: 'add' , orderable: false},
					{ data: 'edit' , orderable: false},
					{ data: 'delete' , orderable: false},
				]
			});
			

$('.selectall').click(function() {
    if ($(this).is(':checked')) {
        $('input:checkbox').prop('checked', true);
    } else {
        $('input:checkbox').prop('checked', false);
    }
});


			$('body').on('click', '.View_check', function() {
				if($(this).is(":checked")) {
					$('.View_Option input:checkbox').prop('checked',true);
				} else {
					$('.View_Option input:checkbox').prop('checked',false);
				}
				//return false;
			});
			
			$('body').on('click', '.addbutton', function() {
				var data = $('#userprivilege').serialize();
                $('.addbutton').attr('disabled', 'disabled');
				var params = table.$('input,select,textarea').serializeArray();
				//console.log(params); return false;
			if(confirm("Are you sure you want to save changes ?")){

				$.ajaxSetup({
					headers: {
						'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
					}
				});
				
				$.ajax({
					url: "{{ route('handleprivilege') }}",
					dataType : "json",
					type: "post",
					data : data,
					success : function(response) {
						if(response.status == 'success')
						{
							
							table.ajax.reload();
							$('.addbutton').removeAttr('disabled');
							
						} 
						else if(response.status == 'exceptionError')
						{
							// CommonManager.forcelogout();
						}
					},
				});
			};
				
			});
			
			
			$('body').on('change', '#user_id', function() {
				$('.addbutton').removeClass('d-none');

					table.ajax.reload();
				
			});
			
			$('body').on('change', '#module', function() {
				$('.addbutton').removeClass('d-none');
				table.ajax.reload();
				
			});
			
			
			$('body').on('click', '.addbutton', function() {
				$('.createform').removeClass('d-none');
				$('.updateform').addClass('d-none');
			});
			
			$('body').on('click', '.cancelbutton', function() {
				$('.createform').addClass('d-none');
				$('.updateform').addClass('d-none');
			});
			
			
			
		});
	</script>
@endsection



