<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Annexure B Undertaking</title>
    <style>
        * {
            font-family: Arial, sans-serif;
            /* margin: 0 !important ; */
            /* padding: 0 !important; */
            line-height: 1.4;
        }
        .container {
            width: 100%;
            max-width: 800px;
            margin: 0 0;
            /* padding: 20px; */
            box-sizing: border-box;
            font-family: freeserif;
        }
        .letterhead {
            font-weight: bold;
            margin-bottom: 10px;
            text-align: center;
        }
        .content {
            text-align: justify;
        }
        .signature-block {
            margin-top: 30px;
        }
        p .indent {
            text-indent:50px;
        }
    </style>
</head>
<body>

<?php

if ($details != null) {
    $detail = json_decode($details->institution_head_detail);
}

?>
    <div class="container">
        <div class="letterhead">
            <p>Annexure –‘B’</p>
            <h4>Letter of Undertaking</h4>
            <p style="font-size:14px;margin-bottom:0px  !important">(On Rs.100/- Non-Judicial Stamp Paper)</p>
            <p style="font-size:14px;margin-bottom:0px  !important">(Applicable to all Educational/Academic Institutions)</p>
        </div>
        <div class="content">
            <p style="float:right">Dated: <b>{{date('d/m/Y')}}</b></p><br><br>
                <p>
                I,  <b>{{$users->name}}</b> (name), son/daughter of <b>{{$users->father_name}}</b> aged   <b>{{$users->age}}</b> here by undertake that I am working / associated with  <b>{{$users->institute}}</b> (Name of the academic institution) as <b>{{$users->designation}}</b> Designation.
                I undertake that I am the authorized signatory/ or head of <b>{{$users->institute}}</b>, <b>{{$details->address}}</b> (Name & Address of the academic institution) and authorized to undertake, sign and execute any instrument essential and incidental to obtain official domain for the above said institute. I do hereby agree for and on behalf of the Institution or management of the educational institution that I will abide by all the terms & conditions while applying for registration of <b>{{$users->domainName}}</b> (Domain name) under edu.in / ac.in / res.in to ERNET India, a Scientific Autonomous Society of Ministry of Electronics & IT, Govt. of India. I also certify and undertake the following:
                </p>

                <ol>

            <li class="indent">
                 That the <b>{{$users->institute}}</b> (Name of the Institution) is involved in academic / educational/ research activities (attested copy of documentary proof in support of the same is enclosed) and we shall be using domain as registered and provided by ERNET India for bonafide academic/educational and or research purpose only and not for any other purpose.
            </li>
            <li class="indent">
                 That all the contact details including head (like Chancellor/ VC/Principal/ Head Master/ Director etc), of the said academic institution/organization - Admin details, billing details and Technical details provided in the ‘online registration form’ are correct.
            </li>
            <li class="indent">
                 That to the best of my knowledge, the registration of the domain name will not infringe upon or otherwise violate the rights of any third party. It shall be the responsibility of the <b>{{$users->institute}}</b>.(Name Institution/ Organization) to ensure compliance of this norm and ERNET India shall not be held responsible or liable in case of any violation in any manner whatsoever of this norm at any time.
            </li>
            <li class="indent">
                 That I am registering the domain name on behalf of institute solely for the lawful purposes and will not use for any illegal activities or any activities prohibited by law of the land and in case of default of any law or a provision/proviso thereof will be liable for punishment/penalty as per the provisions contained therein.
                </li>
            <li class="indent">
                 That the institute <b>{{$users->institute}}</b>.(Name Institution/ Organization) will not use the domain name in violation of any applicable laws or regulations not limited to provisions of the IT Act of Government of India but any law or rules or notifications applicable from time to time.
            </li>
            <li class="indent">
                That the institute will not create subdomain under this domain for its other institutes.
                </li>
            <li class="indent">
                 That ownership of the content uploaded on the website using the domain <domain name> will be of the institute. ERNET India will not be responsible for the website content.
                </li>
            <li class="indent">
                 That no illegal, offensive (including but not limited to material that is sexually explicit content or which promotes racism, bigotry, hatred or physical harm), deceptive, misleading, abusive, indecent, harassing, blasphemous, defamatory, libelous, obscene, pornographic, pedophilic or menacing; ethnically objectionable, disparaging content will be uploaded on the website using this domain <domain name>.
                </li>
            <li class="indent">
                 That no content will be uploaded on the website that is objectionable or otherwise unlawful in any manner whatsoever; or which consists of or contains software viruses, political campaigning, commercial solicitation, chain letters, mass mailings or any "spam”.
            </li>
            <li class="indent">
             That no content will be uploaded on the website that infringes upon or violates any third party’s rights including, but not limited to, intellectual property rights, rights of privacy (including without limitation unauthorized disclosure of a person’s name, e-mail address, physical address or phone number) or rights of publicity.
            </li>
            <li class="indent">
                That ERNET India will not be responsible for any hacking of institute’s website and redirection to any fraudulent activity like gaming site, bank website, any website having financial/payment.
            </li>
            <li class="indent">
             That it shall be the responsibility of the institution to update all the contact details and name server entries online using User ID and Password, failing which ERNET India will not be held liable for any issue like non-functional of domain etc arising due to it. Concerned Institution will be responsible for maintaining the ID(s) and password(s) of specific domain and handover the same to other responsible person in case of transfer, or resignation/ or superannuation of any person related to domain contact details.
            </li>
            <li class="indent">
                 That the documents i.e. approval/ affiliation / recognition by AICTE/UGC/ Central or State Education Board/ University/ Or Government (Central or State) approval (tick whichever is applicable) for academic institution(s), uploaded while applying for domain registration is certified to the extent that they are correct and true copy of originals. The Application on the letter head of the institution/ organization is signed by the Head of the Institute (like Principal/ VC/ Chancellor, Director etc.) of …….......................................………… (Name of Institution) and his/her name, phone number, and official e-mail is provided in the online form.
            </li>
            <li class="indent">
                That the institution is functioning as per the UGC Guidelines and / or AICTE/ and or Government (Central or State) norms and / or University norms and the office bearers/ Management abide by it (applicable to all institutions including private and autonomous institutions/ Colleges/ Universities ).
            </li>
            <li class="indent">
             That in future, if any dispute arises regarding office bearer (s)/ Management / Head of Institution/ or Supremacy/ or Powers etc. in our institute, ERNET India will not be held responsible in any manner whatsoever for any ownership of domain or institute. None from institution shall make ERNET India a party in the court and in such a situation, ERNET India reserves the right to take suitable action including suspension/freezing of domain name etc.
            </li>
            <li class="indent">
             That (Name of the Institute applying for domain name) indemnify ERNET India, its management and officers against any and all costs, liabilities, losses, and expenses (including, but not limited to, legal expenses) arising out of any claim, suit, action or proceeding for any act(s) and/or omissions of the Institution.
            </li>
            <li class="indent">
                That I agree to terms & conditions mentioned in the ERNET India’s Domain registration website/portal.
            </li>
        </div>
        <div class="signature-block">
            <p>Yours sincerely,</p>
            <p>(Sign & Stamp of Head/Authorized Signatory of the Institute)</p>
            <p>Full Name : <b>{{$users->name}}</b> </p>
            <p>Address :<b>{{$details->address}}</b> </p>
            <p>Mobile : <b>{{$details->mobile}}</b> </p>
            <p>Email :<b>{{$users->email}}</b>  </p>
            </p>
            <p>Encl: Certified documents</p>
            <p>To<br>
            ERNET India<br>
            (Ministry of Electronics &IT, Govt of India)<br>
            5th Floor, Block I, A Wing DMRC IT Park<br>
            Shastri Park, New Delhi 110053
            </p>
        </div>
    </div>
</body>
</html>
