<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Annexure A Application Letter</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            line-height: 1.4;
        }
        .container {
            width: 100%;
            max-width: 800px;
            margin: 0 auto;
            padding: 0 20px;
            box-sizing: border-box;
            font-family: freeserif;
        }
        .letterhead {
            font-weight: bold;
            margin-bottom: 10px;
        }
        .signature-block {
            margin-top: 30px;
        }
    </style>
</head>
<body>

<?php

if ($details != null) {
    $detail = json_decode($details->institution_head_detail);
}

$domainprice=Auth::user()->domainPrice;

if(getdiscount()!=null){

    $discount =json_encode(getdiscount()->discount);

    $offer_discount_percent = ($discount*$domainprice)/100;

    $offer_amount = ($domainprice-$offer_discount_percent);

    $taxes=json_encode(getmisc()->service_tax);

    $taxamt = ($offer_amount*$taxes)/100;

    $totalpayableamount=$offer_amount+$taxamt;


    

}else{

    $discount =0;
    
    $offer_discount_percent =0;

    $offer_amount = 0;

    $taxes=json_encode(getmisc()->service_tax);

    $taxamt = ($domainprice*$taxes)/100;

    $totalpayableamount=$domainprice+$taxamt;

}



?>

<div class="container">

    <div class="letterhead" style="float:right">
        <p>Annexure –‘A’</p>
    </div><br>
   
   <center> <h2>Application Letter</h2>
    <p>(To be given on letterhead of the institute duly signed and stamped by head of the institute)</p> </center>
    <p>
        To,<br>
       <span style="float:right">Dated: <b>{{date('d/m/Y')}}</b></span>
    </p>
    <p>
        ERNET India<br>
        5th Floor, Block- I, A Wing<br>
        DMRC IT Park, Shastri Park,<br>
        New Delhi 110053
    </p>
    <p>
       <b> Subject: Application for registration/renewal of Domain Name <b>{{$users->domainName}}</b>
        for <b>{{$users->institute}}</b> (Name of Academic Institution) <b/>
    </p>
    <p>
        I, <b>{{$users->name}}</b> (name), <b>{{$users->designation}}</b> (Designation) as head of <b>{{$users->institute}}</b>, <b>{{$details->address}}</b> (Name & Address of the academic institution) do hereby agree for and on behalf of the management of <b>{{$users->institute}}</b> that I will abide by the terms and conditions of ERNET for registering/renewing a domain name <b>{{$users->domainName}}</b> under edu.in / ac.in/ res.in. My appointment letter is enclosed.
    </p>
    <p>
        I do hereby authorize the following person, working in the institute, to act on behalf of <b>{{$users->institute}}</b> (Institute_Name) for handling all the activities related to domain name <b>{{$users->domainName}}</b>. :
    </p>
    <p>
        Name: <b>{{$users->name}}</b><br>
        Adhar No: __________________________<br>
        Designation: <b>{{$users->designation}}</b><br>
        Signature of authorized person: __________________________<br>
        Phone: <b>{{$details->phone}}</b><br>
        Email: <b>{{$users->email}}</b>
    </p>
    <p>
        Further, it is to inform that the online registration/renewal form has been filled and uploaded with the required documents. Payment has also been made online through the portal <a href="https://registry.ernet.in">https://registry.ernet.in</a> of Rs <b>{{$totalpayableamount}}  </b></b>for registering above said domain
            for<b>  {{$users->domainPeriod}} year(s) @if($nameserver!=null) @if($nameserver->server_type==1) and Rs {{$prices->price+$taxes*$prices->price/100}}  for ERNET DNS for {{$nameserver->ernet_name_server_duration_year}} year(s) therefore sum total of domain and DNS is Rs {{$totalpayableamount+$prices->price+$taxes*$prices->price/100}}  @endif @endif .
    </p>
    <p>
        Therefore, ERNET India is requested to register/renew the above said domain for <b>{{$users->institute}}</b> (name of academic institution).
    </p>
    <div class="signature-block">
        <p>Yours sincerely,</p>
        <p>Signature<br>
        (Name and Address of the Head of the Institute with sign and stamp)<br>
        Email: <b>{{$users->email}}</b><br>
        Mobile No.: <b>{{$details->mobile}}</b></p>
    </div>
</div>

</body>
</html>
