<!DOCTYPE html>
<html>
  <head>
    <meta charset="utf-8" />
    <title>Invoice</title>
    <link href="{{asset('/assets/css/bootstrap.min.css')}}" rel="stylesheet">
    <style>
      @page {
                margin: 0!important;
            }
      .invoice-box {
        max-width: 1000px;
        margin: auto;
        border: 1px solid #eee;
        box-shadow: 0 0 10px rgba(0, 0, 0, 0.15);
        font-size: 16px;
        line-height: 24px;
        font-family: 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif;
        color: #000000;
      }

      .invoice-box table {
        /* border: 1px solid #000000; */
        width: 100%;
        line-height: inherit;
        text-align: left;
      }

      .invoice-box table tr.top table td {
        text-align: justify;
        /* border: 1px solid #000 !important; */
      }

      @media only screen and (max-width: 600px) {
        .invoice-box table tr.top table td {
          width: 100%;
          display: block;
          text-align: center;
        }

        .invoice-box table tr.information table td {
          width: 100%;
          display: block;
          text-align: center;
        }
      }

   


      th,
      td {
        border: 1px solid #000;
        font-size: 15px;
        /* padding: 0.25em 0.5em; */
      }

      .large-table td {
        font-size: 12px;
      }

      .bigfont {
        font-size: 15px;
      }

      .bg-primary {
    background-color: #658fcc!important;
}

.invoice-box table tr.top table td {
    text-align: left;
    border: 1px solid #000 !important;
}

    </style>
  </head>
  <body>
    <div class="invoice-box" style="font-family: freeserif;">
      <table cellpadding="0" cellspacing="0">
        <tr class="top">
          <td colspan="2">
            <table class="table table-bordered">
              <tbody>
                <tr>
                  <table class="table table-bordered">
                    <th class="title" style="width:200px;">
                    <img src="/var/www/html/ernet/public/assets/img/Ernet-Logo.png" class="text-center img-rounded logo" style="width: 100%; max-width: 150px; margin-top: 20px;
                      margin-left: 17px;" />
                      <!-- <img src="{{asset('/assets/img/Ernet-Logo.png')}}" class="text-center img-rounded logo" style="width: 100%; max-width: 150px; margin-top: 40px;margin-left: 17px;" /> -->
                    </th>
                    <td style="text-align:center; color: #000000;" class="bigfont">
                      <p style="margin-block-start: 0%;
                                    margin-block-end: 0%;">
                        <strong> ERNET India </strong>
                        </br> 5th Floor, Block -1 <br> DMRC IT Park, Shastri Park,New Delhi 110053 <br> Tel: 011-22170580, 22170594 <br> GSTIN: 07AAATE0202A2ZS <br>
                      </p>
                      <h4 style="margin-block-start: 0%;margin-block-end: 0%;">
                        <strong> Receipt</strong>
                      </h4>
                    </td>
                </tr>
              </tbody>
              <table class="table table-bordered">
                <tbody>
                  <tr>
                    <td>
                      <strong>Receipt Number:</strong>
                    </td>
                    <td>R000{{$user->id}}<br>/{{$data->id??''}} </td>
                    <td>
                      <strong>Details of School/College<br>/Institute/University: </strong>
                    </td>
                    <td> {{$user->institute}}</td>
                  </tr>
                  <tr>
                    <td>
                      <strong>Receipt Date:</strong>
                    </td>
                    <td>{{date('d/m/Y')}}</td>
                    <td>
                      <strong>Domain Name:</strong>
                    </td>
                    <td> {{$user->domainName}}</td>
                  </tr>
                  <tr>
                    <td>
                      <strong>Place of Supply:</strong>
                    </td>
                    <td></td>
                    <td>
                      <strong>Address of School/College<br>/Institute/University: </strong>
                    </td>
                    <td> {{$user_detail->address}}</td>
                  </tr>
                </tbody>


              </table>
              <table>
                <thead>
                <tbody>
                  <tr>
                    <td style="padding: 10px;">
                      <strong>GSTIN of School/College/Institute/University:</strong> {{$user_detail->gst_no}}
                    </td>
                    <td style="padding: 10px;">
                      <strong>State:</strong> {{$user_detail->state}}
                    </td>
                  </tr>

                  <tr style="border:1px solid #000 !important;padding: 0px !important;margin: 0px;height: 20px !;">
                    <td style="">
                      <strong></strong>
                    </td>
                    <td style="text-align: right;font-size: 14px;">
                      <strong>(Amount in Rs.)</strong>
                    </td>
                  </tr>


                </tbody>
                </thead>
              </table>
              <table class="table table-bordered">
                <thead class="bg-primary text-white">
                  <tr>
                  <th style="border: 1px solid black ; ">Description of <br>Product/Service</th>
                    <th style="border: 1px solid black ; ">SAC <br> Code </th>
                    <th style="border: 1px solid black ; ">Date</th>
                    <th style="border: 1px solid black ; ">Period in <br> Year </th>
                    <th style="border: 1px solid black ; ">Amount</th>
                    <th style="border: 1px solid black ; ">Discount <br>(%)</th>
                    <th style="border: 1px solid black ; ">Discount <br>Amount</th>
                    <th colspan="2" style="border: 1px solid black ; ">CGST <table style="border: 0px solid #000 !important;">
                        <tr style="border: 0px solid #000 !important;">
                          <td style="border: 0px solid #000 !important;">Rate/Amt</td>
                          <!-- <td style="border: 0px solid #000 !important;">/<br></td>
                          <td style="border: 0px solid #000 !important;">Amt.</td> -->
                        </tr>
                      </table>
                    </th>
                    <th colspan="2" style="border: 1px solid black ; ">SGST <br>
                      <table style="border: 0px solid #000 !important;">
                        <tr style="border: 0px solid #000 !important;">
                          <td style="border: 0px solid #000 !important;">Rate/Amt</td>
                          <!-- <td style="border: 0px solid #000 !important;">/<br></td>
                          <td style="border: 0px solid #000 !important;">Amt.</td> -->
                        </tr>
                      </table>
                    </th>
                    <th colspan="2" style="border: 1px solid black ; ">IGST <table style="border: 0px solid #000 !important;">
                        <tr style="border: 0px solid #000 !important;">
                          <td style="border: 0px solid #000 !important;">Rate/Amt</td>
                          <!-- <td style="border: 0px solid #000 !important;"> / <br></td>
                          <td style="border: 0px solid #000 !important;">Amt.</td> -->
                        </tr>
                      </table>
                    </th>
                    <th style="border: 1px solid black ; "> Total Amount</th>
                  </tr>
                </thead>
                <tbody> 
                  
                                @php
                                    $ttl_amount = 0;
                                    $tax_amount = 0;
                                    $grand_total=0;
                                    $total_amount_before_tax = 0;
                                    $total_igst = 0;
                                    $service_name = "";
                                @endphp
                                @foreach($transactions as $transaction)


                                        @php
                                        $detail = json_decode($transaction->request);
                                        
                                               
                                              $ttl_amount = $ttl_amount + (int)$transaction->total_amount;
                                              $grand_total = $grand_total + (float)$transaction->total_amount;

                                              $total_igst += ($transaction->total_amount - $transaction->total_amount*100/118);
                                              $total_amount_before_tax += ($transaction->total_amount*100/118);
                                              $service_name = $transaction->transaction_type;
                                              $tot
                                    @endphp

                                    

    @if($transaction->transaction_type == 'domainRegisterWithNameServer')
                
         <tr>
          <td>Domain Fee</td>
          <td>998313</td>
          <td>{{\Carbon\Carbon::parse($transaction->created_at)->format('d/m/Y')}}</td>
          <td>{{$detail->domain_duration??0}}</td>
          <td>{{$detail->domain_price??0}}</td>

          <td>{{$detail->domain_disper??'0'}}</td>
          <td>{{$detail->domain_dis??'0'}}</td>
          <!-- <td>{{$detail->domain_disamt??0}}</td> -->

          <td>0.00</td>
          <td>0.00</td>
          <td>0.00</td>
          <td>0.00</td>
          <td>{{ $detail->domain_taxper!=null?number_format($detail->domain_taxper, 2, '.', '')??0:""}}</td>
          <td>{{ $detail->domain_tax!=null?number_format($detail->domain_tax, 2, '.', '')??0:""}}</td>
          <td>{{ $detail->domain_amount!=null?number_format($detail->domain_amount, 2, '.', '')??0:"" }}</td>
          
        </tr>


         
         <tr>
          <td>DNS Fee</td>
          <td>998313</td>
          <td>{{\Carbon\Carbon::parse($transaction->created_at)->format('d/m/Y')}}</td>
          <td>{{$detail->dns_duration!=null?$detail->dns_duration??0:""}}</td>
          <td>{{$detail->dns_price!=null?$detail->dns_price??0:""}}</td>

          <td>0</td>
          <td>0</td>

          <td>0.00</td>
          <td>0.00</td>
          <td>0.00</td>
          <td>0.00</td>
          <td>{{ $detail->dns_taxper!=null?number_format($detail->dns_taxper, 2, '.', '')??0:""}}</td>
          
          <td>{{ $detail->dns_tax!=null?number_format($detail->dns_tax, 2, '.', '')??0:""}}</td>
          <td>{{ $detail->dns_amount!=null?number_format($detail->dns_amount, 2, '.', '')??0:""}}</td>
        </tr>

        @if(isset($detail->dns_setupcharge))

        <tr>
          <td>DNS Setup Charge</td>
          <td>998313</td>
          <td>{{\Carbon\Carbon::parse($transaction->created_at)->format('d/m/Y')}}</td>
          <td>0</td>
          <td>{{ $detail->dns_setupamount }}</td>

          <td>0</td>
          <td>0</td>

          <td>0.00</td>
          <td>0.00</td>
          <td>0.00</td>
          <td>0.00</td>
          <td>{{ $detail->dns_taxamount }}.00</td>
          
          <td>36.00</td>
          <td>{{ $detail->dns_setupcharge }}.00</td>
        </tr>

        @endif

        @elseif($transaction->transaction_type == 'domainRegister')

          <tr>
          <td>Domain Fee</td>
          <td>998313</td>
          <td>{{\Carbon\Carbon::parse($transaction->created_at)->format('d/m/Y')}}</td>
          <td>
            @if(isset($detail->domain_duration))
            {{ $detail->domain_duration!=null?$detail->domain_duration??0:""}}
            @endif
          </td>
          <td>
          @if(isset($detail->domain_duration))

            {{ $detail->domain_price!=null?$detail->domain_price??0:""}}
            @endif
   
          </td>

          <td>
          @if(isset($detail->domain_disper))
  
          {{ $detail->domain_disper!=null?$detail->domain_disper??'0':""}}
          @endif
  
        </td>
          <td>
          @if(isset($detail->domain_disper))

            {{ $detail->domain_dis!=null?$detail->domain_dis??'0':""}}
          
            @endif

          </td>

          <td>0.00</td>
          <td>0.00</td>
          <td>0.00</td>
          <td>0.00</td>
          <td>
          @if(isset($detail->domain_taxper))
          {{ $detail->domain_taxper!=null?number_format($detail->domain_taxper, 2, '.', '')??0:""}}
          @endif
          </td>
          <td>
          @if(isset($detail->domain_tax))
          {{ $detail->domain_tax!=null?number_format($detail->domain_tax, 2, '.', '')??0:""}}
          @endif

        </td>
          <td>{{ $transaction->total_amount!=null?number_format($transaction->total_amount, 2, '.', '')??0:"" }}</td>
        </tr>

          @elseif(trim($transaction->transaction_type) == 'nameServerUpdate')

          <tr>
          <td>ERNET DNS Fee</td>
          <td>998313</td>
          <td>{{\Carbon\Carbon::parse($transaction->created_at)->format('d/m/Y')}}</td>
     
          <td>
            @if($detail!=null)
            {{  $detail->dns_duration!=null?$detail->dns_duration??0:""}}
            @endif
          </td>
          <td>
          @if($detail!=null)
            {{  $detail->dns_price!=null?$detail->dns_price??0:""}}
          @endif
          </td>

          <td>0</td>
          <td>0</td>

          <td>0.00</td>
          <td>0.00</td>
          <td>0.00</td>
          <td>0.00</td>
      
          <td>
          @if($detail!=null)
          {{$detail->dns_taxper!=null?number_format($detail->dns_taxper, 2, '.', '')??0:""}}
          @endif</td>
          <td>
          @if($detail!=null)
         {{$detail->dns_tax!=null?number_format($detail->dns_tax, 2, '.', '')??0:""}}
        @endif</td>
          <td>
          {{ $transaction->total_amount!=null?number_format($transaction->total_amount, 2, '.', '')??0:"" }}
          </td>

        </tr>

@if(isset($detail->dns_setupcharge))

<tr>
  <td>DNS Setup Charge</td>
  <td>998313</td>
  <td>{{\Carbon\Carbon::parse($transaction->created_at)->format('d/m/Y')}}</td>
  <td>0</td>
  <td>{{ $detail->dns_setupamount }}</td>

  <td>0</td>
  <td>0</td>

  <td>0.00</td>
  <td>0.00</td>
  <td>0.00</td>
  <td>0.00</td>
  <td>{{ $detail->dns_taxamount }}.00</td>
  
  <td>36.00</td>
  <td>{{ $detail->dns_setupcharge }}.00</td>
</tr>

@endif

         @elseif($transaction->transaction_type == 'userNameServerUpdate')

         <tr>
          <td>Other DNS </td>
          <td>998313</td>
          <td>{{\Carbon\Carbon::parse($transaction->created_at)->format('d/m/Y')}}</td>
     
          <td>0</td>
          <td>
            @if($detail)
            {{$detail->dns_price!=null?$detail->dns_price??0:""}}
            @else
            {{50}}
            @endif
          </td>

          <td>0</td>
          <td>0</td>

          <td>0.00</td>
          <td>0.00</td>
          <td>0.00</td>
          <td>0.00</td>
      
          <td>

          @if($detail)
            {{$detail->dns_taxper!=null?number_format($detail->dns_taxper, 2, '.', '')??0:""}}
          @else
          {{18}}
          @endif

          </td>
          <td>
          @if($detail)
          {{$detail->dns_tax!=null?number_format($detail->dns_tax, 2, '.', '')??0:""}}
          @else 
          {{9}}
          @endif
          </td>
          <td>
            @if($detail)
            {{$detail->amount!=null?number_format($detail->amount, 2, '.', '')??0:"" }}
            @else
            {{59}}
           @endif
          </td>

        </tr>

         @elseif($transaction->transaction_type == 'domainRenewal')

          <tr>
          <td>Domain Renewal Fee</td>
          <td>998313</td>
          <td>{{\Carbon\Carbon::parse($transaction->created_at)->format('d/m/Y')}}</td>
     
          <td>{{$transaction->duration==null?$transaction->period:$transaction->duration}}</td>
          <td>{{$detail->server_price??0}}</td>

          <td>0</td>
          <td>0</td>

          <td>0.00</td>
          <td>0.00</td>
          <td>0.00</td>
          <td>0.00</td>
      
          <td>

            @if($detail!=null)
            {{$detail->server_price_taxper!=null?number_format($detail->server_price_taxper, 2, '.', '')??0:""}}</td>
            @endif

          <td>
          @if($detail!=null)
          @if ($detail->server_price !== null && $detail->server_price_taxper !== null &&
          is_numeric($detail->server_price) && is_numeric($detail->server_price_taxper))
          {{ number_format(($detail->server_price ?? 0) * ($detail->server_price_taxper / 100), 2, '.', '') }}
          @endif
          @endif

          </td>
          <td>


          @if($detail!=null  && isset($detail->extra_charges))
          {{ number_format(($detail->server_price ?? 0) * (1 + $detail->server_price_taxper / 100), 2, '.', '') }}
          @else
          {{$transaction->total_amount??0.00}}
          @endif</td>



        </tr>

        @if($detail!=null  && isset($detail->extra_charges))

        @if($detail->extra_charges>0)
        <tr>
          <td>Late/Reactivation Fee</td>
          <td>998313</td>
          <td>{{\Carbon\Carbon::parse($transaction->created_at)->format('d/m/Y')}}</td>
     
          <td>0</td>
          <td>{{$detail->extra_charges??0}}</td>

          <td>0</td>
          <td>0</td>

          <td>0.00</td>
          <td>0.00</td>
          <td>0.00</td>
          <td>0.00</td>
      
          <td>{{$detail->server_price_taxper!=null?number_format($detail->server_price_taxper, 2, '.', '')??0:""}}</td>
          <td>
          {{ number_format(($detail->extra_charges ?? 0) * ($detail->server_price_taxper / 100), 2, '.', '') }}
          </td>
          <td>
          {{ number_format(($detail->extra_charges ?? 0) * (1 + $detail->server_price_taxper / 100), 2, '.', '') }}</td>

        </tr>
        @endif
        @endif

      
      @elseif($transaction->transaction_type == 'ewaas' || $transaction->transaction_type == 'elmaas')

          <tr>
          <td>Ewaas Service </td>
          <td>998313</td>
          <td>{{\Carbon\Carbon::parse($transaction->created_at)->format('d/m/Y')}}</td>
     
          <td>{{$detail->years??0}}</td>
          <td>{{$detail->server_price??0}}</td>

          <td>0</td>
          <td>0</td>

          <td>0.00</td>
          <td>0.00</td>
          <td>0.00</td>
          <td>0.00</td>
      
          <td>{{ number_format($detail->server_taxper, 2, '.', '')??0}}</td>
          <td>{{ number_format($detail->server_price_tax, 2, '.', '')??0}}</td>
          <td>{{ number_format($detail->amount, 2, '.', '')??0 }}</td>

        </tr>

      @else 


      @endif

         @endforeach
      </table>
      <table class="table table-bordered">
        

        <tr>
          <th colspan="3" style="border-bottom:none;">Total Amount Received(in words)</th>
          <td style="float:right;border:0px !Important">(Rupees {{numberToWord($grand_total)}}.)</td>
        </tr>

        <tr>
          <th colspan="3" style="border-bottom:none;">Total amount before Tax</th>
          <td style="float:right;border:0px !Important">{{number_format($total_amount_before_tax, 2, '.', '')}} </td>
        </tr>
        <tr style="border: #000000;">
          <th colspan="3" style="border-bottom:none;">Add: CGST</th>
          <td style="float:right;border:0px !Important">00.00</td>
        </tr>
        <tr>
          <th colspan="3" style="border-bottom:none;">Add: SGST</th>
          <td style="float:right;border:0px !Important">00.00</td>
        </tr>
        <tr>
          <th colspan="3" style="border-bottom:none;">Add: IGST</th>
          <td style="float:right;border:0px !Important">{{number_format($total_igst, 2, '.', '')}}</td>
        </tr>
        
        <tr>
          <th colspan="3" style="border-bottom:none;">Total Tax Amount(GST)</th>
          <td style="float:right;border:0px !Important">{{number_format($total_igst, 2, '.', '')}}</td>
        </tr>

        <tr>
          <th colspan="3" style="border-bottom:none;">Grand Total</th>
          <td style="float:right;border:0px !Important">{{number_format($grand_total, 2, '.', '')}}</td>
        </tr>
        
      </table>
      <table class="table table-bordered">
        <tr>
          <th colspan="1">This is system generated receipt and it does not require signature</th>
        </tr>
      </table>
      </tbody>
      </table>
      </table>
    </div>
  </body>
</html>