
@extends('layouts.FrontLayout')
@section('content')
<style>

@media only screen and (max-width:425px) {
.input-group>.form-control, .input-group>.form-select {
    width: 100% !important;
}
}

.error {
    border: 1px solid red; 
}

</style>
    <div class="content-wrapper">
        <section class="apply-domain-content pt-5">
            <form id="saveUserEnquiry"   >
                @csrf
                <div class="container-fluid">
                    <div class="apply-domain-inner">
                        <div class="row">
                            <div class="apply-domain-note">
                                <h3>Domain - {{$appliedDomain}}</h3>
                                <p>Declaration</p>
                            </div>
                           <input type="hidden" name="domainName" value="{{$appliedDomain}}">
                            <div class="col-12">
                                <div class="terms-conditions-outer">
                                    <div class="input-group mb-3">
                                        <span>I &nbsp;</span>
                                        <input type="text" name="contact_name" class="form-control contact_name textbox required-field" id="basic-url" aria-describedby="basic-addon3" placeholder="Contact Name"  onKeyPress="if(this.value.length==50) return false;">&nbsp;
                                        <span class="text-danger error-text contact_name_err"></span><span>&nbsp; son / daughter of &nbsp;</span>
                                        <input type="text" name="father_name" class="form-control father_name textbox required-field" id="basic-url" aria-describedby="basic-addon3" placeholder="Father Name"  onKeyPress="if(this.value.length==50) return false;">
                                        <span> &nbsp;aged &nbsp;</span>
                                        <input type="number" name="age" class="form-control age required-field" id="basic-url" aria-describedby="basic-addon3" placeholder="Age" >
                                        <span>&nbsp;
                                            , hereby undertake that I am working / associated with </span>
                                    </div>
                                    <div class="input-group mb-3">
                                        <input type="text" name="institute" class="form-control institute textbox_allow required-field" id="basic-url" aria-describedby="basic-addon3" placeholder="Institute"  onKeyPress="if(this.value.length==50) return false;">&nbsp;<span class="text-danger error-text institute_err"></span>
                                        <span> &nbsp;affiliated by &nbsp;</span>
                                        <input type="text" name="board" class="form-control board textbox_allow required-field" id="basic-url" onKeyPress="if(this.value.length==100) return false;" aria-describedby="basic-addon3" placeholder="AICTE/UGC/ Education board/ University/ Or Government
                                        permission etc" >

                                        <span> &nbsp;with Affiliation No.  &nbsp;</span>
                                        <input type="text" name="affilation_no" class="form-control affilation_no" id="basic-url" onKeyPress="if(this.value.length==100) return false;" aria-describedby="basic-addon3" placeholder="" >

                                        <span> &nbsp;as &nbsp; </span>
                                        <input type="text" name="designation" class="form-control designation textbox required-field" onKeyPress="if(this.value.length==30) return false;" id="basic-url" aria-describedby="basic-addon3" placeholder="Designation" >&nbsp;<span class="text-danger error-text designation_err"></span>

                                    </div>

                                    <div class="input-group mb-3">
                                        <span> &nbsp; and my email id &nbsp; </span>
                                        <input type="email" name="email" class="form-control email emailonly required-field" id="basic-url" aria-describedby="basic-addon3" placeholder="Email"  onKeyPress="if(this.value.length==50) return false;"> &nbsp;<span class="text-danger error-text email_err"></span>
                                        <span> &nbsp; I am authorize to sign legal documents on behalf of institute. &nbsp; </span>
                                    </div>
                                    <div class="terms-conditions-inner">
                                        <div class="accordion-body">
                                            <div class="container-fluid">
                                                <h4>I undertake that I am the authorized signatory and head of the domain owner institution and authorized to undertake, sign and execute any instrument essential and incidental to obtain official domain for the said institute. I do hereby agree for and on behalf of the management of the educational /research institution that I will abide by the terms & conditions while applying for registration of the domain name under edu.in / ac.in / res.in/ or विद्या.भारत at ERNET India, a Scientific Society of Ministry of Electronics & IT, Govt. of India. I also certify and undertake the following: </h4>
                                                <ol>
    <li>That the domain applying institute is involved in academic/educational/research activities (documentary proof is enclosed), recognized by Central/State educational Board/UGC/AICTE and will be using the registered domain for bonafide academic/educational and or research purpose only and not for any other business.</li>
    <li>That I am registering the domain name solely for the lawful purpose and will not use for any illegal activities.</li>
    <li>That I will not use the domain name in violation of any applicable laws or regulations i.e IT Act of Government of India or any law or rules applicable from time to time.</li>
    <li>That all the contact details of head (like Chancellor/VC/Principal/Head Master/Director etc.), of the said academic institution/organization - Admin details, billing details and Technical details being provided in the ‘online registration form’ as well as the documents being uploaded are verified to be correct, accurate, reliable.</li>
    <li>That to the best of my knowledge, the registration of the domain name will not infringe upon or otherwise violate the rights of any third party. It shall be the responsibility of the Institute to ensure compliance of this norms and ERNET India shall not be held responsible or liable in case of any violation by the institute at any time.</li>
    <li>That ownership of the content uploaded on the website of the domain (domain name) applied and registered will be of the institute. ERNET India will not be responsible for the website content.</li>
    <li>That no illegal, offensive (including but not limited to material that is sexually explicit content or which promotes racism, bigotry, hatred or physical harm), deceptive, misleading, abusive, indecent, harassing, blasphemous, defamatory, libelous, obscene, pornographic, pedophilic or menacing; ethnically objectionable, disparaging content will be uploaded on the website using this domain (domain name).</li>
    <li>That no content will be uploaded that is objectionable or otherwise unlawful in any manner whatsoever; or which consists of or contains software viruses, political campaigning, commercial solicitation, chain letters, mass mailings or any "spam”.</li>
    <li>That no content will be uploaded that infringes upon or violates any third party’s rights including, but not limited to, intellectual property rights, rights of privacy (including without limitation unauthorized disclosure of a person’s name, e-mail address, physical address or phone number) or rights of publicity.</li>
    <li>That ERNET India will not be responsible for any hacking of institute’s website and redirection to any fraudulent activity like gaming site, bank website, any website having financial/payment.</li>
    <li>That it is agreed that any changes in management/head of organization/institution or any other contact details (like Admin, Technical and Billing) will be informed in writing i.e. on letterhead of the institute duly signed and stamped by head of the institution/organization to ERNET India within 15 days from such change.</li>
    <li>It shall be responsibility of organization/Institute to update the Technical & Billing details and name server entries online using User ID and Password, failing which ERNET India will not be held liable for any issue like non-functional of domain etc. arises due to it. Organization will be responsible for maintaining the ID and password of domain and handover of the same to other responsible person in case of transfer, or resignation/ or superannuation of any person related to domain contact details.</li>
    <li>ERNET India is absolved and will not be held responsible for any dispute regarding the ownership of domain or institute. In future, if any dispute arises regarding office bearer/Management/Head of organization etc in our institute, The institute and its current and future management would be bound to absolve ERNET from any dispute/litigation etc. regarding the ownership or administration of the domain name registered by the Institute. In no circumstances, ERNET India will be made a party in the court/tribunals/appellate etc. ERNET India reserves the right to suspend/freeze/delete the domain name under dispute.</li>
    <li>Domain User/Registrant shall indemnify ERNET India, its management and officers against any and all costs, liabilities, losses, and expenses (including, but not limited to, legal expenses) arising out of any claim, suit, action or proceeding for any act(s) and/or omissions of the Institution.</li>
    <li>I have read the Registration Guidelines and T&amp;C for registering domain name.</li>
  
                                                </ol>

                                                <input type="checkbox" name="agree" value="1" required>I agree to all terms and conditions 
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="px-5 mb-4">
                                    <a href="{{url('/')}}" class="btn btn-danger">Cancel</a>
                                    <button type="submit" name="submit" id="submit" class="submit btn btn-success ">Submit</button>
                                </div>
                            </div>


                        </div>
                    </div>
                </div>
            </form>
        </section>
       
        <div class="modal show" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLongTitle">
                            <b>Please note that mere applying for a domain does not confer the right to registration of the
                            domain. Upon scrutiny of the application and documents and if the domain name applied meets
                            the relevance criteria with the Institution name and activities, the domain is approved and
                            intimated to the user.</b><br>
                    </div>
                    <div class="modal-body">
                        <div style="font-size: 14px " class="container-fluid pt-0">

                        <h3>Before applying for the domain, please read important information below :</h5>
                        </h3>
                            

                            <ol class="p-0">
    <li>Read carefully Domain registration Guidelines and T&amp;C</li>
    <li>Read and understand the Domain naming conventions/Guidelines and ensure that the desired domain name complies with the conventions</li>
    <li>Make sure you have scanned copies of the required documents:
      <ol type="A">
        <li>a. Proof/affiliation letter of Educational Institute document issued by UGC/AICTE/Education Board/State Government, etc. If the affiliation letter is in a language other than Hindi or English, it must be verbatim translated by an authorized translator of the court, signed, and stamped by the head of the Institute.</li>
        <li>b. Undertaking on a Non Judiciary Stamp Paper of Rs 100.00 only (Annexure-‘A’)</li>
        <li>c. Application on Letterhead for domain registration (Annexure ‘B’)</li>
        <li>d. GST Registration Certificate, if applicable. In case the institution is providing the GSTN number of their parent society/trust/foundation etc then the institution has to provide PAN Card and Registration certificate of the parent society/trust. Kindly note that GST invoice will be issued in the name of the institution whose GST Number is provided while filling the application form for domain registration.</li>
        <li>e. In case of Societies/Trust/Autonomous bodies, the copy of affiliation of the academic institution opened under it and for which domain name is applied.</li>
    </ol>
    </li>
    <li>Read the Tariff carefully</li>
    <li>Check availability of the desired domain name</li>
    <li>Fill in each field in the form carefully since any wrong data will result in rejection of your application and forfeiture of any payment made.</li>
    <li>Make payment Online (Debit/Credit Card/Netbanking/UPI) only</li>
    <li>Please note carefully that 'NO' Cash / DD / Cheque/offline NEFT is accepted and in case deposited by the user, will not be treated as paid and will be returned back.</li>
  </ol>
  <p><strong>Notes:</strong></p>
  <ol>
    <li>The domain Registration/Renewal charges have to be paid through the portal ONLY.</li>
    <li>Auto reminders for renewal of domain will be sent on admin and technical email-id (filled in online registration form) of the domain 60 days, 45 days, 30 days, 15, and 5 days prior to expiry of domain name. However, it is the responsibility of Registrant to renew domain before its expiry irrespective of reminder emails from ERNET India.</li>
    <li>In case Domain is not renewed on or before the expiry date, the domain will go into deactivation and an amount of Rs. 1000+GST will be charged for reactivation along with renewal charges.</li>
    <li>In case deactivated domain is not renewed within 40 days of expiry of domain, it will be deleted.</li>
    <li>After deletion of domain, it can be restored within 30 days of deletion with restoration charges of Rs.2500/- +GST per domain +renewal charges.</li>
    <li>E-Receipt against payment of domain registration/renewal will be sent to admin email of domain after confirmation of payment and registration/renewal of domain.</li>
    <li>The refund request will be entertained within 60 days of submitting online payment for valid reasons only and before registration of domain. Once, domain is registered, then the refund cases will also not be processed.</li>
    <li>If the documentation and Application process is not completed by the user with 15 days of filling online application form, the application will get automatically deleted by the system.</li>
    <li>If required documents are not uploaded within 15 days of filling online application form then application will be deleted and payment will be refunded. A fresh/new application will need to be filled in such cases along with payment as applicable.</li>
    <li>If domain registration application is rejected due to invalid documents / and or applied for unrecognized institution, and valid documents are not uploaded with 10 days of rejection then application will get automatically deleted by the system and payment will be refunded.</li>
  </ol>
  <br><br>
  <p><strong>ERNET Registration Nos:</strong></p>
  <ul type="none" class="p-0">
    <li>PAN: AAATE0202A</li>
    <li>TAN: DELE01699F</li>
    <li>GSTN: 07AAATE0202A2ZS</li>
  </ul>

                        </div>
                    </div>
                    <div class="modal-footer">
                        <a href="{{url('/')}}" type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</a>
                        <button id="closeModal" type="button" class="btn btn-success  " data-dismiss="modal" aria-label="Close">Confirm</button>
                    </div>
                </div>
            </div>
        </div>
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.4/jquery.min.js"></script>

        <script>

            $(window).on('load', function() {
                $('.submit').attr('disabled','disabled');
                $('#exampleModalCenter').modal('show');
            });
            $('#closeModal').click(function() {
                $('#exampleModalCenter').modal('hide');
            });

$( document ).ready(function() {

$('.emailonly').on('keypress',function(e){

var regex=new RegExp("^[a-zA-Z0-9-_,@.]");
var key=String.fromCharCode(!e.charCode ? e.which :e.charCode);
if(!regex.test(key)){
    e.preventDefault();
    return false;
}

});



$('.textbox').on('keypress',function(e){

var regex=new RegExp("^[a-zA-Z ]");
var key=String.fromCharCode(!e.charCode ? e.which :e.charCode);
if(!regex.test(key)){
    e.preventDefault();
    return false;
}

});

$('.required-field').on('input', function() {
$(this).removeClass('error'); 
});

$('.textbox_allow').on('keypress',function(e){

var regex=new RegExp("^[a-zA-Z_& ]");
var key=String.fromCharCode(!e.charCode ? e.which :e.charCode);
if(!regex.test(key)){
    e.preventDefault();
    return false;
}

});


$('.email').on('change',function($e){

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

                $.ajax({
                    url: "{{url('/checkemailexits')}}",
                    data: { email: $(this).val(),
                        "_token": "{{ csrf_token() }}" },
                    type: "post",
                    dataType: 'json',
                    success: function(response) {
                        if (response.exists) {
                   
                            
                        $('.submit').removeAttr('disabled');

                        } else {

                            $('.submit').attr('disabled','disabled');
                            Swal.fire({
                                    icon: 'error',
                                    text: 'Invalid email id',
                                    showConfirmButton: true,
                            });

                        }
                    }
                });

})


                $('body').on('submit', '#saveUserEnquiry', function(e) {

                e.preventDefault();

        var form = document.getElementById("saveUserEnquiry");
        var elements = form.getElementsByClassName("required-field");

        for (var i = 0; i < elements.length; i++) {
            if (elements[i].value.trim() === "") {
                elements[i].classList.add("error");
            } else {
                elements[i].classList.remove("error");
            }
        }

        var hasError = form.querySelector('.error');
        if (hasError) {
            e.preventDefault();
            hasError.focus();
            return false;
        }

        $('#overlay').show();

                    var current = $(this);
                    var email=$('.email').val();

                    var data = current.serialize();
                    $('.submit').text('processing');
                    Swal.fire({
                        title: "Please wait...",
                        html: "The email verification link is being sent to your registered email id."
                    })
                    Swal.showLoading();
                    $.ajax({
                        url: "{{url('/userDomainEnquiry')}}",
                        dataType : "json",
                        type: "post",
                        data : data,
                        success : function(response) {
                            $('#overlay').hide();
                            $('.submit').text('submit');
                            $('.submit').removeAttr('disabled');
                            if(response.status == 'success') {
                                Swal.fire({
                                    icon: 'success',
                                    text: 'The Declaration Details have been successfully submitted.\n The email verification link has been sent to your registered email. Kindly, verify your email within next 8 hrs otherwise the domain may not remain available',
                                    showConfirmButton: true,
                                }).then(function () {
                                    window.location.href = "{{ url('/')}}";
                                });
                            } else if(response.status == false) {
                                Swal.fire({
                                    icon: 'error',
                                    text: response.error,
                                    showConfirmButton: true,
                                });
                                $.each( response.error, function( key, value ) {
                                    $('.'+key+'_err').text("*");
                                });
                            }
                        },
                    });                    
                    return false;
                });


                $(".form-control").keyup(function () {
                    $('.contact_name_err').text('');
                    $('.institute_err').text('');
                    $('.designation_err').text('');
                    $('.email_err').text('');
                });
            });
            const ageInput = document.querySelector('.age');

            ageInput.addEventListener('change', function() 
            {
                let age = parseInt(this.value);

                if (isNaN(age) || age < 18) {
                    age = '';
                } else if (age > 99) {
                    age = 99;
                }

                this.value = age;
            });
        </script>
    @endsection
    @section("js")
@endsection
