@include('layouts.vas')

    <section class="h-100 h-custom" style="background-color: #8fc4b7;">
  <div class="container py-5 h-100">
    <div class="row d-flex justify-content-center align-items-center h-100">
      <div class="col-lg-8 col-xl-6">
        <div class="card rounded-3">
          <img src="{{asset('/assets/img/vas_payment_banner.png')}}" class="w-100" style="border-top-left-radius: .3rem; border-top-right-radius: .3rem;">
          <div class="card-body p-4 p-md-5">
            <h3 class="mb-4 pb-2 pb-md-0 px-md-2">VAS Available</h3>

            <form class="px-md-2" method="get" action="{{route('billdesk.initiate.payment')}}">

                @csrf
                        <input type="hidden" class="form-control" name="customer_name" id="customer_name"  value="{{Auth::user()->institute}}" readonly/>
                        <input type="hidden" class="form-control" name="transaction_type" id="transaction_type"  value="ewaas" readonly/>
                        <input type="hidden" class="form-control" name="customer_email" id="customer_email"  value="{{Auth::user()->email}}" readonly/>
                        <input type="hidden" class="form-control" name="remark" id="remark"  value="EWaaS Charges" readonly/>
              <div class="mb-4">
                <label>VAS Service Duration</label>
                <select name="service_duration" id="service_duration" class="select form-control">

                  <!-- New -->
                   @if($data['ernet_name_server_prices'])
                                      <option value="">Select VAS Duration</option>
                                      @foreach($data['ernet_name_server_prices'] as $price)
                                        @if($data['user_name_server'] != null)
                                          <option value="{{$price->id}}" @if($user_name_server->ernet_name_server_duration_year == $price->years) selected @endif>{{$price->years}} years</option>
                                        @else
                                        <option value="{{$price->id}}">{{$price->years}} years</option>
                                        @endif
                                      @endforeach
                                    @endif


                  <!-- New -->
                            
                        </select>

                        <div class="col-6 my-2">
                              <label class="form-label">Price</label>
                              <input type="hidden" class="form-control" name="years" id="years"  value=""/>
                              <input type="text" class="form-control" name="server_price" id="server_price"  value="" readonly/>
                          </div>
                          <div class="col-6 my-2">
                              <label class="form-label"> Taxes ( {{ number_format(getmisc()->service_tax,2)}} % ) </label>
                              <input type="text" class="form-control" name="server_price_tax" id="server_price_tax"  value="" readonly/>
                          </div>
                          <div class="col-6 my-2">
                              <label class="form-label">Total Amount</label>
                              <input type="text" class="form-control" name="amount" id="server_price_total" value="" readonly/>
                          </div>
               </div>

      

              <button type="submit" class="btn btn-success btn-lg mb-1">Submit</button>

            </form>

          </div>
        </div>
      </div>
    </div>
  </div>
</section>

@include('layouts.vasfooter')
<script type="text/javascript">
  $( document ).ready(function() {
        
        


        $(document).on("change",'#service_duration',function(){
        $.ajax({
            url: "{{ url('getVasServerPrice') }}"+'/'+$(this).val(),
            dataType : "json",
            type: "get",
            success : function(response) {

                if(response.status == true) {
                    $('#years').val(response.data.years);
                    $('#server_price').val(response.data.vas_price);
                    var server_price_gst_percent = (18*response.data.vas_price)/100;
                    $('#server_price_tax').val(server_price_gst_percent);
                    $('#server_price_total').val(parseFloat(response.data.vas_price)+parseFloat(server_price_gst_percent));
                } else if(response.status == false) {
                    alert(response.message);
                }

            },
        });
    });
    });
</script> 