<html>
<head>
    <title>Hindi Domain EPP Test</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        .success { color: green; }
        .error { color: red; }
        .debug { background: #f5f5f5; padding: 10px; margin: 10px 0; }
        pre { background: #f0f0f0; padding: 10px; overflow-x: auto; }
    </style>
</head>
<body>
    <h1>Hindi Domain EPP Test Results</h1>
    
    @if($result['success'] ?? false)
        <div class="success">
            <h2>✓ Test Completed Successfully</h2>
        </div>
        
        <div class="debug">
            <h3>Domain Information:</h3>
            <p><strong>Original:</strong> {{ $result['debug_info']['original_domain'] }}</p>
            <p><strong>Punycode:</strong> {{ $result['debug_info']['punycode_domain'] }}</p>
            <p><strong>Available:</strong> {{ $result['epp_response']['is_available'] ? 'Yes' : 'No' }}</p>
            @if($result['epp_response']['reason'])
                <p><strong>Reason:</strong> {{ $result['epp_response']['reason'] }}</p>
            @endif
        </div>
        
        <h3>Raw EPP Response:</h3>
        <pre>{{ $result['epp_response']['raw_xml'] }}</pre>
        
    @else
        <div class="error">
            <h2>✗ Test Failed</h2>
            <p><strong>Error:</strong> {{ $result['error']['message'] }}</p>
        </div>
    @endif
    
    <p><small>Test run at: {{ $result['timestamp'] }}</small></p>
</body>
</html>