<html lang="en">
<head>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.1.3/dist/css/bootstrap.min.css" integrity="sha384-MCw98/SFnGE8fJT3GXwEOngsV7Zt27NXFoaoApmYm81iuXoPkFOJwJ8ERdknLPMO" crossorigin="anonymous">

<link href="{{ asset('css/app.css') }}" rel="stylesheet" type="text/css" />
   <style type="text/css" media="print">
    .page {
        overflow: hidden;
        page-break-after: always;
    }
    .page:last-of-type {
        page-break-after: auto
    }
</style>
</head>
<body>
    
    <div class="container-fluid mt-3 " style="">
        
    <div class="row" style="background:#fff;border:1px solid black">
            
   <table class="table table-bordered">
 
  <tbody>
    <tr>
      <td class="text-center"><img src="https://nipgr.intileo.com/uploads/NCS-TCP-logo 1.png"></td>
      <td class="text-center"><h4>{{$atl->name}}</h4>
      <p>Accrediation Number:{{$atl->registration_number}}</p></td>
      <td class="text-center"><h6>Date:{{now()->format('d/m/Y')}}</h6></td>
    </tr>
    <tr>
        <th>Application Number:</th> 
        <td colspan="2">{{$details->application_number}}</td>
    </tr>
    <tr>
      <th scope="row">Name & Address of TCPF:</th>
      <td colspan="2">{{$details->tcpf_name}} , {{$details->address}}</td>
    </tr>
    <tr>
      <th scope="row">Plant Species to be Tested: </th>
      <td colspan="2">{{$details->plant_name}}</td>
    </tr>
     <tr>
      <th scope="row">Total Number of Sample: </th>
      <td colspan="2">{{$details->number_of_sample}}</td>
    </tr>
  </tbody>
</table>


<table class="table table-bordered">
  <thead>
    <tr>
      <th class="text-center">Particulars of Testing</th>
      <th colspan="{{$details->total_virus}}" class="text-center">Viruses to be tested</th>
    </tr>
    <tr>
        <th class="text-center">Sample Registration <br>Number (20 digits)</th>
        
        @foreach(json_decode($details->viruses) as $virus)

        <th class="text-center">
          
              {{$virus->test_performed_by_kit}} <br> {{$virus->plant_virus_name}}
          
        </th>
        
         @endforeach
        
    </tr>
    
  
    @foreach($samples as $sample)
                        <tr>
                            
                            <?php  $viruesreport=json_decode($sample->sample_reports)?>
                            
                            <td class="text-center">{{$sample->digit_number}}</td>
                            
                            @foreach($viruesreport as $virus)
                            <td class="text-center">{{$virus->virus_pos==1?"Positive":"Negative"}}</td>
                            @endforeach
                            
                    
                        </tr>
    @endforeach
  
  </thead>
   
  <tbody>
    
    
    
  </tbody>

</table>

<table class="table mb-5">
    
    <tr style="border:1px solid gray;">
         <th style="font-weight:500;border:1px solid gray;">Remarks if any</th>
         <th colspan="4"  style="font-weight:500;border:1px solid gray;">{{$details->sample_tested_remarks ?? ''}}                                 </th>
     </tr>
     
     <tr style="border:1px solid gray">
         <th style="font-weight:500;border:1px solid gray;">(Sign / Name of Scientist Virgology) / date</th>
         <th colspan="4"  style="font-weight:500;border:1px solid gray;">                                                           </th>
     </tr>
     
        
     <tr style="border:1px solid gray">
         <th style="font-weight:500;border:1px solid gray;">(Signature of head of ATL) / date</th>
         <th colspan="4"  style="font-weight:500;border:1px solid gray;">                                                    </th>
     </tr>
     
</table>
         
        </div>

    </div>
    <br><br><br>
</body>
</html>