@extends('layouts.admin')

{{-- Web site Title --}}
@section('title', __('record/title.record_edit'))

{{-- Content Header --}}
@section('header')
    Edit Record
    <small>{{ __('record/title.record_edit_subtitle', ['record' => $record->name]) }}</small>
@endsection

{{-- Breadcrumbs --}}
@section('breadcrumbs')
    <li>
        <a href="{{ route('dns-name-server') }}">
            <i class="fa fa-dashboard"></i> {{ __('site.dashboard') }}
        </a>
    </li>
    <li>
        <a href="{{ route('zones.records.index', $zone) }}">
            {{ __('site.zones') }}
        </a>
    </li>
    <li class="active">
        {{ __('record/title.record_edit') }}
    </li>
@endsection

@section('content')

<style>
      .blink {
            animation: blinker 4.5s linear infinite;
            color: #fff;
            font-weight:bold;
            font-family: sans-serif;
        }
        @keyframes blinker {
            50% {
                opacity: 0.5;
            }
        }
</style>

<div class="container-xxl flex-grow-1 container-p-y" xmlns="http://www.w3.org/1999/html">
  <div class="row">
    <div class="col-md-12">
      <div class="card mb-4 mt-5">
        <div class="card-body px-5 ">
            <form role="form" id="save-ernet-dns-record" method="POST">
                @csrf
                <div class="row">
                    <input type="hidden" value="{{$zone->user_id}}" name="user_id" id="user_id">
                  
                    <input type="hidden" name="id" id="id">

                    <div class="col-md-3 mb-3">
                        <label class="form-label">Record Type </label>
                        <select class="form-control" id="type" name="type" required>
                            <option value="A" selected="selected">A</option>
                            <option value="AAAA">AAAA</option>
                            <option value="CNAME">CNAME</option>
                            <option value="MX">MX</option>
                            <option value="NAPTR">NAPTR</option>
                            <option value="NS">NS</option>
                            <option value="SRV">SRV</option>
                            <option value="TXT">TXT</option>
                        </select>
                    </div>
                        <div class="col-md-3 mb-3">
                            <label class="form-label">Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="name" id="name" value="{{$zone->domain}}" placeholder="@ or www"  readonly required>
                            <span style="font-size: 0.85rem;">Use'@' to refer to the fully qualified domain name.</span>
                        </div>
                        <div class="col-md-3 mb-3">
                            <label class="form-label">Value <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="data" id="data" placeholder="xx.xx.xx.xx"  required >
                        </div>
                        <div class="col-md-3 mb-3 ttl">
                            <label class="form-label">TTL (seconds) </label>
                            <input type="number" class="form-control" name="ttl" id="ttl" placeholder="Default" value="" maxlength="35" >
                            <span style="font-size: 0.85rem;">Leave empty, to use default's TTL value (see Settings).</span>
                        </div>
                </div>
                <div class="m-5">
                    <br>
                    <button class="btn btn-success d-grid float-end" id="add_dns_btn" name="action" value="submit">Update Record</button>
                </div>
            </form>

            <br><br>
            <button id="showHelpDiv" class="btn btn-primary blink" >Show Help</button>
            <div id="helpDiv" class=" m-5" style="display: none">
                    <pre>
            A
                Maps a host name to IPv4 address.
                Data is a IPv4 address in dotted decimal format.
                Multiple addresses are defined with the same name.

            AAAA
                Maps a host name to IPv6 address.
                Data is a IPv6 address.
                Multiple addresses are defined with the same name.

            CNAME
                Maps an alias to the real or canonical name.
                Data is a host name.
                Ends Data with a '.' if you supply Fully Qualified Domain Name (FQDN).
                CNAME records must be unique on a domain.

            MX
                Specifies the name and relative preference of mail exchangers.
                Priority field is relative to other MX record for the same name.
                Data is a host name.
                Ends Data with a '.' if you supply FQDN.
                Any number of MX records may be defined.

            NS
                Can't use '@' as a Name.
                Delegates a subdomain to a DNS server.
                Data is a host name.
                Ends Data with a '.' if you supply FQDN.

            PTR
                Only used on IN-ADDR.ARPA. zones.
                Maps an IP address (IPv4 or IPv6) to a host name.
                Data is a host name. Must use an FQDN format (they end with a dot).

            SRV
                Identifies the host(s) that will support a particular service.
                Name is defined as '_service._proto' FQDN format (see RFC 2782).
                Priority field is relative to other SRV record for the same service.
                Data field include weight, port and target information (see RFC 2782).

            TXT
                 Associate some arbirary and unformatted text with a host or other name.</pre>
            </div>

        </div>
          
      </div>
    </div>
  </div>
</div>

    <div id="collapseHelp" class="collapse">
        <pre>{!! __('record/messages.records_help') !!}</pre>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.0/jquery.min.js"></script>
    <script src="https://ajax.aspnetcdn.com/ajax/jquery.validate/1.9/jquery.validate.js"></script>

    <script>

  $('#save-ernet-dns-record').validate({
    submitHandler:function(form)
    {
      $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
      });
      $.ajax({
        url:"{{url('ernetdash/save-ernet-dns-record')}}",
        type:'POST',
        dataType:'json',
        data:$("#save-ernet-dns-record").serialize(),
        cache: false,
        beforeSend: function(){
            $(".loader-area").show();
        },
        success:function(res)
        {
          if(res.status == true)
          {
                alert('Record Updated Successfully');
                window.location.href="{{url('ernetdash/zones')}}";
          }else if(res.status == false)
          {
            //   Swal.fire({
            //       icon: 'error',
            //       text: res.msg,
            //       showConfirmButton: true,
            //   })
          }
        },
        complete: function(){
            $("#add-server-smt-btn").prop('disabled',false);
        },
      });
    }
  });

  function editRecord(){

      var id="{{$record->id}}";
      var type="{{$record->type}}";
      var name="{{$record->name}}";
      var data="{{$record->data}}";
      var priority="{{$record->priority}}";
      var weight="{{$record->port}}";
      var protocol="{{$record->protocol}}";
      var service="{{$record->service}}";
      var ttl="{{$record->ttl}}";

      $('#id').val(id);
      $('#type').val(type);
      $('#name').val(name);
      $('#data').val(data);
      $('#ttl').val(ttl);

      $('.Priority').remove();
      $('.Weight').remove();
      $('.Port').remove();
      $('.Service').remove();
      $('.Protocol').remove();
      $('#data').removeAttr('placeholder');

      if (type == 'A'){
          $('#data').attr('placeholder','xx.xx.xx.xx');
      }

      if (type == 'MX'){
          $('#data').attr('placeholder','Name Server');
          $('.ttl').after('' +
              ' <div class="col-md-3 mb-3 Priority">\n' +
              '                            <label class="form-label">Priority <span class="text-danger">*</span></label>\n' +
              '                            <input type="number" class="form-control" name="priority" id="priority" value=""  onKeyPress="if(this.value.length==2) return false;" required>\n' +
              '                        </div>');

          $('#priority').val(priority);

      }

      if (type == 'SRV'){
          $('.ttl').after('' +
              ' <div class="col-md-3 mb-3 Priority">\n' +
              '                            <label class="form-label">Priority </label>\n' +
              '                            <input type="number" class="form-control" name="priority" id="priority" value=""  onKeyPress="if(this.value.length==2) return false;" >\n' +
              '                        </div>' +
              '<div class="col-md-3 mb-3 Service">\n' +
              '                        <label class="form-label">Service</label>\n' +
              '                        <input type="text" class="form-control" name="service" id="service" value="" placeholder="_ldap,_ftp or _smtp" maxlength="35" >\n' +
              '                    </div>' +
              '<div class="col-md-3 mb-3 Protocol">\n' +
              '                        <label class="form-label">Protocol</label>\n' +
              '                        <input type="text" class="form-control" name="protocol" id="protocol" placeholder="_tcp or _upd" value="" maxlength="35" >\n' +
              '                    </div>' +
              '<div class="col-md-3 mb-3 Weight">\n' +
              '                        <label class="form-label">Weight</label>\n' +
              '                        <input type="number" class="form-control" name="weight" id="weight" value="" maxlength="35" >\n' +
              '                    </div>' +
              '<div class="col-md-3 mb-3 Port">\n' +
              '                        <label class="form-label">Port</label>\n' +
              '                        <input type="text" class="form-control" name="port" id="port" value="" maxlength="35" >\n' +
              '                    </div>');

          $('#priority').val(priority);
          $('#weight').val(weight);
          $('#port').val(port);
          $('#protocol').val(protocol);
          $('#service').val(service);
      }

      if (type == 'NS'){

          $('#data').attr('placeholder','Name Server');
      }
      window.scrollTo(0,0);
      $('#name').focus();

  }

  editRecord();

  $(document).on("click",'#showHelpDiv',function(){
      if ($(this).text() == 'Show Help'){
          $("#helpDiv").show();
          $(this).text('Hide Help');
      }else {
          $("#helpDiv").hide();
          $(this).text('Show Help');
      }

  });

  function deleteRecord(id){
      Swal.fire({
          title: 'Are you sure?',
          text: 'You are about delete this record.',
          icon: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#28a745',
          cancelButtonColor: '#6c757d',
          confirmButtonText: 'Confirm',
          cancelButtonText: 'Cancel'
      }).then((result) => {
          if (result.isConfirmed) {
              $.ajax({
                  url: "{{ url('deleteRecord') }}"+'/'+id,
                  dataType : "json",
                  type: "get",
                  success : function(response) {
                      if(response.status == true)
                      {
                          Swal.fire({
                              icon: 'success',
                              text: response.msg,
                              showConfirmButton: true,
                          }).then(function () {
                              location.reload();
                          });
                      }else if(response.status == false)
                      {
                          Swal.fire({
                              icon: 'error',
                              text: response.msg,
                              showConfirmButton: true,
                          })
                      }

                  },
              });
          }
      });


  }

  $(document).on("change",'#type',function(){
      $('.Priority').remove();
      $('.Weight').remove();
      $('.Port').remove();
      $('#data').removeAttr('placeholder');

      if ($(this).val() == 'A'){
          $('#data').attr('placeholder','xx.xx.xx.xx');
          $('#name').attr('placeholder','@ or www');
      }

      if ($(this).val() == 'AAAA'){
          $('#data').attr('placeholder','xx.xx.xx.xx.xx.xx.xx.xx');
          $('#name').attr('placeholder','@ or mail');
          $('#data').removeAttr('pattern');
          $('#data').attr('pattern','^([0-9a-fA-F]{4}:){7}[0-9a-fA-F]{4}$');
      }
      if ($(this).val() == 'TXT'){
          $('#data').attr('placeholder','String of characters');
          $('#data').removeAttr('pattern');
      }

      if ($(this).val() == 'CNAME'){
          $('#data').attr('placeholder','coolexample.com');
          $('#name').attr('placeholder','blog or shop');
          $('#data').removeAttr('pattern');
      }

      if ($(this).val() == 'MX'){
          $('#data').attr('placeholder','smtp.secureserver.net');
          $('#data').removeAttr('pattern');
          $('.ttl').after('' +
              ' <div class="col-md-3 mb-3 Priority">\n' +
              '                            <label class="form-label">Priority <span class="text-danger">*</span></label>\n' +
              '                            <input type="number" class="form-control" name="priority" id="priority" value=""  onKeyPress="if(this.value.length==2) return false;" required >\n' +
              '                        </div>');
      }

      if ($(this).val() == 'SRV'){
          $('#data').attr('placeholder','host.domain.com');
          $('#name').attr('placeholder','@ or mail');
          $('#data').removeAttr('pattern');
          $('.ttl').after('' +
              ' <div class="col-md-3 mb-3 Priority">\n' +
              '                            <label class="form-label">Priority </label>\n' +
              '                            <input type="number" class="form-control" name="priority" id="priority" value=""  placeholder="0 or greater"  onKeyPress="if(this.value.length==35) return false;" >\n' +
              '                        </div>' +
              '<div class="col-md-3 mb-3 Service">\n' +
              '                        <label class="form-label">Service</label>\n' +
              '                        <input type="text" class="form-control" name="service" id="service" value="" placeholder="_ldap,_ftp or _smtp" maxlength="35" >\n' +
              '                    </div>' +
              '<div class="col-md-3 mb-3 Protocol">\n' +
              '                        <label class="form-label">Protocol</label>\n' +
              '                        <input type="text" class="form-control" name="protocol" id="protocol" placeholder="_tcp or _upd" value="" maxlength="35" >\n' +
              '                    </div>' +
              '<div class="col-md-3 mb-3 Weight">\n' +
              '                        <label class="form-label">Weight</label>\n' +
              '                        <input type="number" class="form-control" name="weight" id="weight" placeholder="0 or greater" value="" maxlength="35" >\n' +
              '                    </div>' +
              '<div class="col-md-3 mb-3 Port">\n' +
              '                        <label class="form-label">Port</label>\n' +
              '                        <input type="text" class="form-control" name="port" id="port" placeholder="80 or 21" value="" maxlength="35" >\n' +
              '                    </div>');
      }

      if ($(this).val() == 'NS'){
          $('#name').attr('placeholder','@ or www');
          $('#data').attr('placeholder','ns1.domain.com');
          $('#data').removeAttr('pattern');
      }

  });


</script>

@endsection
