@extends('layouts.admin')

@section('title', __('record/title.view_records'))

@section('header')
    {{ __('record/title.view_records') }}
    <small>{{ __('record/title.view_records_subtitle', ['domain' => $zone->domain]) }}</small>
@endsection

@section('breadcrumbs')
    <li>
        <a href="{{ route('dns-name-server') }}">
            <i class="fa fa-dashboard"></i> {{ __('site.dashboard') }}
        </a>
    </li>
    <li class="active">
        {{ __('record/title.view_records') }}
    </li>
@endsection

@section('content')

    @include('partials.notifications')
    <a href="{{ route('zones.records.create', $zone) }}" class="btn btn-success margin-bottom" role="button">
            <i class="fa fa-plus"></i> {{ __('record/title.create_new') }}
    </a>
    <div class="box">
        <div class="box-body">
            @include('record._table')
        </div>
    </div>
@endsection
