@extends('layouts.AdminLayout')

@section('content')

<div class="content-wrapper">

<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-2">Registered/Renewed Hindi Domain List &nbsp;&nbsp;<span class="btn btn-primary exportdata" style="color:whitelcursor:pointer">Export To Excel</span></h4>
			
		<div class="card">
			<div style="padding:20px">	

            <div class="row py-2">
			<h5 class="fw-bold py-3 mb-1" style="text-align:center;">As on Date : {{date('d/m/Y')}}</h4>
            <form method="get" id="chatexport" action="{{ url('/ernetdash/domainhiexport') }}">	
			@csrf
			<input type="hidden" name="search_text" class="search_text" >

			<div class="row my-2">
					<div class="col-md-3" id="tday2">							
					<label style="font-family:Times New Roman;color:black" >Application Date From<br></label>
						<div class="input-group col-md-3" style="float:left;">
							<input type="date"  max="<?php echo  date('Y-m-d'); ?>" data-date-format="yyyy-mm-dd" data-date-viewmode="years" class="form-control from" name="dd1" id="start_date" autocomplete="off">
				    </div>
						
					</div>
					<div class="col-md-3" id="tday2">
					   <label  style="font-family:Times New Roman;color:black" >Application Date To<br></label>
						<div class="input-group col-md-3" style="float:left;">
						<input type="date" max="<?php echo  date('Y-m-d'); ?>"  data-date-format="yyyy-mm-dd" data-date-viewmode="years" class="form-control to" name="dd2" id="end_date" autocomplete="off">
						</div>
					</div>

					<div class="col-md-3" id="tday2">							
					<label style="font-family:Times New Roman;color:black" >Domain<br></label>
                    <div class="input-group col-md-3" style="float:left;">
						<input type="text"  class="form-control domain" name="domain" id="domain" >
						</div>					
					</div>

					<div class="col-md-3 id="tday2">							
					<label  style="font-family:Times New Roman;color:black" >State<br></label>
					  <select class="form-control" name="state" id="state">
						<option value="">Select State</option>
						@foreach($states as $state)
                        <option value="{{$state->description}}">{{$state->description}}</option>
						@endforeach
					  </select>
					</div>

                    <div class="col-md-3" id="tday2">							
					<label  style="font-family:Times New Roman;color:black" >Period (in Yearly)<br></label>
					  <select class="form-control" name="period" id="period">
						<option value="">All Year</option>
						<option value="1">1</option>
						<option value="2">2</option>
						<option value="3">3</option>
						<option value="4">4</option>
						<option value="5">5</option>
						<option value="6">6</option>
						<option value="7">7</option>
						<option value="8">8</option>
						<option value="9">9</option>
						<option value="10">10</option>
					  </select>
					</div>

                    <div class="col-md-3" id="tday2">							
					<label  style="font-family:Times New Roman;color:black" >Domain Status<br></label>
					  <select class="form-control" name="status" id="status">
						<option value="">All</option>
						<option value="1">Registered</option>
                        <option value="2">Renewed</option>
					  </select>
					</div>

					<div class="col-md-4" style="margin-top:20px;">	
						 <button type="button" class="btn btn-primary search ">Search</button>
                         <a href="{{url('ernetdash/reports/domainhi')}}" style="color:#fff"> <button type="button" class="btn btn-info search ">Reset</button></a>
					</div>
					
			
			</div>
			</div>
			</div>
		</div>
				</div>
                <div class="card">
                <div style="padding:20px">	
					<div class="table-responsive text-nowrap mt-5">
						
						<table class="table table-striped table-bordered dataTable no-footer" id="dataTable" width="100%" cellspacing="0">
							<thead class="table-secondary">
								<tr>
                                <th>S.No.</th>
								<th>Domain Name</th>
								<th>Institute Name</th>
								<th>Contact No.</th>
								<th>Period (in Years)</th>
                                <th>Registration Date</th>
                                <th>Expiry Date</th>
								<th>Action</th>
								</tr>
							</thead>
						   
							<tbody>
								
							</tbody>
						</table>
		            </div>
				</div>
        </form>

</div></div>

			
<div class="modal fade" id="holdModal" tabindex="-1" role="dialog" aria-labelledby="holdModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
  <form method="post" id="holdform">
    {!! csrf_field() !!}
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="holdModalLabel">Hold Domain</h5>
      </div>
      <div class="modal-body">
    
         <input type="hidden" id="hold_id" name="hold_id">

         <div class="form-group">
           <label for="">Remarks </label>
           <textarea class="form-control" name="hold_remarks" id="hold_remarks" rows="3" required></textarea>
         </div>

      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        <button type="submit" class="btn btn-danger">Hold</button>
      </div>
    </div>
    </form>
  </div>
</div>
		

@endsection
@section("js")

<link href="{{ asset('vendor/datatables/dataTables.bootstrap4.min.css') }}" rel="stylesheet">

<script src="{{ asset('vendor/datatables/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('vendor/datatables/dataTables.bootstrap4.min.js') }}"></script>
	<script type="text/javascript">
		
		$(document).ready(function() {
			
			var table = $('#dataTable').DataTable({
				processing: true,
				serverSide: true,
				"ajax": {
                    "url": "{{url('ernetdash/domainhiajax')}}",
                    "type": "GET",
                    "datatype": "json",
					"data": function(d){
						d.from = $('#start_date').val();
						d.to = $('#end_date').val();
						d.domain = $('.domain').val();
						d.state=$('#state').val();
                        d.period=$('#period').val();
                        d.status=$('#status').val();
					}
                },
				columns: [
					{ data: 'id', orderable: false}, 
					{ data: 'domain', orderable: false},
					{ data: 'inst', orderable: false},
					{ data: 'phone', orderable: false},
					{ data: 'period', orderable: false},
                    { data: 'reg_date', orderable: false},
					{ data: 'expiry_date', orderable: false},
					{ data: 'action', orderable: false},
				],
				"language": {
                 "emptyTable": "No Data Available"
                },
                "searching": false
			});


$('body').on('click', '.hold_button', function() {

var id = $(this).attr('data-id');

$('#hold_id').val(id);
$('#holdModal').modal('show');

});

$('body').on('submit', '#holdform', function(e) {
  e.preventDefault();
  var current = $(this);		
  var data = current.serialize();

  $.ajaxSetup({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
  });

  Swal.fire({
    title: "Please wait...",
  })

  Swal.showLoading();

  $.ajax({
    url: "{{route('domain.hold')}}",
    dataType : "json",
    type: "post",
    data : data,
    success : function(response) {

      if(response.status == 'success') {

        Swal.fire({
            icon: 'success',
            text: 'Domain has been hold successfully',
            showConfirmButton: true,
        }).then(function () {
            window.location.reload();
        });

      } else if(response.status == 'error') {

        alert(response.message);

      }
    },
  });

})
			
			$('body').on('click', '.search', function() {
				$start=$('#start_date').val();
				 $end=$('#end_date').val();

    if($start!= '' && $end!= '' && $start> $end)
    {
    alert("From Date cannot be greater than To Date");
    return false;
    }else{
		table.ajax.reload();
	}
			});

			$('.dataTables_filter input').keyup(function() {
			$('.search_text').val($(this).val());
		    });
		
			$('body').on('click', '.exportdata', function() {
				$('#chatexport').submit();
			});
			
		});
	</script>

@endsection


