@extends('layouts.AdminLayout')

@section('content')

<div class="content-wrapper">

<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-2">Expired Domain List &nbsp;&nbsp;<span class="btn btn-primary exportdata" style="color:whitelcursor:pointer">Export To Excel</span></h4>
			
		<div class="card">
			<div style="padding:20px">	

            <div class="row py-2">
			<h5 class="fw-bold py-3 mb-1" style="text-align:center;">As on Date : {{date('d/m/Y')}}</h4>
            <form method="get" id="chatexport" action="{{ url('/ernetdash/expiredexport') }}">	
			@csrf
			<input type="hidden" name="search_text" class="search_text" >

			<div class="row px-4 my-2">
					<div class="col-md-2" id="tday2">							
					<label style="font-family:Times New Roman;color:black" >Application Date From<br></label>
						<div class="input-group col-md-3" style="float:left;">
							<input type="date"  max="<?php echo  date('Y-m-d'); ?>" data-date-format="yyyy-mm-dd" data-date-viewmode="years" class="form-control from" name="dd1" id="start_date" autocomplete="off">
						</div>
						
					</div>
					<div class="col-md-2" id="tday2">
					   <label  style="font-family:Times New Roman;color:black" >Application Date To<br></label>
						<div class="input-group col-md-3" style="float:left;">
						<input type="date" max="<?php echo  date('Y-m-d'); ?>"  data-date-format="yyyy-mm-dd" data-date-viewmode="years" class="form-control to" name="dd2" id="end_date" autocomplete="off">
						</div>
					</div>

					<div class="col-md-2" id="tday2">							
					<label  style="font-family:Times New Roman;color:black" >Domain<br></label>
                    <div class="input-group col-md-3" style="float:left;">
						<input type="text"  class="form-control domain" name="domain" id="domain" >
						</div>					
					</div>

					<div class="col-md-2" id="tday2">							
					<label  style="font-family:Times New Roman;color:black" >State<br></label>
					  <select class="form-control" name="state" id="state">
						<option value="">Select State</option>
						@foreach($states as $state)
                        <option value="{{$state->description}}">{{$state->description}}</option>
						@endforeach
					  </select>
					</div>

					<div class="col-md-4" style="margin-top:20px;">	
						 <button type="button" class="btn btn-primary search ">Search</button>
						 <a href="{{url('ernetdash/reports/expired')}}" style="color:#fff"> <button type="button" class="btn btn-info search ">Reset</button></a>
					</div>
					
			
				</div>
                
                
					<div class="table-responsive text-nowrap mt-4">
						
						<table class="table table-striped table-bordered dataTable no-footer" id="dataTable" width="100%" cellspacing="0">
						<thead class="table-secondary">
								<tr>
                                <th>S.No.</th>
								<th>Domain Name</th>
								<th>Institute Name</th>
								<th>Contact No.</th>
								<th>Period (in Years)</th>
                                <th>Expiry Date</th>
								</tr>
							</thead>
						   
							<tbody>
								
							</tbody>
						</table>
					</div>

                    </form>
			</div>
		</div>

@endsection
@section("js")

<link href="{{ asset('vendor/datatables/dataTables.bootstrap4.min.css') }}" rel="stylesheet">

<script src="{{ asset('vendor/datatables/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('vendor/datatables/dataTables.bootstrap4.min.js') }}"></script>
	<script type="text/javascript">
		
		$(document).ready(function() {

			// $.ajaxSetup({
			// 	headers: {
			// 		'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
			// 	}
			// });
			
			var table = $('#dataTable').DataTable({
				processing: true,
				serverSide: true,
				"ajax": {
                    "url": "{{url('ernetdash/expiredajax')}}",
                    "type": "GET",
                    "datatype": "json",
					"data": function(d){
						d.from = $('#start_date').val();
						d.to = $('#end_date').val();
						d.domain = $('.domain').val();
						d.state=$('#state').val();
					}
                },
				columns: [
					{ data: 'id', orderable: false}, 
					{ data: 'domain', orderable: false},
					{ data: 'inst', orderable: false},
					{ data: 'phone', orderable: false},
					{ data: 'period', orderable: false},
					{ data: 'expiry_date', orderable: false},
				],
				"language": {
                 "emptyTable": "No Data Available"
                },
                "searching": false
			});
			
			$('body').on('click', '.search', function() {
				$start=$('#start_date').val();
				 $end=$('#end_date').val();

    if($start!= '' && $end!= '' && $start> $end)
    {
    alert("From Date cannot be greater than To Date");
    return false;
    }else{
		table.ajax.reload();
	}
			});

			$('.dataTables_filter input').keyup(function() {
			$('.search_text').val($(this).val());
		    });
		
			$('body').on('click', '.exportdata', function() {
				$('#chatexport').submit();
			});
			
		});
	</script>

@endsection


