@extends('layouts.AdminLayout')

@section('content')

<style>

td.dt-nowrap { white-space: nowrap }
</style>

<div class="content-wrapper">

<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-2">Payment Report &nbsp;&nbsp;<span class="btn btn-primary exportdata" style="color:whitelcursor:pointer">Export To Excel</span></h4>
			
		<div class="card">
			<div style="padding:20px">	

            <div class="row py-2">
			<h5 class="fw-bold py-3 mb-1" style="text-align:center;">As on Date : {{date('d/m/Y')}}</h4>
            <form method="get" id="chatexport" action="{{ url('/ernetdash/paymentexport') }}">	
			@csrf
			<input type="hidden" name="search_text" class="search_text" >

			<div class="row px-10 my-2">
					<div class="col-md-3" id="tday2">							
					<label style="font-family:Times New Roman;color:black" >Application Date From<br></label>
						<div class="input-group" style="float:left;">
							<input type="date"  max="<?php echo  date('Y-m-d'); ?>" data-date-format="yyyy-mm-dd" data-date-viewmode="years" class="form-control from" name="dd1" id="start_date" autocomplete="off">
						</div>
					</div>
					
					<div
					 class="col-md-3" id="tday2">
					   <label  style="font-family:Times New Roman;color:black" >Application Date To<br></label>
						<div class="input-group" style="float:left;">
						<input type="date" max="<?php echo  date('Y-m-d'); ?>"  data-date-format="yyyy-mm-dd" data-date-viewmode="years" class="form-control to" name="dd2" id="end_date" autocomplete="off">
						</div>
					</div>

					<div class="col-md-3" id="tday2">							
					<label style="font-family:Times New Roman;color:black" >Payment Type <br></label>
						<div class="input-group " style="float:left;">
							<select class="form-control" name="trns_type" id="trns_type">
								<option value="">Select</option>
								@foreach($transaction_type as $type)

								<?php
								$types='';
								if($type->transaction_type=='domainRegister'){
									$types='Domain Registration Fee';
								}else if($type->transaction_type=='nameServerUpdate'){
								   $types='Ernet Name Server Fee';
								}else if($type->transaction_type=='domainRenewal'){
								   $types='Domain Renewal Fee';
								}else if($type->transaction_type=='domainRegisterWithNameServer'){
								   $types='Domain and DNS Fee';
								}else if($type->transaction_type=='userNameServerUpdate'){
								   $types='Name Server Update Fee';
								}else{
								   $types=$type->transaction_type;
								}
								
								?>
									<option value="{{$type->transaction_type}}">{{$types}}</option>
								@endforeach
							</select>
						</div>
					</div>

					<div class="col-md-3" id="tday2">							
					<label style="font-family:Times New Roman;color:black" >Domain Status <br></label>
						<div class="input-group " style="float:left;">
							<select class="form-control" name="domain_type" id="domain_type">
								<option value="">Select</option>
								<option value="1">Incomplete Application</option>
								<option value="2">Pending Creation</option>
								<option value="3">Rejected Domain</option>
								<option value="4">Renewal Domain Application</option>
								<option value="5">Hold </option>
								<option value="6">Pending Restorable</option>
								<option value="7">Cooling Period</option>
								<option value="8">Active-English</option>
								<option value="9">Active-Hindi</option>
							</select>
						</div>
					</div>




					<div class="col-md-3" id="tday2">							
					<label  style="font-family:Times New Roman;color:black" >Domain<br></label>
                    <div class="input-group " style="float:left;">
						<input type="text"  class="form-control domain" name="domain" id="domain" >
						</div>					
					</div>

					<div class="col-md-3" style="margin-top:20px;">	
						 <button type="button" class="btn btn-primary search ">Search</button>
						 <a href="{{url('ernetdash/reports/nixi-payment-report')}}" style="color:#fff"><button type="button" class="btn btn-info search">Reset</button></a>
						 </div>
						 <div class="col-md-3" style="margin-top:20px;">	
						 <b><span>Total Amount: <span id="totalAmountValue">0.00</span></span></b>
					</div>

					
		
					</div>
                </div>
                
				</div>
				</div>
	 <div class="card my-2">
		 <div style="padding:20px">
                
					<div class="table-responsive text-nowrap mt-4">
						
						<table class=" table table-striped table-bordered dataTable no-footer" id="dataTable" width="100%" cellspacing="0">
							<thead class="table-secondary">
							<tr>
                                <th>S.No.</th>
								<th>Domain Name</th>
								<th>Operation</th>
								<th>Period (in Years)</th>
                                <th>ERNET Status</th>
								<th>ERNET Expiry Date</th>
								<th>NIXI Status</th>
								<th>NIXI Expiry Date</th>
								<th>Last Payment received date</th>
								<th>Last Paid Amount</th>
								</tr>
							</thead>
						   
							<tbody>
								
							</tbody>
						</table>
					</div>

                    </form>
			</div>
		</div>

@endsection
@section("js")

<link href="{{ asset('vendor/datatables/dataTables.bootstrap4.min.css') }}" rel="stylesheet">

<script src="{{ asset('vendor/datatables/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('vendor/datatables/dataTables.bootstrap4.min.js') }}"></script>
	<script type="text/javascript">
		
		$(document).ready(function() {
			var table = $('#dataTable').DataTable({
				processing: true,
				serverSide: true,
				"ajax": {
                    "url": "{{url('/ernetdash/nixi-payment-ajax')}}",
                    "type": "GET",
                    "datatype": "json",
					"data": function(d){
						d.from = $('#start_date').val();
						d.to = $('#end_date').val();
						d.domain = $('.domain').val();
						d.trns_type = $('#trns_type').val();
						d.domain_type = $('#domain_type').val();
						
					}
                },
				columns: [
					{ data: 'id', orderable: false}, 
					{ data: 'domain', orderable: false},
					{ data: 'type', orderable: false},
                    { data: 'period', orderable: false},
					{ data: 'ernetstatus', orderable: false},
					{ data: 'ernetexpiredate', orderable: false},
                    { data: 'nixidetail', orderable: false},
					{ data: 'nixiexpiredate', orderable: false},
					{ data: 'txnAmount', orderable: false},
					{ data: 'created_at', orderable: false},
				],
				"language": {
                 "emptyTable": "No Data Available"
                },
                "searching": false
			});
			var from = $('#start_date').val();
			var to = $('#end_date').val();
			var domain = $('.domain').val();
			var trns_type = $('#trns_type').val();
			var domain_type = $('#domain_type').val();
			
			$.ajax({
				url: "{{ url('/ernetdash/nixi-gettotalamount') }}",
				type: "GET",
				dataType: "json",
				data:{
					'from':from,'to':to,'domain':domain,'trns_type':trns_type,'domain_type':domain_type,
				},
				success: function(response) {
					var totalAmount = response.totalamount;
					$('#totalAmountValue').text(totalAmount.toFixed(2));
				},
				error: function() {
					$('#totalAmountValue').text('0.00');
				}
			});
			$('body').on('click', '.search', function() {
				$start = $('#start_date').val();
				$end = $('#end_date').val();
				$trns_type=$('#trns_type').val();
				$domain_type=$('#domain_type').val();
				if ($start !== '' && $end !== '' && $start > $end) {
					alert("From Date cannot be greater than To Date");
					return false;
				} else {
					$.ajax({
						url: "{{ url('/ernetdash/nixi-gettotalamount') }}",
						type: "GET",
						dataType: "json",
						data: {
							'from': $start,
							'to': $end,
							'trns_type': $trns_type,
							'domain_type':$domain_type,
						},
						success: function(response) {
							var totalAmount = response.totalamount;
							$('#totalAmountValue').text(totalAmount.toFixed(2));
						}
					});
					table.ajax.reload();
				}
});

			$('.dataTables_filter input').keyup(function() {
			$('.search_text').val($(this).val());
		    });
		




			$('body').on('click', '.exportdata', function() {
				$('#chatexport').submit();
			});
			
		});
	</script>

@endsection


