@extends('layouts.AdminLayout')

@section('content')

<div class="content-wrapper">

<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-2">{{$pagetext}}</h4>
			
		<div class="card">
			<div style="padding:20px">	

            <div class="row py-2">
			<h5 class="fw-bold py-3 mb-1" style="text-align:center;">As on Date : {{date('d/m/Y')}}</h4>
            <form method="get" id="chatexport" action="{{ url('/ernetdash/vasexport') }}">	
			@csrf
			<input type="hidden" name="search_text" class="search_text" >

			<div class="row px-4 my-2">
					<div class="col-md-3" id="tday2">							
					<label style="font-family:Times New Roman;color:black" > Last Update Date From <br></label>
						<div class="input-group col-md-3" style="float:left;">
							<input type="text"  max="<?php echo  date('Y-m-d'); ?>" data-date-format="yyyy-mm-dd"  placeholder="dd-mm-yyyy" data-date-viewmode="years" class="form-control from datepicker" name="dd1" id="start_date" autocomplete="off">
						</div>
					</div>
					<div class="col-md-3" id="tday2">
					   <label  style="font-family:Times New Roman;color:black" > Last Update Date To<br></label>
						<div class="input-group col-md-3" style="float:left;">
						<input type="text" max="<?php echo  date('Y-m-d'); ?>"  data-date-format="yyyy-mm-dd" placeholder="dd-mm-yyyy" data-date-viewmode="years" class="form-control to datepicker" name="dd2" id="end_date" autocomplete="off">
						</div>
					</div>

					<div class="col-md-3" id="tday2">							
					<label  style="font-family:Times New Roman;color:black" >Domain<br></label>
                    <div class="input-group col-md-3" style="float:left;">
						<input type="text"  class="form-control domain" name="domain" id="domain" >
						</div>					
					</div>

					<div class="col-md-4" style="margin-top:20px;">	
						 <button type="button" class="btn btn-primary search ">Search</button>
					</div>
					
				</div>
                </div>
                
				</div>
				</div>
	 <div class="card my-2">
		 <div style="padding:20px">	
					<div class="table-responsive text-nowrap mt-4">
						
						<table class="table table-striped table-bordered dataTable no-footer" id="dataTable" width="100%" cellspacing="0">
						<thead class="table-secondary">
								<tr>
                                <th>S.No.</th>
								<th>Domain Name</th>
								<th>Template Name</th>
								<th>Service Type</th>
                                <th>Last Updated at</th>
								</tr>
							</thead>
						   
							<tbody>
								
							</tbody>
						</table>
					</div>

                    </form>
			</div>
		</div>

@endsection
@section("js")

<link href="{{ asset('vendor/datatables/dataTables.bootstrap4.min.css') }}" rel="stylesheet">
<link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>

<script src="{{ asset('vendor/datatables/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('vendor/datatables/dataTables.bootstrap4.min.js') }}"></script>


<script>
    $(function() {
      $(".datepicker").datepicker({
		 dateFormat: 'dd-mm-yy',
		 constrainInput: false,
		 changeYear:true,
		 changeMonth:true,
		 yearRange:'1980:+0',
		 maxDate:0
	 });
    });
  </script>

	<script type="text/javascript">
		
		$(document).ready(function() {

            var status="{{$status}}";

			var table = $('#dataTable').DataTable({
				processing: true,
				serverSide: true,
				"ajax": {
                    "url": "{{url('ernetdash/servicereportajax')}}",
                    "type": "GET",
                    "datatype": "json",
					"data": function(d){
						d.from = $('#start_date').val();
						d.to = $('#end_date').val();
						d.domain = $('.domain').val();
                        d.status=status;
					}
                },
				columns: [
					{ data: 'id', orderable: false}, 
					{ data: 'domain', orderable: false},
					{ data: 'temp', orderable: false},
					{ data: 'type', orderable: false},
					{ data: 'date', orderable: false},
				],
				"language": {
                 "emptyTable": "No Data Available"
                },
                "searching": false
			});
			
	$('body').on('click', '.search', function() {
				
    $start=$('#start_date').val();
	$end=$('#end_date').val();

    if($start!= '' && $end!= '' && $start> $end)
    {
    alert("From Date cannot be greater than To Date");
    return false;
    }else{
		table.ajax.reload();
	}
			
    });

			$('.dataTables_filter input').keyup(function() {
			$('.search_text').val($(this).val());
		    });
		
		
			
		});
	</script>

@endsection


