@extends('layouts.admin')

{{-- Web site Title --}}
@section('title')
    {{ __('tools/title.push_updates') }} @parent
@endsection

{{-- Content Header --}}
@section('header')
    {{ __('tools/title.push_updates') }}
    <small>{{ __('tools/title.push_updates_subtitle') }}</small>
@endsection

{{-- Breadcrumbs --}}
@section('breadcrumbs')
    <li>
        <a href="{{ url('ernetdash/dns-details-view') }}">
            <i class="fa fa-dashboard"></i> {{ __('site.dashboard') }}
        </a>
    </li>
    <li>
        <a href="{{-- route('tools.index') --}}">
            {{ __('site.tools') }}
        </a>
    </li>
    <li class="active">
        {{ __('tools/title.push_updates') }}
    </li>
@endsection

{{-- Content --}}
@section('content')
    <div class="box">
        <div class="box-header with-border">
            <h3 class="box-title">{{ __('tools/title.pushing_updates') }}</h3>
        </div>

        <div class="box-body">
            <div class="form-group">
                <textarea class="form-control" rows="15" id="output" disabled>{{ $output }}</textarea>
            </div>
        </div>

        <div class="box-footer">
            <a href="{{ url('ernetdash/dns-details-view') }}" class="btn btn-primary pull-right" role="button">
                {{ __('general.done') }} <i class="fa fa-arrow-right"></i>
            </a>
        </div>

    </div>
@endsection

{{-- Scripts --}}
@push('scripts')
    <script>
        $(function () {
            var $textarea = $('#output');
            $textarea.scrollTop($textarea[0].scrollHeight);
        });
    </script>
@endpush

