@extends('layouts.UserLayout')
@section('content')
@php
@endphp

<style>
    .check {
        -webkit-appearance: none;
        height: 20px;
        width: 20px;
        position: relative;
        transition: 0.10s;
        background-color: #FE0006;
        text-align: center;
        font-weight: 600;
        color: white;
        border-radius: 3px;
        outline: none;
    }

    .check:checked {
        background-color: #0E9700;
    }

    .check:before {
        content: "✖";
    }
    .check:checked:before {
        content: "✔";
    }

    .check:hover {
        cursor: pointer;
        opacity: 0.8;
    }

    .card-header {
    padding: 2.4rem 1.5rem;
    }

</style>
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="row">
        <div class="col-12 my-3 mt-5">
            <h5 class="card-header bg-info mb-3">
            <p style="float:left">Domain Contact Details </p>
            <p style="float:right;color:#fff">{{\Illuminate\Support\Facades\Auth::user()->domainName}}</p>  
            </h5>
            <div class="card">
                <div class="card-body">
                    <div class="text-light small fw-semibold text-end progress-label"></div>
                    <div class="demo-vertical-spacing">
                        <div class="progress">
                            <div
                                class="progress-bar bg-danger progress-bar-striped progress-bar-animated shadow-none"
                                role="progressbar"
                                style="width: 0%; padding: 10px"
                                aria-valuenow="0"
                                aria-valuemin="0"
                                aria-valuemax="100"
                            >
                                0%
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="nav-align-top mb-4">
                                <ul class="nav nav-tabs nav-fill" role="tablist">
                                    <li class="nav-item">
                                        <a
                                            type="button"
                                            class="nav-link home active"
                                            role="tab"
                                            data-bs-toggle="tab"
                                            data-bs-target="#navs-justified-home"
                                            aria-controls="navs-justified-home"
                                            aria-selected="true"
                                        >
                                            {{--                            <i class="tf-icons bx bx-home"></i> --}}
                                            Details of Institution
                                            <span class="badge  bg-label-danger"></span>
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a
                                            type="button"
                                            class="nav-link profile"
                                            role="tab"
                                            data-bs-toggle="tab"
                                            data-bs-target="#navs-justified-profile"
                                            aria-controls="navs-justified-profile"
                                            aria-selected="false"
                                        >
                                            Details of Head of Institution
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a
                                            type="button"
                                            class="nav-link messages"
                                            role="tab"
                                            data-bs-toggle="tab"
                                            data-bs-target="#navs-justified-messages"
                                            aria-controls="navs-justified-messages"
                                            aria-selected="false"
                                        >
                                            Administrative Contact Details
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a
                                            type="button"
                                            class="nav-link billing"
                                            role="tab"
                                            data-bs-toggle="tab"
                                            data-bs-target="#navs-justified-billing"
                                            href="#navs-justified-billing"
                                            aria-controls="navs-justified-billing"
                                            aria-selected="false"
                                        >
                                            Billing Contact Details
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a
                                            type="button"
                                            class="nav-link technical"
                                            role="tab"
                                            data-bs-toggle="tab"
                                            data-bs-target="#navs-justified-technical"
                                            href="#navs-justified-technical"
                                            aria-controls="navs-justified-technical"
                                            aria-selected="false"
                                        >
                                            Technical Contact Details
                                        </a>
                                    </li>
                                </ul>
                                <div class="tab-content" style="box-shadow: none">
                                    <div class="tab-pane fade show active" id="navs-justified-home" role="tabpanel">
                                        <div class="card mb-4" style="box-shadow: none" >
                                            <div class="card-header d-flex align-items-center justify-content-between">
                                                <h5 class="mb-0 text-center"></h5>
                                                {{--                    <small class=" float-end  text-dark"></small>--}}
                                            </div>
                                            <div class="card-body">
                                                <form method="post" id="InstitutionDetail" action="">
                                                    @csrf
                                                    <div class="row mb-3">
                                                        <label class="col-sm-2 col-form-label" for="basic-default-name">Name of Institution</label>
                                                        <div class="col-sm-10">
                                                            <input type="text" name="institution" class="form-control institution_name" id="basic-default-name" value="{{\Illuminate\Support\Facades\Auth::user()->institute ?? ''}}" placeholder="" disabled />
                                                        </div>
                                                    </div>

                                                   

                                                    <div class="row mb-3">
                                                        <label class="col-sm-2 col-form-label" for="basic-default-message">Address<span style="color: red">*</span></label>
                                                        <div class="col-sm-10">
                                                        <textarea
                                                            id="basic-default-message"
                                                            name="address"
                                                            class="form-control address"
                                                            placeholder="Enter Institute Address"
                                                            aria-label="Hi, Do you have a moment to talk Joe?"
                                                            aria-describedby="basic-icon-default-message2"
                                                            required
                                                        ></textarea>
                                                        </div>
                                                    </div>

                                                    <div class="row mb-3">
                                                        <label class="col-sm-2 col-form-label" for="basic-default-pincode">Pin Code<span style="color: red">*</span></label>
                                                        <div class="col-sm-10">
                                                            <input
                                                                type="number"
                                                                maxlength="6"
                                                                name="pincode"
                                                                id="basic-default-pincode"
                                                                class="form-control pincode"
                                                                placeholder="Enter Pin Code"
                                                                aria-label="658 799 8941"
                                                                aria-describedby="basic-default-pincode"
                                                                required
                                                            />
                                                        </div>
                                                    </div>

                                                    
                                                    <div class="row mb-3">
                                                        <label class="col-sm-2 col-form-label" for="basic-default-city">City<span style="color: red">*</span></label>
                                                        <div class="col-sm-10">
                                                            <!-- <select name="city" class="form-control city" required id="city">
                                                                <option value="" class="form-control">Select City</option>
                                                               
                                                            </select> -->

                                                            <input
                                                                    type="text"
                                                                    name="city"
                                                                    id="city"
                                                                    class="form-control city"
                                                                    placeholder="City Name"
                                                                    required
                                                                    readonly
                                                            />
                                                        </div>
                                                    </div>

                                                    <div class="row mb-3">
                                                        <label class="col-sm-2 col-form-label" for="basic-default-state">State<span style="color: red">*</span></label>
                                                        <div class="col-sm-10">
                                                            <select name="state" class="form-control state" required id="state" disabled>
                                                                <option value="">Select State</option>
                                                                @foreach($states as $state)
                                                                    <option value="{{$state->description}}">{{$state->description}}</option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                    </div>
                                                    
                                                    <div class="row mb-3">
                                                        <label class="col-sm-2 col-form-label" for="basic-default-phone">Phone No<span style="color: red">*</span></label>
                                                        <div class="col-sm-10">
                                                                <input
                                                                    type="number"
                                                                    maxlength="12"
                                                                    name="phone"
                                                                    id="basic-default-phone"
                                                                    class="form-control phone"
                                                                    placeholder="123-456-7890"
                                                                    aria-label="658 799 8941"
                                                                    aria-describedby="basic-default-phone"
                                                                    required
                                                                />
                                                        </div>
                                                    </div>
                                                    <div class="row mb-3">
                                                        <label class="col-sm-2 col-form-label" for="basic-default-phone">GST No</label>
                                                        <div class="col-sm-10">
                                                            <div class="input-group">
                                                                <input
                                                                    type="text"
                                                                    maxlength="15"
                                                                    name="gst"
                                                                    id=""
                                                                    class="form-control phone-mask gst"
                                                                    placeholder="00AAAAA0000A0A0"
                                                                    aria-label="658 799 8941"
                                                                    aria-describedby="basic-default-phone"
                                                                />
                                                                <span class="input-group-text" id="basic-addon14"><input id="checkGST" type="checkbox" name="switch" class="check" disabled></span>
                                                            </div>

                                                        </div>

                                                    </div>
                                                    <div class="row justify-content-end">
                                                        <div class="col-sm-10">
                                                            <button type="submit" class=" submit btn btn-success">Save</button>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="tab-pane fade" id="navs-justified-profile" role="tabpanel"  >
                                        <div class="col-xxl">
                                            <div class="card mb-4" style="box-shadow: none">
                                                <div class="card-header d-flex align-items-center justify-content-between">
                                                </div>
                                                <div class="card-body">
                                                    <form method="post" id="InstitutionHeadDetail" action="">
                                                        @csrf
                                                        <div class="row mb-3">
                                                            <label class="col-sm-2 col-form-label" for="basic-default-name">Name<span style="color: red">*</span></label>
                                                            <div class="col-sm-10">
                                                                <input type="text" name="head[name]" value="{{Auth::user()->name ?? ''}}" class="form-control InstitutionHeadName" id="basic-default-name" placeholder="Enter Name" readonly required/>
                                                            </div>
                                                        </div>
                                                        <div class="row mb-3">
                                                            <label class="col-sm-2 col-form-label" for="basic-default-Designation ">Designation </label>
                                                            <div class="col-sm-10">
                                                                <input
                                                                    value="{{Auth::user()->designation ?? ''}}"
                                                                    name="head[designation]"
                                                                    type="text"
                                                                    class="form-control InstitutionHeadDesignation"
                                                                    id="basic-default-Designation "
                                                                    placeholder="Enter Designation"
                                                                    readonly
                                                                    required
                                                                />
                                                            </div>
                                                        </div>
                                                        <div class="row mb-3">
                                                            <label class="col-sm-2 col-form-label" for="basic-default-email">Email<span style="color: red">*</span></label>
                                                            <div class="col-sm-10">
                                                                <div class="">
                                                                    <input
                                                                        value="{{Auth::user()->email ?? ''}}"
                                                                        type="email"
                                                                        name="head[email]"
                                                                        id="basic-default-email"
                                                                        class="form-control InstitutionHeadEmail"
                                                                        placeholder="Enter Email"
                                                                        aria-label="john.doe"
                                                                        aria-describedby="basic-default-email2"
                                                                        readonly
                                                                        required
                                                                    />
                                                                </div>
                                                                <div class="form-text"></div>
                                                            </div>
                                                        </div>
                                                        <div class="row mb-3">
                                                            <label class="col-sm-2 col-form-label" for="basic-default-phone">Phone No<span style="color: red">*</span></label>
                                                            <div class="col-sm-10">
                                                                <input
                                                                    type="number"
                                                                    name="head[phone]"
                                                                    id="basic-default-phone"
                                                                    class="form-control InstitutionHeadPhone phone"
                                                                    placeholder="658 799 8941"
                                                                    aria-label="658 799 8941"
                                                                    aria-describedby="basic-default-phone"
                                                                    required
                                                                />
                                                            </div>
                                                        </div>
                                                        <div class="row mb-3">
                                                            <label class="col-sm-2 col-form-label" for="basic-default-mobile">Mobile No<span style="color: red">*</span></label>
                                                            <div class="col-sm-10">
                                                                <div class="input-group">
                                                                    <span class="input-group-text" id="basic-addon14">+91</span>
                                                                    <input
                                                                        type="number"
                                                                        maxlength="10"
                                                                        name="head[mobile]"
                                                                        id="basic-default-mobile"
                                                                        class="form-control InstitutionHeadMobile mobile"
                                                                        placeholder="658 799 8941"
                                                                        aria-label="658 799 8941"
                                                                        aria-describedby="basic-default-mobile"
                                                                        required
                                                                    />
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="row justify-content-end">
                                                            <div class="col-sm-10">
                                                                <button type="submit" class=" submit btn btn-success">Save</button>
                                                            </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="tab-pane fade" id="navs-justified-messages" role="tabpanel">
                                        <div class="col-xxl">
                                            <div class="card mb-4" style="box-shadow: none">
                                                <div class="card-header d-flex align-items-center justify-content-between">
                                                    {{--                                    <h5 class="mb-0">Basic Layout</h5>--}}
                                                    <!-- <small class=" float-end  text-dark text-dark"><input class="AdministrativeDetail" type="checkbox"> &nbsp; Same as Head of Institution</small> -->
                                                </div>
                                                <div class="card-body">
                                                    <form method="post" id="AdministrativeDetail" action="">
                                                        @csrf
                                                        <div class="row mb-3">
                                                            <label class="col-sm-2 col-form-label" for="basic-default-name">Name<span style="color: red">*</span></label>
                                                            <div class="col-sm-10">
                                                                <input type="text" name="administrative[name]" class="form-control AdministrativeName" id="basic-default-name" placeholder="Enter Name" required />
                                                            </div>
                                                        </div>
                                                        <div class="row mb-3">
                                                            <label class="col-sm-2 col-form-label" for="basic-default-Designation ">Designation <span style="color: red">*</span></label>
                                                            <div class="col-sm-10">
                                                                <input
                                                                    name="administrative[designation]"
                                                                    type="text"
                                                                    class="form-control AdministrativeDesignation"
                                                                    id="basic-default-Designation "
                                                                    placeholder="Enter Designation"
                                                                    required
                                                                />
                                                            </div>
                                                        </div>
                                                        <div class="row mb-3">
                                                            <label class="col-sm-2 col-form-label" for="basic-default-email">Email<span style="color: red">*</span></label>
                                                            <div class="col-sm-10">
                                                                <div class="input-group input-group-merge">
                                                                    <input
                                                                        type="email"
                                                                        name="administrative[email]"
                                                                        id="basic-default-email"
                                                                        class="form-control AdministrativeEmail"
                                                                        placeholder="Enter Email"
                                                                        aria-label="john.doe"
                                                                        aria-describedby="basic-default-email2"
                                                                        required
                                                                    />
                                                                </div>
                                                                <div class="form-text"></div>
                                                            </div>
                                                        </div>
                                                        <div class="row mb-3">
                                                            <label class="col-sm-2 col-form-label" for="basic-default-phone">Phone No<span style="color: red">*</span></label>
                                                            <div class="col-sm-10">
                                                                <input
                                                                    type="number"
                                                                    maxlength="12"
                                                                    name="administrative[phone]"
                                                                    id="basic-default-phone"
                                                                    class="form-control AdministrativePhone phone"
                                                                    placeholder="123-456-7890"
                                                                    aria-label="658 799 8941"
                                                                    aria-describedby="basic-default-phone"
                                                                    required
                                                                />
                                                            </div>
                                                        </div>
                                                        <div class="row mb-3">
                                                            <label class="col-sm-2 col-form-label" for="basic-default-phone">Mobile No<span style="color: red">*</span></label>
                                                            <div class="col-sm-10">
                                                                <div class="input-group">
                                                                    <span class="input-group-text" id="basic-addon14">+91</span>
                                                                    <input
                                                                        type="number"
                                                                        name="administrative[mobile]"
                                                                        id="basic-default-phone"
                                                                        class="form-control AdministrativeMobile mobile"
                                                                        placeholder="658 799 8941"
                                                                        aria-label="658 799 8941"
                                                                        aria-describedby="basic-default-phone"
                                                                        required
                                                                    />
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="row justify-content-end">
                                                            <div class="col-sm-10">
                                                                <button type="submit" class="submit btn btn-success">Save</button>
                                                            </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="tab-pane fade" id="navs-justified-billing" role="tabpanel">
                                        <div class="col-xxl">
                                            <div class="card mb-4" style="box-shadow: none">
                                                <div class="card-header d-flex align-items-center justify-content-between">
                                                    {{--                                    <h5 class="mb-0">Basic Layout</h5>--}}
                                                    <!-- <small class=" float-end  text-dark"><input class="BillingDetail" type="checkbox"> &nbsp; Same as Administrative Details</small> -->
                                                </div>
                                                <div class="card-body">
                                                    <form method="post" id="BillingDetail" action="">
                                                        @csrf
                                                        <div class="row mb-3">
                                                            <label class="col-sm-2 col-form-label" for="basic-default-name">Name<span style="color: red">*</span></label>
                                                            <div class="col-sm-10">
                                                                <input type="text" name="billing[name]" class="form-control BillingName" id="basic-default-name" placeholder="Enter Name" required />
                                                            </div>
                                                        </div>
                                                        <div class="row mb-3">
                                                            <label class="col-sm-2 col-form-label" for="basic-default-Designation ">Designation <span style="color: red">*</span></label>
                                                            <div class="col-sm-10">
                                                                <input
                                                                    name="billing[designation]"
                                                                    type="text"
                                                                    class="form-control BillingDesignation"
                                                                    id="basic-default-Designation "
                                                                    placeholder="Enter Designation"
                                                                    required
                                                                />
                                                            </div>
                                                        </div>
                                                        <div class="row mb-3">
                                                            <label class="col-sm-2 col-form-label" for="basic-default-email">Email<span style="color: red">*</span></label>
                                                            <div class="col-sm-10">
                                                                <div class="input-group input-group-merge">
                                                                    <input
                                                                        type="email"
                                                                        name="billing[email]"
                                                                        id="basic-default-email"
                                                                        class="form-control BillingEmail"
                                                                        placeholder="Enter Email"
                                                                        aria-label="john.doe"
                                                                        aria-describedby="basic-default-email2"
                                                                        required
                                                                    />
                                                                </div>
                                                                <div class="form-text"></div>
                                                            </div>
                                                        </div>
                                                        <div class="row mb-3">
                                                            <label class="col-sm-2 col-form-label" for="basic-default-phone">Phone No<span style="color: red">*</span></label>
                                                            <div class="col-sm-10">
                                                                <input
                                                                    type="number"
                                                                    maxlength="12"
                                                                    name="billing[phone]"
                                                                    id="basic-default-phone"
                                                                    class="form-control BillingPhone phone"
                                                                    placeholder="123-456-7890"
                                                                    aria-label="658 799 8941"
                                                                    aria-describedby="basic-default-phone"
                                                                    required
                                                                />
                                                            </div>
                                                        </div>
                                                        <div class="row mb-3">
                                                            <label class="col-sm-2 col-form-label" for="basic-default-phone">Mobile No<span style="color: red">*</span></label>
                                                            <div class="col-sm-10">
                                                                <div class="input-group">
                                                                    <span class="input-group-text" id="basic-addon14">+91</span>
                                                                    <input
                                                                        type="number"
                                                                        maxlength="10"
                                                                        name="billing[mobile]"
                                                                        id="basic-default-phone"
                                                                        class="form-control BillingMobile mobile"
                                                                        placeholder="658 799 8941"
                                                                        aria-label="658 799 8941"
                                                                        aria-describedby="basic-default-phone"
                                                                        required
                                                                    />
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="row justify-content-end">
                                                            <div class="col-sm-10">
                                                                <button type="submit" class="submit btn btn-success">Save</button>
                                                            </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="tab-pane fade" id="navs-justified-technical" role="tabpanel">
                                        <div class="col-xxl">
                                            <div class="card mb-4" style="box-shadow: none">
                                                <div class="card-header d-flex align-items-center justify-content-between">
                                                    <!-- {{--                                    <h5 class="mb-0">Basic Layout</h5>--}}   <small class=" float-end  text-dark"><input class="TechnicalDetail" type="checkbox"> &nbsp; Same as Administrative Details</small> -->
                                                    <small class=" float-end  text-dark"></small>
                                                </div>
                                                <div class="card-body">
                                                    <form id="TechnicalDetail" method="post">
                                                        @csrf
                                                        <div class="row mb-3">
                                                            <label class="col-sm-2 col-form-label" for="basic-default-name">Name<span style="color: red">*</span></label>
                                                            <div class="col-sm-10">
                                                                <input type="text" name="technical[name]" class="form-control TechnicalName" id="basic-default-name" placeholder="Enter Name" required />
                                                            </div>
                                                        </div>
                                                        <div class="row mb-3">
                                                            <label class="col-sm-2 col-form-label" for="basic-default-Designation ">Designation <span style="color: red">*</span></label>
                                                            <div class="col-sm-10">
                                                                <input
                                                                    name="technical[designation]"
                                                                    type="text"
                                                                    class="form-control TechnicalDesignation"
                                                                    id="basic-default-Designation "
                                                                    placeholder="Enter Designation"
                                                                    required
                                                                />
                                                            </div>
                                                        </div>
                                                        <div class="row mb-3">
                                                            <label class="col-sm-2 col-form-label" for="basic-default-email">Email<span style="color: red">*</span></label>
                                                            <div class="col-sm-10">
                                                                <div class="">
                                                                    <input
                                                                        type="email"
                                                                        name="technical[email]"
                                                                        id="basic-default-email"
                                                                        class="form-control TechnicalEmail"
                                                                        placeholder="Enter Email"
                                                                        aria-label="john.doe"
                                                                        aria-describedby="basic-default-email2"
                                                                        required
                                                                    />
                                                                </div>
                                                                <label  style="display: none;font-size: 12px;color: red" class=" techEmailError  " >This email should be different from Administrative Contact Details email.</label>
                                                                <div class="form-text"></div>
                                                            </div>
                                                        </div>
                                                        <div class="row mb-3">
                                                            <label class="col-sm-2 col-form-label" for="basic-default-phone">Phone No<span style="color: red">*</span></label>
                                                            <div class="col-sm-10">
                                                                <input
                                                                    type="number"
                                                                    name="technical[phone]"
                                                                    id="basic-default-phone"
                                                                    class="form-control TechnicalPhone phone"
                                                                    placeholder="123-456-7890"
                                                                    aria-label="658 799 8941"
                                                                    aria-describedby="basic-default-phone"
                                                                    required
                                                                />
                                                            </div>
                                                        </div>
                                                        <div class="row mb-3">
                                                            <label class="col-sm-2 col-form-label" for="basic-default-phone">Mobile No<span style="color: red">*</span></label>
                                                            <div class="col-sm-10">
                                                                <div class="input-group">
                                                                    <span class="input-group-text" id="basic-addon14">+91</span>
                                                                    <input
                                                                        type="number"
                                                                        name="technical[mobile]"
                                                                        id="basic-default-phone"
                                                                        class="form-control TechnicalMobile mobile"
                                                                        placeholder="658 799 8941"
                                                                        aria-label="658 799 8941"
                                                                        aria-describedby="basic-default-phone"
                                                                        required
                                                                    />
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="row justify-content-end">
                                                            <div class="col-sm-10">
                                                                <button type="submit" class="submit btn btn-success
">Submit</button>
                                                            </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Domain Status Table End-->
    </div>
</div>
<!-- Content wrapper -->

@endsection
@section("js")
<script>
    var domainSt = {{\Illuminate\Support\Facades\Auth::user()->domainStatus}};
    $(function() {
        var domainSt = {{\Illuminate\Support\Facades\Auth::user()->domainStatus}};
        if (domainSt == 6){
            $('.home').addClass('disabled');
            $('.profile').addClass('disabled');
            $('.messages').addClass('disabled');
            $("#InstitutionDetail :input").attr("disabled", true);

            var tab = {{$tab??1}}
            if (tab == 5){
                $('.nav a[href="#navs-justified-technical"]').tab('show');
            }else {
                $('.nav a[href="#navs-justified-billing"]').tab('show');
            }
        }
        getListData();
        $(document).ready(function() {
            $('.profile').addClass('disabled');
            $('.messages').addClass('disabled');
            $('.billing').addClass('disabled');
            $('.technical').addClass('disabled');
            // $('#checkGST').attr('checked',true);
        });
        $('.phone').keypress(function(e) {
            var txt = String.fromCharCode(e.which);
            if (!txt.match(/[0-9]/)) {
                return false;
            }
            if ($(this).val().length > 11) {
                e.preventDefault();
            }
        });
        $('.mobile').keypress(function(e) {
            var txt = String.fromCharCode(e.which);
            if (!txt.match(/[0-9]/)) {
                return false;
            }
            if ($(this).val().length > 9) {
                e.preventDefault();
            }
        });

        $('.address').keypress(function(e) {
            var txt = String.fromCharCode(e.which);
            if (!txt.match(/[a-zA-Z0-9 ]/)) {
                return false;
            }
        });
        $('.pincode').keypress(function(e) {
            if ($(this).val().length > 5) {
                e.preventDefault();
            }
        });
        $('.TechnicalEmail').keyup(function(e) {
            // $('.techEmailError').hide();
            
            // if ($(this).val() == $('.InstitutionHeadEmail').val() || $(this).val() == $('.AdministrativeEmail').val()) {
            //     $('.techEmailError').show();
            // }
        });
        $('.AdministrativeEmail').keypress(function(e) {
            var txt = String.fromCharCode(e.which);
            if (!txt.match(/[a-zA-Z0-9@_. ]/)) {
                return false;
            }
        }); 
        $('.BillingEmail').keypress(function(e) {
            var txt = String.fromCharCode(e.which);
            if (!txt.match(/[a-zA-Z0-9@_. ]/)) {
                return false;
            }
        }); 
        $('.TechnicalEmail').keypress(function(e) {
            var txt = String.fromCharCode(e.which);
            if (!txt.match(/[a-zA-Z0-9@_. ]/)) {
                return false;
            }
        });
        $('.gst').keyup(function(e) {
            $('#checkGST').attr('checked',false);
            var gst = $(this).val();
            if (gst.match(/[0-9]{2}[A-Z]{5}[0-9]{4}[A-Z]{1}[1-9A-Z]{1}Z[0-9A-Z]{1}/)) {
                $.ajax({
                    url: "{{ url('verifyGst') }}",
                    dataType : "json",
                    type: "get",
                    data:{gst:gst},
                    success : function(response) {
                        if(response.status == true) {
                            $('#checkGST').attr('checked',true);
                        } else if(response.status == false) {
                            $('#checkGST').attr('checked',false);
                        }
                    },
                });
            }

        });

        $('.pincode').keyup(function(e) {
            $.ajax({
                url: "{{ url('getpincode') }}",
                dataType : "json",
                type: "get",
                data:{pincode:$(this).val()},
                success : function(response) {

                    if(response.status == true) {

                    if(response.data!=null){
                       $('#state option[value="' + response.data.state_name + '"]').prop('selected', true);          
                       $('#city').val(response.data.name);
                    }else{
                        $('#state option[value=""]').prop('selected', true);          
                       $('#city').val('');
                    }

                    } else if(response.status == false) {
                        alert(response.message);
                    }

                },
            });
        });


        $(document).on("change",'.state',function(){
            $.ajax({
                url: "{{ url('getCityByState') }}"+'/'+$(this).val(),
                dataType : "json",
                type: "get",
                success : function(response) {

                    if(response.status == true) {
                        $('.city').empty();
                        $.each( response.data, function( key, value ) {
                            $('.city').append('<option value="'+value.name+'">'+value.name+'</option>');
                        });
                    } else if(response.status == false) {
                        alert(response.message);
                    }

                },
            });
        });
    });
    function getListData(){
        $.ajax({
            url: "{{ url('domainContactDetailsList') }}",
            dataType : "json",
            type: "get",
            success : function(response) {

                if(response.status == true) {
                    console.log(response.data.address);
                    if (domainSt == 6){
                        $('.home').addClass('disabled');
                        $('.profile').addClass('disabled');
                        $('.messages').addClass('disabled');
                    }

                    if(domainSt>4){
                        /*$('.home').addClass('disabled');  
                        $('.profile').tab('show');*/
                          
                        $('.home').tab('show');
                        $('.profile').removeClass('disabled');
                    }
                    $('.address').html(response.data.address);
                    // $('.state').val(response.data.state).change();
                    // $('.city').val(response.data.city).change();

                    $('#state option[value="' + response.data.state + '"]').prop('selected', true);          
                    $('.city').val(response.data.city);

                    $('.pincode').val(response.data.pincode);
                    $('.gst').val(response.data.gst_no);

                    if(response.data.gst_no!=null){
                        $('#checkGST').attr('checked',true);
                    };
                    
                    $('.phone').val(response.data.phone);
                    {{--if (response.data.gst_no != null){--}}
                    {{--    var gst = response.data.gst_no;--}}
                    {{--    if (gst.match(/[0-9]{2}[A-Z]{5}[0-9]{4}[A-Z]{1}[1-9A-Z]{1}Z[0-9A-Z]{1}/)) {--}}
                    {{--        $.ajax({--}}
                    {{--            url: "{{ url('verifyGst') }}",--}}
                    {{--            dataType : "json",--}}
                    {{--            type: "get",--}}
                    {{--            data:{gst:gst},--}}
                    {{--            success : function(response) {--}}
                    {{--                if(response.status == true) {--}}
                    {{--                    $('#checkGST').attr('checked',true);--}}
                    {{--                } else if(response.status == false) {--}}
                    {{--                    $('#checkGST').attr('checked',false);--}}
                    {{--                }--}}
                    {{--            },--}}
                    {{--        });--}}
                    {{--    }--}}
                    {{--}--}}



                    $('.progress-bar').attr('aria-valuenow','20');
                    $('.progress-bar').css('width','20%');
                    $('.progress-bar').html('20%');

                    if (response.data.institution_head_detail != null){
                        $('.profile').removeClass('disabled');
                        if (domainSt == 6){
                            $('.home').addClass('disabled');
                            $('.profile').addClass('disabled');
                            $('.messages').addClass('disabled');
                        }
                        $('.progress-bar').attr('aria-valuenow','40');
                        $('.progress-bar').css('width','40%');
                        $('.progress-bar').html('40%');
                        $('.progress-bar').removeClass('bg-danger');
                        $('.progress-bar').addClass('bg-warning');
                    }
                    if (response.data.administrative_detail != null){
                        $('.messages').removeClass('disabled');
                        if (domainSt == 6){
                            $('.home').addClass('disabled');
                            $('.profile').addClass('disabled');
                            $('.messages').addClass('disabled');
                        }
                        $('.progress-bar').attr('aria-valuenow','60');
                        $('.progress-bar').css('width','60%');
                        $('.progress-bar').html('60%');
                    }
                    if (response.data.billing_contact_detail != null){
                        $('.billing').removeClass('disabled');
                        $('.progress-bar').attr('aria-valuenow','80');
                        $('.progress-bar').css('width','80%');
                        $('.progress-bar').html('80%');
                    }
                    if (response.data.technical_detail != null){
                        $('.technical').removeClass('disabled');
                        $('.progress-bar').attr('aria-valuenow','100');
                        $('.progress-bar').css('width','100%');
                        $('.progress-bar').html('100%');
                        $('.progress-bar').removeClass('bg-warning');
                        $('.progress-bar').addClass('bg-success');
                    }

                    $('.InstitutionHeadName').val(JSON.parse(response.data.institution_head_detail).name);
                    $('.InstitutionHeadDesignation').val(JSON.parse(response.data.institution_head_detail).designation);
                    $('.InstitutionHeadEmail').val(JSON.parse(response.data.institution_head_detail).email);
                    $('.InstitutionHeadPhone').val(JSON.parse(response.data.institution_head_detail).phone);
                    $('.InstitutionHeadMobile').val(JSON.parse(response.data.institution_head_detail).mobile);

                    $('.AdministrativeName').val(JSON.parse(response.data.administrative_detail).name);
                    $('.AdministrativeDesignation').val(JSON.parse(response.data.administrative_detail).designation);
                    $('.AdministrativeEmail').val(JSON.parse(response.data.administrative_detail).email);
                    $('.AdministrativePhone').val(JSON.parse(response.data.administrative_detail).phone);
                    $('.AdministrativeMobile').val(JSON.parse(response.data.administrative_detail).mobile);

                    $('.BillingName').val(JSON.parse(response.data.billing_contact_detail).name);
                    $('.BillingDesignation').val(JSON.parse(response.data.billing_contact_detail).designation);
                    $('.BillingEmail').val(JSON.parse(response.data.billing_contact_detail).email);
                    $('.BillingPhone').val(JSON.parse(response.data.billing_contact_detail).phone);
                    $('.BillingMobile').val(JSON.parse(response.data.billing_contact_detail).mobile);

                    $('.TechnicalName').val(JSON.parse(response.data.technical_detail).name);
                    $('.TechnicalDesignation').val(JSON.parse(response.data.technical_detail).designation);
                    $('.TechnicalEmail').val(JSON.parse(response.data.technical_detail).email);
                    $('.TechnicalPhone').val(JSON.parse(response.data.technical_detail).phone);
                    $('.TechnicalMobile').val(JSON.parse(response.data.technical_detail).mobile);


                } else if(response.status == false) {

                    alert(response.message);

                }

            },
        });
    }

  var regex = /^[6-9]\d{9}$/; 

  $('#InstitutionDetail').validate({
    rules: {
      phone: {
        required: true,
        phoneIN: true
      },
    },
    messages: {
        phone: {
        required: "Please Enter phone no",
        phoneIN: "Please enter a valid phone number"
      },
    },

    submitHandler:function(form)
    {
        if ($('.gst').val().length>1){
            if ($('#checkGST').is(':unchecked')){
                Swal.fire({
                    icon: 'error',
                    text: 'Invalid GST number!',
                    showConfirmButton: true,
                });
                return false;
            }
        }

   
      $('#state').removeAttr('disabled');

      $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
      });
      $.ajax({
        url:"{{route('updateInstitutionDetail')}}",
        type:'POST',
        dataType:'json',
        data:$("#InstitutionDetail").serialize(),
        cache: false,
        beforeSubmit: function(){
            $(".loader-area").show();
        },
        success:function(res)
        {
          if(res == true)
          {
              $('#state').attr('disabled','disabled');
              Swal.fire({
                  icon: 'success',
                  text: 'Institution details saved successfully!',
                  showConfirmButton: true,
              });

          }
          else if(res == false)
          {
              $('#state').attr('disabled','disabled');
              alert('Not Updated!');
          }
          else {
            $('#state').attr('disabled','disabled');
              alert('something went wrong!');
          }
        },
        complete: function(){
            $("form").trigger("reset");
            $(".submit").prop('disabled',false);
            $('.profile').tab('show');
            $('.profile').removeClass('disabled');
            getListData();
        },
      });
    }
  });


  $.validator.addMethod("phoneIN", function(value, element) {
    //return this.optional(element) || /^(\+91[\-\s]?)?[0]?(91)?[0123456789]\d{7,11}$/.test(value);
    return this.optional(element) || /^(?!(\d)\1{11})\d{12}$/.test(value);
}, "Please enter a valid  phone number");

  $('#InstitutionHeadDetail').validate({
        rules: {
            phone: {
              required: true,
              phoneIN : true
            },
            mobile: {
              required: true,
              phoneIN : true
            },
        },
        messages: {
          phone: {
              required: "Please Enter phone no",
              phoneIN: "Please enter a valid phone number"
          },
          mobile: {
              required: "Please Enter phone no",
              phoneIN: "Please enter a valid mobile number"
          },
      },
      submitHandler:function(form)
      {


//if (!regex.test($('.InstitutionHeadPhone').val())) {
 // alert('Please enter a valid mobile number');
 // return false;
//}
if (!regex.test($('.InstitutionHeadMobile').val())) {
  alert('Please enter a valid mobile number');
  return false;
}


          $.ajaxSetup({
              headers: {
                  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
              }
          });
          $.ajax({
              url:"{{route('updateInstitutionHeadDetail')}}",
              type:'POST',
              dataType:'json',
              data:$("#InstitutionHeadDetail").serialize(),
              cache: false,
              beforeSubmit: function(){
                  $(".loader-area").show();
              },
              success:function(res)
              {
                  if(res == true)
                  {
                      Swal.fire({
                          icon: 'success',
                          text: 'Head of Institution details saved successfully!',
                          showConfirmButton: true,
                      });
                  }
                  else if(res == false)
                  {
                      alert('Not Updated!');
                  }
                  else {
                      alert('something went wrong!');
                  }
              },
              complete: function(){
                  $("form").trigger("reset");
                  $(".submit").prop('disabled',false);
                  $('.messages').tab('show');
                  $('.messages').removeClass('disabled');
                  getListData();
              },
          });
      }
  });

  $('#AdministrativeDetail').validate({
      rules: {
          name: {
              required: true,
          },
      },
      messages: {
          name: {
              required: "Please Enter name",
              name: "Please Enter name",
          },
      },
      submitHandler:function(form)
      {

          if ($('.AdministrativeEmail').val() == $('.InstitutionHeadEmail').val()) {
              alert('Admin email should be different than Institutional email.');
              return false;
          }

          var regex = /^[6-9]\d{9}$/; 

          var regex2 = /^[0-9]\d{7,11}$/; 


if (!regex.test($('.AdministrativeMobile').val())) {
  alert('Please enter a valid mobile number');
  return false;
}

          $.ajaxSetup({
              headers: {
                  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
              }
          });
          $.ajax({
              url:"{{route('updateAdministrativeDetail')}}",
              type:'POST',
              dataType:'json',
              data:$("#AdministrativeDetail").serialize(),
              cache: false,
              beforeSubmit: function(){
                  $(".loader-area").show();
              },
              success:function(res)
              {
                  if(res == true)
                  {
                      Swal.fire({
                          icon: 'success',
                          text: 'Administrative details saved successfully!!',
                          showConfirmButton: true,
                      });
                  }
                  else if(res == false)
                  {
                      alert('Not Updated!');
                  }
                  else {
                      alert('something went wrong!');
                  }
              },
              complete: function(){
                  $("form").trigger("reset");
                  $(".submit").prop('disabled',false);
                  $('.billing').tab('show');
                  $('.billing').removeClass('disabled');
                  getListData();
              },
          });
      }
  });
  $('#BillingDetail').validate({
      rules: {
          name: {
              required: true,
          }
      },
      messages: {
          name: {
              required: "Please Enter name",
              name: "Please Enter name",
          }
      },
      submitHandler:function(form)
      {

            if ($('.BillingEmail').val() == $('.InstitutionHeadEmail').val()) {
              alert('Billing email should be different than Institutional email.');
              return false;
            }


if (!regex.test($('.BillingMobile').val())) {
  alert('Please enter a valid mobile number');
  return false;
}

var regex2 = /^[0-9]\d{7}$/; 


// var regex3= /^(\+91[\-\s]?)?[0]?(91)?[0123456789]\d{7,11}$/;
// if (!regex3.test($('.BillingPhone').val())) {
//   alert('Please enter a valid phone number');
//   return false;
// }

var reg2=/^([0-9])\1*$/;
if (reg2.test($('.BillingPhone').val())) {
  alert('Please enter a valid phone number');
  return false;
}
          $.ajaxSetup({
              headers: {
                  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
              }
          });
          $.ajax({
              url:"{{route('updateBillingDetail')}}",
              type:'POST',
              dataType:'json',
              data:$("#BillingDetail").serialize(),
              cache: false,
              beforeSubmit: function(){
                  $(".loader-area").show();
              },
              success:function(res)
              {
                  if(res == true)
                  {
                      Swal.fire({
                          icon: 'success',
                          text: 'Billing details saved successfully!',
                          showConfirmButton: true,
                      });
                  }
                  else if(res == false)
                  {
                      alert('Not Updated!');
                  }
                  else {
                      alert('something went wrong!');
                  }
              },
              complete: function(){
                  $(".submit").prop('disabled',false);
                  $("form").trigger("reset");
                  $('.technical').tab('show');
                  $('.technical').removeClass('disabled');
                  getListData();
              },
          });
      }
  });
  $('#TechnicalDetail').validate({
      rules: {
          name: {
              required: true,
          },
      },
      messages: {
          name: {
              required: "Please Enter name",
              name: "Please Enter name",
          },
      },

      submitHandler:function(form)
      {
        
          if ($('.TechnicalEmail').val() == $('.InstitutionHeadEmail').val() ) {
              alert('Technical email should be different than Institutional email.');
              return false;
          }


if (!regex.test($('.TechnicalMobile').val())) {
  alert('Please enter a valid mobile number');
  return false;
}

var regex3= /^(\+91[\-\s]?)?[0]?(91)?[0123456789]\d{7,11}$/;
if (!regex3.test($('.TechnicalPhone').val())) {
  alert('Please enter a valid phone number');
  return false;
}

var reg5=/^([0-9])\1*$/;
if (reg5.test($('.TechnicalPhone').val())) {
  alert('Please enter a valid phone number');
  return false;
}


          $.ajaxSetup({
              headers: {
                  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
              }
          });
          $.ajax({
              url:"{{route('updateTechnicalDetail')}}",
              type:'POST',
              dataType:'json',
              data:$("#TechnicalDetail").serialize(),
              cache: false,
              beforeSubmit: function(){
                  $(".loader-area").show();
              },
              success:function(res)
              {
                  if(res.status == true)
                  {
                      Swal.fire({
                          icon: 'success',
                          text: res.msg,
                          showConfirmButton: true,
                      }).then(function () {
                          var st = {{\Illuminate\Support\Facades\Auth::user()->domainStatus}};
                          if (st>3){
                            window.location.href = "{{ url('user-application-preview')}}";
                          }else {
                            window.location.href = "{{ url('dns-name-server')}}";
                          }
                      });

                  }
                  else if(res.status == false)
                  {
                      Swal.fire({
                          icon: 'error',
                          text: res.msg,
                          showConfirmButton: true,
                      })
                  }
              },
              complete: function(){
                  $("form").trigger("reset");
                  getListData();
                  $(".submit").prop('disabled',false);

              },
          });
      }
  });

    $(".AdministrativeDetail").change(function() {
        if(this.checked) {
            $('.AdministrativeName').val( $('.InstitutionHeadName').val());
            $('.AdministrativeDesignation').val( $('.InstitutionHeadDesignation').val());
            // $('.AdministrativeEmail').val( $('.InstitutionHeadEmail').val());
            $('.AdministrativePhone').val( $('.InstitutionHeadPhone').val());
            $('.AdministrativeMobile').val( $('.InstitutionHeadMobile').val());
        }else {
            $('.AdministrativeName').val('');
            $('.AdministrativeDesignation').val('');
            // $('.AdministrativeEmail').val('');
            $('.AdministrativePhone').val('');
            $('.AdministrativeMobile').val('');
        }
    });
    $(".BillingDetail").change(function() {
        if(this.checked) {
            $('.BillingName').val( $('.AdministrativeName').val());
            $('.BillingDesignation').val( $('.AdministrativeDesignation').val());
            $('.BillingEmail').val( $('.AdministrativeEmail').val());
            $('.BillingPhone').val( $('.AdministrativePhone').val());
            $('.BillingMobile').val( $('.AdministrativeMobile').val());
        }else {
            $('.BillingName').val('');
            $('.BillingDesignation').val('');
            $('.BillingEmail').val('');
            $('.BillingPhone').val('');
            $('.BillingMobile').val('');
        }
    });
    $(".TechnicalDetail").change(function() {
        if(this.checked) {
            $('.TechnicalName').val( $('.AdministrativeName').val());
            $('.TechnicalDesignation').val( $('.AdministrativeDesignation').val());
            $('.TechnicalEmail').val( $('.AdministrativeEmail').val());
            $('.TechnicalPhone').val( $('.AdministrativePhone').val());
            $('.TechnicalMobile').val( $('.AdministrativeMobile').val());
        }else {
            $('.TechnicalName').val('');
            $('.TechnicalDesignation').val('');
            $('.TechnicalEmail').val('');
            $('.TechnicalPhone').val('');
            $('.TechnicalMobile').val('');
        }
    });


</script>
@endsection
