@extends('layouts.UserLayout')
@section('content')
@php
@endphp

<style>
    
    p {
    margin-top: 0;
    margin-bottom: 0rem !important;
    }

</style>

<div class="container-xxl flex-grow-1 container-p-y" xmlns="http://www.w3.org/1999/html">
    @if(Session::has('message'))
        <p class="alert text-dark {{ Session::get('alert-class', 'alert-danger') }}">{{ Session::get('message') }}</p>
    @endif
  <div class="row">
    <div class="col-md-12">
      <div class="card mb-4 mt-5">
          <h5 class="card-header bg-info mb-4">
          <p style="float:left">DNS Name Server Details</p>
          <p style="float:right;color:#fff">{{\Illuminate\Support\Facades\Auth::user()->domainName}}</p>  
          </h5>
        <div class="card-body">

              <div class="col-12 my-2 text-center">
                  <div title="This is ernet server" class="form-check form-check-inline">
                      <input class="form-check-input" type="radio" name="name_server_type" id="ernet_name_server_form" value="ernet_name_server_form"
                            checked >
                      <label class="form-check-label">ERNET India Name Server</label>
                  </div>
                  <div title="This is user server" class="form-check form-check-inline">
                      <input class="form-check-input" type="radio" name="name_server_type" value="user_name_server_form"
                             @if($user_name_server != null)
                                @if($user_name_server->server_type == 2) checked @endif
                            @endif
                      >
                      <label class="form-check-label">Other Name Server</label>
                  </div>
                   <!-- @if($user_name_server == null) -->
                  <a href="{{ url('domain-payment-dns-skip')}}" class="btn btn-info mr-4" id="add-server-smt-btn"  >Skip</a>
                  <!-- @endif -->

              </div>
              <br>
            <div class="user-server-form">
                <form action="{{url('addDnsNameServerUser')}}" method="post">
                    @csrf
                    <div class="row">
                        <div class="col-6 my-2 primary_server">
                            <label class="form-label">Primary Name Server <span style="color: red">*</span> </label>
                            <input type="text" class="form-control" id="primary_server" name="primary_name_server" placeholder="Primary Name Server" value="@if($user_name_server != null && $user_name_server->server_type == 2){{$user_name_server->primary_name_server}}@endif"  required/>
                        </div>
                        @if($user_name_server != null)
                            @if($user_name_server != null && $user_name_server->server_type == 2 && $user_name_server->primary_name_server_ip != null && $user_name_server->primary_name_server_ip!='...')
                                @php
                                    $domain_fragmented = explode(".", $user_name_server->primary_name_server_ip);
                                @endphp
                                <div class="col-6 my-2 primary_server_ips">
                                    <label class="form-label">Primary Name Server IP<span style="color: red">*</span></label>
                                    <div class="input-group">
                                        @foreach($domain_fragmented as $key=>$value)
                                            <input type="number" class="form-control ip_input" name="primary_name_server_ip[]"  placeholder="127" value="{{$value}}"  />
                                            @if($key ==3)
                                                @break;
                                            @endif
                                            <span class="input-group-text" id="basic-addon11">.</span>
                                        @endforeach
                                    </div>
                                </div>
                            @endif
                                @if($user_name_server != null && $user_name_server->server_type == 2 && $user_name_server->primary_name_server_ip6 != null)
                                    @php
                                        $domain_fragmented = explode(":", $user_name_server->primary_name_server_ip6);
                                    @endphp
                                    <div class="col-12 my-2 primary_server_ips">
                                        <label class="form-label">Primary Name Server IPV6<span style="color: red">*</span></label>
                                        <div class="input-group">
                                            @foreach($domain_fragmented as $key=>$value)
                                                <input type="text" class="form-control ip_input6" name="primary_name_server_ip6[]"  placeholder="2001" value="{{$value}}"  />
                                                @if($key ==5)
                                                    @break;
                                                @endif
                                                <span class="input-group-text" id="basic-addon11">:</span>
                                            @endforeach
                                        </div>
                                    </div>
                                @endif
                        @endif


                        <div class="col-6 my-2 primary_server_one">
                            <label class="form-label">Secondary Name Server 1<span style="color: red">*</span></label>
                            <input type="text" class="form-control " id="primary_server_one"  name="secondary_name_server1" placeholder="Secondary Name Server 1" value="@if($user_name_server != null && $user_name_server->server_type == 2 ){{$user_name_server->secondary_name_server1}}@endif" required />
                        </div>

                        @if($user_name_server != null)
                            @if($user_name_server != null && $user_name_server->server_type == 2 && $user_name_server->secondary_name_server1_ip != null && $user_name_server->secondary_name_server1_ip!='...')
                                @php
                                    $domain_fragmented = explode(".", $user_name_server->secondary_name_server1_ip);
                                @endphp
                                <div class="col-6 my-2 primary_server_one_ips">
                                    <label class="form-label">Secondary Name Server 1 IP<span style="color: red">*</span></label>
                                    <div class="input-group">
                                        @foreach($domain_fragmented as $key=>$value)
                                            <input type="number" class="form-control ip_input" name="secondary_name_server1_ip[]"  placeholder="127" value="{{$value}}"  />
                                            @if($key ==3)
                                                @break;
                                            @endif
                                            <span class="input-group-text" id="basic-addon11">.</span>
                                        @endforeach
                                    </div>
                                </div>
                            @endif
                            @if($user_name_server != null && $user_name_server->server_type == 2 && $user_name_server->secondary_name_server1_ip6 != null)
                                @php
                                    $domain_fragmented = explode(":", $user_name_server->secondary_name_server1_ip6);
                                @endphp
                                <div class="col-12 my-2 primary_server_one_ips">
                                    <label class="form-label">Secondary Name Server IPV6<span style="color: red">*</span></label>
                                    <div class="input-group">
                                        @foreach($domain_fragmented as $key=>$value)
                                            <input type="text" class="form-control ip_input6" name="secondary_name_server1_ip6[]"  placeholder="2001" value="{{$value}}"  />
                                            @if($key ==5)
                                                @break;
                                            @endif
                                            <span class="input-group-text" id="basic-addon11">:</span>
                                        @endforeach
                                    </div>
                                </div>
                            @endif
                        @endif


                        <div class="col-6 my-2 primary_server_two ">
                            <label class="form-label">Secondary Name Server 2</label>
                            <input type="text" class="form-control" id="primary_server_two" name="secondary_name_server2" placeholder="Secondary Name Server 2" value="@if($user_name_server != null && $user_name_server->server_type == 2){{$user_name_server->secondary_name_server2}} @endif"/>
                        </div>
                        @if($user_name_server != null)
                            @if($user_name_server != null && $user_name_server->server_type == 2 && $user_name_server->secondary_name_server2_ip != null && $user_name_server->secondary_name_server2_ip!='...')
                                @php
                                    $domain_fragmented = explode(".", $user_name_server->secondary_name_server2_ip);
                                @endphp
                                <div class="col-6 my-2 primary_server_two_ips">
                                    <label class="form-label">Secondary Name Server 2 IP<span style="color: red">*</span></label>
                                    <div class="input-group">
                                        @foreach($domain_fragmented as $key=>$value)
                                            <input type="number" class="form-control ip_input" name="secondary_name_server2_ip[]"  placeholder="127" value="{{$value}}"  />
                                            @if($key ==3)
                                                @break;
                                            @endif
                                            <span class="input-group-text" id="basic-addon11">.</span>
                                        @endforeach
                                    </div>
                                </div>
                            @endif
                            @if($user_name_server != null && $user_name_server->server_type == 2 && $user_name_server->secondary_name_server2_ip6 != null)
                                @php
                                    $domain_fragmented = explode(":", $user_name_server->secondary_name_server2_ip6);
                                @endphp
                                <div class="col-12 my-2 primary_server_two_ips">
                                    <label class="form-label">Primary Name Server IPV6<span style="color: red">*</span></label>
                                    <div class="input-group">
                                        @foreach($domain_fragmented as $key=>$value)
                                            <input type="text" class="form-control ip_input6" name="secondary_name_server2_ip6[]"  placeholder="2001" value="{{$value}}"  />
                                            @if($key ==5)
                                                @break;
                                            @endif
                                            <span class="input-group-text" id="basic-addon11">:</span>
                                        @endforeach
                                    </div>
                                </div>
                            @endif
                        @endif

                        <div class="col-6 my-2 primary_server_three">
                            <label class="form-label">Secondary Name Server 3</label>
                            <input type="text" class="form-control" id="primary_server_three" name="secondary_name_server3" placeholder="Secondary Name Server 3" value="@if($user_name_server != null && $user_name_server->server_type == 2){{$user_name_server->secondary_name_server3}} @endif"/>
                        </div>
                        @if($user_name_server != null)
                            @if($user_name_server != null && $user_name_server->server_type == 2 && $user_name_server->secondary_name_server3_ip != null && $user_name_server->secondary_name_server3_ip!='...')
                            @php
                                $domain_fragmented = explode(".", $user_name_server->secondary_name_server3_ip);
                            @endphp
                            <div class="col-6 my-2 primary_server_three_ips">
                                <label class="form-label">Secondary Name Server 3 IP<span style="color: red">*</span></label>
                                <div class="input-group">
                                    @foreach($domain_fragmented as $key=>$value)
                                        <input type="number" class="form-control ip_input" name="secondary_name_server3_ip[]"  placeholder="127" value="{{$value}}"  />
                                        @if($key ==3)
                                            @break;
                                        @endif
                                        <span class="input-group-text" id="basic-addon11">.</span>
                                    @endforeach
                                </div>
                            </div>
                        @endif
                            @if($user_name_server != null && $user_name_server->server_type == 2 && $user_name_server->secondary_name_server3_ip6 != null)
                            @php
                                $domain_fragmented = explode(":", $user_name_server->secondary_name_server3_ip6);
                            @endphp
                            <div class="col-12 my-2 primary_server_three_ips">
                                <label class="form-label">Primary Name Server IPV6<span style="color: red">*</span></label>
                                <div class="input-group">
                                    @foreach($domain_fragmented as $key=>$value)
                                        <input type="text" class="form-control ip_input6" name="secondary_name_server3_ip6[]"  placeholder="2001" value="{{$value}}"  />
                                        @if($key ==5)
                                            @break;
                                        @endif
                                        <span class="input-group-text" id="basic-addon11">:</span>
                                    @endforeach
                                </div>
                            </div>
                        @endif
                        @endif

                        <div class="col-6 my-2 primary_server_four">
                            <label class="form-label">Secondary Name Server 4</label>
                            <input type="text" class="form-control" id="primary_server_four" name="secondary_name_server4" placeholder="Secondary Name Server 4" value="@if($user_name_server != null && $user_name_server->server_type == 2){{$user_name_server->secondary_name_server4}} @endif"/>
                        </div>
                        @if($user_name_server != null)
                            @if($user_name_server != null && $user_name_server->server_type == 2 && $user_name_server->secondary_name_server4_ip != null && $user_name_server->secondary_name_server4_ip!='...')
                            @php
                                $domain_fragmented = explode(".", $user_name_server->secondary_name_server4_ip);
                            @endphp
                            <div class="col-6 my-2 primary_server_five_ips">
                                <label class="form-label">Secondary Name Server 4 IP<span style="color: red">*</span></label>
                                <div class="input-group">
                                    @foreach($domain_fragmented as $key=>$value)
                                        <input type="number" class="form-control ip_input" name="secondary_name_server4_ip[]"  placeholder="127" value="{{$value}}"  />
                                        @if($key ==3)
                                            @break;
                                        @endif
                                        <span class="input-group-text" id="basic-addon11">.</span>
                                    @endforeach
                                </div>
                            </div>
                        @endif
                            @if($user_name_server != null && $user_name_server->server_type == 2 && $user_name_server->secondary_name_server4_ip6 != null )
                            @php
                                $domain_fragmented = explode(":", $user_name_server->secondary_name_server4_ip6);
                            @endphp
                            <div class="col-12 my-2 primary_server_five_ips">
                                <label class="form-label">Primary Name Server IPV6<span style="color: red">*</span></label>
                                <div class="input-group">
                                    @foreach($domain_fragmented as $key=>$value)
                                        <input type="text" class="form-control ip_input6" name="secondary_name_server4_ip6[]"  placeholder="2001" value="{{$value}}"  />
                                        @if($key ==5)
                                            @break;
                                        @endif
                                        <span class="input-group-text" id="basic-addon11">:</span>
                                    @endforeach
                                </div>
                            </div>
                        @endif
                        @endif

                        <div class="col-6 my-2 primary_server_five">
                            <label class="form-label">Secondary Name Server 5</label>
                            <input type="text" class="form-control" id="primary_server_five" name="secondary_name_server5" placeholder="Secondary Name Server 5" value="@if($user_name_server != null && $user_name_server->server_type == 2){{$user_name_server->secondary_name_server5}} @endif" />
                        </div>
                        @if($user_name_server != null)
                            @if($user_name_server != null && $user_name_server->server_type == 2 && $user_name_server->secondary_name_server5_ip != null && $user_name_server->secondary_name_server5_ip!='...')
                            @php
                                $domain_fragmented = explode(".", $user_name_server->secondary_name_server5_ip);
                            @endphp
                            <div class="col-6 my-2 primary_server_six_ips">
                                <label class="form-label">Secondary Name Server 5 IP<span style="color: red">*</span></label>
                                <div class="input-group">
                                    @foreach($domain_fragmented as $key=>$value)
                                        <input type="number" class="form-control ip_input" name="secondary_name_server5_ip[]"  placeholder="127" value="{{$value}}"  />
                                        @if($key ==3)
                                            @break;
                                        @endif
                                        <span class="input-group-text" id="basic-addon11">.</span>
                                    @endforeach
                                </div>
                            </div>
                        @endif
                            @if($user_name_server != null && $user_name_server->server_type == 2 && $user_name_server->secondary_name_server5_ip6 != null)
                            @php
                                $domain_fragmented = explode(":", $user_name_server->secondary_name_server5_ip6);
                            @endphp
                            <div class="col-12 my-2 primary_server_six_ips">
                                <label class="form-label">Primary Name Server IPV6<span style="color: red">*</span></label>
                                <div class="input-group">
                                    @foreach($domain_fragmented as $key=>$value)
                                        <input type="text" class="form-control ip_input6" name="secondary_name_server5_ip6[]"  placeholder="2001" value="{{$value}}"  />
                                        @if($key ==5)
                                            @break;
                                        @endif
                                        <span class="input-group-text" id="basic-addon11">:</span>
                                    @endforeach
                                </div>
                            </div>
                        @endif
                        @endif

                    </div>
                    <h5 class="text-info mt-3">Note : Name Server cannot be same as Domain Name</h5>
                    <div class="card-header m-auto p-0 my-2">
                        <div class="col-12 my-2">
                            <div class="form-check form-check-inline p-0">
                                <label class="form-check-label">Enable DNSSEC</label>
                            </div>
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" id="enable_dnsse_no" name="enable_dnsse" value="no" checked>
                                <label class="form-check-label">No</label>
                            </div>
                            <div class="form-check form-check-inline">
                                @if($user_name_server!=null)
                                    <input class="form-check-input" type="radio" id="enable_dnsse_yes" name="enable_dnsse" value="yes" @if($user_name_server->enable_dnsse_no=='yes') checked @endif>
                                @else
                                <input class="form-check-input" type="radio" id="enable_dnsse_yes" name="enable_dnsse" value="yes">
                                @endif
                                <label class="form-check-label">Yes</label>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 my-3" id="kripa">
                        <div class="table-responsive text-nowrap">
                        <table class="table table-striped table-bordered dataTable no-footer">
              <thead class="table-secondary">
                                <tr>
                                    <th>Key Tag</th>
                                    <th>Algorithm</th>
                                    <th>Digest Type</th>
                                    <th>Digest</th>
                                    <th>Action</th>
                                </tr>
                                </thead>
                                <tbody>
                                @if($dns_security_extension != null)
                                    @foreach($dns_security_extension as $i => $dns_security_ext)
                                    @if($dns_security_ext->key_tag!=null)
                                        <tr>
                                            <td><input type="text" class="form-control" name="dnsse[{{$i}}][key_tag]" id="key_tag" value="{{$dns_security_ext->key_tag}}"></td>
                                            <td>

                                            <select name="dnsse[{{$i}}][algorithm]" id="algorithm" class="form-control">
                                            @foreach($algos as $algo)
                                            <option value="{{$algo->value}}" @if($algo->value==$dns_security_ext->algorithm) selected  @endif> ({{$algo->value}}) {{$algo->name}}</option>
                                            @endforeach
                                        </select>

                                        </td>
                                            <td>
                                            <select name="dnsse[{{$i}}][digest_type]" class="form-control" id="digest_type">
                                                    <option value="1" @if($dns_security_ext->digest_type==1) selected  @endif>(1) SHA-1</option>
                                                    <option value="2" @if($dns_security_ext->digest_type==2) selected  @endif>(2) SHA-256</option>
                                                    <option value="3" @if($dns_security_ext->digest_type==3) selected  @endif>(3) GOST R 34.11-94</option>
                                                    <option value="4" @if($dns_security_ext->digest_type==4) selected  @endif>(4) SHA-384</option>
                                                </select>
                                            </td>

                                            <td><textarea  class="form-control" name="dnsse[{{$i}}][digest]" id="digest" >{{$dns_security_ext->digest}} </textarea></td>
                                            <td><button type="button" class="btn btn-sm btn-danger remove-row" data-id="{{$i}}">Remove</button></td>

                                        </tr>
                                    @endif
                                    @endforeach
                                @else

                                 <tr>
                                    <td><input type="text" class="form-control" name="dnsse[0][key_tag]" id="key_tag" value=""></td>
                                    <td>
                                        <select name="dnsse[0][algorithm]" id="algorithm" class="form-control">
                                            @foreach($algos as $algo)
                                            <option value="{{$algo->value}}"> ({{$algo->value}}) {{$algo->name}}</option>
                                            @endforeach
                                        </select>
                                        <!-- <input type="text" class="form-control" name="dnsse[0][algorithm]" id="algorithm" value=""> -->
                                    </td>
                                    <td>
                                        <select name="dnsse[0][digest_type]" class="form-control">
                                            <option value="1">(1) SHA-1</option>
                                            <option value="2">(2) SHA-256</option>
                                            <option value="3">(3) GOST R 34.11-94</option>
                                            <option value="4">(4) SHA-384</option>
                                        </select>
                                    </td>
                                    <td><textarea  class="form-control" name="dnsse[0][digest]" id="digest" value=""></textarea></td>
                                    <td><button type="button" class="btn btn-sm btn-danger remove-row" data-id="0">Remove</button></td>
                                </tr>

                                @endif

                                <!-- <tr>
                                    <td><input type="text" class="form-control" name="dnsse[0][key_tag]" id="key_tag" value=""></td>
                                    <td><input type="text" class="form-control" name="dnsse[0][algorithm]" id="algorithm" value=""></td>
                                    <td>
                                        <select name="dnsse[0][digest_type]" class="form-control">
                                            <option value="SHA1">SHA1</option>
                                        </select>
                                    </td>
                                    <td><input type="text" class="form-control" name="dnsse[0][digest]" id="digest" value=""></td>
                                </tr> -->

                                </tbody>
                            </table>
                        </div>
                        <div class="mb-4 mt-3 float-end">
                            <!-- <button type="button" class="btn btn-sm btn-danger remove-row">Remove</button> -->
                            <button type="button" id="add" value="Add" class="btn btn-sm btn-primary add-row">Add</button>
                        </div>
                    </div>
                    <div class="col-6 my-5">
                        <a href="{{url()->previous()}}"> <input type="button" class="btn btn-danger ml-3" id="back" name="back" value="Back"/></a>
                        <button class="btn btn-success mr-4" id="add-server-smt-btn" name="action" value="Submit">Submit</button>
                    </div>
                </form>
            </div>
            <div class="ernet-server-form d-none">
                <form action="{{url('addDnsNameServerErnet')}}" method="post">
                    @csrf
                      <div class="row">
                          <div class="col-12 my-2">
                              <label class="form-label">Domain Name <span style="color: red">*</span> </label>
                              <input type="text" class="form-control" id="domain_name" name="domain_name" placeholder="" value="{{\Illuminate\Support\Facades\Auth::user()->domainName}}" disabled />
                          </div>
                          <div class="col-12 my-2">
                              <label class="form-label">DNS Service Duration</label>
                              <select class="form-control"  id="service_duration" name="dns_service_duration" required>
                                    @if($ernet_name_server_prices)
                                      <option value="">Select Duration</option>
                                      @foreach($ernet_name_server_prices as $price)
                                        @if($user_name_server != null)
                                          <option value="{{$price->id}}" @if($user_name_server->ernet_name_server_duration_year == $price->years) selected @endif>{{$price->years}} years</option>
                                        @else
                                        <option value="{{$price->id}}">{{$price->years}} years</option>
                                        @endif
                                      @endforeach
                                    @endif
                              </select>
                          </div>
                          <div class="col-6 my-2">
                              <label class="form-label">Price</label>
                              <input type="hidden" class="form-control" name="years" id="years"  value=""/>
                              <input type="text" class="form-control" name="server_price" id="server_price"  value="" readonly/>
                          </div>
                          <div class="col-6 my-2">
                              <label class="form-label"> Taxes ( {{ number_format(getmisc()->service_tax,2)}} % ) </label>
                              <input type="text" class="form-control" name="server_price_tax" id="server_price_tax"  value="" readonly/>
                          </div>
                          
                          <div class="col-6 my-2">
                              <label class="form-label">Total Amount</label>
                              <input type="text" class="form-control" name="server_price_total" id="server_price_total" value="" readonly/>
                          </div>
                          <div class="col-12 my-2">
                              <label class="form-label">Primary Name Server </label>
                              <input type="text" class="form-control" id="primary_name_server" name="primary_name_server_ernet"  value="{{$ernet_name_server->primary_name_server??''}}" readonly/>
                          </div>
                          @foreach(json_decode($ernet_name_server->secondary_name_server) as $key=>$value)
                              <div class="col-6 my-2">
                                  <label class="form-label">Secondary Name Server {{$key+1}} </label>
                                  <input type="text" class="form-control secondaryNameServer{{$key+1}}" id="primary_server_five" name="secondary_name_server_ernet{{$key+1}}"  value="{{$value??''}}" readonly/>
                              </div>
                          @endforeach

                      </div>
                    <div class="col-6 my-5">
                        <a href="{{url()->previous()}}"> <input type="button" class="btn btn-danger ml-3" id="back" name="back" value="Back"/></a>
                        <button class="btn btn-success mr-4" id="add-server-smt-btn" name="action" value="Submit">Submit</button>
                        <a href="{{ url('domain-payment-dns-skip')}}" class="btn btn-info mr-4" id="add-server-smt-btn"  >Skip</a>
                        </div>
                </form>
              </div>

        </div>
      </div>
    </div>
  </div>
</div>
@endsection
@section("js")
<script>
     $( document ).ready(function() {
        
        var service_tax = {!! json_encode(getmisc()->service_tax) !!};
        if($('#enable_dnsse_yes').is(':checked')) { $("#kripa").show(); }
        if ($('#service_duration').val()){
            $.ajax({
                url: "{{ url('getNameServerPrice') }}"+'/'+$('#service_duration').val(),
                dataType : "json",
                type: "get",
                success : function(response) {
                    if(response.status == true) {
                        $('#years').val(response.data.years);
                        $('#server_price').val(response.data.price);

                        // var offer_discount_percent = (discount*response.data.price)/100;
                        // $('#offer_discount').val(offer_discount_percent);

                        // var offer_amount = (response.data.price-offer_discount_percent);

                        var server_price_gst_percent = (response.data.price*service_tax)/100;
                        console.log(server_price_gst_percent);

                        $('#server_price_tax').val(server_price_gst_percent);
                        
                        $('#server_price_total').val(parseFloat(response.data.price)+parseFloat(server_price_gst_percent));

                        } else if(response.status == false) {
                            alert(response.message);
                        }
                },
            });
        }
    });


        var count="{{$dnscount}}";
        var i = 0;

        if(count!=0){
           var i=count-1;
        }

    $(document).on("click",'.add-row',function(){
         i++;
         var markup = ' <tr id="rowdns-'+i+'">'+
                '<td><input type="text" class="form-control" name="dnsse['+i+'][key_tag]" id="key_tag" value=""></td>'+
               '<td><select name="dnsse['+i+'][algorithm]" id="algorithm" class="form-control">'+
        '@foreach($algos as $algo)'+
        '<option value="{{ $algo->value }}"> ({{$algo->value}}) {{ $algo->name }}</option>'+
        '@endforeach'+
        '</select></td>'+
                '<td> <select name="dnsse['+i+'][digest_type]" class="form-control">\n' +
                '                            <option value="1">(1) SHA-1</option>\n' +
                '                            <option value="2">(2) SHA-256</option>\n' +
                '                            <option value="3">(3) GOST R 34.11-94</option>\n' +
                '                            <option value="4">(4) SHA-384</option>\n' +
                '                        </select></td>'+
                '<td><textarea class="form-control" name="dnsse['+i+'][digest]" id="digest" value=""></textarea></td>'+
                '<td><button type="button" class="btn btn-sm btn-danger remove-row" data-id="' + i + '">Remove</button></td>' +
                '</tr>';
            $("table tbody").append(markup);

    });
    $(document).on("click",'.remove-row',function(){
        var id=$(this).attr('data-id');
        $('#rowdns-'+i+'').remove();
    });

  $("#enable_dnsse_no").click(function(){
    $("#kripa").hide();
  });

  $("#enable_dnsse_yes").click(function(){
     $("#kripa").show();
  });

    $(document).ready(function() {
        if ($("#ernet_name_server_form").prop("checked")) {
            $('.user-server-form').addClass('d-none');
            $('.ernet-server-form').removeClass('d-none');
        }else {
            $('.user-server-form').removeClass('d-none');
            $('.ernet-server-form').addClass('d-none');
        }

        $('input[type="radio"]').click(function() {
            if($(this).attr('id') == 'ernet_name_server_form') {
                $('.user-server-form').addClass('d-none');
                $('.ernet-server-form').removeClass('d-none');
            }

            else {
                $('.user-server-form').removeClass('d-none');
                $('.ernet-server-form').addClass('d-none');
            }
        });
    });

   $(document).on("change",'#service_duration',function(){
        
        var service_tax = {!! json_encode(getmisc()->service_tax) !!};
        $.ajax({
            url: "{{ url('getNameServerPrice') }}"+'/'+$(this).val(),
            dataType : "json",
            type: "get",
            success : function(response) {

                if(response.status == true) {
                    $('#years').val(response.data.years);
                    $('#server_price').val(response.data.price);

                    // var offer_discount_percent = (discount*response.data.price)/100;
                    // $('#offer_discount').val(offer_discount_percent);

                    // var offer_amount = (response.data.price-offer_discount_percent);

                    // var server_price_gst_percent = (service_tax*offer_amount)/100;

                    // $('#server_price_tax').val(server_price_gst_percent);
                    
                    // $('#server_price_total').val(parseFloat(offer_amount)+parseFloat(server_price_gst_percent));

                    var server_price_gst_percent = (response.data.price*service_tax)/100;
                        console.log(server_price_gst_percent);

                        $('#server_price_tax').val(server_price_gst_percent);
                        
                        $('#server_price_total').val(parseFloat(response.data.price)+parseFloat(server_price_gst_percent));
                        
                } else if(response.status == false) {
                    alert(response.message);
                }

            },
        });
    });

    // $('#primary_server').unbind('change');
    $('#primary_server').on('input',function(e) {

        if ($('#primary_server_five').val().trim() == $(this).val().trim() || $('#primary_server_one').val().trim() == $(this).val().trim() || $('#primary_server_two').val().trim() == $(this).val().trim() || $('#primary_server_three').val().trim() == $(this).val().trim()  || $('#primary_server_four').val().trim() == $(this).val().trim()){
            alert('name server can not be same or blank!');
            $('#primary_server').val('');
        }

            var domain = $(this).val();
            $('.primary_server_ips').remove();
            $.ajax({
                url: "{{ url('checkDNSMatch') }}",
                dataType : "json",
                data : {domain:domain},
                type: "get",
                success : function(response) {
                    $('.primary_server_ips').remove();
                    if(response == true) {
                        $(".primary_server").after('' +
                            '<div class="col-6 my-2 primary_server_ips">\n' +
                            '                            <label class="form-label">Primary Name Server IPv4<span style="color: red">*</span></label>\n' +
                            '                        <div class="input-group">\n' +
                            '                            <input type="number" class="form-control ip_input" name="primary_name_server_ip[]"  placeholder="127" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">.</span>\n' +
                            '                            <input type="number"  class="form-control ip_input" name="primary_name_server_ip[]" placeholder="254" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">.</span>\n' +
                            '                            <input type="number"  class="form-control ip_input" name="primary_name_server_ip[]" placeholder="11" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">.</span>\n' +
                            '                            <input type="number"  class="form-control ip_input" name="primary_name_server_ip[]" placeholder="2" value=""  />\n' +
                            '                        </div>\n' +
                            '                    </div>'+
                            '<div class="col-12 my-2 primary_server_ips">\n' +
                            '                            <label class="form-label">Primary Name Server IPv6<span style="color: red"></span></label>\n' +
                            '                        <div class="input-group">\n' +
                            '                            <input type="text" class="form-control ip_input6" name="primary_name_server_ip6[]"  placeholder="2001" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="primary_name_server_ip6[]" placeholder="0db8" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="primary_name_server_ip6[]" placeholder="0001" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="primary_name_server_ip6[]" placeholder="0000" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text" class="form-control ip_input6" name="primary_name_server_ip6[]"  placeholder="0000" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="primary_name_server_ip6[]" placeholder="0ab9" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="primary_name_server_ip6[]" placeholder="C0A8" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="primary_name_server_ip6[]" placeholder="0102" value=""  />\n' +
                            '                        </div>\n' +
                            '                    </div>');
                    } else {

                    }
                },
            });
        
    });

    // $('#primary_server_one').unbind('keyup');
    $('#primary_server_one').on('input',function(e) {
        if ($('#primary_server').val().trim() == $(this).val().trim() || $('#primary_server_two').val().trim() == $(this).val().trim() || $('#primary_server_three').val().trim() == $(this).val().trim() || $('#primary_server_four').val().trim() == $(this).val().trim() || $('#primary_server_five').val().trim() == $(this).val().trim()){
            alert('name server can not be same or blank!');
            $('#primary_server_one').val('');
        }
            var domain = $(this).val();
            $('.primary_server_one_ips').remove();
            $.ajax({
                url: "{{ url('checkDNSMatch') }}",
                dataType : "json",
                data : {domain:domain},
                type: "get",
                success : function(response) {
                    $('.primary_server_one_ips').remove();
                    if(response == true) {
                        $(".primary_server_one").after('' +
                            '<div class="col-6 my-2 primary_server_one_ips ">\n' +
                            '                            <label class="form-label">Secondary Name Server 1 IPv4<span style="color: red">*</span></label>\n' +
                            '                        <div class="input-group">\n' +
                            '                            <input type="number" class="form-control ip_input" name="secondary_name_server1_ip[]"  placeholder="127" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">.</span>\n' +
                            '                            <input type="number"  class="form-control ip_input" name="secondary_name_server1_ip[]" placeholder="268" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">.</span>\n' +
                            '                            <input type="number"  class="form-control ip_input" name="secondary_name_server1_ip[]" placeholder="11" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">.</span>\n' +
                            '                            <input type="number"  class="form-control ip_input" name="secondary_name_server1_ip[]" placeholder="2" value=""  />\n' +
                            '                        </div>\n' +
                            '                    </div>'+
                            '<div class="col-12 my-2 primary_server_one_ips">\n' +
                            '                            <label class="form-label">Secondary Name Server 1 IPv6<span style="color: red"></span></label>\n' +
                            '                        <div class="input-group">\n' +
                            '                            <input type="text" class="form-control ip_input6" name="secondary_name_server1_ip6[]"  placeholder="2001" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server1_ip6[]" placeholder="0db8" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server1_ip6[]" placeholder="0001" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server1_ip6[]" placeholder="0000" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text" class="form-control ip_input6" name="secondary_name_server1_ip6[]"  placeholder="0000" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server1_ip6[]" placeholder="0ab9" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server1_ip6[]" placeholder="C0A8" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server1_ip6[]" placeholder="0102" value=""  />\n' +
                            '                        </div>\n' +
                            '                    </div>'
                        );
                    } else {

                    }
                },
            });
        
    });

    // $('#primary_server_two').unbind('change');
    $('#primary_server_two').on('input',function(e) {

        if ($('#primary_server').val().trim() == $(this).val().trim()  || $('#primary_server_one').val().trim()  == $(this).val().trim()  || $('#primary_server_three').val().trim()  == $(this).val().trim()  || $('#primary_server_four').val().trim()  == $(this).val().trim()   || $('#primary_server_five').val().trim()  == $(this).val().trim() ){
            alert('name server can not be same or blank!');
            $('#primary_server_two').val('');
        }
      
       
            var domain = $(this).val();
            $('.primary_server_two_ips').remove();
            $.ajax({
                url: "{{ url('checkDNSMatch') }}",
                dataType : "json",
                data : {domain:domain},
                type: "get",
                success : function(response) {
                    $('.primary_server_two_ips').remove();
                    if(response == true) {
                        $(".primary_server_two").after('' +
                            '<div class="col-6 my-2 primary_server_two_ips">\n' +
                            '                            <label class="form-label">Secondary Name Server 2 IP<span style="color: red">*</span></label>\n' +
                            '                        <div class="input-group">\n' +
                            '                            <input type="number"  class="form-control ip_input" name="secondary_name_server2_ip[]"  placeholder="127" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">.</span>\n' +
                            '                            <input type="number"  class="form-control ip_input" name="secondary_name_server2_ip[]" placeholder="268" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">.</span>\n' +
                            '                            <input type="number"  class="form-control ip_input" name="secondary_name_server2_ip[]" placeholder="11" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">.</span>\n' +
                            '                            <input type="number"  class="form-control ip_input" name="secondary_name_server2_ip[]" placeholder="2" value=""  />\n' +
                            '                        </div>\n' +
                            '                    </div>'+
                            '<div class="col-12 my-2 primary_server_two_ips">\n' +
                            '                            <label class="form-label">Secondary Name Server 2 IPv6<span style="color: red"></span></label>\n' +
                            '                        <div class="input-group">\n' +
                            '                            <input type="text" class="form-control ip_input6" name="secondary_name_server2_ip6[]"  placeholder="2001" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server2_ip6[]" placeholder="0db8" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server2_ip6[]" placeholder="0001" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server2_ip6[]" placeholder="0000" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text" class="form-control ip_input6" name="secondary_name_server2_ip6[]"  placeholder="0000" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server2_ip6[]" placeholder="0ab9" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server2_ip6[]" placeholder="C0A8" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server2_ip6[]" placeholder="0102" value=""  />\n' +
                            '                        </div>\n' +
                            '                    </div>');
                    } else {

                    }
                },
            });
        
    });

    // $('#primary_server_three').unbind('keyup');
    $('#primary_server_three').on('input',function(e) {
        
        if ($('#primary_server').val().trim() == $(this).val().trim() || $('#primary_server_one').val().trim() == $(this).val().trim() || $('#primary_server_two').val().trim() == $(this).val().trim() || $('#primary_server_four').val().trim() == $(this).val().trim()  || $('#primary_server_five').val().trim() == $(this).val().trim()){
            alert('name server can not be same or blank!');
            $('#primary_server_three').val('');
        }

            var domain = $(this).val();
            $('.primary_server_three_ips').remove();
            $.ajax({
                url: "{{ url('checkDNSMatch') }}",
                dataType : "json",
                data : {domain:domain},
                type: "get",
                success : function(response) {
                    $('.primary_server_three_ips').remove();
                    if(response == true) {
                        $(".primary_server_three").after('' +
                            '<div class="col-6 my-2 primary_server_three_ips">\n' +
                            '                            <label class="form-label">Secondary Name Server 3 IPv4<span style="color: red">*</span></label>\n' +
                            '                        <div class="input-group">\n' +
                            '                            <input type="number"  class="form-control ip_input" name="secondary_name_server3_ip[]"  placeholder="127" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">.</span>\n' +
                            '                            <input type="number"  class="form-control ip_input" name="secondary_name_server3_ip[]" placeholder="268" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">.</span>\n' +
                            '                            <input type="number"  class="form-control ip_input" name="secondary_name_server3_ip[]" placeholder="11" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">.</span>\n' +
                            '                            <input type="number"  class="form-control ip_input" name="secondary_name_server3_ip[]" placeholder="2" value=""  />\n' +
                            '                        </div>\n' +
                            '                    </div>'+
                            '<div class="col-12 my-2 primary_server_three_ips">\n' +
                            '                            <label class="form-label">Secondary Name Server 3 IPv6<span style="color: red"></span></label>\n' +
                            '                        <div class="input-group">\n' +
                            '                            <input type="text" class="form-control ip_input6" name="secondary_name_server3_ip6[]"  placeholder="2001" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server3_ip6[]" placeholder="0db8" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server3_ip6[]" placeholder="0001" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server3_ip6[]" placeholder="0000" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text" class="form-control ip_input6" name="secondary_name_server3_ip6[]"  placeholder="0000" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server3_ip6[]" placeholder="0ab9" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server3_ip6[]" placeholder="C0A8" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server3_ip6[]" placeholder="0102" value=""  />\n' +
                            '                        </div>\n' +
                            '                    </div>');
                    } else {

                    }
                },
            });
       
    });

    // $('#primary_server_four').unbind('keyup');
    $('#primary_server_four').on('input',function(e) {
      
        if ($('#primary_server').val().trim() == $(this).val().trim() || $('#primary_server_one').val().trim() == $(this).val().trim() || $('#primary_server_two').val().trim() == $(this).val().trim() || $('#primary_server_three').val().trim() == $(this).val().trim()  || $('#primary_server_five').val().trim() == $(this).val().trim()){
            alert('name server can not be same or blank!');
            $('#primary_server_four').val('');
        }

            var domain = $(this).val();
            $('.primary_server_four_ips').remove();
            $.ajax({
                url: "{{ url('checkDNSMatch') }}",
                dataType : "json",
                data : {domain:domain},
                type: "get",
                success : function(response) {
                    $('.primary_server_four_ips').remove();
                    if(response == true) {
                        $(".primary_server_four").after('' +
                            '<div class="col-6 my-2 primary_server_four_ips">\n' +
                            '                            <label class="form-label">Secondary Name Server 4 IPv4</label>\n' +
                            '                        <div class="input-group">\n' +
                            '                            <input type="number"  class="form-control ip_input" name="secondary_name_server4_ip[]"  placeholder="127" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">.</span>\n' +
                            '                            <input type="number"  class="form-control ip_input" name="secondary_name_server4_ip[]" placeholder="268" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">.</span>\n' +
                            '                            <input type="number"  class="form-control ip_input" name="secondary_name_server4_ip[]" placeholder="11" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">.</span>\n' +
                            '                            <input type="number"  class="form-control ip_input" name="secondary_name_server4_ip[]" placeholder="2" value=""  />\n' +
                            '                        </div>\n' +
                            '                    </div>'+
                            '<div class="col-12 my-2 primary_server_four_ips">\n' +
                            '                            <label class="form-label">Secondary Name Server 4 IPv6<span style="color: red"></span></label>\n' +
                            '                        <div class="input-group">\n' +
                            '                            <input type="text" class="form-control ip_input6" name="secondary_name_server4_ip6[]"  placeholder="2001" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server4_ip6[]" placeholder="0db8" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server4_ip6[]" placeholder="0001" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server4_ip6[]" placeholder="0000" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text" class="form-control ip_input6" name="secondary_name_server4_ip6[]"  placeholder="0000" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server4_ip6[]" placeholder="0ab9" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server4_ip6[]" placeholder="C0A8" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server4_ip6[]" placeholder="0102" value=""  />\n' +
                            '                        </div>\n' +
                            '                    </div>');
                    } else {

                    }
                },
            });
       
    });

    // $('#primary_server_five').unbind('change');
    $('#primary_server_five').on('input',function(e) {
        
        if ($('#primary_server').val().trim() == $(this).val().trim() || $('#primary_server_one').val().trim() == $(this).val().trim() || $('#primary_server_two').val().trim() == $(this).val().trim() || $('#primary_server_three').val().trim() == $(this).val().trim()  || $('#primary_server_four').val().trim() == $(this).val().trim()){
            alert('name server can not be same or blank!');
            $('#primary_server_five').val('');
        }

            var domain = $(this).val();
            $('.primary_server_five_ips').remove();
            $.ajax({
                url: "{{ url('checkDNSMatch') }}",
                dataType : "json",
                data : {domain:domain},
                type: "get",
                success : function(response) {
                    $('.primary_server_five_ips').remove();
                    if(response == true) {
                        $(".primary_server_five").after('' +
                            '<div class="col-6 my-2 primary_server_five_ips">\n' +
                            '                            <label class="form-label">Secondary Name Server 5 IPv4</label>\n' +
                            '                        <div class="input-group">\n' +
                            '                            <input type="number"  class="form-control ip_input" name="secondary_name_server5_ip[]"  placeholder="127" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">.</span>\n' +
                            '                            <input type="number"  class="form-control ip_input" name="secondary_name_server5_ip[]" placeholder="268" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">.</span>\n' +
                            '                            <input type="number"  class="form-control ip_input" name="secondary_name_server5_ip[]" placeholder="11" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">.</span>\n' +
                            '                            <input type="number"  class="form-control ip_input" name="secondary_name_server5_ip[]" placeholder="2" value="" ' +
                            ' />\n' +
                            '                        </div>\n' +
                            '                    </div>'+
                            '<div class="col-12 my-2 primary_server_five_ips">\n' +
                            '                            <label class="form-label">Secondary Name Server 5 IPv6<span style="color: red"></span></label>\n' +
                            '                            <div class="input-group">\n' +
                            '                            <input type="text" class="form-control ip_input6" name="secondary_name_server5_ip6[]"  placeholder="2001" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server5_ip6[]" placeholder="0db8" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server5_ip6[]" placeholder="0001" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server5_ip6[]" placeholder="0000" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text" class="form-control ip_input6" name="secondary_name_server5_ip6[]"  placeholder="0000" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server5_ip6[]" placeholder="0ab9" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server5_ip6[]" placeholder="C0A8" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server5_ip6[]" placeholder="0102" value=""  />\n' +
                            '                        </div>\n' +
                            '                    </div>');
                    } else {

                    }
                },
            });
        
    });

    $('body').on("keypress", '.ip_input', function(e) {

        if ($(this).val().length > 2) {

            if($(this).val()>255){
                alert('Only less than 255  is allowed');
            }
            e.preventDefault();
        }

    });

    $('body').on("keypress", '.ip_input6', function(e) {
        if ($(this).val().length > 3) {
            e.preventDefault();
        }

        // var txt = $(this).val();
        // if (!txt.match(/[0-9a-fA-F]/)) {
        //     alert('only hexadecimal allowed')
        // }



    });

    $('body').on("keyup", '.ip_input6', function(e) {
        if ($(this).val().length > 0){
            regexp = /^[0-9a-fA-F]+$/;
            if (!regexp.test($(this).val())) {
                alert('Only Hexadecimal inputs are allowed!');
                $(this).val('');
            }
        }
    });

    $('body').on("keyup", '.ip_input', function(e) {
        if($(this).val()>255){
            alert('The value of IP address should be less than 255');
            $(this).val('');
        }
        e.preventDefault();
    });
    
</script>
@endsection
