@extends('layouts.UserLayout')
@section('content')
@php
@endphp
<!-- Content wrapper -->
<div class="container-xxl flex-grow-1 container-p-y" xmlns="http://www.w3.org/1999/html">
  <div class="row">
    <div class="col-md-12">
      <div class="card mb-4 mt-5">
          <h5 class="card-header bg-info mb-4">Apply for Ernet DNS</h5>
        <div class="card-body">
            <div class="ernet-server-form">
                <form role="form" id="modified_ernet_server_form" method="post">
                    @csrf
                      <div class="row">
                          <div class="col-12 my-2">
                              <label class="form-label">Domain Name <span style="color: red">*</span> </label>
                              <input type="text" class="form-control" id="domain_name" name="domain_name" placeholder="" value="{{\Illuminate\Support\Facades\Auth::user()->domainName}}" disabled />
                          </div>
                          <div class="col-12 my-2">
                              <label class="form-label">DNS Service Duration</label>
                              <select class="form-control"  id="service_duration" name="dns_service_duration" required>
                                  @if($ernet_name_server_prices)
                                      <option value="">Select Duration</option>
                                      @foreach($ernet_name_server_prices as $price)
                                          <option value="{{$price->id}}" @if($user_name_server->ernet_name_server_duration_year ?? '0' == $price->id) selected @endif>{{$price->years}} years</option>
                                      @endforeach
                                      @endif
                              </select>
                          </div>
                          <div class="col-6 my-2">
                              <label class="form-label">Price</label>
                              <input type="hidden" class="form-control" name="years" id="years"  value="" />
                              <input type="text" class="form-control" name="server_price" id="server_price"  value="" readonly/>
                          </div>
                          <div class="col-6 my-2">
                              <label class="form-label"> Taxes ( 18.00 % )</label>
                              <input type="text" class="form-control" name="server_price_tax" id="server_price_tax"  value="" readonly/>
                          </div>
                          <div class="col-6 my-2">
                              <label class="form-label">Total Amount</label>
                              <input type="text" class="form-control" name="server_price_total" id="server_price_total" value="" readonly/>
                          </div>
                          <div class="col-12 my-2">
                              <label class="form-label">Primary Name Server </label>
                              <input type="text" class="form-control" id="primary_name_server" name="primary_name_server_ernet"  value="{{$ernet_name_server->primary_name_server??''}}" readonly/>
                          </div>
                          @foreach(json_decode($ernet_name_server->secondary_name_server) as $key=>$value)
                              <div class="col-6 my-2">
                                  <label class="form-label">Secondary Name Server {{$key+1}} </label>
                                  <input type="text" class="form-control secondaryNameServer{{$key+1}}" id="primary_server_five" name="secondary_name_server_ernet{{$key+1}}"  value="{{$value??''}}" readonly/>
                              </div>
                          @endforeach

                      </div>
                    <div class="col-6 my-5">
                        <a href="{{url()->previous()}}"> <input type="button" class="btn btn-danger ml-3" id="back" name="back" value="Back"/></a>
                        <button class="btn btn-success mr-4" id="add-server-smt-btn" name="action" value="Submit">Submit</button>
                    </div>
                </form>
              </div>

        </div>
      </div>
    </div>
  </div>
</div>
<!-- Content wrapper -->

@endsection
@section("js")
<script>
    $( document ).ready(function() {
        if ($('#service_duration').val()){
            $.ajax({
                url: "{{ url('getNameServerPrice') }}"+'/'+$('#service_duration').val(),
                dataType : "json",
                type: "get",
                success : function(response) {
                    if(response.status == true) {
                        $('#years').val(response.data.years);
                        $('#server_price').val(response.data.price);
                        var server_price_gst_percent = (18*response.data.price)/100;
                        $('#server_price_tax').val(server_price_gst_percent);
                        $('#server_price_total').val(parseFloat(response.data.price)+parseFloat(server_price_gst_percent));
                    } else if(response.status == false) {
                        alert(response.message);
                    }
                },
            });
        }
    });


  $('#modified_ernet_server_form').validate({
    submitHandler:function(form)
    {
      $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
      });
      $.ajax({
        url:"{{url('addDnsNameServerErnet')}}",
        type:'POST',
        dataType:'json',
        data:$("#modified_ernet_server_form").serialize(),
        cache: false,
        beforeSend: function(){
            $(".loader-area").show();
        },
        success:function(res)
        {
          if(res.status == true)
          {
              Swal.fire({
                  icon: 'success',
                  text: 'Name Server Details have been submitted successfully.',
                  showConfirmButton: true,
              }).then(function () {
                  window.location.href = "{{ url('dns-name-server-payment')}}";
              });
          }else if(res.status == false)
          {
              Swal.fire({
                  icon: 'error',
                  text: res.msg,
                  showConfirmButton: true,
              })
          }
        },
        complete: function(){
            $("#add-server-smt-btn").prop('disabled',false);
        },
      });
    }
  });

    $(document).on("change",'#service_duration',function(){
        $.ajax({
            url: "{{ url('getNameServerPrice') }}"+'/'+$(this).val(),
            dataType : "json",
            type: "get",
            success : function(response) {

                if(response.status == true) {
                    $('#years').val(response.data.years);
                    $('#server_price').val(response.data.price);
                    var server_price_gst_percent = (18*response.data.price)/100;
                    $('#server_price_tax').val(server_price_gst_percent);
                    $('#server_price_total').val(parseFloat(response.data.price)+parseFloat(server_price_gst_percent));
                } else if(response.status == false) {
                    alert(response.message);
                }

            },
        });
    });

</script>
@endsection
