@extends('layouts.UserLayout')
@section('content')

<link href="https://pay.billdesk.com/jssdk/v1/dist/billdesksdk/billdesksdk.css"rel="stylesheet">

<style>

li{
    color:#000 !important
}

</style>

<div class="container-xxl flex-grow-1 container-p-y" xmlns="http://www.w3.org/1999/html">
  <div class="row">
    <div class="col-md-12">
      <div class="card mb-4 mt-5">
          <h5 class="card-header bg-info mb-4">Domain Payment Summary </h5>
          <div class="card-body">
              <div class="row ">
                  <div class="col-lg-12 mb-4 mb-xl-0">
                      <small class=" fw-semibold"></small>
                    

                    <form method="post" id="editdomainform">
                      @csrf
                          <div class="demo-inline-spacing mt-3">
                              <div class="list-group">
                                  <ul class="list-group">

                                  <?php

$domainprice=Auth::user()->domainPrice;

if(getdiscount()!=null){

    $discount =json_encode(getdiscount()->discount);

    $offer_discount_percent = ($discount*$domainprice)/100;

    $offer_amount = ($domainprice-$offer_discount_percent);

    $taxes=json_encode(getmisc()->service_tax);

    $taxamt = ($offer_amount*$taxes)/100;

    $totalpayableamount=$offer_amount+$taxamt;

}else{

    $discount =0;
    
    $offer_discount_percent =0;

    $offer_amount = $domainprice;

    $taxes=json_encode(getmisc()->service_tax);

    $taxamt = ($domainprice*$taxes)/100;

    $totalpayableamount=$domainprice+$taxamt;

}


?>
                                     
                                 
                                      <li class="list-group-item ">Domain Name : {{Auth::user()->domainName}}</li>
                                      <li class="list-group-item ">Domain Duration : {{Auth::user()->domainPeriod}} years</li>
                                      <li class="list-group-item ">Domain Price : ₹{{Auth::user()->domainPrice}}</li>
                                      <li class="list-group-item ">Offer Discount : ₹{{$offer_discount_percent}}</li>
                                      <li class="list-group-item ">Total Amount : ₹{{$offer_amount}}</li>
                                      <li class="list-group-item ">Domain Tax : ₹{{$taxamt}}</li>
                                      <li class="list-group-item ">Total Payable Amount : ₹{{$totalpayableamount}}</li>

                                      <input type="hidden" class="form-control" name="period"  value="{{Auth::user()->domainPeriod}}" readonly/>
                                      <input type="hidden" class="form-control" name="domain_name"  value="{{Auth::user()->domainName}}" readonly/>
                                      <input type="hidden" class="form-control" name="domain_duration"  value="{{Auth::user()->domainPeriod}}" readonly/>
                                      <input type="hidden" class="form-control" name="domain_price" value="{{Auth::user()->domainPrice}}" readonly/>
                                      <input type="hidden" class="form-control" name="domain_disper" value="{{$discount}}" readonly/>
                                      <input type="hidden" class="form-control" name="domain_dis"  value="{{$offer_discount_percent}}" readonly/>
                                      <input type="hidden" class="form-control" name="domain_disamt"  value="{{$offer_amount}}" readonly/>
                                      <input type="hidden" class="form-control" name="domain_taxper"  value="{{$taxes}}" readonly/>
                                      <input type="hidden" class="form-control" name="domain_tax"  value="{{$taxamt}}" readonly/>
                                      <input type="hidden" class="form-control" name="amount"  value="{{$totalpayableamount}}" readonly/>
                                      <input type="hidden" class="form-control" name="transaction_type" id="transaction_type"  value="domainRegister" readonly/>
                                      <input type="hidden" class="form-control" name="remark" id="remark"  value="Domain Registration Fee" readonly/>

                                  </ul>
                              </div>
                          </div>
                          <div class="col-12 mt-3">
                              <label class="form-label"></label>
                              <a href="{{url()->previous()}}"> <input type="button" class="btn btn-danger ml-3" id="back" name="back" value="Back"/></a>
                              <button type="submit" class="btn btn-success mr-4" id="myButton" style="display:none">Make Payment</button>
                          </div>
                      </form>
                  </div>
              </div>
          </div>
      </div>
    </div>
  </div>
</div>

@endsection
@section("js")


<script type="module" src="https://pay.billdesk.com/jssdk/v1/dist/billdesksdk/billdesksdk.esm.js"></script></script>
<script nomodule="" src="https://pay.billdesk.com/jssdk/v1/dist/billdesksdk.js"></script> 

<script src="https://code.jquery.com/jquery-latest.min.js"></script>

<script>
              
$(document).ready(function() {

  setTimeout(function () {
            $('#myButton').show();
  }, 3000);

$('body').on('submit', '#editdomainform', function(e) {
  e.preventDefault();
  $('#overlay').show();

  var current = $(this);		
  var data = current.serialize();
  $.ajaxSetup({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
  });

  $.ajax({
    url: "{{route('createBilldeskOrder')}}",
    dataType : "json",
    type: "post",
    data : data,
    success : function(response) {
    if(response.status == 'success') {

var flow_config ={
merchantId:response.mid,
bdOrderId: response.orderId,
authToken: response.otoken,
childWindow: false,
returnUrl: response.ru, 
retryCount: 3,
prefs: {
 "payment_categories": ["card", "nb","upi"],
//"payment_categories": ["upi"],
// "allowed_bins": ["459150", "525211"]
 },
netBanking:{
 "showPopularBanks" : "Y",
 "popularBanks": ["Kotak Bank"," AXIS Bank [Retail]"],
}
} 

var theme_config = {
 sdkPrimaryColor: response.sdkPrimaryColor,
 sdkAccentColor: response.sdkAccentColor,
 sdkBackgroundColor: response.sdkBackgroundColor,
 sdkBannerColor: response.sdkBannerColor
}

var config = {
responseHandler: responseHandler,
merchantLogo: response.logo,
flowConfig: flow_config,
flowType: "payments",
themeConfig: theme_config
}

$('#overlay').hide();

window.loadBillDeskSdk(config);

} else if(response.status == 'error') {
        Swal.fire({
            icon: 'error',
            text: 'Please try again',
            showConfirmButton: true,
        })
      }
    },
  });
});

});

var responseHandler = function (txn) {
 console.log("callback received status:: ",txn.status)
 console.log("callback received response:: ",txn.response)
}


    </script>

@endsection